/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.jndi.JndiAttrs;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    public static final int DEFAULT_DATABASE_PORT = 1521;
    public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
    private boolean newSyntax = true;
    public boolean connection_revised = false;
    public boolean connection_redirected = false;
    private String TNSAddress;
    private static final Pattern pattern = Pattern.compile("(?=ldaps?://)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddrResolution(String TNSdesc, Properties _up) throws NetException {
        String prop;
        this.up = _up;
        this.TNSAddress = TNSdesc;
        if (this.up.containsKey("java.naming.provider.url") || TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
            boolean isLdapUrlList = false;
            Vector<String> ldapUrlList = null;
            if (TNSdesc.startsWith("ldap:") || TNSdesc.startsWith("ldaps:")) {
                ldapUrlList = this.computeLdapList(TNSdesc);
                if (ldapUrlList.size() > 1) {
                    isLdapUrlList = true;
                } else {
                    int pos = TNSdesc.lastIndexOf(47);
                    if (pos == -1) {
                        throw new NetException(124);
                    }
                    this.up.put("java.naming.provider.url", TNSdesc.substring(0, pos));
                    this.TNSAddress = TNSdesc.substring(pos + 1, TNSdesc.length());
                }
            }
            if (!isLdapUrlList) {
                String[] attrname = new String[1];
                JndiAttrs ja = new JndiAttrs(this.up);
                attrname[0] = service_attr_name;
                Vector _service = null;
                try {
                    _service = ja.getAttrs(this.TNSAddress, attrname);
                }
                finally {
                    ja.close();
                }
                this.TNSAddress = (String)_service.firstElement();
                this.connection_revised = true;
            } else {
                this.processLdapFailoverLoadblance(ldapUrlList);
            }
        }
        if ((prop = this.up.getProperty("oracle.net.oldSyntax")) != null && (prop.equalsIgnoreCase("ON") || prop.equalsIgnoreCase("TRUE") || prop.equalsIgnoreCase("YES"))) {
            this.newSyntax = false;
        }
    }

    private Vector<String> computeLdapList(String tnsDesc) {
        String[] ldapUrlS = pattern.split(tnsDesc);
        int nonEmptyLdapUrlsCount = 0;
        for (int i2 = 0; i2 < ldapUrlS.length; ++i2) {
            ldapUrlS[i2] = ldapUrlS[i2].trim();
            if (ldapUrlS[i2].length() == 0) continue;
            ++nonEmptyLdapUrlsCount;
        }
        Vector<String> ret = new Vector<String>(nonEmptyLdapUrlsCount);
        for (int i3 = 0; i3 < ldapUrlS.length; ++i3) {
            if (ldapUrlS[i3].length() == 0) continue;
            ret.add(ldapUrlS[i3]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLdapFailoverLoadblance(Vector<String> urlList) throws NetException {
        boolean urlStart = false;
        if (urlList.size() <= 1) {
            throw new NetException(124);
        }
        boolean ldapFailover = true;
        boolean ldapLoadbalance = true;
        String prop = this.up.getProperty("oracle.net.ldap_failover");
        if (prop != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapFailover = false;
        }
        if ((prop = this.up.getProperty("oracle.net.ldap_loadbalance")) != null && (prop.equalsIgnoreCase("OFF") || prop.equalsIgnoreCase("FALSE") || prop.equalsIgnoreCase("NO"))) {
            ldapLoadbalance = false;
        }
        if (urlList.size() > 1) {
            urlList = NavDescriptionList.setActiveChildren(urlList, ldapFailover, ldapLoadbalance);
        }
        StringBuffer sbJndiUrlList = new StringBuffer();
        int listSize = urlList.size();
        Hashtable<String, String> tabMapUrlToTns = new Hashtable<String, String>(listSize);
        for (int i2 = 0; i2 < listSize; ++i2) {
            String url = (String)urlList.elementAt(i2);
            int pos = url.lastIndexOf(47);
            if (pos == -1) {
                throw new NetException(124);
            }
            String jndiUrl = url.substring(0, pos);
            String tnsAddr = url.substring(pos + 1, url.length());
            sbJndiUrlList.append(jndiUrl);
            if (i2 < listSize - 1) {
                sbJndiUrlList.append(' ');
            }
            tabMapUrlToTns.put(jndiUrl.substring(jndiUrl.indexOf(47)), tnsAddr);
        }
        String jndiUrlList = new String(sbJndiUrlList);
        this.up.put("java.naming.provider.url", jndiUrlList);
        JndiAttrs ja = new JndiAttrs(this.up);
        String ldapUlrConnected = ja.getLdapUrlUsed();
        this.TNSAddress = (String)tabMapUrlToTns.get(ldapUlrConnected.substring(ldapUlrConnected.indexOf(47)));
        Vector serviceList = null;
        String[] attrNames = new String[]{service_attr_name};
        try {
            serviceList = ja.getAttrs(this.TNSAddress, attrNames);
        }
        finally {
            ja.close();
        }
        this.TNSAddress = (String)serviceList.firstElement();
        this.connection_revised = true;
    }

    public String getTNSAddress() {
        return this.TNSAddress.toUpperCase();
    }

    public ConnOption resolveAndExecute(String TNSdesc) throws NetException, IOException {
        ConnStrategy orig_cs = this.cs;
        if (TNSdesc != null) {
            this.cs = new ConnStrategy(this.up);
            if (this.connection_redirected) {
                this.cs.sdu = orig_cs.sdu;
                this.cs.tdu = orig_cs.tdu;
                this.cs.retryCount = orig_cs.retryCount;
                this.cs.socketOptions = orig_cs.socketOptions;
                this.cs.reuseOpt = true;
            }
            if (TNSdesc.indexOf(41) == -1) {
                if ((TNSdesc = TNSdesc.trim()).startsWith("//") || TNSdesc.matches("[\\w]*") || TNSdesc.matches("[\\[[\\w:]*\\]]") || TNSdesc.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:pooled)?(?-i)")) {
                    String tnsAdmin = System.getProperty("oracle.net.tns_admin");
                    NameResolver nr = NameResolverFactory.getNameResolver(tnsAdmin, this.cs.getOSUsername(), this.cs.getProgramName());
                    TNSdesc = TNSdesc.replaceAll("#", "\\\\#");
                    this.TNSAddress = nr.resolveName(TNSdesc);
                    this.resolveAddrTree(this.TNSAddress);
                } else {
                    this.resolveSimple(TNSdesc);
                }
            } else if (this.newSyntax) {
                this.resolveAddrTree(TNSdesc);
            } else {
                this.resolveAddr(TNSdesc);
            }
        } else if (this.cs == null || !this.cs.hasMoreOptions()) {
            return null;
        }
        return this.cs.execute();
    }

    private void resolveSimple(String TNSdesc) throws NetException {
        ConnOption co = new ConnOption();
        int fColon = 0;
        int sColon = 0;
        int eColon = 0;
        int initialIndex = 0;
        boolean isIPV6Literal = false;
        if (TNSdesc.startsWith("[")) {
            initialIndex = TNSdesc.indexOf(93);
            if (initialIndex == -1) {
                throw new NetException(115);
            }
            isIPV6Literal = true;
        }
        if ((fColon = TNSdesc.indexOf(58, initialIndex)) == -1 || (sColon = TNSdesc.indexOf(58, fColon + 1)) == -1) {
            throw new NetException(115);
        }
        eColon = TNSdesc.indexOf(58, sColon + 1);
        if (eColon != -1) {
            throw new NetException(115);
        }
        try {
            co.host = isIPV6Literal ? TNSdesc.substring(1, fColon - 1) : TNSdesc.substring(0, fColon);
            co.port = Integer.parseInt(TNSdesc.substring(fColon + 1, sColon));
            co.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + "))";
            co.sid = TNSdesc.substring(sColon + 1, TNSdesc.length());
            String connData = "(DESCRIPTION=(CONNECT_DATA=(SID=" + co.sid + ")(CID=(PROGRAM=" + this.cs.getProgramName() + ")(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))" + "(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + ")))";
            co.protocol = DEFAULT_CONNECT_PROTOCOL;
            co.conn_data = new StringBuffer(connData);
            this.cs.addOption(co);
        }
        catch (NumberFormatException nfe) {
            throw new NetException(116);
        }
    }

    private void resolveAddr(String TNSdesc) throws NetException {
        if (TNSdesc.startsWith("alias=")) {
            String desc = TNSdesc;
            TNSdesc = desc.substring(desc.indexOf("alias=") + 6, desc.length());
        }
        ConnOption co = new ConnOption();
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        NVPair cid = null;
        NVPair addr = null;
        try {
            cid = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "CID");
            addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "address");
        }
        catch (NLException exp) {
            NetException ne = new NetException(101);
            ne.initCause(exp);
            throw ne;
        }
        NVPair cnvp = nvn.findNVPair(addr, "protocol");
        if (cnvp == null) {
            throw new NetException(100);
        }
        co.protocol = cnvp.getAtom();
        if (!(co.protocol.equals(DEFAULT_CONNECT_PROTOCOL) || co.protocol.equals("tcp") || co.protocol.equals("SSL") || co.protocol.equals("ssl") || co.protocol.equals("ANO") || co.protocol.equals("ano"))) {
            throw new NetException(102);
        }
        cnvp = nvn.findNVPair(addr, "Host");
        if (cnvp == null) {
            throw new NetException(103);
        }
        co.host = cnvp.getAtom();
        cnvp = nvn.findNVPair(addr, "Port");
        if (cnvp == null) {
            throw new NetException(104);
        }
        co.port = Integer.parseInt(cnvp.getAtom());
        cnvp = nvn.findNVPair(addr, "sduSize");
        if (cnvp != null) {
            co.sdu = Integer.parseInt(cnvp.getAtom());
        }
        if ((cnvp = nvn.findNVPair(addr, "tduSize")) != null) {
            co.tdu = Integer.parseInt(cnvp.getAtom());
        }
        NVPair cdata = null;
        try {
            cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSdesc), "connect_data");
        }
        catch (NLException exp) {
            NetException ne = new NetException(101);
            ne.initCause(exp);
            throw ne;
        }
        StringBuffer tnsSB = new StringBuffer(TNSdesc);
        co.conn_data = cdata != null ? this.insertCID(TNSdesc) : tnsSB;
        co.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + co.host + ")(PORT=" + co.port + "))";
        this.cs.addOption(co);
    }

    private void resolveAddrTree(String TNSdesc) throws NetException {
        NavSchemaObjectFactory fac = new NavSchemaObjectFactory();
        NavServiceAlias sa = (NavServiceAlias)fac.create(4);
        try {
            String alias = TNSdesc.startsWith("alias=") ? TNSdesc : "alias=" + TNSdesc;
            sa.initFromString(alias);
        }
        catch (NLException nle) {
            throw new NetException(501);
        }
        catch (SOException soe) {
            throw new NetException(502, soe.getMessage());
        }
        sa.navigate(this.cs, null);
    }

    private StringBuffer insertCID(String TNSaddr) throws NetException {
        NVFactory nvf = new NVFactory();
        NVNavigator nvn = new NVNavigator();
        StringBuffer tns = new StringBuffer(2048);
        NVPair desc = null;
        NVPair addrl = null;
        NVPair addr = null;
        NVPair cdata = null;
        NVPair sroute = null;
        try {
            desc = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "description");
            addrl = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address_list");
            addr = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "address");
            cdata = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "connect_data");
            sroute = nvn.findNVPairRecurse(nvf.createNVPair(TNSaddr), "source_route");
        }
        catch (NLException exp) {
            NetException ne = new NetException(101);
            ne.initCause(exp);
            throw ne;
        }
        NVPair sid = null;
        NVPair cid = null;
        NVPair sn = null;
        if (cdata == null) {
            throw new NetException(105);
        }
        sid = nvn.findNVPair(cdata, "SID");
        cid = nvn.findNVPair(cdata, "CID");
        sn = nvn.findNVPair(cdata, "SERVICE_NAME");
        if (sid == null && sn == null) {
            throw new NetException(106);
        }
        tns.append("(DESCRIPTION=");
        if (addrl != null && addrl.getListSize() > 0) {
            for (int i2 = 0; i2 < addrl.getListSize(); ++i2) {
                NVPair nvp = addrl.getListElement(i2);
                tns.append(nvp.toString());
            }
        } else if (addr != null) {
            tns.append(addr.toString());
        } else {
            throw new NetException(107);
        }
        if (sn != null) {
            tns.append("(CONNECT_DATA=" + sn.toString() + "(CID=(PROGRAM=" + this.cs.getProgramName() + ")(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        } else {
            tns.append("(CONNECT_DATA=" + sid.toString() + "(CID=(PROGRAM=" + this.cs.getProgramName() + ")(HOST=__jdbc__)(USER=" + this.cs.getOSUsername() + ")))");
        }
        if (sroute != null) {
            tns.append(sroute.toString());
        }
        tns.append(")");
        return tns;
    }

    public Properties getUp() {
        return this.up;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.cs.isConnectionSocketKeepAlive();
    }
}

