/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;

class T4CNamedTypeAccessor
extends NamedTypeAccessor {
    static final int maxLength = Integer.MAX_VALUE;
    final int[] meta = new int[1];
    T4CMAREngine mare;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    T4CNamedTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, typeName, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            Object var10_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_14 = null;
            }
            catch (Throwable throwable2) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CNamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var19_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CNamedTypeAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_19 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        byte[] toid = this.mare.unmarshalDALC();
        byte[] oid = this.mare.unmarshalDALC();
        byte[] snp = this.mare.unmarshalDALC();
        int vsn = this.mare.unmarshalUB2();
        long imagel = this.mare.unmarshalUB4();
        int flags = this.mare.unmarshalUB2();
        byte[] byte_value = null;
        byte_value = imagel > 0L ? this.mare.unmarshalCLR((int)imagel, this.meta) : new byte[]{};
        this.pickledBytes[this.lastRowProcessed] = byte_value;
        this.processIndicator(this.meta[0]);
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.rowSpaceIndicator != null) {
            if (this.meta[0] == 0) {
                this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
                this.rowSpaceIndicator[tmpLengthOffset] = 0;
            } else {
                this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
                this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
            }
        }
        ++this.lastRowProcessed;
        return false;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CNamedTypeAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

