/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class OutRawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = Short.MAX_VALUE;
    static final int MAXLENGTH_OLD = Short.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutRawAccessor(OracleStatement stmt, int max_len, short form, int external_type) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type));
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.init(stmt, 23, 23, form, true);
            this.initForDataAccess(external_type, max_len, null);
            Object var8_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? Short.MAX_VALUE : Short.MAX_VALUE;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
            Object var7_7 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable2) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int currentRow) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OutRawAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                result = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, result, 0, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = result;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OutRawAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OutRawAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

