/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DiagnosabilityMXBean;
import oracle.jdbc.driver.OracleLog;

public class OracleDiagnosabilityMBean
extends StandardMBean
implements DiagnosabilityMXBean {
    OracleDiagnosabilityMBean() throws NotCompliantMBeanException {
        super(DiagnosabilityMXBean.class);
    }

    public boolean getLoggingEnabled() {
        return OracleLog.isEnabled();
    }

    public void setLoggingEnabled(boolean enable) {
        OracleLog.setTrace(enable);
    }

    public boolean stateManageable() {
        return false;
    }

    public boolean statisticsProvider() {
        return false;
    }

    protected String getDescription(MBeanInfo info) {
        return DatabaseError.findMessage("DiagnosabilityMBeanDescription", (Object)this);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return DatabaseError.findMessage("DiagnosabilityMBeanConstructor()", (Object)this);
    }

    protected String getDescription(MBeanAttributeInfo info) {
        String n2 = info.getName();
        if (n2.equals("LoggingEnabled")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanLoggingEnabledDescription", (Object)this);
        }
        if (n2.equals("stateManageable")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStateManageableDescription", (Object)this);
        }
        if (n2.equals("statisticsProvider")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStatisticsProviderDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + n2);
        return super.getDescription(info);
    }
}

