/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

abstract class CharCommonAccessor
extends Accessor {
    int internalMaxLengthNewer;
    int internalMaxLengthOlder;
    static final int MAX_NB_CHAR_PLSQL = 32766;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    CharCommonAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOffsets(int nrows) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nrows));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.columnIndex = this.statement.defineCharSubRange;
            this.statement.defineCharSubRange = this.columnIndex + nrows * this.charLength;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, short form, int external_type, boolean forBind, int newer, int older) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(newer) + ", " + OracleLog.argument(older));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (forBind) {
                if (internal_type != 23) {
                    internal_type = 1;
                }
                if (stmt.maxFieldSize > 0 && (max_len == -1 || max_len < stmt.maxFieldSize)) {
                    max_len = stmt.maxFieldSize;
                }
            }
            this.init(stmt, internal_type, database_type, form, forBind);
            if (forBind && stmt.connection.defaultnchar) {
                this.formOfUse = (short)2;
            }
            this.internalMaxLengthNewer = newer;
            this.internalMaxLengthOlder = older;
            this.initForDataAccess(external_type, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int newer, int older) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(newer) + ", " + OracleLog.argument(older));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.init(stmt, internal_type, database_type, form, false);
            this.initForDescribe(internal_type, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size != 0 && max_field_size <= max_len) {
                max_len = max_field_size;
            }
            this.internalMaxLengthNewer = newer;
            this.internalMaxLengthOlder = older;
            this.initForDataAccess(0, max_len, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? this.internalMaxLengthNewer : this.internalMaxLengthOlder;
            if (max_len == 0) {
                this.internalTypeMaxLength = 0;
            } else if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.charLength = this.isNullByDescribe ? 0 : this.internalTypeMaxLength + 1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInt(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int result = 0;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Integer.parseInt(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getBoolean(int currentRow) throws SQLException {
        try {
            String valAsString;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((valAsString = this.getString(currentRow)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            valAsString = valAsString.trim();
            try {
                boolean __result__;
                BigDecimal valAsBD = new BigDecimal(valAsString);
                boolean bl = __result__ = valAsBD.signum() != 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = __result__;
                return bl2;
            }
            catch (NumberFormatException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short getShort(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short result = 0;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Short.parseShort(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s2 = result;
            return s2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getByte(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte result = 0;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Byte.parseByte(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = result;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLong(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long result = 0L;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Long.parseLong(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = result;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getFloat(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float result = 0.0f;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Float.parseFloat(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f2 = result;
            return f2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getDouble(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double result = 0.0;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = Double.parseDouble(this.getString(currentRow).trim());
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d2 = result;
            return d2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    String ss = this.getString(currentRow);
                    if (ss != null) {
                        result = new BigDecimal(ss.trim());
                    }
                }
                catch (NumberFormatException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getBigDecimal(int currentRow, int scale) throws SQLException {
        try {
            BigDecimal bd;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((bd = this.getBigDecimal(currentRow)) != null) {
                bd.setScale(scale, 6);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bd);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = bd;
            return bigDecimal;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                result = new String(this.rowSpaceChar, lenoffset + 1, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date getDate(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = Date.valueOf(this.getString(currentRow).trim());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = result;
            return date;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = Time.valueOf(this.getString(currentRow).trim());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = result;
            return time;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp getTimestamp(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = Timestamp.valueOf(this.getString(currentRow).trim());
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    byte[] getBytes(int currentRow) throws SQLException {
        return this.getBytesInternal(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytesInternal(int currentRow) throws SQLException {
        byte[] result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            int lenoffset = this.columnIndex + this.charLength * currentRow;
            int len = this.rowSpaceChar[lenoffset] >> 1;
            if (len > this.internalTypeMaxLength) {
                len = this.internalTypeMaxLength;
            }
            DBConversion dbconv = this.statement.connection.conversion;
            byte[] buf = new byte[len * 6];
            int nbytes = this.formOfUse == 2 ? dbconv.javaCharsToNCHARBytes(this.rowSpaceChar, lenoffset + 1, buf, 0, len) : dbconv.javaCharsToCHARBytes(this.rowSpaceChar, lenoffset + 1, buf, 0, len);
            result = new byte[nbytes];
            System.arraycopy(buf, 0, result, 0, nbytes);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getAsciiStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.CharsToStream(this.rowSpaceChar, lenoffset + 1, len, 10);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                PhysicalConnection conn = this.statement.connection;
                result = conn.conversion.CharsToStream(this.rowSpaceChar, lenoffset + 1, len << 1, 11);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = result;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reader getCharacterStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                result = new CharArrayReader(this.rowSpaceChar, lenoffset + 1, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader = result;
            return charArrayReader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getBinaryStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                DBConversion dbconv = this.statement.connection.conversion;
                byte[] buf = new byte[len * 6];
                int nbytes = this.formOfUse == 2 ? dbconv.javaCharsToNCHARBytes(this.rowSpaceChar, lenoffset + 1, buf, 0, len) : dbconv.javaCharsToCHARBytes(this.rowSpaceChar, lenoffset + 1, buf, 0, len);
                result = new ByteArrayInputStream(buf, 0, nbytes);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream byteArrayInputStream = result;
            return byteArrayInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = this.getString(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String __result__ = this.getString(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR __result__ = this.getCHAR(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR = __result__;
            return cHAR;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CHAR getCHAR(int currentRow) throws SQLException {
        try {
            byte[] bytes;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((bytes = this.getBytesInternal(currentRow)) == null || bytes.length == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CHAR cHAR = null;
                return cHAR;
            }
            CharacterSet cs = this.formOfUse == 2 ? this.statement.connection.conversion.getDriverNCharSetObj() : this.statement.connection.conversion.getDriverCharSetObj();
            CHAR __result__ = new CHAR(bytes, cs);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR = __result__;
            return cHAR;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL getURL(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                try {
                    result = new URL(this.getString(currentRow));
                }
                catch (MalformedURLException exc) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL = result;
            return uRL;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytesFromHexChars(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharCommonAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int lenoffset = this.columnIndex + this.charLength * currentRow;
                int len = this.rowSpaceChar[lenoffset] >> 1;
                if (len > this.internalTypeMaxLength) {
                    len = this.internalTypeMaxLength;
                }
                result = this.statement.connection.conversion.hexChars2Bytes(this.rowSpaceChar, lenoffset + 1, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharCommonAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
            _checkSum = CRC64.updateChecksum(_checkSum, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
        } else {
            int lenoffset = this.columnIndex + this.charLength * currentRow;
            int len = this.rowSpaceChar[lenoffset] >> 1;
            _checkSum = CRC64.updateChecksum(_checkSum, this.rowSpaceChar, lenoffset + 1, len);
        }
        return _checkSum;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.CharCommonAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

