/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.jdbinterface.common;

import com.businessobjects.reports.jdbinterface.common.FieldInfo;
import com.businessobjects.reports.jdbinterface.common.ResultSetReader;
import com.businessobjects.reports.jdbinterface.common.ServerDriverType;
import com.crystaldecisions.reports.common.value.ValueType;

public class JDBUtils {
    public static final int MaxStringValueCharCount = 65534;
    public static final int MaxStringValueByteCount = 131070;
    private static final int do = 64;
    private static final int if = 5;
    private static final int for = 10;
    private static final int int = 19;
    private static final int byte = 38;
    private static final int char = 16002;
    private static final int a = 38;
    private static final int try = 53;
    private static final int new = 24;
    private static final int case = -8;

    private JDBUtils() {
    }

    public static int SQL2CrystalSize(int n, int n2) {
        switch (n) {
            case -7: 
            case -5: 
            case -2: 
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 16: 
            case 91: 
            case 2004: {
                return n2;
            }
            case 4: {
                return n2;
            }
            case -4: 
            case 2: {
                return n2;
            }
            case -6: 
            case -3: 
            case 5: 
            case 7: 
            case 12: 
            case 92: 
            case 93: {
                return (n2 + 1) * 2;
            }
            case -1: {
                return n2;
            }
        }
        return n2;
    }

    public static int checkFieldAttribute(ServerDriverType serverDriverType, String string, int n) {
        if (serverDriverType.isOracle() && (string.equalsIgnoreCase("CHAR") || string.equalsIgnoreCase("VARCHAR") || string.equalsIgnoreCase("VARCHAR2"))) {
            n = 0;
        }
        return n;
    }

    public static void FillInFieldInfo(FieldInfo fieldInfo, ServerDriverType serverDriverType, int n, String string, int n2, int n3) {
        ValueType valueType;
        int n4 = n2;
        if (n4 == 0) {
            n4 = n3;
        }
        int n5 = 0;
        boolean bl = ResultSetReader.IsBinarySQLType(n);
        int n6 = bl ? 1 : 0;
        int n7 = ResultSetReader.GetAdjustedSQLDataType(n, string, n3, serverDriverType);
        switch (n7) {
            case -5: {
                valueType = ValueType.number;
                break;
            }
            case -7: {
                if (serverDriverType.isMySQL() && n3 > 1) {
                    if (n3 < 8) {
                        valueType = ValueType.int8s;
                        break;
                    }
                    if (n3 < 16) {
                        valueType = ValueType.int16s;
                        break;
                    }
                    if (n3 < 32) {
                        valueType = ValueType.int32s;
                        break;
                    }
                    valueType = ValueType.int64s;
                    break;
                }
                valueType = ValueType.bool;
                break;
            }
            case 2005: {
                valueType = ValueType.memo;
                n5 = 0;
                break;
            }
            case -4: {
                valueType = ValueType.blob;
                n5 = 0;
                break;
            }
            case 2004: {
                valueType = ValueType.blob;
                n5 = 0;
                break;
            }
            case 16: {
                valueType = ValueType.bool;
                break;
            }
            case 1: {
                valueType = ValueType.string;
                n6 = JDBUtils.checkFieldAttribute(serverDriverType, string, n6);
                if (serverDriverType.isMySQL() && string.equalsIgnoreCase("SET")) {
                    n3 *= 64;
                } else if (string.equalsIgnoreCase("NCHAR")) {
                    n6 = 2;
                }
                n5 = JDBUtils.SQL2CrystalSize(12, n3);
                break;
            }
            case 2: 
            case 3: {
                valueType = ValueType.number;
                if (n2 == 0) {
                    if (n3 <= 5) {
                        valueType = ValueType.int16s;
                    } else if (n3 <= 10) {
                        valueType = ValueType.int32s;
                    } else if (n3 <= 19) {
                        valueType = ValueType.number;
                    } else if (n3 <= 38) {
                        valueType = ValueType.number;
                    }
                }
                if ((serverDriverType.isSQLServer() || serverDriverType.isMySQL() || serverDriverType.isInformix() || serverDriverType.isSybase()) && (string.equalsIgnoreCase("MONEY") || string.equalsIgnoreCase("SMALLMONEY"))) {
                    valueType = ValueType.currency;
                }
                n4 = n3;
                break;
            }
            case 6: 
            case 8: {
                n4 = 53;
                valueType = ValueType.number;
                break;
            }
            case 7: {
                n4 = 24;
                valueType = ValueType.number;
                break;
            }
            case 4: {
                valueType = ValueType.int32s;
                n4 = n3;
                break;
            }
            case 5: {
                valueType = ValueType.int16s;
                break;
            }
            case -6: {
                valueType = ValueType.int16s;
                break;
            }
            case -3: 
            case -2: {
                n6 = 1;
            }
            case 12: {
                valueType = ValueType.string;
                n5 = JDBUtils.SQL2CrystalSize(12, n3);
                if (string.equalsIgnoreCase("NVARCHAR")) {
                    n6 = 2;
                } else if (string.equalsIgnoreCase("TIMESTAMP")) {
                    n5 = JDBUtils.SQL2CrystalSize(12, n3 * 2);
                } else if (string.equalsIgnoreCase("SQL_VARIANT")) {
                    n5 = 16002;
                } else if (string.equalsIgnoreCase("RAW") || string.equalsIgnoreCase("BINARY") || string.equalsIgnoreCase("VARBINARY")) {
                    n5 = JDBUtils.SQL2CrystalSize(12, n3 * 2);
                } else if (string.equalsIgnoreCase("ROWID")) {
                    n5 = 38;
                }
                n6 = JDBUtils.checkFieldAttribute(serverDriverType, string, n6);
                break;
            }
            case 91: {
                if (serverDriverType.isOracle()) {
                    valueType = ValueType.dateTime;
                    break;
                }
                valueType = ValueType.date;
                n4 = n3;
                break;
            }
            case 92: {
                valueType = ValueType.time;
                n4 = n3;
                break;
            }
            case 93: {
                n4 = n3;
                valueType = ValueType.dateTime;
                break;
            }
            case -1: {
                valueType = ValueType.memo;
                n5 = 0;
                break;
            }
            case -8: {
                n5 = 38;
                valueType = ValueType.string;
                break;
            }
            case 2006: {
                valueType = ValueType.pointer;
                break;
            }
            case 2003: {
                if (serverDriverType.isPostgreSQL()) {
                    valueType = ValueType.memo;
                    n5 = 0;
                    break;
                }
            }
            default: {
                if (string.equalsIgnoreCase("NVARCHAR") || string.equalsIgnoreCase("NCHAR")) {
                    valueType = ValueType.string;
                    n6 = 2;
                    n5 = JDBUtils.SQL2CrystalSize(12, n3);
                    break;
                }
                if (string.equalsIgnoreCase("NTEXT")) {
                    valueType = ValueType.memo;
                    n6 = 2;
                    n5 = 0;
                    break;
                }
                valueType = ValueType.unknown;
                n5 = 0;
                n6 = 1;
            }
        }
        fieldInfo.dataType = valueType;
        fieldInfo.fieldSize = n5;
        fieldInfo.m_Attributes = n6;
        fieldInfo.m_Precision = n4;
    }
}

