/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.log4j.Log4jNDC;
import com.businessobjects.foundation.logging.log4j.SpecializedHierarchy;
import com.businessobjects.foundation.logging.spi.BootstrapLogger;
import com.businessobjects.foundation.logging.spi.ConfigurableLoggingProvider;
import com.businessobjects.foundation.logging.spi.INDC;
import java.net.URL;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootCategory;

public class Log4jProvider
extends ConfigurableLoggingProvider {
    public static final String OVERRIDE_KEY = "bobj.logging.log4j.override";
    public static final String CONFIGURATION_KEY = "bobj.logging.log4j.config";
    public static final String DEFAULT_CONFIG_NAME = "log4j.properties";
    public static final String RELATIVE_CONFIG_PATH = "META-INF/BusinessObjects.Logging/log4j";
    private static Log4jNDC s_ndc = new Log4jNDC();
    private SpecializedHierarchy m_hierarchy = new SpecializedHierarchy((Logger)new RootCategory(Level.OFF));

    public void configure(URL url) {
        new PropertyConfigurator().doConfigure(url, (LoggerRepository)this.m_hierarchy);
    }

    public void configure(String configFileName) {
        new PropertyConfigurator().doConfigure(configFileName, (LoggerRepository)this.m_hierarchy);
    }

    public void dispose() {
        this.m_hierarchy.shutdown();
    }

    public ILogger getLogger(String name) {
        return (ILogger)this.m_hierarchy.getLogger(name);
    }

    public INDC getNDCInterface() {
        return s_ndc;
    }

    public void initializeConfiguration() {
        String override = System.getProperty(OVERRIDE_KEY);
        if (override != null) {
            BootstrapLogger.debug("Overriding the default configuration mechanism and configuring from the file " + override + ".");
            new PropertyConfigurator().doConfigure(override, (LoggerRepository)this.m_hierarchy);
        } else {
            this.configureResources("META-INF/BusinessObjects.Logging/log4j/" + System.getProperty(CONFIGURATION_KEY, DEFAULT_CONFIG_NAME));
        }
    }

    public void reconfigure() {
        this.m_hierarchy.resetConfiguration();
        this.m_hierarchy.getRootLogger().setLevel(Level.OFF);
        this.initializeConfiguration();
    }
}

