/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.NumberUtil;
import com.crystaldecisions12.reports.common.StringUtil;
import com.crystaldecisions12.reports.common.value.BooleanValue;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.NumericValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class NumberValue
extends NumericValue {
    public static final NumberValue zero = new NumberValue(0.0, true);
    public static final NumberValue one = new NumberValue(100.0, true);
    public static final NumberValue two = new NumberValue(200.0, true);
    public static final NumberValue ten = new NumberValue(1000.0, true);

    private NumberValue(double d10, boolean bl2) {
        super(d10, bl2);
    }

    static NumberValue a(double d10, boolean bl2) {
        if (d10 == zero.getScaledDouble()) {
            return zero;
        }
        if (d10 == one.getScaledDouble()) {
            return one;
        }
        if (d10 == two.getScaledDouble()) {
            return two;
        }
        if (d10 == ten.getScaledDouble()) {
            return ten;
        }
        return new NumberValue(d10, bl2);
    }

    public static NumberValue fromScaledDouble(double d10) {
        return NumberValue.a(d10, false);
    }

    public static NumberValue fromScaledLong(long l2) {
        return NumberValue.a(l2, NumberUtil.a(l2));
    }

    public static NumberValue fromDouble(double d10) {
        return NumberValue.fromScaledDouble(d10 * 100.0);
    }

    public static NumberValue fromLong(long l2) {
        return NumberValue.a((double)l2 * 100.0, NumberUtil.if(l2));
    }

    public static NumberValue fromCurrencyValue(CurrencyValue currencyValue) {
        return NumberValue.a(currencyValue.getScaledDouble(), currencyValue.f);
    }

    public FormulaValue coerceToNumber() {
        return this;
    }

    public FormulaValue coerceToCurrency() {
        return CurrencyValue.fromNumberValue(this);
    }

    public FormulaValue coerceToBoolean() {
        return this.getScaledDouble() == 0.0 ? BooleanValue.FALSE : BooleanValue.TRUE;
    }

    public ValueType getValueType() {
        return ValueType.ax;
    }

    public String toString() {
        return "n" + super.toString();
    }

    public static CrystalValue fromFormattedString(Locale locale, String string) throws ParseException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = string;
        string2 = string2.trim();
        NumberFormat numberFormat = FormatterCache.new(locale);
        DecimalFormat decimalFormat = FormatterCache.do(locale);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string3 = decimalFormatSymbols.getCurrencySymbol();
        String string4 = StringUtil.removeNegativeSymbol(string2 = StringUtil.removeCurrencySymbol(string2, string3));
        boolean bl2 = string4.compareTo(string2) != 0;
        Number number = numberFormat.parse(string4);
        double d10 = number.doubleValue();
        if (bl2) {
            d10 = -d10;
        }
        return NumberValue.fromDouble(d10);
    }
}

