/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.valuegrid;

import com.crystaldecisions.reports.common.GroupPath;
import com.crystaldecisions.reports.common.value.SpecialCrystalValue;
import com.crystaldecisions.reports.valuegrid.IValueGrid;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ValueGridUtilities {
    public static void ForEachValueGridRow(IValueGrid iValueGrid, IRowOrColumnHandler iRowOrColumnHandler) {
        int n2 = iValueGrid.getNRows();
        for (int i2 = 0; i2 < n2; ++i2) {
            GroupPath groupPath = iValueGrid.getRowGroupPath(i2);
            if (iRowOrColumnHandler.OnRowOrColumn(true, i2, groupPath)) continue;
            return;
        }
    }

    public static void ForEachValueGridColumn(IValueGrid iValueGrid, IRowOrColumnHandler iRowOrColumnHandler) {
        int n2 = iValueGrid.getNColumns();
        for (int i2 = 0; i2 < n2; ++i2) {
            GroupPath groupPath = iValueGrid.getColumnGroupPath(i2);
            if (iRowOrColumnHandler.OnRowOrColumn(false, i2, groupPath)) continue;
            return;
        }
    }

    public static void ForEachValueGridRowOrColumn(IValueGrid iValueGrid, boolean bl2, IRowOrColumnHandler iRowOrColumnHandler) {
        if (bl2) {
            ValueGridUtilities.ForEachValueGridRow(iValueGrid, iRowOrColumnHandler);
        } else {
            ValueGridUtilities.ForEachValueGridColumn(iValueGrid, iRowOrColumnHandler);
        }
    }

    public static Object FetchAssociatedValue(IValueGrid iValueGrid, boolean bl2, GroupPath groupPath) {
        if (bl2) {
            return iValueGrid.fetchRowAssociatedValue(groupPath);
        }
        return iValueGrid.fetchColumnAssociatedValue(groupPath);
    }

    public static void DumpValueGrid(IValueGrid iValueGrid) {
        Object object;
        GroupPath groupPath;
        int n2;
        System.out.println("Rows: " + iValueGrid.getNRows() + ", Columns: " + iValueGrid.getNColumns() + ", ValuesPerCells: " + iValueGrid.getNValuesPerCell());
        int n3 = iValueGrid.getNRows();
        for (n2 = 0; n2 < n3; ++n2) {
            groupPath = iValueGrid.getRowGroupPath(n2);
            object = iValueGrid.fetchRowAssociatedValue(groupPath);
            System.out.println("Row " + n2 + ", " + groupPath.toString() + " , Associated Value: " + object.toString());
        }
        n3 = iValueGrid.getNColumns();
        for (n2 = 0; n2 < n3; ++n2) {
            groupPath = iValueGrid.getColumnGroupPath(n2);
            object = iValueGrid.fetchColumnAssociatedValue(groupPath);
            System.out.println("Column " + n2 + ", " + groupPath.toString() + " , Associated Value: " + object.toString());
        }
        n3 = iValueGrid.getNRows();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = iValueGrid.getNColumns();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = iValueGrid.getNValuesPerCell();
                for (int i3 = 0; i3 < n5; ++i3) {
                    Object object2 = iValueGrid.fetchCellValue(n2, i2, i3);
                    System.out.println("<" + n2 + "," + i2 + "," + i3 + ">: " + object2.toString());
                }
            }
        }
        System.out.println();
    }

    public static void DumpValueGridXML(IValueGrid iValueGrid, String string) {
        try {
            Element element;
            Element element2;
            Element element3;
            Element element4;
            Object object;
            Object object2;
            GroupPath groupPath;
            int n2;
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element5 = document.createElement("ValueGrid");
            element5.setAttribute("nRows", new Integer(iValueGrid.getNRows()).toString());
            element5.setAttribute("nColumns", new Integer(iValueGrid.getNColumns()).toString());
            element5.setAttribute("nValuesPerCell", new Integer(iValueGrid.getNValuesPerCell()).toString());
            document.appendChild(element5);
            for (n2 = 0; n2 < iValueGrid.getNValuesPerCell(); ++n2) {
                Element element6 = document.createElement("ValueAssociatedAttribute");
                element6.setTextContent(ValueGridUtilities.a(iValueGrid.fetchAssociatedValueAttribute(n2)).toString());
                element5.appendChild(element6);
            }
            int n3 = iValueGrid.getNRows();
            for (n2 = 0; n2 < n3; ++n2) {
                groupPath = iValueGrid.getRowGroupPath(n2);
                object2 = iValueGrid.fetchRowAssociatedValue(groupPath);
                object = iValueGrid.fetchRowAssociatedAttribute(groupPath);
                element4 = document.createElement("Row");
                element3 = document.createElement("GroupPath");
                if (groupPath == null) {
                    element3.setTextContent("");
                } else {
                    element3.setTextContent(groupPath.toString());
                }
                element2 = document.createElement("RowAssociatedValue");
                element2.setTextContent(ValueGridUtilities.a(object2).toString());
                element = document.createElement("RowAssociatedAttribute");
                element.setTextContent(ValueGridUtilities.a(object).toString());
                element4.appendChild(element3);
                element4.appendChild(element2);
                element4.appendChild(element);
                element5.appendChild(element4);
            }
            n3 = iValueGrid.getNColumns();
            for (n2 = 0; n2 < n3; ++n2) {
                groupPath = iValueGrid.getColumnGroupPath(n2);
                object2 = iValueGrid.fetchColumnAssociatedValue(groupPath);
                object = iValueGrid.fetchColumnAssociatedAttribute(groupPath);
                element4 = document.createElement("Column");
                element3 = document.createElement("GroupPath");
                if (groupPath == null) {
                    element3.setTextContent("");
                } else {
                    element3.setTextContent(groupPath.toString());
                }
                element2 = document.createElement("ColumnAssociatedValue");
                element2.setTextContent(ValueGridUtilities.a(object2).toString());
                element = document.createElement("ColumnAssociatedAttribute");
                element.setTextContent(ValueGridUtilities.a(object).toString());
                element4.appendChild(element3);
                element4.appendChild(element2);
                element4.appendChild(element);
                element5.appendChild(element4);
            }
            n3 = iValueGrid.getNRows();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = iValueGrid.getNColumns();
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5 = iValueGrid.getNValuesPerCell();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        element3 = document.createElement("Cell");
                        element2 = document.createElement("Value");
                        if (iValueGrid.fetchCellValue(n2, i2, i3) != null) {
                            element2.setTextContent(ValueGridUtilities.a(iValueGrid.fetchCellValue(n2, i2, i3)).toString());
                        }
                        element3.appendChild(element2);
                        element = document.createElement("Attribute");
                        if (iValueGrid.fetchCellAttribute(n2, i2, i3) != null) {
                            element.setTextContent(ValueGridUtilities.a(iValueGrid.fetchCellAttribute(n2, i2, i3)).toString());
                        }
                        element3.appendChild(element);
                        element5.appendChild(element3);
                    }
                }
            }
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            outputFormat.setIndent(4);
            outputFormat.setVersion("1.0");
            XMLSerializer xMLSerializer = new XMLSerializer(fileOutputStream, outputFormat);
            xMLSerializer.serialize(document);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(iOException);
            throw illegalStateException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            illegalStateException.initCause(parserConfigurationException);
            throw illegalStateException;
        }
    }

    private static Object a(Object object) {
        if (object instanceof SpecialCrystalValue || object == null) {
            return "NULL";
        }
        return object;
    }

    public static interface IRowOrColumnHandler {
        public boolean OnRowOrColumn(boolean var1, int var2, GroupPath var3);
    }
}

