/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.financial;

import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions.reports.formulas.functions.financial.ae;
import com.crystaldecisions.reports.formulas.functions.financial.an;

class h
implements FormulaFunctionFactory {
    private static final h fr = new h();
    private static final FormulaFunctionArgumentDefinition[][] fs = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.settlementDate, CommonArguments.maturityDate, CommonArguments.discountRate, CommonArguments.redemptionValue}, {CommonArguments.settlementDate, CommonArguments.maturityDate, CommonArguments.discountRate, CommonArguments.redemptionValue, CommonArguments.basis}};
    private static final FormulaFunctionDefinition[] ft = new FormulaFunctionDefinition[]{new a(fs[0]), new a(fs[1])};

    private h() {
    }

    public static h aM() {
        return fr;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return ft[n2];
    }

    public int getNFunctionInstances() {
        return ft.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("PriceDisc", "pricedisc", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            double d10;
            double d11;
            if (formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[1].getFormulaValue() != null) {
                DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
                DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
                if (dateValue.getCRDate() >= dateValue2.getCRDate()) {
                    String[] stringArray = new String[]{"maturityDate", "settlementDate"};
                    throw new FormulaFunctionArgumentException("JRC00002334", "", FormulaResources.a(), "BadOrder", stringArray, 1);
                }
            }
            if (formulaValueReferenceArray[2].getFormulaValue() != null && (d11 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002335", "", FormulaResources.a(), "ArgumentOutOfRange", 2);
            }
            if (formulaValueReferenceArray[3].getFormulaValue() != null && (d10 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002336", "", FormulaResources.a(), "ArgumentOutOfRange", 3);
            }
            if (formulaValueReferenceArray.length == 5 && formulaValueReferenceArray[4].getFormulaValue() != null && ((n2 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getInt()) < 0 || n2 > 4)) {
                throw new FormulaFunctionArgumentException("JRC00002337", "", FormulaResources.a(), "ArgumentOutOfRange", 4);
            }
            return FormulaValueType.currency;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
            DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
            double d10 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getDouble();
            double d11 = ((NumericValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble();
            an an2 = an.do;
            if (formulaValueReferenceArray.length == 5) {
                n2 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getInt();
                an2 = an.a(n2);
            }
            double[] dArray = ae.a(dateValue, dateValue2, an2);
            n2 = (int)dArray[0];
            double d12 = dArray[1];
            double d13 = d11 - d10 * d11 * (double)n2 / d12;
            return CurrencyValue.fromDouble((double)d13);
        }
    }
}

