/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EqualsUtil {
    private EqualsUtil() {
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean areEquivalentValues(CrystalValue crystalValue, CrystalValue crystalValue2) {
        if (EqualsUtil.areEqual(crystalValue, crystalValue2)) {
            return true;
        }
        if (crystalValue == null || crystalValue2 == null) {
            return false;
        }
        if (crystalValue.getValueType().equals(crystalValue2.getValueType())) {
            return false;
        }
        if (!crystalValue.getValueType().isNumeric() || !crystalValue2.getValueType().isNumeric()) {
            return false;
        }
        return ((NumericValue)crystalValue).getDouble() == ((NumericValue)crystalValue2).getDouble();
    }

    public static boolean areEqual(Collection<?> collection, Collection<?> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            Object obj;
            Object obj2 = iterator.next();
            if (EqualsUtil.areEqual(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean areInstancesEqual(Collection<?> collection, Collection<?> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        Iterator<?> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            Object obj;
            Object obj2 = iterator.next();
            if (obj2 == (obj = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Collection<?> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        for (Object obj : collection2) {
            if (collection.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqualIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static boolean areEqualIgnoreCase(CrystalValue crystalValue, CrystalValue crystalValue2) {
        return crystalValue == null ? crystalValue2 == null : crystalValue.equals((Object)crystalValue2, true);
    }

    public static boolean areEqual(float f7, float f8) {
        return Float.floatToIntBits(f7) == Float.floatToIntBits(f8);
    }

    public static boolean areEqual(double d10, double d11) {
        return Double.doubleToLongBits(d10) == Double.doubleToLongBits(d11);
    }

    public static boolean areEqual(long l2, long l3) {
        return l2 == l3;
    }

    public static boolean areEqual(boolean bl2, boolean bl3) {
        return bl2 == bl3;
    }

    public static boolean areEqual(char c10, char c11) {
        return c10 == c11;
    }

    public static int getHashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static int getHashCode(Collection<?> collection) {
        int n2 = 1;
        for (Object obj : collection) {
            n2 = 31 * n2 + EqualsUtil.getHashCode(obj);
        }
        return n2;
    }

    public static int getHashCode(boolean bl2) {
        return bl2 ? 1231 : 1237;
    }

    public static int getHashCode(long l2) {
        return (int)l2 ^ (int)(l2 >>> 32);
    }

    public static int getHashCode(float f7) {
        return Float.floatToIntBits(f7);
    }

    public static int getHashCode(double d10) {
        return EqualsUtil.getHashCode(Double.doubleToLongBits(d10));
    }
}

