/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.PromptValueList;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.businessobjects.reports.crprompting.CRPromptValue;
import com.crystaldecisions.reports.common.NumberUtil;
import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.locale.FormatterCache;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public final class ValueConverter {
    public static final String PARAM_MULTI_SEPARATOR = "_crMULTI_";
    public static final String PARAM_RANGE_SEPARATOR = "_crRANGE_";
    public static final String DATE_SEPARATOR = "-";
    public static final String TIME_SEPARATOR = ":";
    public static final String COMMA = ",";
    private static final String PARAM_NULL = "_crNULL_";

    private ValueConverter() {
    }

    public static String getIValueString(IPromptValue value) {
        return ValueConverter.getIValueString(CRPromptValue.getFormulaValue(value));
    }

    private static String getIValueString(FormulaValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).getString();
        }
        if (value instanceof NumericValue) {
            DecimalFormat nf = FormatterCache.GetDecimalFormatter((Locale)Locale.US);
            nf.setGroupingUsed(false);
            double tmp = NumberUtil.normalizeDouble((double)((NumericValue)value).getDouble());
            nf.setMaximumFractionDigits(Integer.MAX_VALUE);
            String numberStr = nf.format(tmp);
            return numberStr;
        }
        if (value instanceof DateValue) {
            DateValue val = (DateValue)value;
            Calendar cal = Calendar.getInstance((Locale)Locale.US);
            cal.set(val.getYear(), val.getMonth() - 1, val.getDay());
            DateFormat format = FormatterCache.GetShortDateFormatter((Calendar)cal, (Locale)Locale.US);
            ((SimpleDateFormat)format).applyPattern("'Date('yyyy','MM','dd')'");
            return format.format((Object)cal);
        }
        if (value instanceof TimeValue) {
            TimeValue val = (TimeValue)value;
            Calendar cal = Calendar.getInstance();
            cal.set(0, 0, 0, val.getHours(), val.getMinutes(), val.getWholeSeconds());
            cal.set(14, (int)(val.getNanoseconds() / 1000000L));
            DateFormat format = FormatterCache.GetTimeFormatter((Calendar)cal, (Locale)Locale.getDefault());
            ((SimpleDateFormat)format).applyPattern("'Time('HH','mm','ss')'");
            return format.format(cal.getTime());
        }
        if (value instanceof DateTimeValue) {
            DateTimeValue val = (DateTimeValue)value;
            DateValue d10 = val.getDateValue();
            TimeValue t2 = val.getTimeValue();
            Calendar cal = Calendar.getInstance((Locale)Locale.US);
            cal.set(DateValue.getYear((DateValue)d10), DateValue.getMonth((DateValue)d10) - 1, DateValue.getDay((DateValue)d10), TimeValue.getHours((TimeValue)t2), TimeValue.getMinutes((TimeValue)t2), TimeValue.getWholeSeconds((TimeValue)t2));
            cal.set(14, (int)(TimeValue.getNanoseconds((TimeValue)t2) / 1000000L));
            DateFormat format = FormatterCache.GetShortDateTimeFormatter((Calendar)cal, (Locale)Locale.US);
            ((SimpleDateFormat)format).applyLocalizedPattern("'DateTime('yyyy','MM','dd','HH','mm','ss')'");
            return format.format((Object)cal);
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getBoolean() ? "true" : "false";
        }
        throw new IllegalArgumentException("Only discrete FormulaValues are allowed");
    }

    public static IPromptValue getPromptValue(PromptValueType valueType, String iValueString) {
        return CRPromptValue.fromFormulaValue(ValueConverter.getFormulaValue(valueType, iValueString));
    }

    public static FormulaValue getFormulaValue(PromptValueType valueType, String iValueString) {
        if (iValueString == null || valueType == null || valueType != PromptValueType.string && iValueString.equals("")) {
            return null;
        }
        switch (valueType.value()) {
            case 2: {
                return ValueConverter.getBooleanValue(iValueString);
            }
            case 1: {
                return ValueConverter.getCurrencyValue(iValueString);
            }
            case 3: {
                return ValueConverter.getDateValue(iValueString);
            }
            case 5: {
                return ValueConverter.getDateTimeValue(iValueString);
            }
            case 0: {
                return ValueConverter.getNumberValue(iValueString);
            }
            case 4: {
                return ValueConverter.getStringValue(iValueString);
            }
            case 6: {
                return ValueConverter.getTimeValue(iValueString);
            }
        }
        throw new IllegalArgumentException("Invalid PromptValueType");
    }

    private static StringValue getStringValue(String formattedString) {
        return StringValue.fromString((String)formattedString);
    }

    private static BooleanValue getBooleanValue(String formattedString) {
        if (formattedString == null) {
            return null;
        }
        if (formattedString.equalsIgnoreCase("true")) {
            return BooleanValue.TRUE;
        }
        if (formattedString.equalsIgnoreCase("false")) {
            return BooleanValue.FALSE;
        }
        assert (false) : "Failed to parse formattedString into a BooleanValue";
        return null;
    }

    public static NumberValue getNumberValue(String formattedString) {
        return (NumberValue)ValueConverter.getNumericValue(formattedString, false);
    }

    public static CurrencyValue getCurrencyValue(String formattedString) {
        return (CurrencyValue)ValueConverter.getNumericValue(formattedString, true);
    }

    private static NumericValue getNumericValue(String formattedString, boolean isCurrency) {
        Number theNumber;
        if (formattedString == null) {
            return null;
        }
        String str = formattedString;
        str = str.trim();
        DecimalFormat format = FormatterCache.GetDecimalCurrencyFormatter((Locale)Locale.US);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        String currencySymbol = symbols.getCurrencySymbol();
        String cleanStr = StringUtil.removeNegativeSymbol((String)(str = StringUtil.removeCurrencySymbol((String)str, (String)currencySymbol)));
        boolean isNegative = cleanStr.compareTo(str) != 0;
        DecimalFormat nf = FormatterCache.GetDecimalFormatter((Locale)Locale.US);
        try {
            theNumber = nf.parse(cleanStr);
        }
        catch (ParseException e10) {
            assert (false) : "Failed to parse formattedString into a NumericValue";
            return null;
        }
        double num = theNumber.doubleValue();
        if (isNegative) {
            num = -num;
        }
        return isCurrency ? CurrencyValue.fromDouble((double)num) : NumberValue.fromDouble((double)num);
    }

    private static DateValue getDateValue(String formattedString) {
        if (!formattedString.startsWith("Date(") || !formattedString.endsWith(")")) {
            assert (false) : "Failed to parse formattedString into a DateValue";
            return null;
        }
        String dateString = formattedString.substring(5, formattedString.length() - 1);
        StringTokenizer tokenizer = new StringTokenizer(dateString, COMMA);
        if (tokenizer.countTokens() != 3) {
            assert (false) : "Failed to parse formattedString into a DateValue";
            return null;
        }
        int year = Integer.parseInt(tokenizer.nextToken());
        int month = Integer.parseInt(tokenizer.nextToken());
        int day = Integer.parseInt(tokenizer.nextToken());
        return DateValue.fromYMD((int)year, (int)month, (int)day);
    }

    private static TimeValue getTimeValue(String formattedString) {
        if (!formattedString.startsWith("Time(") || !formattedString.endsWith(")")) {
            assert (false) : "Failed to parse formattedString into a TimeValue";
            return null;
        }
        String dateTimeString = formattedString.substring(5, formattedString.length() - 1);
        if (dateTimeString == null || dateTimeString.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(dateTimeString, COMMA);
        if (tokenizer.countTokens() != 3) {
            assert (false) : "Failed to parse formattedString into a TimeValue";
            return null;
        }
        int hours = Integer.parseInt(tokenizer.nextToken());
        int minutes = Integer.parseInt(tokenizer.nextToken());
        int seconds = Integer.parseInt(tokenizer.nextToken());
        return TimeValue.fromHMS((int)hours, (int)minutes, (double)seconds);
    }

    private static DateTimeValue getDateTimeValue(String formattedString) {
        if (!formattedString.startsWith("DateTime(") || !formattedString.endsWith(")")) {
            assert (false) : "Failed to parse formattedString into a DateValue";
            return null;
        }
        String dateTimeString = formattedString.substring(9, formattedString.length() - 1);
        StringTokenizer tokenizer = new StringTokenizer(dateTimeString, COMMA);
        if (tokenizer.countTokens() != 6) {
            assert (false) : "Failed to parse formattedString into a DateValue";
            return null;
        }
        int year = Integer.parseInt(tokenizer.nextToken());
        int month = Integer.parseInt(tokenizer.nextToken());
        int day = Integer.parseInt(tokenizer.nextToken());
        int hours = Integer.parseInt(tokenizer.nextToken());
        int minutes = Integer.parseInt(tokenizer.nextToken());
        int seconds = Integer.parseInt(tokenizer.nextToken());
        DateValue date = DateValue.fromYMD((int)year, (int)month, (int)day);
        TimeValue time = TimeValue.fromHMS((int)hours, (int)minutes, (double)seconds);
        return DateTimeValue.fromDateAndTimeValues((DateValue)date, (TimeValue)time);
    }

    public static IPromptValue.IPromptValueList convertStringValueToIPromptValues(String sPromptValue, IPrompt prompt, Locale locale) {
        if (sPromptValue == null || prompt == null) {
            throw new IllegalArgumentException("InvalidPromptingInputValues");
        }
        PromptValueList iValues = new PromptValueList();
        if (prompt.getAllowMultipleValues()) {
            String[] multiArr = sPromptValue.split(PARAM_MULTI_SEPARATOR);
            int len2 = multiArr.length;
            for (int k2 = 0; k2 < len2; ++k2) {
                IPromptValue iValue = ValueConverter.createValue(multiArr[k2], prompt, locale);
                if (iValue == null) {
                    return null;
                }
                iValues.add(iValue);
            }
        } else {
            IPromptValue iValue = ValueConverter.createValue(sPromptValue, prompt, locale);
            if (iValue == null) {
                return null;
            }
            iValues.add(iValue);
        }
        return iValues;
    }

    private static boolean isRangeValue(String sPromptValue) {
        String[] sSplitArr;
        int iLen;
        boolean bRet = false;
        if (sPromptValue != null && (iLen = (sSplitArr = sPromptValue.split(PARAM_RANGE_SEPARATOR)).length) >= 2) {
            String s1 = sSplitArr[0];
            String s2 = sSplitArr[iLen - 1];
            if ((s1.startsWith("(") || s1.startsWith("[")) && (s2.endsWith(")") || s2.endsWith("]"))) {
                bRet = true;
            }
        }
        return bRet;
    }

    private static Boolean isInclusiveBound(char ch2) {
        switch (ch2) {
            case '(': 
            case ')': {
                return Boolean.FALSE;
            }
            case '[': 
            case ']': {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private static String getLowerBoundValue(String sPromptValue) {
        String[] sSplitArr;
        String sRet = "";
        if (sPromptValue != null && (sSplitArr = sPromptValue.split(PARAM_RANGE_SEPARATOR)).length >= 2) {
            sRet = sSplitArr[0];
            sRet = sRet.substring(1);
        }
        return sRet;
    }

    private static String getUpperBoundValue(String sPromptValue) {
        String[] sSplitArr;
        String sRet = "";
        if (sPromptValue != null && (sSplitArr = sPromptValue.split(PARAM_RANGE_SEPARATOR)).length >= 2) {
            sRet = sSplitArr[sSplitArr.length - 1];
            sRet = sRet.substring(0, sRet.length() - 1);
        }
        return sRet;
    }

    private static String convertToInternalDateFormat(String sPromptValue) {
        StringBuilder sbRet = new StringBuilder();
        if (sPromptValue != null) {
            String[] sSplitArr = sPromptValue.split(DATE_SEPARATOR);
            if (sSplitArr.length == 3) {
                sbRet.append("Date(");
                sbRet.append(sSplitArr[0].trim());
                sbRet.append(COMMA);
                sbRet.append(sSplitArr[1].trim());
                sbRet.append(COMMA);
                sbRet.append(sSplitArr[2].trim());
                sbRet.append(")");
            } else {
                return sPromptValue;
            }
        }
        return sbRet.toString();
    }

    private static String convertToInternalDateTimeFormat(String sPromptValue) {
        String[] sSplitArr;
        StringBuilder sbRet = new StringBuilder();
        if (sPromptValue != null && (sSplitArr = sPromptValue.split(" ")).length == 2) {
            String sDate = sSplitArr[0];
            String sTime = sSplitArr[1];
            String[] sDateArr = sDate.split(DATE_SEPARATOR);
            String[] sTimeArr = sTime.split(TIME_SEPARATOR);
            if (sDateArr.length == 3 && sTimeArr.length == 3) {
                sbRet.append("DateTime(");
                sbRet.append(sDateArr[0].trim());
                sbRet.append(COMMA);
                sbRet.append(sDateArr[1].trim());
                sbRet.append(COMMA);
                sbRet.append(sDateArr[2].trim());
                sbRet.append(COMMA);
                sbRet.append(sTimeArr[0].trim());
                sbRet.append(COMMA);
                sbRet.append(sTimeArr[1].trim());
                sbRet.append(COMMA);
                sbRet.append(sTimeArr[2].trim());
                sbRet.append(")");
            } else {
                return sPromptValue;
            }
        }
        return sbRet.toString();
    }

    private static String convertToInternalTimeFormat(String sPromptValue) {
        StringBuilder sbRet = new StringBuilder();
        if (sPromptValue != null) {
            String[] sSplitArr = sPromptValue.split(TIME_SEPARATOR);
            if (sSplitArr.length == 3) {
                sbRet.append("Time(");
                sbRet.append(sSplitArr[0].trim());
                sbRet.append(COMMA);
                sbRet.append(sSplitArr[1].trim());
                sbRet.append(COMMA);
                sbRet.append(sSplitArr[2].trim());
                sbRet.append(")");
            } else {
                return sPromptValue;
            }
        }
        return sbRet.toString();
    }

    private static String convertValue(String sPromptValue, PromptValueType promptValueType, Locale locale) {
        String sRet = null;
        if (sPromptValue == null || promptValueType == null) {
            return null;
        }
        switch (promptValueType.value()) {
            case 0: 
            case 1: {
                sRet = sPromptValue.replaceAll("\\s", "");
                if (sRet.equals("")) break;
                NumberFormat numFormat = NumberFormat.getInstance((Locale)locale);
                try {
                    sRet = numFormat.parse(sPromptValue).toString();
                }
                catch (ParseException e10) {}
                break;
            }
            case 2: {
                sRet = sPromptValue;
                break;
            }
            case 4: {
                sRet = sPromptValue;
                break;
            }
            case 5: {
                sRet = ValueConverter.convertToInternalDateTimeFormat(sPromptValue);
                break;
            }
            case 6: {
                sRet = ValueConverter.convertToInternalTimeFormat(sPromptValue);
                break;
            }
            case 3: {
                sRet = ValueConverter.convertToInternalDateFormat(sPromptValue);
                break;
            }
        }
        return sRet;
    }

    private static IPromptValue createValue(String sPromptValue, IPrompt prompt, Locale locale) {
        assert (sPromptValue != null && prompt != null);
        if (sPromptValue.equals(PARAM_NULL) && !prompt.getNullable()) {
            throw new IllegalArgumentException("InvalidPromptingInputValues");
        }
        if (sPromptValue.equals(PARAM_NULL)) {
            return CRPromptValue.NULL;
        }
        PromptValueType promptValueType = prompt.getValueType();
        if (ValueConverter.isRangeValue(sPromptValue)) {
            if (!prompt.getAllowRangeValue()) {
                throw new IllegalArgumentException("InvalidPromptingInputValues");
            }
            Boolean lowerBoundIncluded = ValueConverter.isInclusiveBound(sPromptValue.charAt(0));
            Boolean upperBoundIncluded = ValueConverter.isInclusiveBound(sPromptValue.charAt(sPromptValue.length() - 1));
            String lowerBoundValue = ValueConverter.getLowerBoundValue(sPromptValue);
            String upperBoundValue = ValueConverter.getUpperBoundValue(sPromptValue);
            if (lowerBoundValue.length() > 0) {
                lowerBoundValue = ValueConverter.convertValue(lowerBoundValue, promptValueType, locale);
            } else if (!Boolean.TRUE.equals(lowerBoundIncluded)) {
                lowerBoundIncluded = null;
            }
            if (upperBoundValue.length() > 0) {
                upperBoundValue = ValueConverter.convertValue(upperBoundValue, promptValueType, locale);
            } else if (!Boolean.TRUE.equals(upperBoundIncluded)) {
                upperBoundIncluded = null;
            }
            FormulaValue startValue = lowerBoundIncluded == null ? null : ValueConverter.getFormulaValue(promptValueType, lowerBoundValue);
            FormulaValue endValue = upperBoundIncluded == null ? null : ValueConverter.getFormulaValue(promptValueType, upperBoundValue);
            boolean includeStart = Boolean.TRUE.equals(lowerBoundIncluded);
            boolean includeEnd = Boolean.TRUE.equals(upperBoundIncluded);
            return CRPromptValue.fromFormulaValue((FormulaValue)RangeValue.fromStartAndEndValues((FormulaValue)startValue, (FormulaValue)endValue, (boolean)includeStart, (boolean)includeEnd));
        }
        String sConvertedValue = ValueConverter.convertValue(sPromptValue, promptValueType, locale);
        return CRPromptValue.fromFormulaValue(ValueConverter.getFormulaValue(promptValueType, sConvertedValue));
    }
}

