/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.PromptValueList;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.businessobjects.reports.crprompting.ValueConverter;
import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.reports.common.value.ArrayValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.SerializationHelper;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRPromptValue
implements IPromptValue {
    private static final String XML_CRPROMPTVALUE_VALUE = "value";
    FormulaValue value;
    public static final CRPromptValue NULL = new Null();
    public static final CRPromptValue TRUE = new Boolean(BooleanValue.TRUE);
    public static final CRPromptValue FALSE = new Boolean(BooleanValue.FALSE);
    public static final CRPromptValue EMPTYSTRING = new Str(StringValue.empty);
    public static final CRPromptValue ZERO = new Number(NumberValue.zero);
    public static final CRPromptValue ZEROCURRENCY = new Currency(CurrencyValue.zero);

    public CRPromptValue() {
    }

    CRPromptValue(FormulaValue value) {
        this.value = value;
    }

    public static final CRPromptValue fromFormulaValue(FormulaValue value) {
        if (value instanceof StringValue) {
            StringValue string = (StringValue)value;
            return string.getString().length() == 0 ? EMPTYSTRING : new Str(string);
        }
        if (value instanceof NumberValue) {
            NumberValue number = (NumberValue)value;
            return number.getDouble() == 0.0 ? ZERO : new Number(number);
        }
        if (value instanceof CurrencyValue) {
            CurrencyValue currency = (CurrencyValue)value;
            return currency.getDouble() == 0.0 ? ZEROCURRENCY : new Currency(currency);
        }
        if (value instanceof DateValue) {
            return new DateVal((DateValue)value);
        }
        if (value instanceof TimeValue) {
            return new Time((TimeValue)value);
        }
        if (value instanceof DateTimeValue) {
            return new DateTime((DateTimeValue)value);
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getBoolean() ? TRUE : FALSE;
        }
        if (value instanceof RangeValue) {
            return new Range((RangeValue)value);
        }
        if (value == null) {
            return NULL;
        }
        if (value instanceof ArrayValue) {
            throw new IllegalArgumentException("Cannot make a CRPromptValue from an ArrayValue");
        }
        throw new IllegalArgumentException("Unexpected instance of FormulaValue");
    }

    public static final FormulaValue getFormulaValue(IPromptValue promptValue) {
        if (promptValue instanceof CRPromptValue) {
            return ((CRPromptValue)promptValue).getFormulaValue();
        }
        if (promptValue == null) {
            throw new IllegalArgumentException("IPromptValue cannot be null");
        }
        if (promptValue.isNull()) {
            return null;
        }
        if (promptValue instanceof IPromptValue.IBoolean) {
            return BooleanValue.fromBoolean((boolean)((IPromptValue.IBoolean)promptValue).getBooleanValue());
        }
        if (promptValue instanceof IPromptValue.IString) {
            return StringValue.fromString((String)((IPromptValue.IString)promptValue).getStringValue());
        }
        if (promptValue instanceof IPromptValue.INumber) {
            return NumberValue.fromDouble((double)((IPromptValue.INumber)promptValue).getNumberValue());
        }
        if (promptValue instanceof IPromptValue.ICurrency) {
            return CurrencyValue.fromDouble((double)((IPromptValue.ICurrency)promptValue).getCurrencyValue());
        }
        if (promptValue instanceof IPromptValue.IDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(((IPromptValue.IDate)promptValue).getDateValue());
            return DateValue.fromCalendar((Calendar)calendar);
        }
        if (promptValue instanceof IPromptValue.ITime) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(((IPromptValue.ITime)promptValue).getTimeValue());
            return TimeValue.fromCalendar((Calendar)calendar);
        }
        if (promptValue instanceof IPromptValue.ITime) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(((IPromptValue.ITime)promptValue).getTimeValue());
            return TimeValue.fromCalendar((Calendar)calendar);
        }
        if (promptValue instanceof IPromptValue.IRange) {
            IPromptValue.IRange range = (IPromptValue.IRange)promptValue;
            return RangeValue.fromStartAndEndValues((FormulaValue)CRPromptValue.getFormulaValue(range.getStartValue()), (FormulaValue)CRPromptValue.getFormulaValue(range.getEndValue()), (boolean)range.includeStart(), (boolean)range.includeEnd());
        }
        throw new IllegalArgumentException("Unknown instance of IPromptValue");
    }

    public final FormulaValue getFormulaValue() {
        return this.value;
    }

    @Override
    public final boolean isNull() {
        return this.value == null;
    }

    @Override
    public Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] loaded) {
        return null;
    }

    @Override
    public void endElement(String eleName, Map<Object, Object> objState) {
    }

    @Override
    public final void readElement(String eleName, String val, Attributes attrs, Map<Object, Object> objState) {
        if (eleName.equals(XML_CRPROMPTVALUE_VALUE)) {
            this.value = ValueConverter.getFormulaValue(this.getPromptValueType(), val);
        }
    }

    @Override
    public PromptValueType getPromptValueType() {
        return null;
    }

    @Override
    public final void save(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        String sTypeName = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties attrs = SerializationHelper.getHeaderAttributes(sTypeName);
        writer.writeStartElement(sTypeName, attrs);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(sTypeName);
    }

    @Override
    public final void save(XMLWriter writer, String tag, XMLSerializationContext ctxt) throws IOException {
        writer.writeStartObjectElement(tag, "2", this, ctxt);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(tag);
    }

    @Override
    public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        writer.writeTextElement(XML_CRPROMPTVALUE_VALUE, ValueConverter.getIValueString(this), null);
    }

    @Override
    public final void startElement(String eleName, Map<Object, Object> objState, Attributes attrs) {
    }

    @Override
    public final Object clone(boolean deepClone) {
        return CRPromptValue.fromFormulaValue(this.value);
    }

    @Override
    public final void copyTo(Object destObject, boolean deepCopy) {
        ((CRPromptValue)destObject).value = this.value;
    }

    @Override
    public final boolean hasContent(Object obj) {
        return PromptValueList.equalPromptValues(this, obj);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof CRPromptValue && CloneUtil.equalObjects(((CRPromptValue)obj).value, this.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public final String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Range
    extends CRPromptValue
    implements IPromptValue.IRange {
        private static final String XML_RANGEVALUE_LIST = "RangeValueList";
        private IPromptValue.IPromptValueList rangeValueList;

        public Range() {
        }

        Range(RangeValue value) {
            super((FormulaValue)value);
        }

        @Override
        public IPromptValue.IDiscrete getStartValue() {
            FormulaValue start = ((RangeValue)this.getFormulaValue()).getStartValue();
            return (IPromptValue.IDiscrete)((Object)Range.fromFormulaValue(start));
        }

        @Override
        public IPromptValue.IDiscrete getEndValue() {
            FormulaValue end = ((RangeValue)this.getFormulaValue()).getEndValue();
            return (IPromptValue.IDiscrete)((Object)Range.fromFormulaValue(end));
        }

        @Override
        public boolean includeStart() {
            return ((RangeValue)this.getFormulaValue()).getIncludeStart();
        }

        @Override
        public boolean includeEnd() {
            return ((RangeValue)this.getFormulaValue()).getIncludeEnd();
        }

        @Override
        public PromptValueType getPromptValueType() {
            IPromptValue.IDiscrete startValue = this.getStartValue();
            if (startValue != null) {
                return startValue.getPromptValueType();
            }
            IPromptValue.IDiscrete endValue = this.getEndValue();
            if (endValue != null) {
                return endValue.getPromptValueType();
            }
            assert (false) : "Unbounded Range Values are not allowed";
            return null;
        }

        @Override
        public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
            PromptValueList outRangeValueList = new PromptValueList();
            IPromptValue.IDiscrete startValue = this.getStartValue();
            outRangeValueList.add(startValue == null ? NULL : startValue);
            IPromptValue.IDiscrete endValue = this.getEndValue();
            outRangeValueList.add(endValue == null ? NULL : endValue);
            outRangeValueList.add(this.includeStart() ? TRUE : FALSE);
            outRangeValueList.add(this.includeEnd() ? TRUE : FALSE);
            writer.writeObjectElement(outRangeValueList, XML_RANGEVALUE_LIST, ctxt);
        }

        @Override
        public final Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] loaded) {
            Object newObject = ClassFactory.createObject(attrs, ctxt, loaded);
            if (eleName.equals(XML_RANGEVALUE_LIST)) {
                this.rangeValueList = (IPromptValue.IPromptValueList)newObject;
            }
            return newObject;
        }

        @Override
        public void endElement(String eleName, Map<Object, Object> objState) {
            if (this.rangeValueList != null && this.rangeValueList.size() == 4) {
                this.value = RangeValue.fromStartAndEndValues((FormulaValue)CRPromptValue.getFormulaValue((IPromptValue)this.rangeValueList.get(0)), (FormulaValue)CRPromptValue.getFormulaValue((IPromptValue)this.rangeValueList.get(1)), (boolean)((IPromptValue.IBoolean)this.rangeValueList.get(2)).getBooleanValue(), (boolean)((IPromptValue.IBoolean)this.rangeValueList.get(3)).getBooleanValue());
                this.rangeValueList = null;
            }
        }
    }

    public static final class DateTime
    extends CRPromptValue
    implements IPromptValue.IDateTime {
        public DateTime() {
        }

        DateTime(DateTimeValue value) {
            super((FormulaValue)value);
        }

        public Date getDateTimeValue() {
            return ((DateTimeValue)this.getFormulaValue()).getJavaDate();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.dateTime;
        }
    }

    public static final class Time
    extends CRPromptValue
    implements IPromptValue.ITime {
        public Time() {
        }

        Time(TimeValue value) {
            super((FormulaValue)value);
        }

        public Date getTimeValue() {
            return ((TimeValue)this.getFormulaValue()).getJavaDate();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.time;
        }
    }

    public static final class DateVal
    extends CRPromptValue
    implements IPromptValue.IDate {
        public DateVal() {
        }

        DateVal(DateValue value) {
            super((FormulaValue)value);
        }

        public Date getDateValue() {
            return ((DateValue)this.getFormulaValue()).getJavaDate();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.date;
        }
    }

    public static final class Currency
    extends CRPromptValue
    implements IPromptValue.ICurrency {
        public Currency() {
        }

        Currency(CurrencyValue value) {
            super((FormulaValue)value);
        }

        public double getCurrencyValue() {
            return ((CurrencyValue)this.getFormulaValue()).getDouble();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.currency;
        }
    }

    public static final class Number
    extends CRPromptValue
    implements IPromptValue.INumber {
        public Number() {
        }

        Number(NumberValue value) {
            super((FormulaValue)value);
        }

        public double getNumberValue() {
            return ((NumberValue)this.getFormulaValue()).getDouble();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.number;
        }
    }

    public static final class Str
    extends CRPromptValue
    implements IPromptValue.IString {
        public Str() {
        }

        Str(StringValue value) {
            super((FormulaValue)value);
        }

        public String getStringValue() {
            return ((StringValue)this.getFormulaValue()).getString();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.string;
        }
    }

    public static final class Boolean
    extends CRPromptValue
    implements IPromptValue.IBoolean {
        public Boolean() {
        }

        Boolean(BooleanValue value) {
            super((FormulaValue)value);
        }

        public boolean getBooleanValue() {
            return ((BooleanValue)this.getFormulaValue()).getBoolean();
        }

        public PromptValueType getPromptValueType() {
            return PromptValueType.bool;
        }
    }

    public static final class Null
    extends CRPromptValue
    implements IPromptValue.IDiscrete,
    IPromptValue.IRange {
        public Null() {
            super(null);
        }

        public IPromptValue.IDiscrete getEndValue() {
            return this;
        }

        public IPromptValue.IDiscrete getStartValue() {
            return this;
        }

        public boolean includeEnd() {
            return false;
        }

        public boolean includeStart() {
            return false;
        }
    }
}

