/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.queryengine.driverImpl.jdbc;

import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.reports.queryengine.driverImpl.jdbc.JDBCConnection;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCServerSQLInfo {
    public static final int FUNCTION_NAME = 0;
    public static final int FUNCTION_RETURN_TYPE = 1;
    public static final int FUNCTION_ARGUMENT_COUNTS = 2;
    public static final int FUNCTION_FLAGS = 3;
    public static final int CATAGORY_SYSTEM = 0;
    public static final int CATAGORY_STRING = 1;
    public static final int CATAGORY_NUMERIC = 2;
    public static final int CATAGORY_DATETIME = 3;
    public static final String[] NumericFunctions = new String[]{"ABS|7|1|7|2", "ACOS|7|1|7|2", "ASIN|7|1|7|2", "ATAN|7|1|7|2", "ATAN2|7|2|7|7|2", "CEILING|4|1|7|2", "COS|7|1|7|2", "COT|7|1|7|2", "DEGREES|7|1|7|2", "EXP|7|1|7|2", "FLOOR|4|1|7|2", "LOG|7|1|7|2", "LOG10|7|1|7|2", "MOD|4|2|4|4|2", "PI|7|0|2", "POWER|7|2|7|4|2", "RADIANS|7|1|7|2", "RAND|7|1|4|2", "ROUND|7|2|7|4|2", "SIGN|1|1|7|2", "SIN|7|1|7|2", "SQRT|7|1|7|2", "TAN|7|1|7|2", "TRUNCATE|7|2|7|5|2"};
    public static final String[] StringFunctions = new String[]{"ASCII|4|1|11|2", "BIT_LENGTH|4|1|11|2", "CHAR|11|1|4|2", "CHAR_LENGTH|4|1|11|2", "CHARACTER_LENGTH|4|1|11|2", "CONCAT|11|2|11|11|2", "DIFFERENCE|4|2|11|11|2", "INSERT|11|4|11|5|5|11|2", "LCASE|11|1|11|2", "LEFT|11|2|11|5|2", "LENGTH|4|1|11|2", "LOCATE|4|3|11|11|5|2", "LOCATE|4|2|11|11|2", "LTRIM|11|1|11|2", "OCTET_LENGTH|4|1|11|2", "REPEAT|11|2|11|5|2", "REPLACE|11|3|11|11|11|2", "RIGHT|11|2|11|5|2", "RTRIM|11|1|11|2", "SOUNDEX|11|1|11|2", "SPACE|11|1|5|2", "SUBSTRING|11|3|11|5|5|2", "UCASE|11|1|11|2"};
    public static final String[] SystemFunctions = new String[]{"DATABASE|11|0|2", "IFNULL|250|2|255|255|2", "USER|11|0|2"};
    public static final String[] DateFunctions = new String[]{"CURRENT_DATE|9|0|2", "CURRENT_TIME|9|1|4|2", "CURRENT_TIMESTAMP|9|1|4|2", "CURDATE|9|0|2", "CURTIME|10|0|2", "DAYNAME|11|1|9|2", "DAYOFMONTH|4|1|9|2", "DAYOFWEEK|4|1|9|2", "DAYOFYEAR|4|1|9|2", "HOUR|4|1|10|2", "MINUTE|4|1|10|2", "MONTH|4|1|9|2", "MONTHNAME|11|1|9|2", "NOW|date10|0|2", "QUARTER|4|1|9|2", "SECOND|4|1|10|2", "TIMESTAMPADD|15|3|255|5|15|2", "TIMESTAMPDIFF|4|3|255|15|15|2", "WEEK|4|1|9|2", "YEAR|4|1|9|2"};
    private JDBCConnection a = null;

    public JDBCServerSQLInfo(JDBCConnection jDBCConnection) {
        this.a = jDBCConnection;
    }

    public List<Method> GetServerSQLInformation() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        try {
            DatabaseMetaData databaseMetaData = this.a.GetDatabaseMetaData();
            if (databaseMetaData == null) {
                return null;
            }
            String string = "";
            for (int i = 0; i < 4; ++i) {
                ServerFunctionCatagory serverFunctionCatagory = new ServerFunctionCatagory();
                String[] stringArray = null;
                switch (i) {
                    case 0: {
                        serverFunctionCatagory.catalogName = "System";
                        string = databaseMetaData.getSystemFunctions();
                        stringArray = SystemFunctions;
                        break;
                    }
                    case 1: {
                        serverFunctionCatagory.catalogName = "String";
                        string = databaseMetaData.getStringFunctions();
                        stringArray = StringFunctions;
                        break;
                    }
                    case 2: {
                        serverFunctionCatagory.catalogName = "Numeric";
                        string = databaseMetaData.getNumericFunctions();
                        stringArray = NumericFunctions;
                        break;
                    }
                    case 3: {
                        serverFunctionCatagory.catalogName = "DateTime";
                        string = databaseMetaData.getTimeDateFunctions();
                        stringArray = DateFunctions;
                    }
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    ServerFunction serverFunction = this.a(stringArray[j], string);
                    if (serverFunction == null) continue;
                    serverFunctionCatagory.serverFunctions.add(serverFunction);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return arrayList;
    }

    ServerFunction a(String string, String string2) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ServerFunction serverFunction = new ServerFunction();
        if (serverFunction == null) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            switch (n) {
                case 0: {
                    serverFunction.functionName = stringTokenizer.nextToken();
                    if (string2.indexOf(serverFunction.functionName) != -1) break;
                    return null;
                }
                case 1: {
                    serverFunction.returnType = ValueType.fromInt((int)Integer.parseInt(stringTokenizer.nextToken()));
                }
                case 2: {
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n2 <= 0) break;
                    for (int i = 0; i < n2; ++i) {
                        ServerFnArgumentInfo serverFnArgumentInfo = new ServerFnArgumentInfo();
                        int n3 = Integer.parseInt(stringTokenizer.nextToken());
                        serverFnArgumentInfo.dataType = ValueType.fromInt((int)n3);
                        serverFunction.arguments.add(serverFnArgumentInfo);
                    }
                    break;
                }
                case 3: {
                    serverFunction.flags = Integer.parseInt(stringTokenizer.nextToken());
                    break;
                }
                default: {
                    CrystalAssert.ASSERT((boolean)false);
                }
            }
            ++n;
        }
        return serverFunction;
    }

    class ServerFnArgumentInfo {
        public String argumentName = "";
        public ValueType dataType = null;

        ServerFnArgumentInfo() {
        }
    }

    class ServerFunction {
        public String functionName = "";
        public ValueType returnType = null;
        public List<ServerFnArgumentInfo> arguments = new ArrayList<ServerFnArgumentInfo>();
        public int flags = 0;

        ServerFunction() {
        }
    }

    private class ServerFunctionCatagory {
        public String catalogName = "";
        public List<ServerFunction> serverFunctions = new ArrayList<ServerFunction>();

        private ServerFunctionCatagory() {
        }
    }
}

