/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.rendering.formats;

import com.businessobjects.visualization.rendering.RenderFormat;
import com.businessobjects.visualization.rendering.formats.BMPRenderFormat;
import com.businessobjects.visualization.rendering.formats.FlashRenderFormat;
import com.businessobjects.visualization.rendering.formats.GIFRenderFormat;
import com.businessobjects.visualization.rendering.formats.JPGRenderFormat;
import com.businessobjects.visualization.rendering.formats.PNGRenderFormat;
import com.businessobjects.visualization.rendering.formats.SVGRenderFormat;
import com.businessobjects.visualization.rendering.formats.XAMLRenderFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class OutputType {
    public static final int UNKNOWN = 0;
    public static final int BMP = 1;
    public static final int JPG = 2;
    public static final int PNG = 4;
    public static final int GIF = 8;
    public static final int FLASH = 16;
    public static final int XML = 32;
    public static final int HTML = 64;
    public static final int JS = 128;
    public static final int SVG = 256;
    public static final int XAML = 512;
    public static final int NATIVE = 1024;
    private static final int[] KNOWN_TYPES = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static final RenderFormat[] KNOWN_RENDERFORMATS = new RenderFormat[]{new BMPRenderFormat(), new JPGRenderFormat(), new PNGRenderFormat(), new GIFRenderFormat(), new FlashRenderFormat(240), null, null, null, new SVGRenderFormat(480), new XAMLRenderFormat(512), null};
    private static final String SEPARATOR = "|";

    private OutputType() {
    }

    public static int fromString(String output) {
        String cmp = output.toLowerCase();
        if (cmp.compareTo("bmp") == 0) {
            return 1;
        }
        if (cmp.compareTo("jpg") == 0) {
            return 2;
        }
        if (cmp.compareTo("png") == 0) {
            return 4;
        }
        if (cmp.compareTo("gif") == 0) {
            return 8;
        }
        if (cmp.compareTo("swf") == 0) {
            return 16;
        }
        if (cmp.compareTo("xml") == 0) {
            return 32;
        }
        if (cmp.compareTo("html") == 0) {
            return 64;
        }
        if (cmp.compareTo("js") == 0) {
            return 128;
        }
        if (cmp.compareTo("svg") == 0) {
            return 256;
        }
        if (cmp.compareTo("xaml") == 0) {
            return 512;
        }
        if (cmp.compareTo("native") == 0) {
            return 1024;
        }
        return 0;
    }

    public static String toString(int type) {
        if (type == 1) {
            return "bmp";
        }
        if (type == 2) {
            return "jpg";
        }
        if (type == 4) {
            return "png";
        }
        if (type == 8) {
            return "gif";
        }
        if (type == 16) {
            return "swf";
        }
        if (type == 32) {
            return "xml";
        }
        if (type == 64) {
            return "html";
        }
        if (type == 128) {
            return "js";
        }
        if (type == 256) {
            return "svg";
        }
        if (type == 512) {
            return "xaml";
        }
        if (type == 1024) {
            return "native";
        }
        return "unknown";
    }

    public static int decodeOutputType(String output) {
        int result = 0;
        if (output == null || output.length() == 0) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(output, SEPARATOR);
        while (st.hasMoreElements()) {
            int ot = OutputType.fromString(st.nextToken());
            result += ot;
        }
        return result;
    }

    public static String encodeOutputType(int outputs) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            if ((outputs & KNOWN_TYPES[i]) != KNOWN_TYPES[i]) continue;
            if (buffer.length() > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(OutputType.toString(KNOWN_TYPES[i]));
        }
        return buffer.toString();
    }

    public static RenderFormat[] toRenderFormats(int outputs) {
        ArrayList<RenderFormat> renderFormats = new ArrayList<RenderFormat>();
        for (int i = 0; i < KNOWN_TYPES.length; ++i) {
            if ((outputs & KNOWN_TYPES[i]) != KNOWN_TYPES[i] || KNOWN_RENDERFORMATS[i] == null) continue;
            renderFormats.add(KNOWN_RENDERFORMATS[i]);
        }
        return renderFormats.toArray(new RenderFormat[0]);
    }
}

