/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuGradientOrientationType;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuGradient
extends VisuObject {
    private static final int[] PARAMSIZE = new int[]{2, 3};
    private static VisuObjectType type = VisuObjectType.GRADIENT;
    private VisuRGBA rgba1_;
    private VisuRGBA rgba2_;
    private VisuGradientOrientationType orientation_;

    public VisuGradient(VisuRGBA rgba1, VisuRGBA rgba2) {
        this.rgba1_ = rgba1;
        this.rgba2_ = rgba2;
        this.orientation_ = VisuGradientOrientationType.HORIZONTAL;
    }

    public VisuGradient(VisuRGBA rgba1, VisuRGBA rgba2, VisuGradientOrientationType orientation) {
        this.rgba1_ = rgba1;
        this.rgba2_ = rgba2;
        this.orientation_ = orientation;
    }

    public VisuGradient(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public String toString() {
        String s = "1:" + this.rgba1_.toString() + " 2:" + this.rgba2_.toString() + " " + this.orientation_.toString();
        return s;
    }

    public VisuObjectType getType() {
        return type;
    }

    public VisuRGBA[] getColors() {
        return new VisuRGBA[]{this.rgba1_, this.rgba2_};
    }

    public VisuGradientOrientationType getOrientation() {
        return this.orientation_;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuGradient.stringToArray(xmlValue));
    }

    protected void setXmlValue(String[] values) {
        this.checkParams(values, PARAMSIZE);
        this.rgba1_ = new VisuRGBA(values[0]);
        this.rgba2_ = new VisuRGBA(values[1]);
        this.orientation_ = values.length == 3 ? VisuGradientOrientationType.fromString(values[2]) : VisuGradientOrientationType.HORIZONTAL;
    }

    protected String getXmlValue() {
        String xmlValue = "[" + this.rgba1_.getXmlValue() + "];" + "[" + this.rgba2_.getXmlValue() + "]" + ";" + this.orientation_.value();
        return xmlValue;
    }

    protected Object clone() {
        VisuGradient vg = (VisuGradient)super.clone();
        vg.rgba1_ = (VisuRGBA)this.rgba1_.clone();
        vg.rgba2_ = (VisuRGBA)this.rgba2_.clone();
        vg.orientation_ = this.orientation_;
        return vg;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuGradient) {
            VisuGradient vg = (VisuGradient)obj;
            if (vg.rgba1_.equals(this.rgba1_) && vg.rgba2_.equals(this.rgba2_) && vg.orientation_ == this.orientation_) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("orientation", new Integer(this.orientation_.value()));
            jsonObj.put("color1", this.rgba1_.getJSONObject());
            jsonObj.put("color2", this.rgba2_.getJSONObject());
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuGradient(JSONObject jobj) {
        try {
            this.orientation_ = VisuGradientOrientationType.fromInt(jobj.getInt("orientation"));
            JSONObject rgba1Json = jobj.getJSONObject("color1");
            this.rgba1_ = (VisuRGBA)VisuObject.createFromJSON(rgba1Json.toString());
            JSONObject rgba2Json = jobj.getJSONObject("color2");
            this.rgba2_ = (VisuRGBA)VisuObject.createFromJSON(rgba2Json.toString());
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

