/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuDouble
extends VisuObject {
    private static VisuObjectType type = VisuObjectType.DOUBLE;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$VisuDouble == null ? (class$com$businessobjects$visualization$graphic$VisuDouble = VisuDouble.class$("com.businessobjects.visualization.graphic.VisuDouble")) : class$com$businessobjects$visualization$graphic$VisuDouble));
    private double value_;
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$VisuDouble;

    public VisuDouble(double d) {
        this.value_ = d;
    }

    public VisuDouble(Double d) {
        this.value_ = d;
    }

    public VisuDouble(String s) {
        this.setXmlValue(s);
    }

    public String toString() {
        String s = String.valueOf(this.value_);
        return s;
    }

    public double doubleValue() {
        return this.value_;
    }

    public int intValue() {
        return (int)this.value_;
    }

    public VisuObjectType getType() {
        return type;
    }

    protected void setXmlValue(String xmlValue) {
        if (xmlValue == null) {
            throw new VisualizationRuntimeException("VIZ_00052_ERR_XMLVALUE_IS_NULL");
        }
        try {
            this.value_ = Double.parseDouble(xmlValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("VisuDouble Invalid string : " + xmlValue));
            this.value_ = 0.0;
        }
    }

    protected String getXmlValue() {
        String xmlValue = String.valueOf(this.value_);
        return xmlValue;
    }

    protected Object clone() {
        return super.clone();
    }

    protected boolean checkValidity(Object param) {
        if (param != null) {
            VisuDouble[] vds = (VisuDouble[])param;
            double min = vds[0].doubleValue();
            double max = vds[1].doubleValue();
            double step = vds[2].doubleValue();
            double tmp = this.value_ - min;
            tmp = this.getArrondi(tmp);
            double div = this.getArrondi(tmp / step);
            double dent = (int)div;
            if (this.value_ < min || this.value_ > max) {
                throw new VisualizationRuntimeException("VIZ_00120_ERR_VALUE___0___FOR_VISU", new Object[]{new Double(this.value_), new Double(min), new Double(max)});
            }
            if (tmp != 0.0 && Double.compare(div, dent) != 0) {
                throw new VisualizationRuntimeException("VIZ_00121_ERR_VALUE___0___IS_NOT_I", new Object[]{new Double(this.value_), new Double(step), new Double(min)});
            }
        }
        return true;
    }

    private double getArrondi(double value) {
        double eps = 1000.0;
        double result = 0.0;
        result = (double)Math.round(value * eps) / eps;
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuDouble) {
            VisuDouble vd = (VisuDouble)obj;
            if (vd.value_ == this.value_) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("value", new Double(this.value_));
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuDouble(JSONObject jobj) {
        try {
            this.value_ = jobj.getDouble("value");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

