/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.BaseRegionPropertyDef;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.RegionActionType;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.RegionDefVisiblity;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLActionType;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLBool;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLDynamicNode;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLMultiState;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLProperty;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLPropertyRef;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLPropertyTemplate;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegion;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegionRef;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegionTemplate;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegionType;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegionVisibility;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLStateItem;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibrary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class RegionDef
extends BaseRegionPropertyDef {
    private RegionDefType regionType_;
    private RegionDefVisiblity visibility_;
    private ArrayList actionList_ = new ArrayList();
    private boolean recursive_;

    RegionDef(XMLRegion xr, IGraphicDefNode parent, IGraphicDefNode rootParent, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibTemplate) {
        super(xr.m_a_Id, loc.getValue(xr.m_a_Name), loc.getValue(xr.m_a_Description), parent, rootParent, loc, IGraphicDefNode.GraphicDefNodeType.REGION);
        this.regionType_ = RegionDef.type2TypeRegion(xr.m_a_Type);
        this.visibility_ = RegionDef.visib2VisibElement(xr.m_a_Visibility);
        this.recursive_ = xr.m_a_Recursive && this.regionType_ == RegionDefType.DYNAMIC;
        this.computeAction(xr.m_list_Action);
        this.computeRegion(xr, loc, xlibTemplate);
    }

    private RegionDef(XMLRegion xr, XMLRegionTemplate xtemplate, IGraphicDefNode parent, IGraphicDefNode rootParent, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibTemplate) {
        super(xr.m_a_Id, loc.getValue(xr.m_a_Name), loc.getValue(xr.m_a_Description), parent, rootParent, loc, IGraphicDefNode.GraphicDefNodeType.REGION);
        this.regionType_ = RegionDef.type2TypeRegion(xr.m_a_Type);
        this.visibility_ = RegionDef.visib2VisibElement(xr.m_a_Visibility);
        this.recursive_ = xr.m_a_Recursive && this.regionType_ == RegionDefType.DYNAMIC;
        this.computeAction(xtemplate.m_list_Action);
        this.computeRegion(xtemplate, loc, xlibTemplate);
    }

    public RegionDefType getType() {
        return this.regionType_;
    }

    public RegionDefVisiblity getVisibility() {
        return this.visibility_;
    }

    void setVisibility(RegionDefVisiblity visibility) {
        this.visibility_ = visibility;
    }

    void addAction(RegionActionType type) {
        this.actionList_.add(type);
    }

    public RegionActionType[] getAction() {
        RegionActionType[] list = new RegionActionType[this.actionList_.size()];
        return this.actionList_.toArray(list);
    }

    boolean isActionAvailable(RegionActionType type) {
        boolean bRet = false;
        RegionActionType[] list = this.getAction();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(type)) continue;
            bRet = true;
        }
        return bRet;
    }

    public RegionDef[] getRegions() {
        RegionDef[] result = null;
        ArrayList list = this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
        result = new RegionDef[list.size()];
        list.toArray(result);
        return result;
    }

    public RegionDef getRegion(String key) {
        RegionDef result = (RegionDef)this.getNode(key, IGraphicDefNode.GraphicDefNodeType.REGION);
        return result;
    }

    private void computeRegion(XMLRegion xr, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibtemplate) {
        for (int i = 0; i < xr.m_list_Property.size(); ++i) {
            XMLProperty property = (XMLProperty)xr.m_list_Property.get(i);
            this.computeProperty(this, property, this, null, loc, xlibtemplate, null);
        }
        for (int j = 0; j < xr.m_list_Region.size(); ++j) {
            XMLRegion childXR = (XMLRegion)xr.m_list_Region.get(j);
            if (childXR instanceof XMLRegionRef) {
                XMLRegionRef xrr = (XMLRegionRef)childXR;
                XMLRegionTemplate template = this.searchRegionRefId(xrr.m_a_RefId, xlibtemplate);
                RegionDef childRd = new RegionDef(xrr, template, this, this.getRootParent(), loc, xlibtemplate);
                this.addChild(childRd);
                continue;
            }
            RegionDef childRd = new RegionDef(childXR, this, this.getRootParent(), loc, xlibtemplate);
            this.addChild(childRd);
        }
    }

    private XMLRegionTemplate searchRegionRefId(String refId, XMLVisualizationLibrary xlibtemplate) {
        XMLRegionTemplate group = null;
        for (int i = 0; i < xlibtemplate.m_list_RegionTemplate.size(); ++i) {
            XMLRegionTemplate xrt = (XMLRegionTemplate)xlibtemplate.m_list_RegionTemplate.get(i);
            if (!xrt.m_a_Id.equals(refId)) continue;
            group = xrt;
            break;
        }
        if (group == null) {
            throw new VisualizationRuntimeException("VIZ_00106_ERR_REGION_REFID_NOT_RES", new Object[]{refId});
        }
        return group;
    }

    private void computeProperty(RegionDef rd, XMLProperty xprop, GraphicDefNode parent, String stateId, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibtemplate, HashMap mapDefaultValue) {
        String xmlDf = null;
        if (mapDefaultValue != null && mapDefaultValue.containsKey(xprop.m_a_Id)) {
            xmlDf = (String)mapDefaultValue.get(xprop.m_a_Id);
        }
        if (xprop instanceof XMLBool) {
            XMLBool xb = (XMLBool)xprop;
            PropertyDef pdef = new PropertyDef(rd, parent, xb, loc, stateId, xmlDf);
            parent.addChild(pdef);
            for (int i = 0; i < xb.m_list_Property.size(); ++i) {
                XMLProperty prop = (XMLProperty)xb.m_list_Property.get(i);
                this.computeProperty(rd, prop, pdef, null, loc, xlibtemplate, mapDefaultValue);
            }
        } else if (xprop instanceof XMLMultiState) {
            int i;
            XMLMultiState xms = (XMLMultiState)xprop;
            PropertyDef pdef = new PropertyDef(rd, parent, xms, loc, stateId, xmlDf);
            parent.addChild(pdef);
            for (i = 0; i < xms.m_list_Property.size(); ++i) {
                XMLProperty prop = (XMLProperty)xms.m_list_Property.get(i);
                this.computeProperty(rd, prop, pdef, null, loc, xlibtemplate, mapDefaultValue);
            }
            for (i = 0; i < xms.m_list_Item.size(); ++i) {
                XMLStateItem xsi = (XMLStateItem)xms.m_list_Item.get(i);
                if (!xsi.m_a_Node || xsi.m_list_Property == null) continue;
                for (int j = 0; j < xsi.m_list_Property.size(); ++j) {
                    XMLProperty prop = (XMLProperty)xsi.m_list_Property.get(j);
                    if (prop instanceof XMLPropertyRef) {
                        XMLPropertyRef xpr = (XMLPropertyRef)prop;
                        PropertyDef ref = (PropertyDef)pdef.getNode(pdef.getId() + "/" + xpr.m_a_RefId, IGraphicDefNode.GraphicDefNodeType.PROPERTY);
                        if (ref == null) {
                            this.computeProperty(rd, prop, pdef, xsi.m_a_Id, loc, xlibtemplate, mapDefaultValue);
                            continue;
                        }
                        ref.addState(xsi.m_a_Id);
                        continue;
                    }
                    this.computeProperty(rd, prop, pdef, xsi.m_a_Id, loc, xlibtemplate, mapDefaultValue);
                }
            }
        } else if (xprop instanceof XMLDynamicNode) {
            XMLDynamicNode xdn = (XMLDynamicNode)xprop;
            PropertyDef pdef = new PropertyDef(rd, parent, xdn, loc, stateId, xmlDf);
            parent.addChild(pdef);
            XMLStateItem mandatoryItem = xdn.m_MandatoryItem;
            if (mandatoryItem.m_a_Node && mandatoryItem.m_list_Property != null) {
                for (int j = 0; j < mandatoryItem.m_list_Property.size(); ++j) {
                    XMLProperty prop = (XMLProperty)mandatoryItem.m_list_Property.get(j);
                    this.computeProperty(rd, prop, pdef, mandatoryItem.m_a_Id, loc, xlibtemplate, mapDefaultValue);
                }
            }
            XMLStateItem optionalItem = xdn.m_OptionalItem;
            if (optionalItem.m_a_Node && optionalItem.m_list_Property != null) {
                for (int j = 0; j < optionalItem.m_list_Property.size(); ++j) {
                    XMLProperty prop = (XMLProperty)optionalItem.m_list_Property.get(j);
                    this.computeProperty(rd, prop, pdef, optionalItem.m_a_Id, loc, xlibtemplate, mapDefaultValue);
                }
            }
        } else if (xprop instanceof XMLPropertyRef) {
            XMLPropertyRef xpref = (XMLPropertyRef)xprop;
            HashMap<String, String> mapDefVal = new HashMap<String, String>();
            if (xpref.m_a_DefaultValue != null) {
                StringTokenizer st = new StringTokenizer(xpref.m_a_DefaultValue, "|");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    StringTokenizer st2 = new StringTokenizer(pair, "=");
                    if (st2.countTokens() != 2) continue;
                    mapDefVal.put(st2.nextToken(), st2.nextToken());
                }
            }
            XMLPropertyTemplate group = this.searchPropertyRefId(xpref.m_a_RefId, xlibtemplate);
            for (int i = 0; i < group.m_list_Property.size(); ++i) {
                XMLProperty c = (XMLProperty)group.m_list_Property.get(i);
                this.computeProperty(rd, c, parent, stateId, loc, xlibtemplate, mapDefVal);
            }
        } else {
            PropertyDef pdef = new PropertyDef(rd, parent, xprop, loc, stateId, xmlDf);
            parent.addChild(pdef);
        }
    }

    XMLPropertyTemplate searchPropertyRefId(String refId, XMLVisualizationLibrary xlibtemplate) {
        XMLPropertyTemplate template = null;
        for (int i = 0; i < xlibtemplate.m_list_PropertyTemplate.size(); ++i) {
            XMLPropertyTemplate xpt = (XMLPropertyTemplate)xlibtemplate.m_list_PropertyTemplate.get(i);
            if (!xpt.m_a_Id.equals(refId)) continue;
            template = xpt;
            break;
        }
        if (template == null) {
            throw new VisualizationRuntimeException("VIZ_00108_ERR_PROPERTY_REFID_NOT_R", new Object[]{refId});
        }
        return template;
    }

    private static RegionDefType type2TypeRegion(XMLRegionType get) {
        RegionDefType ret = RegionDefType.STATIC;
        switch (get.value()) {
            case 0: {
                ret = RegionDefType.STATIC;
                break;
            }
            case 1: {
                ret = RegionDefType.DYNAMIC;
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00109_ERR_UNEXPECTED_XMLREGION", new Object[]{new Integer(get.value())});
            }
        }
        return ret;
    }

    static RegionDefVisiblity visib2VisibElement(XMLRegionVisibility gev) {
        RegionDefVisiblity ret = RegionDefVisiblity.MANDATORY;
        switch (gev.value()) {
            case 0: {
                ret = RegionDefVisiblity.MANDATORY;
                break;
            }
            case 1: {
                ret = RegionDefVisiblity.ENABLE;
                break;
            }
            case 2: {
                ret = RegionDefVisiblity.DISABLE;
                break;
            }
            case 3: {
                ret = RegionDefVisiblity.NOTAVAILABLE;
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00110_ERR_UNEXPECTED_XMLREGION", new Object[]{new Integer(gev.value())});
            }
        }
        return ret;
    }

    private void computeAction(ArrayList actionList) {
        for (int i = 0; i < actionList.size(); ++i) {
            XMLActionType xtype = (XMLActionType)actionList.get(i);
            RegionActionType type = null;
            switch (xtype.value()) {
                case 1: {
                    type = RegionActionType.DELETE;
                    break;
                }
                case 0: {
                    type = RegionActionType.MOVE;
                    break;
                }
                case 2: {
                    type = RegionActionType.RESIZE;
                    break;
                }
                case 3: {
                    type = RegionActionType.EXPLODE;
                    break;
                }
                case 4: {
                    type = RegionActionType.XMOVE;
                    break;
                }
                case 5: {
                    type = RegionActionType.YMOVE;
                    break;
                }
                default: {
                    throw new VisualizationRuntimeException("VIZ_00111_ERR_INVALID_ACTION____0_", new Object[]{new Integer(xtype.value())});
                }
            }
            this.addAction(type);
        }
    }

    public boolean isRecursive() {
        return this.recursive_;
    }
}

