/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.BaseRegionPropertyDef;
import com.businessobjects.visualization.graphic.BaseRegionPropertyRef;
import com.businessobjects.visualization.graphic.FeedRestriction;
import com.businessobjects.visualization.graphic.GraphicDef;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyRef;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.RegionRef;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLFeedRestriction;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLPropertyRef;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLPublicGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegion;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLRegionRef;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PublicGraphicDef
extends GraphicDefNode {
    private String id_;
    private String category_;
    private GraphicDef graphicDef_;
    private String defaultLayerId_;
    private String dataSampleUid_;
    private RegionRef regionRootRef_;
    private boolean hasOverloading_;
    private Hashtable feedResctrictionHt_ = new Hashtable();
    private HashMap regionRefMap = new HashMap();

    public PublicGraphicDef(XMLGraphic xg, XMLPublicGraphic xpg, GraphicDef gd, LocalizedEngine.Localizator loc, XMLVisualizationLibrary xlibTemplate) {
        super(xg.m_a_Id, loc.getValue(xpg.m_a_Name), loc.getValue(xpg.m_a_Description), null, null, IGraphicDefNode.GraphicDefNodeType.GRAPHIC);
        this.id_ = gd.getProviderDescription().getId() + "/" + xpg.m_a_Id;
        this.category_ = loc.getValue(xpg.m_a_Category);
        this.graphicDef_ = gd;
        this.dataSampleUid_ = xpg.m_a_DataSampleUid;
        if (xpg.m_list_RegionRef.size() != 0 || xpg.m_list_PropertyRef.size() != 0) {
            this.hasOverloading_ = true;
        }
        if (this.hasOverloading_) {
            this.regionRootRef_ = new RegionRef(null);
            for (int j = 0; j < xg.m_list_Region.size(); ++j) {
                RegionDef rd = new RegionDef((XMLRegion)xg.m_list_Region.get(j), this, this, loc, xlibTemplate);
                this.addChild(rd);
            }
            this.resolveRegionRefInRefNode(this.regionRootRef_, xpg.m_list_RegionRef.iterator(), this.getRegion("root"));
            this.resolvePropertyRefInRefNode(this.regionRootRef_, xpg.m_list_PropertyRef.iterator(), this.getRegion("root"));
            this.regionRefMap.put("root", this.regionRootRef_);
            this.buildHashMapsInRegion(this.regionRootRef_);
        }
        ArrayList list = xpg.m_list_FeedRestriction;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            XMLFeedRestriction xref = (XMLFeedRestriction)iter.next();
            FeedRestriction res = this.resolveFeedRestriction(xref);
            this.feedResctrictionHt_.put(res.getId(), res);
        }
    }

    private void buildHashMapsInRegion(RegionRef regionRef) {
        Iterator iter = regionRef.getChildren().values().iterator();
        while (iter.hasNext()) {
            BaseRegionPropertyRef brpr = (BaseRegionPropertyRef)iter.next();
            if (brpr instanceof RegionRef) {
                RegionRef regionRefChild = (RegionRef)brpr;
                this.regionRefMap.put(regionRefChild.getDef().getId(), regionRefChild);
                this.regionRefMap.put(this.cutRootInId(regionRefChild.getDef().getId()), regionRefChild);
                this.buildHashMapsInRegion(regionRefChild);
                continue;
            }
            PropertyRef propRefChild = (PropertyRef)brpr;
            regionRef.putProperty(propRefChild.getDef().getId(), propRefChild);
            this.buildHashMapsInProperty(propRefChild, regionRef);
        }
    }

    private void buildHashMapsInProperty(PropertyRef propRef, RegionRef regionRef) {
        Iterator iter = propRef.getChildren().values().iterator();
        while (iter.hasNext()) {
            PropertyRef propRefChild = (PropertyRef)iter.next();
            regionRef.putProperty(propRefChild.getDef().getId(), propRefChild);
            propRef.putProperty(propRefChild.getDef().getBasicId(), propRefChild);
            this.buildHashMapsInProperty(propRefChild, regionRef);
        }
    }

    private String cutRootInId(String id) {
        return id.substring(id.indexOf("/") + 1, id.length());
    }

    public RegionDef[] getRegions() {
        if (this.hasOverloading_) {
            ArrayList list = this.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
            return list.toArray(new RegionDef[list.size()]);
        }
        ArrayList list = this.graphicDef_.getChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
        return list.toArray(new RegionDef[list.size()]);
    }

    public RegionDef getRegion(String id) {
        if (this.hasOverloading_) {
            RegionDef result = (RegionDef)this.getNode(id, IGraphicDefNode.GraphicDefNodeType.REGION);
            return result;
        }
        return (RegionDef)this.graphicDef_.getNode(id, IGraphicDefNode.GraphicDefNodeType.REGION);
    }

    public RegionDef getDynamicRegion(String id) {
        RegionDef result = this.getRegion(id);
        if (result == null || result.getType() != RegionDefType.DYNAMIC) {
            throw new VisualizationRuntimeException("VIZ_00037_ERR_ID_____ID_____DOESN_", new Object[]{id});
        }
        return result;
    }

    public IGraphicDefNode[] getChildren() {
        IGraphicDefNode[] result = null;
        if (this.hasOverloading_) {
            result = new IGraphicDefNode[this.childList_.size()];
            this.childList_.toArray(result);
        } else {
            result = new IGraphicDefNode[this.getGraphicDef().childList_.size()];
            this.getGraphicDef().childList_.toArray(result);
        }
        return result;
    }

    private void resolveRegionRefInRefNode(RegionRef toStore, Iterator iterRefs, RegionDef rd) {
        while (iterRefs.hasNext()) {
            XMLRegionRef xref2 = (XMLRegionRef)iterRefs.next();
            RegionDef rdef = null;
            rdef = (RegionDef)this.getBaseDef(xref2.m_a_RefId, rd.getRegions());
            if (rdef == null) {
                throw new VisualizationRuntimeException("VIZ_00106_ERR_REGION_REFID_NOT_RES", new Object[]{xref2.m_a_RefId});
            }
            RegionRef rref = this.buildRegionRef(xref2, rdef, toStore);
            toStore.addChild(rref);
        }
    }

    private void resolvePropertyRefInRefNode(BaseRegionPropertyRef toStore, Iterator iterProps, BaseRegionPropertyDef rd) {
        while (iterProps.hasNext()) {
            XMLPropertyRef xpref = (XMLPropertyRef)iterProps.next();
            PropertyDef pdef = null;
            pdef = xpref.m_a_RefId.indexOf("/") == -1 ? (PropertyDef)this.getBaseDef(xpref.m_a_RefId, rd.getProperties()) : (PropertyDef)this.searchNode(xpref.m_a_RefId, rd.getProperties(), IGraphicDefNode.GraphicDefNodeType.PROPERTY);
            if (pdef == null) {
                throw new VisualizationRuntimeException("VIZ_00100_ERR_INVALID_PROPERTY_DEF", new Object[]{xpref.m_a_RefId});
            }
            PropertyRef pref = this.buildPropertyRef(pdef, xpref, toStore);
            toStore.addChild(pref);
        }
    }

    private RegionRef buildRegionRef(XMLRegionRef xref, RegionDef rdef, BaseRegionPropertyRef refParent) {
        RegionRef rref = new RegionRef(rdef);
        rref.setVisibility(RegionDef.visib2VisibElement(xref.m_a_Visibility));
        rdef.setVisibility(RegionDef.visib2VisibElement(xref.m_a_Visibility));
        this.resolveRegionRefInRefNode(rref, xref.m_list_RegionRef.iterator(), rdef);
        this.resolvePropertyRefInRefNode(rref, xref.m_list_PropertyRef.iterator(), rdef);
        return rref;
    }

    private PropertyRef buildPropertyRef(PropertyDef pdef, XMLPropertyRef xmlPref, BaseRegionPropertyRef refParent) {
        PropertyRef pref = new PropertyRef(pdef);
        pref.setVisibility(PropertyDef.computeVisiblility(xmlPref.m_a_Visibility));
        pdef.setVisibility(PropertyDef.computeVisiblility(xmlPref.m_a_Visibility));
        VisuObject vo = VisuObject.create(pdef.getType().value(), xmlPref.m_a_DefaultValue);
        pref.setDefaultValue(vo);
        pdef.setDefaultValue(vo);
        if (vo instanceof VisuBool || vo instanceof VisuState) {
            this.resolvePropertyRefInRefNode(pref, xmlPref.m_list_PropertyRef.iterator(), pdef);
        }
        return pref;
    }

    private BaseRegionPropertyDef getBaseDef(String id, BaseRegionPropertyDef[] children) {
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getBasicId().equals(id)) continue;
            return children[i];
        }
        return null;
    }

    private FeedRestriction resolveFeedRestriction(XMLFeedRestriction xref) {
        FeedRestriction fr = new FeedRestriction(xref.m_a_FeedDefId, xref.m_a_min, xref.m_a_max);
        if (!this.graphicDef_.getProviderDescription().isValidFeedRestriction(this.graphicDef_.getFeedId(), fr.getId(), fr.getMin(), fr.getMax())) {
            throw new VisualizationInternalException("Invalid FeedRestriction:" + fr.getId() + " for PublicGraphic:" + this.id_);
        }
        return fr;
    }

    public String getId() {
        return this.id_;
    }

    public String getDefaultLayerId() {
        return this.defaultLayerId_;
    }

    public String getCategory() {
        return this.category_;
    }

    public String getDataSampleUid() {
        return this.dataSampleUid_;
    }

    public int getAvailableOutputTypes() {
        return this.graphicDef_.getAvailableOutputTypes();
    }

    public GraphicDef getGraphicDef() {
        return this.graphicDef_;
    }

    public int getMaxRestrictionCount(String feedId) {
        int result = Integer.MAX_VALUE;
        if (this.feedResctrictionHt_.containsKey(feedId)) {
            FeedRestriction fr = (FeedRestriction)this.feedResctrictionHt_.get(feedId);
            result = fr.getMax();
        }
        return result;
    }

    public int getMinRestrictionCount(String feedId) {
        int result = 0;
        if (this.feedResctrictionHt_.containsKey(feedId)) {
            FeedRestriction fr = (FeedRestriction)this.feedResctrictionHt_.get(feedId);
            result = fr.getMin();
        }
        return result;
    }

    public Enumeration getRestrictedFeeds() {
        return this.feedResctrictionHt_.keys();
    }

    public RegionRef getRegionRootRef() {
        return this.regionRootRef_;
    }

    public boolean isHasOverloading() {
        return this.hasOverloading_;
    }

    public boolean checkPropertyRef(String regionId, String propertyId, VisuObject value) {
        Object o = this.regionRefMap.get(regionId);
        if (o != null) {
            PropertyRef pref = ((RegionRef)o).getPropertyRef(propertyId);
            if (pref == null) {
                return false;
            }
            if (pref.getDefaultValue().equals(value)) {
                return true;
            }
        }
        return false;
    }

    public boolean containPropertyRef(String regionId, String propertyId) {
        Object o = this.regionRefMap.get(regionId);
        if (o != null) {
            return ((RegionRef)o).getPropertyRef(propertyId) != null;
        }
        return false;
    }

    public boolean containRegionRef(String regionId) {
        return this.regionRefMap.get(regionId) != null;
    }

    public RegionRef getRegionRef(String id) {
        StringTokenizer st = new StringTokenizer(id, "/");
        if (id.startsWith("root")) {
            st.nextToken();
        }
        BaseRegionPropertyRef search = this.regionRootRef_;
        while (st.hasMoreTokens()) {
            if (search == null) {
                throw new VisualizationRuntimeException("VIZ_00106_ERR_REGION_REFID_NOT_RES", new Object[]{id});
            }
            search = search.getChild(st.nextToken());
        }
        if (search == null) {
            throw new VisualizationRuntimeException("VIZ_00106_ERR_REGION_REFID_NOT_RES", new Object[]{id});
        }
        return search;
    }

    public PropertyRef getPropertyRef(String idRegionRef, String idPropRef) {
        RegionRef regionRef = this.getRegionRef(idRegionRef);
        return this.getPropertyRef(regionRef, idPropRef);
    }

    private PropertyRef getPropertyRef(RegionRef regionRef, String id) {
        StringTokenizer st = new StringTokenizer(id, "/");
        String[] elems = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            elems[i] = st.nextToken();
            ++i;
        }
        if (regionRef.getChild(elems[elems.length - 1]) != null) {
            return (PropertyRef)regionRef.getChild(elems[elems.length - 1]);
        }
        BaseRegionPropertyRef search = regionRef;
        search = search.getChild(elems[0]);
        for (int j = 1; j < elems.length; ++j) {
            if (search == null) {
                throw new VisualizationRuntimeException("VIZ_00100_ERR_INVALID_PROPERTY_DEF", new Object[]{id});
            }
            search = search.getChild(elems[j]);
        }
        if (search == null) {
            throw new VisualizationRuntimeException("VIZ_00100_ERR_INVALID_PROPERTY_DEF", new Object[]{id});
        }
        return (PropertyRef)search;
    }

    public Collection getPropertiesRef() {
        if (this.regionRootRef_ == null) {
            return new ArrayList();
        }
        Collection col = this.regionRootRef_.getChildren().values();
        Iterator iterChildren = col.iterator();
        ArrayList<BaseRegionPropertyRef> list = new ArrayList<BaseRegionPropertyRef>();
        while (iterChildren.hasNext()) {
            BaseRegionPropertyRef child = (BaseRegionPropertyRef)iterChildren.next();
            if (!(child instanceof PropertyRef)) continue;
            list.add(child);
        }
        return list;
    }

    public boolean checkProperty(String propertyId, VisuObject value) {
        PropertyRef pref;
        VisuObject vo;
        boolean result = false;
        if (this.regionRootRef_ == null) {
            return result;
        }
        if (this.containsKey(propertyId) && (vo = (pref = (PropertyRef)this.regionRootRef_.getChildren().get(propertyId)).getDefaultValue()).equals(value)) {
            result = true;
        }
        return result;
    }

    private boolean containsKey(String key) {
        if (this.regionRootRef_ == null) {
            return false;
        }
        Object value = this.regionRootRef_.getChildren().get(key);
        if (value == null) {
            return false;
        }
        return value instanceof PropertyRef;
    }

    boolean containProperty(String id) {
        boolean result = false;
        if (this.regionRootRef_ == null) {
            return result;
        }
        if (this.regionRootRef_.getChildren().containsKey(id)) {
            result = true;
        }
        return result;
    }

    public Collection getProperties() {
        if (this.regionRootRef_ == null) {
            return new ArrayList();
        }
        Collection col = this.regionRootRef_.getChildren().values();
        Iterator iterChildren = col.iterator();
        ArrayList<BaseRegionPropertyRef> list = new ArrayList<BaseRegionPropertyRef>();
        while (iterChildren.hasNext()) {
            BaseRegionPropertyRef child = (BaseRegionPropertyRef)iterChildren.next();
            if (!(child instanceof PropertyRef)) continue;
            list.add(child);
        }
        return list;
    }

    public Hashtable getRegionsRef() {
        Hashtable<String, RegionRef> ht = new Hashtable<String, RegionRef>();
        if (this.regionRootRef_ == null) {
            return ht;
        }
        ht.put("root", this.regionRootRef_);
        return ht;
    }
}

