/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataStructure;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataType;

final class Helper {
    private Helper() {
    }

    static XMLDataType toXML(DataType dt) {
        if (dt.equals(DataType.STRING)) {
            return new XMLDataType(0);
        }
        if (dt.equals(DataType.DOUBLE)) {
            return new XMLDataType(1);
        }
        if (dt.equals(DataType.DATE)) {
            return new XMLDataType(2);
        }
        return new XMLDataType(3);
    }

    static DataType fromXML(XMLDataType xmlDt) {
        DataType dt = null;
        switch (xmlDt.value()) {
            case 0: {
                dt = DataType.STRING;
                break;
            }
            case 2: {
                dt = DataType.DATE;
                break;
            }
            case 1: {
                dt = DataType.DOUBLE;
                break;
            }
            default: {
                dt = DataType.UNKNOWN;
            }
        }
        return dt;
    }

    static XMLDataStructure toXML(DataStructure ds) {
        if (ds.equals(DataStructure.TREE)) {
            return new XMLDataStructure(1);
        }
        return new XMLDataStructure(0);
    }

    static DataStructure fromXML(XMLDataStructure xmlDs) {
        DataStructure ds = null;
        switch (xmlDs.value()) {
            case 1: {
                ds = DataStructure.TREE;
                break;
            }
            default: {
                ds = DataStructure.SIMPLE;
            }
        }
        return ds;
    }
}

