/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLSubDatasetAdapter;
import java.util.Iterator;

public class SubDatasetAdapter
extends DatasetAdapter {
    private DatasetAdapter dependentDataset;
    private int[] dependentLabelValues;

    public SubDatasetAdapter(DatasetAdapter masterDataset, AnalysisAxisAdapter[] axes, MeasureValuesGroupAdapter[] valueGroups, DatasetAdapter[] subDatasets) {
        super(axes, valueGroups, subDatasets);
        this.dependentDataset = masterDataset;
    }

    public SubDatasetAdapter(XMLSubDatasetAdapter adapter, SerializationHelper sh) {
        super(adapter, sh);
        this.dependentLabelValues = new int[adapter.m_list_dependentLabelValues.size()];
        Iterator iter = adapter.m_list_dependentLabelValues.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.dependentLabelValues[i++] = (Integer)iter.next();
        }
    }

    void setDependentDataset(DatasetAdapter dataset) {
        this.dependentDataset = dataset;
    }

    public int[] getDependentLabelValues() {
        return this.dependentLabelValues;
    }

    public void setDependentLabelValues(int[] dependentLabelValues) {
        this.dependentLabelValues = dependentLabelValues;
    }

    public DatasetAdapter getDependentDataset() {
        return this.dependentDataset;
    }

    public Object getXMLDelegate() {
        XMLSubDatasetAdapter xmlSub = new XMLSubDatasetAdapter();
        XMLDatasetAdapter xmlDataset = (XMLDatasetAdapter)super.getXMLDelegate();
        xmlSub.m_list_analysisAxisListAdapter = xmlDataset.m_list_analysisAxisListAdapter;
        xmlSub.m_list_measureValuesGroupListAdapter = xmlDataset.m_list_measureValuesGroupListAdapter;
        for (int i = 0; i < this.dependentLabelValues.length; ++i) {
            xmlSub.m_list_dependentLabelValues.add(new Integer(this.dependentLabelValues[i]));
        }
        return xmlSub;
    }
}

