/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.common.internal.VersionHelper;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataAdapter;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DataSamplesManager {
    private HashMap sets_ = new HashMap();
    private HashMap localeBoundSets_ = new HashMap();
    private String defaultSetUid_;
    private static final String VISU_SETS_ELTS = "SampleSets";
    private static final String VISU_SETS_ELT = "SampleSet";
    private static final String VISU_SETS_UID_ATTR = "setUid";
    private static final String VISU_SETS_LANG_ATTR = "setLang";
    private static final String VISU_SETS_DEFAULTUID_ATTR = "defaultSet";
    private static final char UID_LANG_SEPARATOR = '_';

    public void put(String uid, String lang, DataAdapter da) {
        if (lang == null || lang.equals("")) {
            this.sets_.put(uid, da);
        } else {
            this.localeBoundSets_.put(DataSamplesManager.getKey(uid, lang), da);
        }
    }

    public void put(String uid, DataAdapter da) {
        this.put(uid, "", da);
    }

    public DataHolder get(String uid) {
        return this.get(uid, "");
    }

    public String getDefaultSetUid() {
        return this.defaultSetUid_;
    }

    public DataHolder get(String uid, String language) {
        String key;
        DataAdapter da = null;
        String resolvedUid = uid;
        if (resolvedUid == null || resolvedUid.equals("")) {
            if (this.defaultSetUid_ == null) {
                return null;
            }
            resolvedUid = this.defaultSetUid_;
        }
        if (this.localeBoundSets_.containsKey(key = DataSamplesManager.getKey(resolvedUid, language))) {
            da = (DataAdapter)this.localeBoundSets_.get(key);
        } else if (this.sets_.containsKey(resolvedUid)) {
            da = (DataAdapter)this.sets_.get(resolvedUid);
        } else {
            return null;
        }
        DataDescriptor dd = DataSamplesManager.generateDescriptorFromAdapter(da);
        return new DataHolder(dd, da);
    }

    private static String getKey(String uid, String language) {
        if (language == null || language.equals("")) {
            return uid;
        }
        if (language.length() != 2) {
            throw new VisualizationInternalException("The language code must match ISO 639 spec, 2 letters only (got: " + language + ")");
        }
        return uid + '_' + language;
    }

    private static String getLangFromKey(String key) {
        if (DataSamplesManager.isLocaleBound(key)) {
            return key.substring(key.lastIndexOf(95) + 1);
        }
        return null;
    }

    private static String getUidFromKey(String key) {
        if (DataSamplesManager.isLocaleBound(key)) {
            return key.substring(0, key.lastIndexOf(95));
        }
        return key;
    }

    private static boolean isLocaleBound(String key) {
        return key != null && key.lastIndexOf(95) != -1;
    }

    public static DataDescriptor generateDescriptorFromAdapter(DataAdapter da) {
        DatasetDescriptor ds = new DatasetDescriptor();
        AnalysisAxisAdapter[] axes = da.getDataset().getAxisList();
        for (int i = 0; i < axes.length; ++i) {
            AnalysisAxis anAxis = new AnalysisAxis();
            DimensionLabelsAdapter[] dlas = axes[i].getDimensionLabelsList();
            for (int j = 0; j < dlas.length; ++j) {
                DimensionLabels dl = new DimensionLabels(i + "dl#" + j, dlas[j].getData().getType(), dlas[j].getData().getStructure());
                anAxis.addDimensionLabels(dl);
            }
            ds.addAxis(anAxis);
        }
        MeasureValuesGroupAdapter[] mvga = da.getDataset().getValueGroupList();
        for (int i = 0; i < mvga.length; ++i) {
            MeasureValuesGroup aMvg = new MeasureValuesGroup();
            MeasureValuesAdapter[] mvas = mvga[i].getMeasureValuesList();
            for (int j = 0; j < mvas.length; ++j) {
                MeasureValues mv = new MeasureValues(i + "mv#" + j);
                aMvg.addMeasureValues(mv);
            }
            ds.addValueGroup(aMvg);
        }
        DataDescriptor dd = new DataDescriptor();
        dd.setDatasetDescriptor(ds);
        return dd;
    }

    public void delete(String uid) {
        if (DataSamplesManager.isLocaleBound(uid)) {
            this.localeBoundSets_.remove(uid);
        } else {
            this.sets_.remove(uid);
        }
    }

    public void clear() {
        this.sets_.clear();
        this.localeBoundSets_.clear();
    }

    private void writeSet(HashMap setMap, XmlWriter xw) throws XmlException {
        if (setMap == null) {
            return;
        }
        Iterator iter = setMap.keySet().iterator();
        while (iter.hasNext()) {
            String sampleUID = (String)iter.next();
            DataAdapter da = (DataAdapter)setMap.get(sampleUID);
            xw.startElement(VISU_SETS_ELT);
            xw.attribute(VISU_SETS_UID_ATTR, DataSamplesManager.getUidFromKey(sampleUID));
            if (DataSamplesManager.isLocaleBound(sampleUID)) {
                xw.attribute(VISU_SETS_LANG_ATTR, DataSamplesManager.getLangFromKey(sampleUID));
            }
            xw.startElement("DataAdapter");
            ((XMLDataAdapter)da.getXMLDelegate()).marshall2(xw);
            xw.endElement("DataAdapter");
            xw.endElement(VISU_SETS_ELT);
        }
    }

    public void write(OutputStream os) {
        try {
            XmlWriter xw = new XmlWriter(os, Charset.forName("UTF-8"));
            xw.startDocument();
            xw.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xw.startElement(VISU_SETS_ELTS);
            if (this.defaultSetUid_ != null) {
                xw.attribute(VISU_SETS_DEFAULTUID_ATTR, this.defaultSetUid_);
            }
            this.writeSet(this.sets_, xw);
            this.writeSet(this.localeBoundSets_, xw);
            xw.endElement(VISU_SETS_ELTS);
            xw.endDocument();
        }
        catch (XmlException e) {
            throw new VisualizationInternalException(e);
        }
    }

    public void read(InputStream is) {
        try {
            if (is.available() == 0) {
                return;
            }
            XmlReader xmlReader = new XmlReader(is);
            this.readFromXmlReader(xmlReader);
        }
        catch (XmlException e) {
            throw new VisualizationInternalException("Invalid stream for sample sets", e);
        }
        catch (IOException ioe) {
            throw new VisualizationInternalException("Invalid stream for sample sets", ioe);
        }
    }

    public DataAdapter[] getSamplesAdapters() {
        DataAdapter[] daList = new DataAdapter[this.sets_.size() + this.localeBoundSets_.size()];
        int i = 0;
        Collection coll = this.sets_.values();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            daList[i++] = (DataAdapter)iter.next();
        }
        coll = this.localeBoundSets_.values();
        iter = coll.iterator();
        while (iter.hasNext()) {
            daList[i++] = (DataAdapter)iter.next();
        }
        return daList;
    }

    public String[] getSamplesUids() {
        String[] uidList = new String[this.sets_.size() + this.localeBoundSets_.size()];
        int i = 0;
        Set coll = this.sets_.keySet();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            uidList[i++] = (String)iter.next();
        }
        coll = this.localeBoundSets_.keySet();
        iter = coll.iterator();
        while (iter.hasNext()) {
            uidList[i++] = (String)iter.next();
        }
        return uidList;
    }

    public void readFromXmlReader(XmlReader xmlReader) {
        String currSuid = null;
        String currLang = null;
        try {
            xmlReader.readToStartElement(null, VISU_SETS_ELTS);
            if (this.defaultSetUid_ == null) {
                this.defaultSetUid_ = xmlReader.getAttributeValue(VISU_SETS_DEFAULTUID_ATTR);
            }
            String serVersion = xmlReader.getAttributeValue("version");
            XmlReaderVersion xrv = new XmlReaderVersion(xmlReader, VersionHelper.getCurrentVersion("0.0"), new VisuVersion(serVersion));
            while (xmlReader.next() != XmlEventType.END_DOCUMENT) {
                if (xmlReader.getEventType() != XmlEventType.START_ELEMENT) continue;
                String sNode = xmlReader.getName();
                if (sNode != null && sNode.equals(VISU_SETS_ELT)) {
                    currSuid = xmlReader.getAttributeValue(VISU_SETS_UID_ATTR);
                    currLang = xmlReader.getAttributeValue(VISU_SETS_LANG_ATTR);
                    continue;
                }
                if (sNode == null || !sNode.equals("DataAdapter")) continue;
                XMLDataAdapter xda = new XMLDataAdapter();
                xda.unmarshall(xrv);
                this.put(currSuid, currLang, new DataAdapter(xda, new SerializationHelper(new VersionHelper("0.0", serVersion))));
            }
        }
        catch (Exception e) {
            throw new VisualizationInternalException("Invalid stream for sample sets uid=" + currSuid + " lang=" + currLang, e);
        }
    }
}

