/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIteratorFactory;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.GroupingDimensionAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLAnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLGroupingDimensionAdapter;
import com.businessobjects.visualization.dataexchange.data.graph.IAxisTree;
import com.businessobjects.visualization.dataexchange.data.graph.impl.AxisTreeBuilder;
import com.businessobjects.visualization.dataexchange.data.graph.impl.DimDataBuilder;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsIteratorDefaultFactory;
import java.util.Iterator;

public class AnalysisAxisAdapter
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$data$AnalysisAxisAdapter == null ? (class$com$businessobjects$visualization$dataexchange$data$AnalysisAxisAdapter = AnalysisAxisAdapter.class$("com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter")) : class$com$businessobjects$visualization$dataexchange$data$AnalysisAxisAdapter).getName());
    private DimensionLabelsAdapter[] labels_;
    private GroupingDimensionAdapter[] groupingAdapters_;
    private IDimensionLabelsIteratorFactory dimensionLabelsIteratorFactory_;
    private boolean isCustomIteratorImpl_;
    private transient IAxisTree axisTree_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$data$AnalysisAxisAdapter;

    public AnalysisAxisAdapter(DimensionLabelsAdapter[] labels, GroupingDimensionAdapter[] groupingAdapters) {
        this.labels_ = labels;
        this.groupingAdapters_ = groupingAdapters;
    }

    public AnalysisAxisAdapter(XMLAnalysisAxisAdapter adapter, SerializationHelper sh) {
        this.labels_ = new DimensionLabelsAdapter[adapter.m_list_dimensionLabelsList.size()];
        this.groupingAdapters_ = new GroupingDimensionAdapter[adapter.m_list_groupingDimensionList.size()];
        Iterator iter = adapter.m_list_dimensionLabelsList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DimensionLabelsAdapter dl = new DimensionLabelsAdapter((XMLDimensionLabelsAdapter)iter.next(), sh);
            this.labels_[i++] = dl;
        }
        iter = adapter.m_list_groupingDimensionList.iterator();
        i = 0;
        while (iter.hasNext()) {
            GroupingDimensionAdapter cl = new GroupingDimensionAdapter((XMLGroupingDimensionAdapter)iter.next(), sh);
            this.groupingAdapters_[i++] = cl;
        }
    }

    public DimensionLabelsAdapter[] getDimensionLabelsList() {
        return this.labels_;
    }

    public GroupingDimensionAdapter[] getGroupingDimensionList() {
        return this.groupingAdapters_;
    }

    public void setIteratorFactory(IDimensionLabelsIteratorFactory iteratorFactory) {
        this.dimensionLabelsIteratorFactory_ = iteratorFactory;
        this.isCustomIteratorImpl_ = true;
    }

    public boolean isCustomIteratorImpl() {
        return this.isCustomIteratorImpl_;
    }

    public IDimensionLabelsIteratorFactory getIteratorFactory() {
        return this.dimensionLabelsIteratorFactory_;
    }

    public int isFilled() {
        if (this.isCustomIteratorImpl()) {
            return -1;
        }
        for (int i = 0; i < this.labels_.length; ++i) {
            if (this.labels_[i].getData() != null) continue;
            LOGGER.warn((Object)("No Data for Dimensions:" + this.labels_[i].getUid()));
            return i;
        }
        return -1;
    }

    public IDimensionLabelsIterator getDimensionLabelsIterator(DatasetAdapter da, int iAxis, int dimensionLabelsIndex, DataRange dataRange) {
        return this.getDimensionLabelsIterator(da, iAxis, dimensionLabelsIndex, dataRange, -1, -1);
    }

    public IDimensionLabelsIterator getDimensionLabelsIterator(DatasetAdapter da, int iAxis, int dimensionLabelsIndex, DataRange dataRange, int maxDepth) {
        return this.getDimensionLabelsIterator(da, iAxis, dimensionLabelsIndex, dataRange, maxDepth, -1);
    }

    public IDimensionLabelsIterator getDimensionLabelsIterator(DatasetAdapter da, int iAxis, int dimensionLabelsIndex, DataRange dataRange, int maxDepth, int maxLevel) {
        IDimensionLabelsIteratorFactory factory = this.dimensionLabelsIteratorFactory_;
        if (factory == null) {
            factory = new DimensionLabelsIteratorDefaultFactory();
        }
        IDimensionLabelsIterator iter = null;
        int l = maxDepth < 0 ? this.labels_.length : Math.min(maxDepth + 1, this.labels_.length);
        boolean hasDimFilter = maxDepth == 0 && this.labels_.length > 1;
        int maxLevelForThisDim = maxDepth == 0 && l == 1 ? maxLevel : -1;
        IDimensionLabelsIterator rootDimensionLabelsIterator = factory.newInstance(da, iAxis, 0, dataRange, maxLevelForThisDim, hasDimFilter);
        rootDimensionLabelsIterator.setParentDimensionLabelsIterator(null);
        IDimensionLabelsIterator previousIter = rootDimensionLabelsIterator;
        if (dimensionLabelsIndex == 0) {
            iter = rootDimensionLabelsIterator;
        }
        for (int i = 1; i < l; ++i) {
            hasDimFilter = maxDepth == i && i < this.labels_.length - 1;
            maxLevelForThisDim = maxDepth == i && i == l - 1 ? maxLevel : -1;
            IDimensionLabelsIterator aIter = factory.newInstance(da, iAxis, i, dataRange, maxLevelForThisDim, hasDimFilter);
            aIter.setParentDimensionLabelsIterator(previousIter);
            previousIter = aIter;
            if (dimensionLabelsIndex != i) continue;
            iter = aIter;
        }
        return iter;
    }

    public void setAxisTree(IAxisTree axisTree, DimDataBuilder dataBuilder) {
        this.axisTree_ = axisTree;
        for (int i = 0; i < this.labels_.length; ++i) {
            this.labels_[i].setTreeToDataBuilder(dataBuilder);
        }
    }

    public IAxisTree getAxisTree() {
        if (this.axisTree_ == null) {
            AxisTreeBuilder axisTreeBuilder = new AxisTreeBuilder(this);
            this.axisTree_ = axisTreeBuilder.getAxisTree();
        }
        return this.axisTree_;
    }

    public Object getXMLDelegate() {
        int i;
        XMLAnalysisAxisAdapter xmlAxis = new XMLAnalysisAxisAdapter();
        for (i = 0; i < this.labels_.length; ++i) {
            xmlAxis.m_list_dimensionLabelsList.add((XMLDimensionLabelsAdapter)this.labels_[i].getXMLDelegate());
        }
        for (i = 0; i < this.groupingAdapters_.length; ++i) {
            xmlAxis.m_list_groupingDimensionList.add((XMLGroupingDimensionAdapter)this.groupingAdapters_[i].getXMLDelegate());
        }
        return xmlAxis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

