/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.common.internal;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class VisuVersion {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$common$internal$VisuVersion == null ? (class$com$businessobjects$visualization$common$internal$VisuVersion = VisuVersion.class$("com.businessobjects.visualization.common.internal.VisuVersion")) : class$com$businessobjects$visualization$common$internal$VisuVersion).getName());
    public static final String FIRSTVERSION = "1.0.0.0";
    private int majorXmlStructure_;
    private int minorXmlStructure_;
    private int majorXmlContent_;
    private int minorXmlContent_;
    static final String DOT = ".";
    static /* synthetic */ Class class$com$businessobjects$visualization$common$internal$VisuVersion;

    public VisuVersion(String version) {
        int[] xmlVersionList = null;
        try {
            xmlVersionList = this.intArrayFromString(version == null ? FIRSTVERSION : version);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("invalid string version :" + version));
            xmlVersionList = this.intArrayFromString(FIRSTVERSION);
        }
        if (xmlVersionList.length != 4) {
            throw new VisualizationRuntimeException("VIZ_00074_ERR_VERSION_HAS_AN_INVAL", new Object[]{version});
        }
        this.majorXmlStructure_ = xmlVersionList[0];
        this.minorXmlStructure_ = xmlVersionList[1];
        this.majorXmlContent_ = xmlVersionList[2];
        this.minorXmlContent_ = xmlVersionList[3];
    }

    private String getXmlStructureVersion() {
        return String.valueOf(this.majorXmlStructure_) + DOT + String.valueOf(this.minorXmlStructure_);
    }

    private String getXmlContentVersion() {
        return String.valueOf(this.majorXmlContent_) + DOT + String.valueOf(this.minorXmlContent_);
    }

    public String getXmlVersion() {
        return this.getXmlStructureVersion() + DOT + this.getXmlContentVersion();
    }

    public String toString() {
        return this.getXmlVersion();
    }

    private int[] intArrayFromString(String ver) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(ver, DOT);
        while (st.hasMoreTokens()) {
            al.add(st.nextToken());
        }
        int[] result = new int[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            result[i] = Integer.parseInt((String)al.get(i));
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuVersion) {
            VisuVersion version = (VisuVersion)obj;
            result = this.majorXmlStructure_ == version.majorXmlStructure_ && this.minorXmlStructure_ == version.minorXmlStructure_ && this.majorXmlContent_ == version.majorXmlContent_ && this.minorXmlContent_ == version.minorXmlContent_;
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

