/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.Helper;
import com.businessobjects.visualization.ProviderDescription;
import com.businessobjects.visualization.Score;
import com.businessobjects.visualization.VisualizationEngine;
import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.feed.definition.generated.XMLDataFeedDefinition;
import com.businessobjects.visualization.feed.definition.generated.XMLDataFeedDefinitionList;
import com.businessobjects.visualization.formatting.IFormatFactory;
import com.businessobjects.visualization.graphic.GraphicDef;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.VisuFont;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuTemplate;
import com.businessobjects.visualization.graphic.resource.GraphicResource;
import com.businessobjects.visualization.graphic.resource.GraphicResourceType;
import com.businessobjects.visualization.graphic.resource.GraphicResources;
import com.businessobjects.visualization.graphic.xml.scoring.generated.XMLScoringRules;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisualizationLibrary;
import com.businessobjects.visualization.internal.util.ResourceFormat;
import com.businessobjects.visualization.internal.util.Resources;
import com.businessobjects.visualization.xml.generated.XMLLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;

public class LocalizedEngine {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$LocalizedEngine == null ? (class$com$businessobjects$visualization$LocalizedEngine = LocalizedEngine.class$("com.businessobjects.visualization.LocalizedEngine")) : class$com$businessobjects$visualization$LocalizedEngine));
    private Locale locale_;
    private Hashtable graphicDefHt_ = new Hashtable();
    private Hashtable publicGraphicHt_ = new Hashtable();
    private Hashtable providerHt_ = new Hashtable();
    private Hashtable feedSpecHt_ = new Hashtable();
    private XMLScoringRules xmlScoringRules_;
    private GraphicResources resources_;
    private final IFormatFactory formatFactory_;
    private VisuFont defaultFont_;
    static /* synthetic */ Class class$com$businessobjects$visualization$LocalizedEngine;

    LocalizedEngine(VisualizationEngine engine, Locale locale) {
        this.locale_ = locale;
        this.formatFactory_ = engine.getFormatFactory();
        this.resources_ = engine.getResources();
        VisualizationEngine.VisuProvider[] visuProviders = engine.getVisuProviders();
        for (int i = 0; i < visuProviders.length; ++i) {
            Localizator loc = new Localizator(locale, visuProviders[i].getLocFiles(), visuProviders[i].getRootPackagePath());
            String loaderLibrary = null;
            String loaderClass = null;
            String loaderVersion = null;
            Iterator iter = visuProviders[i].getXmlProvider().m_list_Loader.iterator();
            while (iter.hasNext()) {
                XMLLoader xmlLoader = (XMLLoader)iter.next();
                if (!xmlLoader.m_a_language.equals("java")) continue;
                loaderLibrary = xmlLoader.m_a_Library;
                loaderClass = xmlLoader.m_a_Class;
                loaderVersion = xmlLoader.m_a_version;
                break;
            }
            XMLDataFeedDefinitionList xmlList = visuProviders[i].getDataFeedSpecList();
            iter = xmlList.m_list_DataFeedDefinition.iterator();
            while (iter.hasNext()) {
                XMLDataFeedDefinition xmlSpec = (XMLDataFeedDefinition)iter.next();
                DataFeedDefinition spec = new DataFeedDefinition(xmlSpec, null, loc);
                this.feedSpecHt_.put(spec.getId(), spec);
            }
            ProviderDescription provider = new ProviderDescription(this.feedSpecHt_, visuProviders[i], loaderLibrary, loaderClass, loaderVersion, loc);
            provider.setDefaultValues(visuProviders[i].getXmlDefaultValues(locale));
            int mask = visuProviders[i].getOutputTypeMask();
            for (int j = 0; j < visuProviders[i].getXmlGraphics().length; ++j) {
                XMLGraphic xg = visuProviders[i].getXmlGraphics()[j];
                GraphicDef gd = this.buildGraphicDef(provider, xg, loc, visuProviders[i].getXLibTemplate());
                Iterator iterPg = gd.getPublicGraphics().iterator();
                boolean found = false;
                while (iterPg.hasNext()) {
                    PublicGraphicDef pg = (PublicGraphicDef)iterPg.next();
                    if ((pg.getAvailableOutputTypes() & mask) == 0) continue;
                    found = true;
                    this.publicGraphicHt_.put(pg.getId(), pg);
                    provider.addGraphicDescription(new GraphicDescription(pg, pg.getAvailableOutputTypes() & mask));
                }
                if (!found) continue;
                this.graphicDefHt_.put(gd.getId(), gd);
            }
            this.providerHt_.put(provider.getId(), provider);
            if (i != 0) continue;
            this.xmlScoringRules_ = visuProviders[i].getScoringRules();
            Score.checkValidScoringRules(this.xmlScoringRules_, this.feedSpecHt_, this.publicGraphicHt_);
        }
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public ProviderDescription[] getProviders() {
        ProviderDescription[] result = new ProviderDescription[this.providerHt_.size()];
        Enumeration myenum = this.providerHt_.keys();
        int i = 0;
        while (myenum.hasMoreElements()) {
            result[i++] = (ProviderDescription)this.providerHt_.get(myenum.nextElement());
        }
        return result;
    }

    ProviderDescription getProvider(String id) {
        ProviderDescription result = null;
        if (id != null) {
            result = (ProviderDescription)this.providerHt_.get(id);
        }
        return result;
    }

    public GraphicDescription[] getGraphics() {
        ArrayList list = new ArrayList();
        Enumeration myenum = this.providerHt_.elements();
        while (myenum.hasMoreElements()) {
            ProviderDescription provider = (ProviderDescription)myenum.nextElement();
            Collection subList = provider.getGraphicDescriptionList();
            Iterator subIter = subList.iterator();
            while (subIter.hasNext()) {
                list.add(subIter.next());
            }
        }
        GraphicDescription[] result = new GraphicDescription[list.size()];
        list.toArray(result);
        return result;
    }

    public DataFeedDefinition[] getDataFeedSpecifications() {
        DataFeedDefinition[] result = new DataFeedDefinition[this.feedSpecHt_.size()];
        Enumeration myenum = this.feedSpecHt_.keys();
        int i = 0;
        while (myenum.hasMoreElements()) {
            result[i++] = (DataFeedDefinition)this.feedSpecHt_.get(myenum.nextElement());
        }
        return result;
    }

    public GraphicInstance getGraphicInstance(DataDescriptor data) {
        GraphicInstance gi = new GraphicInstance(this);
        gi.setDataDescriptor(data);
        return gi;
    }

    public GraphicInstance getGraphicInstance(InputStream is) throws SerializationException {
        GraphicInstance gi = new GraphicInstance(this);
        gi.init(is);
        return gi;
    }

    public GraphicInstance getGraphicInstance(String graphicId) {
        GraphicInstance gi = new GraphicInstance(this);
        gi.turnTo(graphicId);
        return gi;
    }

    public GraphicInstance getGraphicInstance(String templateLib, String templateID) {
        return null;
    }

    public GraphicInstance getGraphicInstance(GraphicDescription description) {
        GraphicInstance gi = new GraphicInstance(this);
        gi.turnTo(description.getId());
        return gi;
    }

    public GraphicInstance getSampleImage(String graphicId, int width, int height) {
        return this.getSampleImage(graphicId, width, height, null, null, 0, null);
    }

    public GraphicInstance getSampleImage(String graphicId, int width, int height, VisuTemplate template, DataHolder inputDataHolder, int output, OutputStream os) {
        DataHolder dholder;
        RegionDef region;
        PropertyDef prop;
        GraphicInstance gi = this.getGraphicInstance(graphicId);
        if (template != null) {
            gi.getGraphic().initFromTemplate(template);
        }
        if ((prop = (region = gi.getGraphic().getPublicGraphicDef().getRegion("root")).getProperty("width")) != null) {
            gi.getGraphic().setPropertyValue(region.getId(), prop.getId(), new VisuInteger(width));
        }
        if ((prop = region.getProperty("height")) != null) {
            gi.getGraphic().setPropertyValue(region.getId(), prop.getId(), new VisuInteger(height));
        }
        if ((dholder = inputDataHolder) == null) {
            String sampleUid = gi.getGraphic().getGraphicDescription().getPublicGraphic().getDataSampleUid();
            dholder = gi.getPublicGraphicDef().getGraphicDef().getProviderDescription().getDataSamplesManager().get(sampleUid, this.locale_.getLanguage());
        }
        if (dholder != null) {
            gi.setDataDescriptor(dholder.getDataDescriptor());
            gi.setDataAdapter(dholder.getDataAdapter());
        } else {
            LOGGER.warn((Object)("No sample set resolved for:" + graphicId));
        }
        try {
            if (os != null) {
                os.write(gi.makeGraph(output).render());
            }
        }
        catch (IOException e) {
            throw new VisualizationInternalException(e);
        }
        return gi;
    }

    protected DataFeedDefinition getDataFeedSpecification(String graphicId) {
        DataFeedDefinition result = null;
        GraphicDef gd = (GraphicDef)this.graphicDefHt_.get(graphicId);
        if (gd != null) {
            String feedId = gd.getFeedId();
            result = (DataFeedDefinition)this.feedSpecHt_.get(feedId);
        }
        return result;
    }

    protected GraphicDef getGraphicDef(String graphicId) {
        GraphicDef gd = (GraphicDef)this.graphicDefHt_.get(graphicId);
        return gd;
    }

    protected PublicGraphicDef getPublicGraphic(String publicGraphicId) {
        PublicGraphicDef pg = (PublicGraphicDef)this.publicGraphicHt_.get(publicGraphicId);
        return pg;
    }

    XMLScoringRules getXMLScoringRules() {
        return this.xmlScoringRules_;
    }

    private GraphicDef buildGraphicDef(ProviderDescription pdesc, XMLGraphic xg, Localizator loc, XMLVisualizationLibrary library) {
        GraphicDef gd = new GraphicDef(xg, pdesc, loc, library, pdesc.getAvailableOutputTypes());
        return gd;
    }

    public GraphicResource getResource(GraphicResourceType type, String id) {
        GraphicResource resource = this.resources_.getResource(type, id);
        if (resource == null) {
            LOGGER.warn((Object)("Resource " + id + " not found. Expected behavior modified"));
        }
        return resource;
    }

    public GraphicResources getResources() {
        return this.resources_;
    }

    public IFormatFactory getFormatFactory() {
        return this.formatFactory_;
    }

    Localizator getLocalizator(String[] locFiles, String rootPackagePath) {
        Localizator loc = new Localizator(this.locale_, locFiles, rootPackagePath);
        return loc;
    }

    public VisuFont getDefaultFont() {
        return this.defaultFont_;
    }

    public void setDefaultFont(VisuFont defaultFont) {
        this.defaultFont_ = defaultFont;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Localizator {
        private Locale currentLocale_;
        private Resources[] resourcesList_;
        private Hashtable valueHt_ = new Hashtable();

        Localizator(Locale locale, String[] locFiles, String rootPackagePath) {
            this.currentLocale_ = locale;
            this.resourcesList_ = new Resources[locFiles.length];
            for (int i = 0; i < locFiles.length; ++i) {
                this.resourcesList_[i] = Resources.getResources(Helper.buildResourcePaths(locFiles[i], rootPackagePath), this.currentLocale_, ResourceFormat.DEFAULT);
            }
        }

        public Locale getLocale() {
            return this.currentLocale_;
        }

        public String getValue(String key) {
            String result = key;
            if (key != null && key.length() > 4 && key.substring(0, 4).equalsIgnoreCase("ids_")) {
                result = this.valueHt_.containsKey(key) ? (String)this.valueHt_.get(key) : this.compute(key);
            }
            return result;
        }

        private String compute(String key) {
            String result = key;
            for (int i = 0; i < this.resourcesList_.length; ++i) {
                String loc;
                if (this.resourcesList_[i] == null || (loc = this.resourcesList_[i].getMessage(key)) == null || loc.equals("???")) continue;
                result = loc;
                break;
            }
            this.valueHt_.put(key, result);
            return result;
        }
    }
}

