/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.math;

import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.NumericValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.crystaldecisions12.reports.formulas.functions.CommonArguments;
import com.crystaldecisions12.reports.formulas.functions.FormulaFunctionFactory;

public class RemainderFunctionFactory
implements FormulaFunctionFactory {
    private static RemainderFunctionFactory dI = new RemainderFunctionFactory();
    private static final FormulaFunctionArgumentDefinition[][] dJ = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.num, CommonArguments.denom}, {CommonArguments.numCurr, CommonArguments.denom}, {CommonArguments.num, CommonArguments.denomCurr}, {CommonArguments.numCurr, CommonArguments.denomCurr}};
    private static final FormulaFunctionDefinition[] dK = new FormulaFunctionDefinition[]{new a(dJ[0]), new a(dJ[1]), new a(dJ[2]), new a(dJ[3])};

    private RemainderFunctionFactory() {
    }

    public static RemainderFunctionFactory ay() {
        return dI;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return dK[n2];
    }

    public int getNFunctionInstances() {
        return dK.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("Remainder", "remainder", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            NumericValue numericValue;
            if (formulaValueReferenceArray[1].getFormulaValue() != null && (numericValue = (NumericValue)formulaValueReferenceArray[1].getFormulaValue()).getInt() == 0) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "DivisionByZero", 1);
            }
            return formulaValueReferenceArray[0].getFormulaValueType();
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            boolean bl2;
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            NumericValue numericValue = (NumericValue)formulaValueReferenceArray[0].getFormulaValue();
            NumericValue numericValue2 = (NumericValue)formulaValueReferenceArray[1].getFormulaValue();
            double d10 = numericValue.getScaledDouble() % numericValue2.getScaledDouble();
            FormulaValueType formulaValueType = formulaValueReferenceArray[0].getFormulaValue().getFormulaValueType();
            FormulaValueType formulaValueType2 = formulaValueReferenceArray[0].getFormulaValue().getFormulaValueType();
            boolean bl3 = bl2 = formulaValueType == FormulaValueType.currency || formulaValueType2 == FormulaValueType.currency;
            if (bl2) {
                return CurrencyValue.fromScaledDouble(d10);
            }
            return NumberValue.fromScaledDouble(d10);
        }
    }
}

