/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.RangeValue;
import com.crystaldecisions12.reports.common.value.TimeValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.StringTokenizer;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class DateValue
extends FormulaValue
implements Comparable {
    public static final int nullCRDate = -1;
    private static final int[] h = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int m = DateValue.a(1899, 12, 30);
    private static final int i = DateValue.a(100, 1, 1);
    private static final int k = DateValue.a(9999, 12, 31);
    private static DateValue l = new DateValue(0);
    private final int n;
    static final int j = 2415019;
    public static final DateValue min;
    public static final DateValue max;

    private DateValue(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("CRDate must be >= 0");
        }
        this.n = n2;
    }

    public static DateValue now() {
        DateValue dateValue = DateValue.fromCalendar(new GregorianCalendar(Locale.US));
        if (!l.equals(dateValue)) {
            l = dateValue;
        }
        return l;
    }

    public static DateValue fromCRDate(int n2) {
        if (n2 == -1) {
            return null;
        }
        if (n2 == DateValue.l.n) {
            return l;
        }
        return new DateValue(n2);
    }

    private static int a(int n2, int n3, int n4) {
        short s2 = 0;
        int n5 = 0;
        int n6 = n3;
        int n7 = n4;
        int n8 = n2;
        if (n8 < 0) {
            ++n8;
        }
        if (n6 <= 2) {
            --n8;
            n6 += 12;
        }
        if (n8 * 10000 + n6 * 100 + n7 >= 15821015) {
            s2 = (short)(n8 / 100);
            n5 = 2 - s2 + s2 / 4;
        }
        return 36525 * n8 / 100 + 306001 * (n6 + 1) / 10000 + n7 + 1720994 + n5;
    }

    private static int[] a(int n2) {
        int n3;
        int n4 = n2 + 1;
        if (n4 < 2299161) {
            n3 = n4;
        } else {
            int n5 = (n4 * 100 - 186721625) / 3652425;
            n3 = n4 + 1 + n5 - n5 / 4;
        }
        int n6 = n3 > 1721423 ? n3 + 1524 : n3 + 1158;
        int n7 = (n6 * 100 - 12210) / 36525;
        int n8 = 36525 * n7 / 100;
        int n9 = (n6 - n8) * 10000 / 306001;
        int n10 = n6 - n8 - 306001 * n9 / 10000;
        int n11 = n9 * 10 < 135 ? n9 - 1 : n9 - 13;
        int n12 = n11 * 10 > 25 ? n7 - 4716 : n7 - 4715;
        return new int[]{n12, n11, n10};
    }

    public static DateValue fromYMD(int n2, int n3, int n4) {
        if (n2 < -4713) {
            throw new IllegalArgumentException("year must be >= -4713");
        }
        if (n2 > 54078) {
            throw new IllegalArgumentException("year must be <= 54078");
        }
        if (n3 < 1 || n3 > 12) {
            throw new IllegalArgumentException("month must be between 1 and 12");
        }
        boolean bl2 = n2 >= 1582 ? n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 : n2 % 4 == 0;
        int n5 = h[n3];
        if (n3 == 2 && bl2) {
            n5 = 29;
        }
        if (n4 < 1 || n4 > n5) {
            throw new IllegalArgumentException("day must be between 1 and max days in month");
        }
        return DateValue.fromCRDate(DateValue.a(n2, n3, n4));
    }

    public static DateValue fromCalendar(Calendar calendar) {
        return DateValue.fromYMD(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static DateValue fromOleDate(double d10) {
        int n2 = m + (int)d10;
        if (n2 < 0 || !DateValue.isValidOleDate(d10)) {
            throw new IllegalArgumentException("OleDate cannot be converted to a valid CRDate");
        }
        return DateValue.fromCRDate(n2);
    }

    public static boolean isValidOleDate(double d10) {
        int n2 = m + (int)d10;
        return n2 >= i && n2 <= k;
    }

    public double getOleDate() {
        return this.n - m;
    }

    public static int getCRDate(DateValue dateValue) {
        return dateValue == null ? -1 : dateValue.getCRDate();
    }

    public static int getYear(DateValue dateValue) {
        return dateValue == null ? DateValue.a(-1)[0] : dateValue.getYear();
    }

    public static int getMonth(DateValue dateValue) {
        return dateValue == null ? DateValue.a(-1)[1] : dateValue.getMonth();
    }

    public static int getDay(DateValue dateValue) {
        return dateValue == null ? DateValue.a(-1)[2] : dateValue.getDay();
    }

    public int getCRDate() {
        return this.n;
    }

    public int getYear() {
        return DateValue.a(this.n)[0];
    }

    public int getMonth() {
        return DateValue.a(this.n)[1];
    }

    public int getDay() {
        return DateValue.a(this.n)[2];
    }

    public ValueType getValueType() {
        return ValueType.f;
    }

    public FormulaValue coerceToDate() {
        return this;
    }

    public FormulaValue coerceToDateTime() {
        return this.getStartOfDayDateTimeValue();
    }

    public DateTimeValue getStartOfDayDateTimeValue() {
        return DateTimeValue.fromDateAndTimeValues(this, TimeValue.min);
    }

    public DateTimeValue getEndOfDayDateTimeValue() {
        return DateTimeValue.fromDateAndTimeValues(this, TimeValue.max);
    }

    public RangeValue getDateTimeRangeValue() {
        return RangeValue.fromStartAndEndValues(this.getStartOfDayDateTimeValue(), this.getEndOfDayDateTimeValue(), true, true);
    }

    public int hashCode() {
        return this.n;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        return DateValue.a(this.n, ((DateValue)object).n);
    }

    public DateValue addNumberToDate(int n2) {
        return new DateValue(this.n + n2);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        String string = "d(" + numberFormat.format(this.getYear()) + "-";
        numberFormat.setMinimumIntegerDigits(2);
        string = string + numberFormat.format(this.getMonth()) + "-" + numberFormat.format(this.getDay()) + ")";
        return string;
    }

    public static double To1900Format(DateValue dateValue) {
        double d10 = dateValue.getCRDate() - 2415019;
        if (d10 >= 60.0) {
            d10 += 1.0;
        }
        return d10;
    }

    public static DateValue From1900Format(int n2) {
        if (n2 >= 60) {
            --n2;
        }
        return DateValue.fromCRDate(n2 += 2415019);
    }

    public Date getJavaDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDay());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public String toValueString(Locale locale) {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDay());
        return FormatterCache.if(locale).format((Object)calendar);
    }

    public String toValueString() {
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)Locale.US);
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDay());
        DateFormat dateFormat = FormatterCache.if(Locale.US);
        ((SimpleDateFormat)dateFormat).applyPattern("'Date('yyyy','MM','dd')'");
        return dateFormat.format((Object)calendar);
    }

    public static String toDateValueString(DateValue dateValue, Locale locale) {
        if (dateValue != null) {
            return dateValue.toValueString(locale);
        }
        com.ibm.icu.util.Calendar calendar = com.ibm.icu.util.Calendar.getInstance((Locale)locale);
        calendar.set(DateValue.getYear(null), DateValue.getMonth(null) - 1, DateValue.getDay(null));
        return FormatterCache.if(locale).format((Object)calendar);
    }

    public static CrystalValue fromFormattedString(String string) {
        if (!string.startsWith("Date(") || !string.endsWith(")")) {
            CrystalAssert.a(false);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(5, string.length() - 1), ",");
        if (stringTokenizer.countTokens() != 3) {
            CrystalAssert.a(false);
            return null;
        }
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        return DateValue.fromYMD(n2, n3, n4);
    }

    public static boolean Equals(DateValue dateValue, DateValue dateValue2) {
        if (dateValue == null || dateValue2 == null) {
            return false;
        }
        return dateValue.compareTo(dateValue2) == 0;
    }

    static {
        l = DateValue.now();
        min = DateValue.fromCRDate(i);
        max = DateValue.fromCRDate(5373464);
    }
}

