/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.PNGEncoder.PNGEncoder;
import com.crystaldecisions.reports.common.DIBEncoder;
import com.crystaldecisions.reports.common.ICrystalImage;
import com.crystaldecisions.reports.common.JpegEncoder;
import com.crystaldecisions.reports.common.TwipSize;
import com.crystaldecisions.reports.common.enums.ImageFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractCrystalImage
implements ICrystalImage {
    private static final Logger do = Logger.getLogger((String)"com.crystaldecisions.common");
    private final Set<ImageFormat> if = new TreeSet<ImageFormat>();
    private final ImageFormat[] a;
    protected final Color int = new Color(255, 255, 255, 0);
    private SoftReference<byte[]> for = new SoftReference<Object>(null);

    protected AbstractCrystalImage(ImageFormat[] imageFormatArray) {
        this.a = imageFormatArray;
        for (int i2 = 0; i2 < imageFormatArray.length; ++i2) {
            this.if.add(imageFormatArray[i2]);
        }
    }

    public void draw(Graphics2D graphics2D, int n2, int n3, int n4, int n5, Color color) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(this.getJavaAwtImage(), n2, n3, n4, n5, color, null);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        } else {
            graphics2D.getRenderingHints().remove(RenderingHints.KEY_INTERPOLATION);
        }
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(this.getJavaAwtImage(), n2, n3, null);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        } else {
            graphics2D.getRenderingHints().remove(RenderingHints.KEY_INTERPOLATION);
        }
    }

    public byte[] getMetafileData() {
        return null;
    }

    public Image getImage(Dimension dimension, Color color) {
        Image image = this.getJavaAwtImage();
        if (dimension == null && color == null && image != null) {
            return image;
        }
        if (dimension == null) {
            return this.a(null, color);
        }
        return this.a(new Rectangle(dimension), color);
    }

    public byte[] getDibData() {
        return this.getDibData(null, null);
    }

    public byte[] getDibData(Rectangle rectangle) {
        return this.getDibData(rectangle, null);
    }

    public byte[] getDibData(Color color) {
        return this.getDibData(null, color);
    }

    public byte[] getDibData(Rectangle rectangle, Color color) {
        DIBEncoder dIBEncoder = new DIBEncoder(this.a(rectangle, color), this.getResolution());
        return dIBEncoder.getDibData();
    }

    public byte[] getJpegData(Rectangle rectangle, int n2) {
        return this.getJpegData(rectangle, null, n2);
    }

    public byte[] getJpegData(Rectangle rectangle, Color color, int n2) {
        Image image = this.a(rectangle, color);
        if (n2 < 0) {
            n2 = 75;
        } else if (n2 > 100) {
            n2 = 100;
        }
        int n3 = 10240;
        if (null != rectangle) {
            n3 = (int)(rectangle.getWidth() * rectangle.getHeight());
        } else {
            rectangle = new Rectangle(0, 0, this.getJavaAwtImage().getWidth(null), this.getJavaAwtImage().getHeight(null));
            n3 = (int)(rectangle.getWidth() * rectangle.getHeight());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
        JpegEncoder jpegEncoder = new JpegEncoder(image, n2, byteArrayOutputStream, false, new TwipSize((int)rectangle.getWidth(), (int)rectangle.getHeight()));
        try {
            jpegEncoder.if();
        }
        catch (IOException iOException) {
            do.error((Object)"Failed to get JPEG data for image", (Throwable)iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getPngData(Rectangle rectangle) {
        return this.getPngData(rectangle, null);
    }

    public byte[] getPngData(Rectangle rectangle, Color color) {
        boolean bl2 = rectangle == null && color == null;
        byte[] byArray = this.for.get();
        if (bl2 && byArray != null) {
            return byArray;
        }
        Image image = this.a(rectangle, color);
        if (image instanceof BufferedImage) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                PNGEncoder.encode((BufferedImage)image, (OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                do.error((Object)"Unable to encode to PNG", (Throwable)iOException);
                return null;
            }
            byArray = byteArrayOutputStream.toByteArray();
            if (bl2) {
                this.for = new SoftReference<byte[]>(byArray);
            }
            return byArray;
        }
        return null;
    }

    public boolean saveAsDIBFile(OutputStream outputStream) throws IOException {
        DIBEncoder dIBEncoder = new DIBEncoder(this.getJavaAwtImage(), this.getResolution());
        dIBEncoder.saveAsDIBFile(outputStream);
        return true;
    }

    public boolean saveAsEMFFile(OutputStream outputStream) throws IOException {
        return false;
    }

    protected Image a(Rectangle rectangle, Color color) {
        Image image = this.getJavaAwtImage();
        if (!(image instanceof BufferedImage)) {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
            if (color == null) {
                color = this.int;
            }
            Graphics graphics = bufferedImage.getGraphics().create();
            graphics.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), color, null);
            graphics.dispose();
            image = bufferedImage;
        }
        if (null != rectangle) {
            int n2 = (int)rectangle.getWidth();
            int n3 = (int)rectangle.getHeight();
            Dimension dimension = this.getPixelSize();
            if ((double)n2 != dimension.getWidth() || (double)n3 != dimension.getHeight() || null != color) {
                if (null == color) {
                    image = this.getJavaAwtImage().getScaledInstance(n2, n3, 4);
                } else {
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 5);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    graphics2D.drawImage(image, 0, 0, n2, n3, color, null);
                    graphics2D.dispose();
                    image = bufferedImage;
                }
            }
        }
        return image;
    }

    public boolean canFetchAs(ImageFormat imageFormat) {
        return this.if.contains((Object)imageFormat);
    }

    public ImageFormat[] getSupportedImageFormats() {
        return this.a;
    }

    public boolean canFetchAsMetafile() {
        return this.canFetchAs(ImageFormat.EMF) || this.canFetchAs(ImageFormat.WMF);
    }

    public boolean isRasterImage() {
        return true;
    }

    public boolean isVectorImage() {
        return !this.isRasterImage();
    }
}

