/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.lov.SortOrder;
import com.businessobjects.prompting.internal.PasswordEncryptHelper;
import com.businessobjects.prompting.internal.PropertyBag;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.PromptValueList;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.businessobjects.reports.crprompting.CRPromptValue;
import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.sdk.occa.report.lib.ClonableList;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.SerializationHelper;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prompt
implements IPrompt {
    private static final String XML_PROMPT_NAME = "Name";
    private static final String XML_PROMPT_DESC = "Desc";
    private static final String XML_PROMPT_VALUETYPE = "ValueType";
    private static final String XML_PROMPT_NULLABLE = "Nullable";
    private static final String XML_PROMPT_ALLOWMULTIPLEVALUES = "AllowMultiValues";
    private static final String XML_PROMPT_ALLOWDISCRETEVALUE = "AllowDiscreteValue";
    private static final String XML_PROMPT_ALLOWRANGEVALUE = "AllowRangeValue";
    private static final String XML_PROMPT_ALLOWCUSTOMVALUE = "AllowCustomValue";
    private static final String XML_PROMPT_HASRANGELIMIT = "HasRangeLimit";
    private static final String XML_PROMPT_ISREADONLY = "IsReadOnly";
    private static final String XML_PROMPT_MIN = "Min";
    private static final String XML_PROMPT_MAX = "Max";
    private static final String XML_PROMPT_EDITMASK = "EditMask";
    private static final String XML_PROMPT_VALUES = "Values";
    private static final String XML_PROMPT_ISPASSWORD = "IsPassword";
    private static final String XML_PROMPT_PASSWORD = "Password";
    private static final String XML_PROMPT_VALUEREQUIRED = "ValueRequired";
    private static final String XML_PROMPT_CUID = "CUID";
    private static final String XML_PROMPT_LOVCUID = "LOVCUID";
    private static final String XML_PROMPT_REQUIREDPROMPTCUIDS = "RequiredCUID";
    private static final String XML_PROMPT_HIDDENFIELDS = "HiddenFields";
    private static final String XML_PROMPT_EXTENSIONMETADATA = "ExtensionMetaData";
    private static final String XML_PROMPT_DEFAULTVALUES = "DefaultValues";
    private static final String XML_PROMPT_LOVSORTS = "LOVSorts";
    private String m_name = null;
    private String m_defaultPromptText = null;
    private PromptValueType m_valueType = PromptValueType.string;
    private boolean m_nullable = true;
    private boolean m_allowMultipleValues = false;
    private boolean m_allowDiscreteValue = true;
    private boolean m_allowRangeValue = false;
    private boolean m_allowCustomValue = false;
    private boolean m_valueRequired = true;
    private boolean m_readOnly = false;
    private IPromptValue m_min = CRPromptValue.NULL;
    private IPromptValue m_max = CRPromptValue.NULL;
    private String m_editMask = null;
    private IPromptValue.IPromptValueList m_values = new PromptValueList();
    private boolean m_isPassword = false;
    private String m_password = null;
    private UUID m_cuid = UUID.randomUUID();
    private UUID m_lovCuid;
    private ClonableList<UUID> m_requiredCuids = new ClonableList();
    private ClonableList<Integer> m_hiddenFields = new ClonableList();
    private PropertyBag<String, String> m_extensionPropertyBag = new PropertyBag();
    private IPromptValue.IPromptValueList m_defaultValues = new PromptValueList();
    private ClonableList<IPrompt.ISort> m_LOVSorts = new ClonableList();
    private static final String XML_SORT_INDEX = "SortIndex";
    private static final String XML_SORT_ORDER = "SortOrder";

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public UUID getUUID() {
        return this.m_cuid;
    }

    @Override
    public void setUUID(UUID id) {
        this.m_cuid = id;
    }

    @Override
    public String getDefaultPromptText() {
        return this.m_defaultPromptText;
    }

    @Override
    public void setDefaultPromptText(String description) {
        this.m_defaultPromptText = description;
    }

    @Override
    public PromptValueType getValueType() {
        return this.m_valueType;
    }

    @Override
    public void setValueType(PromptValueType valueType) {
        if (this.m_valueType != valueType) {
            this.m_valueType = valueType;
            this.resetValues();
        }
    }

    @Override
    public boolean getNullable() {
        return this.m_nullable;
    }

    @Override
    public void setNullable(boolean nullable) {
        this.m_nullable = nullable;
    }

    @Override
    public boolean getAllowMultipleValues() {
        return this.m_allowMultipleValues;
    }

    @Override
    public void setAllowMultipleValues(boolean allowMultipleValues) {
        this.m_allowMultipleValues = allowMultipleValues;
    }

    @Override
    public boolean getAllowDiscreteValue() {
        return this.m_allowDiscreteValue;
    }

    @Override
    public void setAllowDiscreteValue(boolean allowDiscreteValue) {
        this.m_allowDiscreteValue = allowDiscreteValue;
        this.resetValues();
    }

    @Override
    public boolean getAllowRangeValue() {
        return this.m_allowRangeValue;
    }

    @Override
    public void setAllowRangeValue(boolean allowRangeValue) {
        this.m_allowRangeValue = allowRangeValue;
        this.resetValues();
    }

    @Override
    public boolean getAllowCustomValue() {
        return this.m_allowCustomValue;
    }

    @Override
    public void setAllowCustomValue(boolean allowCustomValue) {
        this.m_allowCustomValue = allowCustomValue;
    }

    @Override
    public boolean getHasRangeLimit() {
        if (this.m_min instanceof IPromptValue.IString && this.m_max instanceof IPromptValue.IString) {
            String minStr = ((IPromptValue.IString)this.m_min).getStringValue();
            String maxStr = ((IPromptValue.IString)this.m_max).getStringValue();
            int minLen = minStr == null ? 0 : minStr.trim().length();
            int maxLen = maxStr == null ? 0 : maxStr.trim().length();
            return minLen != 0 || maxLen != 0;
        }
        return this.m_min != null && !this.m_min.isNull() || this.m_max != null && !this.m_max.isNull();
    }

    @Override
    public IPromptValue getMin() {
        return this.m_min;
    }

    @Override
    public void setMin(IPromptValue min) {
        this.m_min = min;
    }

    @Override
    public IPromptValue getMax() {
        return this.m_max;
    }

    @Override
    public void setMax(IPromptValue max) {
        this.m_max = max;
    }

    @Override
    public String getEditMask() {
        return this.m_editMask;
    }

    @Override
    public void setEditMask(String editMask) {
        this.m_editMask = editMask;
    }

    @Override
    public IPromptValue.IPromptValueList getValues() {
        return this.m_values;
    }

    @Override
    public void setValues(IPromptValue.IPromptValueList values) {
        this.m_values.clear();
        if (values == null) {
            return;
        }
        this.m_values.addAll(values);
    }

    @Override
    public IPromptValue.IPromptValueList getDefaultValues() {
        return this.m_defaultValues;
    }

    @Override
    public void setDefaultValues(IPromptValue.IPromptValueList defaultValues) {
        this.m_defaultValues.clear();
        if (defaultValues == null) {
            return;
        }
        this.m_defaultValues.addAll(defaultValues);
    }

    @Override
    public boolean getValueRequired() {
        return this.m_valueRequired;
    }

    @Override
    public void setValueRequired(boolean valueRequired) {
        this.m_valueRequired = valueRequired;
    }

    @Override
    public UUID getLOVObjectUUID() {
        return this.m_lovCuid;
    }

    @Override
    public void setLOVObjectUUID(UUID uuid) {
        this.m_lovCuid = uuid;
    }

    @Override
    public List<UUID> getRequiredPromptCUIDs() {
        return Collections.unmodifiableList(this.m_requiredCuids);
    }

    @Override
    public void setRequiredPromptCUIDs(List<UUID> cuids) {
        this.m_requiredCuids = new ClonableList<UUID>((Collection<UUID>)cuids);
    }

    @Override
    public List<Integer> getLOVHiddenFields() {
        return Collections.unmodifiableList(this.m_hiddenFields);
    }

    @Override
    public void setLOVHiddenFields(List<Integer> hiddenFields) {
        this.m_hiddenFields = new ClonableList<Integer>((Collection<Integer>)hiddenFields);
    }

    @Override
    public String getMetadataProperty(String key) {
        return this.m_extensionPropertyBag.getStringValue(key);
    }

    @Override
    public void setMetadataProperty(String key, String value) {
        this.m_extensionPropertyBag.put(key, value);
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean value) {
        this.m_readOnly = value;
    }

    @Override
    public List<IPrompt.ISort> getLOVSorts() {
        if (this.m_LOVSorts.isEmpty()) {
            this.m_LOVSorts.add(new Sort(0, SortOrder.NoSort));
        }
        return this.m_LOVSorts;
    }

    @Override
    public void setLOVSorts(List<IPrompt.ISort> sorts) {
        this.m_LOVSorts = new ClonableList<IPrompt.ISort>((Collection<IPrompt.ISort>)sorts);
    }

    @Override
    public Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] bLoaded) {
        Object newObject = ClassFactory.createObject(attrs, ctxt, bLoaded);
        if (eleName.equals(XML_PROMPT_VALUES)) {
            this.m_values = (IPromptValue.IPromptValueList)newObject;
        } else if (eleName.equals(XML_PROMPT_EXTENSIONMETADATA)) {
            this.m_extensionPropertyBag = (PropertyBag)newObject;
        } else if (eleName.equals(XML_PROMPT_DEFAULTVALUES)) {
            this.m_defaultValues = (IPromptValue.IPromptValueList)newObject;
        } else if (eleName.equals(XML_PROMPT_MIN)) {
            this.m_min = (IPromptValue)newObject;
        } else if (eleName.equals(XML_PROMPT_MAX)) {
            this.m_max = (IPromptValue)newObject;
        } else if (eleName.equals(XML_PROMPT_LOVSORTS) && newObject != null) {
            this.m_LOVSorts.add((IPrompt.ISort)newObject);
        }
        return newObject;
    }

    @Override
    public void endElement(String eleName, Map<Object, Object> objState) {
        if (eleName.length() > 0 || this.m_isPassword) {
            // empty if block
        }
    }

    @Override
    public void readElement(String eleName, String sVal, Attributes attrs, Map<Object, Object> objState) {
        if (eleName.equals(XML_PROMPT_NAME)) {
            this.m_name = sVal;
        } else if (eleName.equals(XML_PROMPT_DESC)) {
            this.m_defaultPromptText = sVal;
        } else if (eleName.equals(XML_PROMPT_VALUETYPE)) {
            this.m_valueType = PromptValueType.from_string(sVal);
        } else if (eleName.equals(XML_PROMPT_NULLABLE)) {
            this.m_nullable = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_ALLOWMULTIPLEVALUES)) {
            this.m_allowMultipleValues = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_ALLOWDISCRETEVALUE)) {
            this.m_allowDiscreteValue = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_ALLOWRANGEVALUE)) {
            this.m_allowRangeValue = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_ALLOWCUSTOMVALUE)) {
            this.m_allowCustomValue = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_ISREADONLY)) {
            this.m_readOnly = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_EDITMASK)) {
            this.m_editMask = sVal;
        } else if (eleName.equals(XML_PROMPT_ISPASSWORD)) {
            this.m_isPassword = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_PASSWORD)) {
            this.m_password = PasswordEncryptHelper.decryptPassword(sVal);
        } else if (eleName.equals(XML_PROMPT_VALUEREQUIRED)) {
            this.m_valueRequired = XMLConverter.getBooleanValue(sVal);
        } else if (eleName.equals(XML_PROMPT_CUID)) {
            this.m_cuid = UUID.fromString(sVal);
        } else if (eleName.equals(XML_PROMPT_LOVCUID)) {
            this.m_lovCuid = UUID.fromString(sVal);
        } else if (eleName.equals(XML_PROMPT_REQUIREDPROMPTCUIDS)) {
            this.m_requiredCuids.add(UUID.fromString(sVal));
        } else if (eleName.equals(XML_PROMPT_HIDDENFIELDS)) {
            this.m_hiddenFields.add(XMLConverter.getInteger(sVal));
        }
    }

    @Override
    public void save(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        String sTypeName = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties attrs = SerializationHelper.getHeaderAttributes(sTypeName);
        writer.writeStartElement(sTypeName, attrs);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(sTypeName);
    }

    @Override
    public void save(XMLWriter writer, String sTag, XMLSerializationContext ctxt) throws IOException {
        writer.writeStartObjectElement(sTag, "2", this, ctxt);
        this.saveContents(writer, ctxt);
        writer.writeEndElement(sTag);
    }

    @Override
    public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
        IPromptValue value;
        int nCount;
        writer.writeTextElement(XML_PROMPT_NAME, this.m_name, null);
        writer.writeTextElement(XML_PROMPT_DESC, this.m_defaultPromptText, null);
        writer.writeEnumElement(XML_PROMPT_VALUETYPE, this.m_valueType, null);
        writer.writeBooleanElement(XML_PROMPT_NULLABLE, this.m_nullable, null);
        writer.writeBooleanElement(XML_PROMPT_ALLOWMULTIPLEVALUES, this.m_allowMultipleValues, null);
        writer.writeBooleanElement(XML_PROMPT_ALLOWDISCRETEVALUE, this.m_allowDiscreteValue, null);
        writer.writeBooleanElement(XML_PROMPT_ALLOWRANGEVALUE, this.m_allowRangeValue, null);
        writer.writeBooleanElement(XML_PROMPT_ALLOWCUSTOMVALUE, this.m_allowCustomValue, null);
        writer.writeBooleanElement(XML_PROMPT_HASRANGELIMIT, this.getHasRangeLimit(), null);
        writer.writeBooleanElement(XML_PROMPT_ISREADONLY, this.m_readOnly, null);
        writer.writeObjectElement(this.m_min, XML_PROMPT_MIN, ctxt);
        writer.writeObjectElement(this.m_max, XML_PROMPT_MAX, ctxt);
        writer.writeTextElement(XML_PROMPT_EDITMASK, this.m_editMask, null);
        this.m_password = null;
        if (this.m_isPassword && this.m_values != null && (nCount = this.m_values.size()) > 0 && (value = (IPromptValue)this.m_values.get(0)) instanceof IPromptValue.IString) {
            this.m_password = ((IPromptValue.IString)value).getStringValue();
        }
        writer.writeObjectElement(this.m_values, XML_PROMPT_VALUES, ctxt);
        writer.writeBooleanElement(XML_PROMPT_ISPASSWORD, this.m_isPassword, null);
        String encodedPassword = PasswordEncryptHelper.encryptPassword(this.m_password);
        writer.writeTextElement(XML_PROMPT_PASSWORD, encodedPassword, null);
        writer.writeBooleanElement(XML_PROMPT_VALUEREQUIRED, this.m_valueRequired, null);
        writer.writeTextElement(XML_PROMPT_CUID, this.m_cuid.toString(), null);
        if (this.m_lovCuid != null) {
            writer.writeTextElement(XML_PROMPT_LOVCUID, this.m_lovCuid.toString(), null);
        }
        for (UUID uuid : this.m_requiredCuids) {
            writer.writeTextElement(XML_PROMPT_REQUIREDPROMPTCUIDS, uuid.toString(), null);
        }
        for (Integer hiddenField : this.m_hiddenFields) {
            writer.writeIntElement(XML_PROMPT_HIDDENFIELDS, hiddenField, null);
        }
        writer.writeObjectElement(this.m_extensionPropertyBag, XML_PROMPT_EXTENSIONMETADATA, ctxt);
        writer.writeObjectElement(this.m_defaultValues, XML_PROMPT_DEFAULTVALUES, ctxt);
        for (IPrompt.ISort sort : this.m_LOVSorts) {
            writer.writeObjectElement(sort, XML_PROMPT_LOVSORTS, ctxt);
        }
    }

    @Override
    public void startElement(String eleName, Map<Object, Object> objState, Attributes attrs) {
    }

    @Override
    public boolean getIsPassword() {
        return this.m_isPassword;
    }

    @Override
    public void setIsPassword(boolean b10) {
        this.m_isPassword = b10;
    }

    private void resetValues() {
        this.m_values.clear();
        this.m_defaultValues.clear();
        this.m_min = CRPromptValue.NULL;
        this.m_max = CRPromptValue.NULL;
    }

    @Override
    public Object clone(boolean deepClone) {
        Prompt prompt = new Prompt();
        this.copyTo(prompt, deepClone);
        return prompt;
    }

    @Override
    public void copyTo(Object destObject, boolean deepCopy) {
        Prompt destPrompt = (Prompt)destObject;
        destPrompt.m_name = this.m_name;
        destPrompt.m_defaultPromptText = this.m_defaultPromptText;
        destPrompt.m_valueType = this.m_valueType;
        destPrompt.m_nullable = this.m_nullable;
        destPrompt.m_allowMultipleValues = this.m_allowMultipleValues;
        destPrompt.m_allowDiscreteValue = this.m_allowDiscreteValue;
        destPrompt.m_allowRangeValue = this.m_allowRangeValue;
        destPrompt.m_allowCustomValue = this.m_allowCustomValue;
        destPrompt.m_readOnly = this.m_readOnly;
        destPrompt.m_valueRequired = this.m_valueRequired;
        destPrompt.m_min = this.m_min;
        destPrompt.m_max = this.m_max;
        destPrompt.m_editMask = this.m_editMask;
        if (this.m_values != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_values, destPrompt.m_values)) {
                this.m_values.copyTo(destPrompt.m_values, deepCopy);
            } else {
                destPrompt.m_values = (IPromptValue.IPromptValueList)this.m_values.clone(deepCopy);
            }
        } else {
            destPrompt.m_values = this.m_values;
        }
        destPrompt.m_isPassword = this.m_isPassword;
        destPrompt.m_password = this.m_password;
        destPrompt.m_cuid = this.m_cuid;
        destPrompt.m_lovCuid = this.m_lovCuid;
        if (this.m_requiredCuids != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_requiredCuids, destPrompt.m_requiredCuids)) {
                this.m_requiredCuids.copyTo(destPrompt.m_requiredCuids, deepCopy);
            } else {
                destPrompt.m_requiredCuids = (ClonableList)this.m_requiredCuids.clone(deepCopy);
            }
        } else {
            destPrompt.m_requiredCuids = this.m_requiredCuids;
        }
        if (this.m_hiddenFields != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_hiddenFields, destPrompt.m_hiddenFields)) {
                this.m_hiddenFields.copyTo(destPrompt.m_hiddenFields, deepCopy);
            } else {
                destPrompt.m_hiddenFields = (ClonableList)this.m_hiddenFields.clone(deepCopy);
            }
        } else {
            destPrompt.m_hiddenFields = this.m_hiddenFields;
        }
        if (this.m_extensionPropertyBag != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_extensionPropertyBag, destPrompt.m_extensionPropertyBag)) {
                this.m_extensionPropertyBag.copyTo(destPrompt.m_extensionPropertyBag, deepCopy);
            } else {
                destPrompt.m_extensionPropertyBag = (PropertyBag)this.m_extensionPropertyBag.clone(deepCopy);
            }
        } else {
            destPrompt.m_extensionPropertyBag = this.m_extensionPropertyBag;
        }
        if (this.m_defaultValues != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_defaultValues, destPrompt.m_defaultValues)) {
                this.m_defaultValues.copyTo(destPrompt.m_defaultValues, deepCopy);
            } else {
                destPrompt.m_defaultValues = (IPromptValue.IPromptValueList)this.m_defaultValues.clone(deepCopy);
            }
        } else {
            destPrompt.m_defaultValues = this.m_defaultValues;
        }
        if (this.m_LOVSorts != null && deepCopy) {
            if (CloneUtil.canCopyTo(this.m_LOVSorts, destPrompt.m_LOVSorts)) {
                this.m_LOVSorts.copyTo(destPrompt.m_LOVSorts, deepCopy);
            } else {
                destPrompt.m_LOVSorts = (ClonableList)this.m_LOVSorts.clone(deepCopy);
            }
        } else {
            destPrompt.m_LOVSorts = this.m_LOVSorts;
        }
    }

    @Override
    public boolean hasContent(Object obj) {
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt prompt = (Prompt)obj;
        if (!CloneUtil.equalStrings(this.m_name, prompt.m_name)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_defaultPromptText, prompt.m_defaultPromptText)) {
            return false;
        }
        if (this.m_valueType != prompt.m_valueType) {
            return false;
        }
        if (this.m_nullable != prompt.m_nullable) {
            return false;
        }
        if (this.m_allowMultipleValues != prompt.m_allowMultipleValues) {
            return false;
        }
        if (this.m_allowDiscreteValue != prompt.m_allowDiscreteValue) {
            return false;
        }
        if (this.m_allowRangeValue != prompt.m_allowRangeValue) {
            return false;
        }
        if (this.m_allowCustomValue != prompt.m_allowCustomValue) {
            return false;
        }
        if (this.m_readOnly != prompt.m_readOnly) {
            return false;
        }
        if (this.m_valueRequired != prompt.m_valueRequired) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_min, prompt.m_min)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_max, prompt.m_max)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_editMask, prompt.m_editMask)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_values, prompt.m_values)) {
            return false;
        }
        if (this.m_isPassword != prompt.m_isPassword) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_password, prompt.m_password)) {
            return false;
        }
        if (!CloneUtil.equalObjects(this.m_cuid, prompt.m_cuid)) {
            return false;
        }
        if (!CloneUtil.equalObjects(this.m_lovCuid, prompt.m_lovCuid)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_requiredCuids, prompt.m_requiredCuids)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_hiddenFields, prompt.m_hiddenFields)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_extensionPropertyBag, prompt.m_extensionPropertyBag)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_defaultValues, prompt.m_defaultValues)) {
            return false;
        }
        return CloneUtil.hasContent(this.m_LOVSorts, prompt.m_LOVSorts);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Prompt)) {
            return false;
        }
        return ((Prompt)o2).m_cuid.equals(this.m_cuid);
    }

    public int hashCode() {
        return this.m_cuid.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Sort
    implements IPrompt.ISort {
        private int sortIndex;
        private SortOrder sortOrder;

        public Sort() {
        }

        public Sort(int sortIndex, SortOrder sortOrder) {
            this.sortIndex = sortIndex;
            this.sortOrder = sortOrder;
        }

        @Override
        public int getSortIndex() {
            return this.sortIndex;
        }

        @Override
        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public Object createMember(String eleName, Attributes attrs, XMLSerializationContext ctxt, Map<Object, Object> objState, boolean[] loaded) {
            return ClassFactory.createObject(attrs, ctxt, loaded);
        }

        @Override
        public void endElement(String eleName, Map<Object, Object> objState) {
        }

        @Override
        public void readElement(String eleName, String val, Attributes attrs, Map<Object, Object> objState) {
            if (eleName.equals(Prompt.XML_SORT_INDEX)) {
                this.sortIndex = XMLConverter.getInt(val);
            } else if (eleName.equals(Prompt.XML_SORT_ORDER)) {
                this.sortOrder = SortOrder.valueOf(val);
            }
        }

        @Override
        public void save(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
            String sTypeName = XMLConverter.getXMLFromClassName(this.getClass().getName());
            Properties attrs = SerializationHelper.getHeaderAttributes(sTypeName);
            writer.writeStartElement(sTypeName, attrs);
            this.saveContents(writer, ctxt);
            writer.writeEndElement(sTypeName);
        }

        @Override
        public void save(XMLWriter writer, String tag, XMLSerializationContext ctxt) throws IOException {
            writer.writeStartObjectElement(tag, "2", this, ctxt);
            this.saveContents(writer, ctxt);
            writer.writeEndElement(tag);
        }

        @Override
        public void saveContents(XMLWriter writer, XMLSerializationContext ctxt) throws IOException {
            writer.writeIntElement(Prompt.XML_SORT_INDEX, this.sortIndex, null);
            writer.writeEnumElement(Prompt.XML_SORT_ORDER, (Object)this.sortOrder, null);
        }

        @Override
        public void startElement(String eleName, Map<Object, Object> objState, Attributes attrs) {
        }

        @Override
        public Object clone(boolean deepClone) {
            Sort sort = new Sort();
            this.copyTo(sort, deepClone);
            return sort;
        }

        @Override
        public void copyTo(Object destObject, boolean deepCopy) {
            Sort destSort = (Sort)destObject;
            destSort.sortIndex = this.sortIndex;
            destSort.sortOrder = this.sortOrder;
        }

        @Override
        public boolean hasContent(Object obj) {
            if (!(obj instanceof Sort)) {
                return false;
            }
            Sort sort = (Sort)obj;
            if (this.sortIndex != sort.sortIndex) {
                return false;
            }
            return CloneUtil.equalObjects((Object)this.sortOrder, (Object)sort.sortOrder);
        }
    }
}

