/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.RadialGradientPaintContext;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

class RadialGradientPaintExtContext
implements PaintContext {
    private static final double sqStep = 0.003937007859349251;
    private static final double[] sqrtLut = RadialGradientPaintContext.sqrtLut;
    private static final ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private Point2D.Double f1;
    private Point2D.Double f2;
    private double maInv;
    private double e;
    private double[] m;
    private int[] gradient;
    private WritableRaster working;
    private ColorModel model;
    private Rectangle bounds;
    private boolean isCircle = false;
    private double maxDistanceSq;
    static final String USAGE = "java my2D.paint.RadialGradientPaintExtContext <width> <height>";

    public RadialGradientPaintExtContext(Rectangle2D.Float bounds, Color[] colors, double[] I, AffineTransform t) throws NoninvertibleTransformException {
        double w = bounds.width;
        double h = bounds.height;
        double x = bounds.x;
        double y = bounds.y;
        double a = 0.0;
        double b = 0.0;
        if (w > h) {
            a = w / 2.0;
            b = h / 2.0;
        } else {
            a = h / 2.0;
            b = w / 2.0;
        }
        this.e = Math.sqrt(1.0 - b * b / (a * a));
        this.f1 = new Point2D.Double();
        this.f2 = new Point2D.Double();
        if (w > h) {
            this.f1.x = x + a * (1.0 + this.e);
            this.f1.y = y + b;
            this.f2.x = x + a * (1.0 - this.e);
            this.f2.y = y + b;
        } else {
            this.f1.x = x + b;
            this.f1.y = y + a * (1.0 + this.e);
            this.f2.x = x + b;
            this.f2.y = y + a * (1.0 - this.e);
        }
        this.maInv = 1.0 / (2.0 * a);
        boolean bl = this.isCircle = bounds.width == bounds.height;
        if (this.isCircle) {
            this.maInv = 1.0 / a;
        }
        this.bounds = t.createTransformedShape(bounds).getBounds();
        this.m = new double[6];
        AffineTransform tInv = t.createInverse();
        tInv.getMatrix(this.m);
        int n = I.length;
        double Imin = 1.0;
        for (int i = 0; i < n; ++i) {
            Imin = Imin > I[i] ? I[i] : Imin;
        }
        int transparencyTest = -16777216;
        int[][] gradients = new int[n][];
        int gradientsTot = 1;
        int rgb1 = 0;
        int rgb2 = 0;
        for (int i = 0; i < n; ++i) {
            int nGradients = (int)(I[i] / Imin * 255.0);
            gradientsTot += nGradients;
            gradients[i] = new int[nGradients];
            double stepSize = 1.0 / (double)nGradients;
            rgb1 = colors[i].getRGB();
            rgb2 = colors[i + 1].getRGB();
            int a1 = rgb1 >> 24 & 0xFF;
            int r1 = rgb1 >> 16 & 0xFF;
            int g1 = rgb1 >> 8 & 0xFF;
            int b1 = rgb1 & 0xFF;
            int da = (rgb2 >> 24 & 0xFF) - a1;
            int dr = (rgb2 >> 16 & 0xFF) - r1;
            int dg = (rgb2 >> 8 & 0xFF) - g1;
            int db = (rgb2 & 0xFF) - b1;
            transparencyTest &= rgb1;
            transparencyTest &= rgb2;
            for (int j = 0; j < nGradients; ++j) {
                int rgb;
                gradients[i][j] = rgb = (int)((double)a1 + (double)(j * da) * stepSize) << 24 | (int)((double)r1 + (double)(j * dr) * stepSize) << 16 | (int)((double)g1 + (double)(j * dg) * stepSize) << 8 | (int)((double)b1 + (double)(j * db) * stepSize);
            }
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(gradients[i], 0, this.gradient, curOffset, gradients[i].length);
            curOffset += gradients[i].length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        this.model = transparencyTest >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        int gradientMaxIndex = this.gradient.length - 1;
        this.maInv *= (double)gradientMaxIndex;
        Rectangle2D maxBounds = tInv.createTransformedShape(t.createTransformedShape(bounds).getBounds()).getBounds2D();
        this.maxDistanceSq = this.f1.distanceSq(maxBounds.getX(), maxBounds.getY());
        double maxDistance = Math.sqrt(this.maxDistanceSq);
        this.maInv *= maxDistance;
    }

    public void dispose() {
        this.working = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        if (this.working == null || this.working.getWidth() < w || this.working.getHeight() < h) {
            this.working = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        WritableRaster raster = this.working;
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getBankData()[0];
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w;
        if (!this.isCircle) {
            this.fillRasterEllipse(pixels, off, adjust, x, y, w, h);
        } else {
            this.fillRasterDisc(pixels, off, adjust, x, y, w, h);
        }
        return raster;
    }

    void fillRasterEllipse(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        int x2 = this.bounds.x + this.bounds.width;
        int y2 = this.bounds.y + this.bounds.height;
        int rowLimit = x + w;
        int lLimit = 0;
        int rLimit = 0;
        int startOff = 0;
        double g = 0.0;
        int j = 0;
        double X = 0.0;
        double Y = 0.0;
        double a00 = this.m[0];
        double a10 = this.m[1];
        double a01 = this.m[2];
        double a11 = this.m[3];
        double a02 = this.m[4];
        double a12 = this.m[5];
        double dX1 = 0.0;
        double dY1 = 0.0;
        double dX2 = 0.0;
        double dY2 = 0.0;
        double maxGradientIndex = this.gradient.length - 1;
        double eMaxGradientIndex = this.e * maxGradientIndex;
        int outRgb = this.gradient[(int)maxGradientIndex];
        double eComp = 1.0 - this.e;
        double sqrt1 = 0.0;
        double sqrt2 = 0.0;
        double d1Sq = 0.0;
        double d2Sq = 0.0;
        double iSq1 = 0.0;
        double iSq2 = 0.0;
        int iSq1Int = 0;
        int iSq2Int = 0;
        double p = 0.0;
        for (int i = 0; i < h; ++i) {
            rowLimit = off + w;
            if (i + y < this.bounds.y || i + y > y2 || x + w < this.bounds.x || x > x2) {
                while (off < rowLimit) {
                    pixels[off++] = outRgb;
                }
            } else {
                startOff = off;
                lLimit = off + this.bounds.x - x;
                rLimit = lLimit + this.bounds.width;
                int n = rLimit = rLimit > rowLimit ? rowLimit : rLimit;
                while (off < lLimit) {
                    pixels[off++] = outRgb;
                }
                j = x + off - startOff;
                X = a00 * (double)j + a01 * (double)(y + i) + a02;
                Y = a10 * (double)j + a11 * (double)(y + i) + a12;
                dX1 = this.f1.x - X;
                dY1 = this.f1.y - Y;
                dX2 = this.f2.x - X;
                dY2 = this.f2.y - Y;
                while (off < rLimit) {
                    d1Sq = (dX1 * dX1 + dY1 * dY1) / this.maxDistanceSq;
                    d2Sq = (dX2 * dX2 + dY2 * dY2) / this.maxDistanceSq;
                    if (d1Sq < 0.003937007859349251) {
                        sqrt1 = Math.sqrt(d1Sq);
                    } else {
                        iSq1 = d1Sq / 0.003937007859349251;
                        iSq1Int = (int)iSq1;
                        p = iSq1 - (double)iSq1Int;
                        sqrt1 = p * sqrtLut[iSq1Int + 1] + (1.0 - p) * sqrtLut[iSq1Int];
                    }
                    if (d2Sq < 0.003937007859349251) {
                        sqrt2 = Math.sqrt(d2Sq);
                    } else {
                        iSq2 = d2Sq / 0.003937007859349251;
                        iSq2Int = (int)iSq2;
                        p = iSq2 - (double)iSq2Int;
                        sqrt2 = p * sqrtLut[iSq2Int + 1] + (1.0 - p) * sqrtLut[iSq2Int];
                    }
                    g = (this.maInv * (sqrt1 + sqrt2) - eMaxGradientIndex) / eComp;
                    g = g > maxGradientIndex ? maxGradientIndex : g;
                    g = g < 0.0 ? 0.0 : g;
                    pixels[off++] = this.gradient[(int)g];
                    dX1 -= a00;
                    dX2 -= a00;
                    dY1 -= a10;
                    dY2 -= a10;
                }
                while (off < rowLimit) {
                    pixels[off++] = outRgb;
                }
            }
            off += adjust;
        }
    }

    void fillRasterDisc(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        int x2 = this.bounds.x + this.bounds.width;
        int y2 = this.bounds.y + this.bounds.height;
        int rowLimit = x + w;
        int lLimit = 0;
        int rLimit = 0;
        int startOff = 0;
        double g = 0.0;
        int j = 0;
        double X = 0.0;
        double Y = 0.0;
        double a00 = this.m[0];
        double a10 = this.m[1];
        double a01 = this.m[2];
        double a11 = this.m[3];
        double a02 = this.m[4];
        double a12 = this.m[5];
        double dX = 0.0;
        double dY = 0.0;
        double maxGradientIndex = this.gradient.length - 1;
        int outRgb = this.gradient[(int)maxGradientIndex];
        double sqrt = 0.0;
        double dSq = 0.0;
        double iSq = 0.0;
        int iSqInt = 0;
        double p = 0.0;
        for (int i = 0; i < h; ++i) {
            rowLimit = off + w;
            if (i + y < this.bounds.y || i + y > y2 || x + w < this.bounds.x || x > x2) {
                while (off < rowLimit) {
                    pixels[off++] = outRgb;
                }
            } else {
                startOff = off;
                lLimit = off + this.bounds.x - x;
                rLimit = lLimit + this.bounds.width;
                int n = rLimit = rLimit > rowLimit ? rowLimit : rLimit;
                while (off < lLimit) {
                    pixels[off++] = outRgb;
                }
                j = x + off - startOff;
                X = a00 * (double)j + a01 * (double)(y + i) + a02;
                Y = a10 * (double)j + a11 * (double)(y + i) + a12;
                dX = this.f1.x - X;
                dY = this.f1.y - Y;
                while (off < rLimit) {
                    dSq = (dX * dX + dY * dY) / this.maxDistanceSq;
                    if (dSq < 0.003937007859349251) {
                        sqrt = Math.sqrt(dSq);
                    } else {
                        iSq = dSq / 0.003937007859349251;
                        iSqInt = (int)iSq;
                        p = iSq - (double)iSqInt;
                        sqrt = p * sqrtLut[iSqInt + 1] + (1.0 - p) * sqrtLut[iSqInt];
                    }
                    g = this.maInv * sqrt;
                    g = g > maxGradientIndex ? maxGradientIndex : g;
                    g = g < 0.0 ? 0.0 : g;
                    pixels[off++] = this.gradient[(int)g];
                    dX -= a00;
                    dY -= a10;
                }
                while (off < rowLimit) {
                    pixels[off++] = outRgb;
                }
            }
            off += adjust;
        }
    }
}

