/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FontInfoObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Rectangle;

class TaskSpacing {
    public static final int TASK_AUTOMATIC_HEIGHT = 0;
    public static final int TASK_FRAME_MARGIN_VC = 250;
    public static final int SPACE_BET_TASKS_VC = 500;
    public static final int SPACE_BET_TASKS_VC_IF_TASKS_ROLLEDUP = 1000;
    public static final int MIN_TASK_HEIGHT = 500;
    public static final int MAX_TASK_HEIGHT = 5000;
    private final Access m_Access;
    private final Perspective m_Perspective;
    private final Rectangle m_rFrame;
    private int m_nTaskSpacingVC = 500;
    private final boolean m_hasChildLinkData = false;

    public TaskSpacing(Perspective perspective, Access access) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_rFrame = this.m_Perspective.getFrameRect(false);
        this.m_nTaskSpacingVC = this.anyTasksRolledUp() ? 1000 : 500;
    }

    public int calcTaskHeight() {
        int nTaskHeight;
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        int nNumRolledUpTasks = this.getNumRolledUpTasks();
        nTotalSeries -= nNumRolledUpTasks;
        int nTaskHeightPref = this.m_Perspective.getTaskHeight();
        if (nTaskHeightPref == 0) {
            double fMaxHeight = this.m_rFrame.height;
            double fTotalSpaceBetAllTasks = (nTotalSeries + 1) * this.m_nTaskSpacingVC;
            double fTotalHeight = fMaxHeight - fTotalSpaceBetAllTasks;
            double fTaskHeight = fTotalHeight / (double)nTotalSeries;
            nTaskHeight = (int)fTaskHeight;
            if (nTaskHeight > 5000) {
                nTaskHeight = 5000;
            }
            if (nTaskHeight < 500) {
                nTaskHeight = 500;
            }
        } else {
            nTaskHeight = nTaskHeightPref;
            if (nTaskHeight < 500) {
                nTaskHeight = 500;
            }
        }
        return nTaskHeight;
    }

    public int calcMaxNumTasks(int nTaskHeight) {
        return 9999;
    }

    public int getTaskY(int nSeries) {
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        int nTaskHeight = this.calcTaskHeight();
        int nMaxNumTasks = this.calcMaxNumTasks(nTaskHeight);
        int nTaskSpacing = this.getSpaceBetTasks();
        int nY = this.m_rFrame.y + this.m_rFrame.height;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        boolean bSeriesMatch = false;
        for (int nNumTasks = 0; sEnum.hasNext() && nNumTasks < nMaxNumTasks && !bSeriesMatch; ++nNumTasks) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            nY = nY - nTaskHeight - nTaskSpacing;
            if (s != nSeries) continue;
            bSeriesMatch = true;
        }
        return nY;
    }

    public int getSpaceBetTasks() {
        return this.m_nTaskSpacingVC;
    }

    public boolean anyTasksRolledUp() {
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        boolean bAnyTasksRolledUp = false;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        while (sEnum.hasNext() && !bAnyTasksRolledUp) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            if (!this.isTaskRolledUp(s)) continue;
            bAnyTasksRolledUp = true;
        }
        return bAnyTasksRolledUp;
    }

    public boolean isTaskRolledUp(int nGroup) {
        boolean bTaskRolledUp = false;
        DataItem dataItem = DataItem.DI_GANTT_PARENT_IF_ROLLEDUP;
        double fParentIfRolledUp = -1.0;
        if (fParentIfRolledUp != -1.0) {
            bTaskRolledUp = true;
        }
        return bTaskRolledUp;
    }

    public int getNumRolledUpTasks() {
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        int nNumRolledUpTasks = 0;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            if (!this.isTaskRolledUp(s)) continue;
            ++nNumRolledUpTasks;
        }
        return nNumRolledUpTasks;
    }

    public String getLongestTaskString() {
        String sLargest = null;
        int nTotalSeries = this.m_Perspective.getNumTotalSeries();
        int nTaskHeight = this.calcTaskHeight();
        int nMaxNumTasks = this.calcMaxNumTasks(nTaskHeight);
        int nMaxTextWidth = 0;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
        for (int nNumTasks = 0; sEnum.hasNext() && nNumTasks < nMaxNumTasks; ++nNumTasks) {
            int s = sEnum.next();
            assert (s >= 0 && s < nTotalSeries);
            String sText = this.m_Perspective.getSeriesLabel(s);
            int nStrLength = sText.length();
            boolean bRolledUp = this.isTaskRolledUp(s);
            if (nStrLength <= nMaxTextWidth || bRolledUp) continue;
            sLargest = sText;
            nMaxTextWidth = nStrLength;
        }
        return sLargest;
    }

    ITextStyle getTaskTextStyle(IdentObj idTaskLabel) {
        FontInfoObj fontInfo = TextStyleObjFactory.newFontInfoObj(this.m_Perspective, idTaskLabel);
        fontInfo.setRotationSetting(0);
        ITextStyle taskTextStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, fontInfo);
        return taskTextStyle;
    }
}

