/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FrameObj;
import java.awt.Point;

public class Depth2D {
    private Perspective m_Perspective;
    private FrameObj m_Frame;
    private int m_nTotalSeries;
    private Point[] m_seriesBackOffsets;
    private Point[] m_seriesFrontOffsets;
    private int[] m_seriesPlanes;
    public int[] m_seriesTypes;
    private int m_nDepthPlanes = 0;
    private SeriesEnumerator m_sEnumForward;

    public Depth2D(Perspective perspective, FrameObj frame, int nTotalSeries) {
        this.m_Perspective = perspective;
        this.m_Frame = frame;
        this.m_nTotalSeries = nTotalSeries;
        this.m_sEnumForward = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        this.m_seriesTypes = this.m_Perspective.getSeriesTypes();
    }

    private boolean wantDepth() {
        boolean bWantDepth = this.m_Perspective.getDepthRadius() > 0 && this.m_Perspective.getJGraphType().wantDepthEffect();
        return bWantDepth;
    }

    public int calc() {
        this.m_nDepthPlanes = 0;
        if (this.wantDepth()) {
            this.m_nDepthPlanes = this.calcDepthPlanes();
            this.calcFrontBackOffsets();
        }
        return this.m_nDepthPlanes;
    }

    public int calcDepthPlanes() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int nNumPlanes = 0;
        int nAreas = 0;
        boolean bHasBars = false;
        boolean bHasAreas = false;
        boolean bHasLines = false;
        this.m_seriesPlanes = new int[this.m_nTotalSeries];
        if (this.m_Perspective.getJGraphType().isScalingAbs()) {
            int nSeriesType;
            int s;
            while (sEnum.hasNext()) {
                s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                if (nSeriesType == 1) {
                    bHasBars = true;
                    continue;
                }
                if (nSeriesType == 3) {
                    this.m_seriesPlanes[s] = nAreas++;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 2) {
                    bHasLines = true;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 12) {
                    bHasBars = true;
                    continue;
                }
                throw new RuntimeException("Unknown riser type = " + nSeriesType + " for series = " + s);
            }
            int plane = nAreas;
            if (bHasBars) {
                ++nNumPlanes;
                sEnum.reset();
                while (sEnum.hasNext()) {
                    s = sEnum.next();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType == 1) {
                        this.m_seriesPlanes[s] = plane;
                    }
                    if (nSeriesType != 12) continue;
                    nNumPlanes = 2;
                }
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasNext()) {
                    s = sEnum.next();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane++;
                }
            }
        } else {
            int nSeriesType;
            int s;
            int plane = 0;
            block8: while (sEnum.hasNext()) {
                s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                switch (nSeriesType) {
                    case 1: {
                        bHasBars = true;
                        continue block8;
                    }
                    case 3: {
                        this.m_seriesPlanes[s] = plane;
                        bHasAreas = true;
                        continue block8;
                    }
                    case 2: {
                        bHasLines = true;
                        continue block8;
                    }
                }
                throw new RuntimeException("unknown seriesType = " + nSeriesType);
            }
            if (bHasAreas) {
                ++nNumPlanes;
                ++plane;
            }
            if (bHasBars) {
                sEnum.reset();
                while (sEnum.hasNext()) {
                    s = sEnum.next();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 1) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasNext()) {
                    s = sEnum.next();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
            }
        }
        return nNumPlanes;
    }

    private void calcFrontBackOffsets() {
        this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
        this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            this.m_seriesBackOffsets[s] = this.calcSeriesOffset(s, false);
            this.m_seriesFrontOffsets[s] = this.calcSeriesOffset(s, true);
        }
    }

    private Point calcSeriesOffset(int s, boolean bFront) {
        Point pt;
        if (bFront) {
            double fFront = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fFront);
        } else {
            double fBack = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fBack);
        }
        return pt;
    }

    public double calcFrontOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane + fUnit;
        return fOffset;
    }

    public double calcBackOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane;
        return fOffset;
    }

    public Point getSeriesFrontOffset(int nSeries) {
        Point ptFrontOffset;
        if (this.m_seriesFrontOffsets == null) {
            if (this.wantDepth()) {
                this.calc();
                ptFrontOffset = new Point(this.m_seriesFrontOffsets[nSeries]);
            } else {
                ptFrontOffset = new Point(0, 0);
            }
        } else {
            ptFrontOffset = new Point(this.m_seriesFrontOffsets[nSeries]);
        }
        return ptFrontOffset;
    }

    public Point getSeriesBackOffset(int nSeries) {
        Point ptBackOffset;
        if (this.m_seriesBackOffsets == null) {
            if (this.wantDepth()) {
                this.calc();
                ptBackOffset = new Point(this.m_seriesBackOffsets[nSeries]);
            } else {
                ptBackOffset = new Point(0, 0);
            }
        } else {
            ptBackOffset = new Point(this.m_seriesBackOffsets[nSeries]);
        }
        return ptBackOffset;
    }

    public int getSeriesType(int nSeries) {
        return this.m_seriesTypes[nSeries];
    }

    public SeriesEnumerator getResetSeriesEnumerator() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        assert (sEnum != null);
        sEnum.reset();
        return sEnum;
    }

    public int getDepthPlanes() {
        return this.m_nDepthPlanes;
    }
}

