/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

class DetShape
extends DetObj {
    private final Shape m_shapeVC;
    private final double m_fIntensity;
    private BlackBoxRenderer m_renderer = null;

    DetShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox, Rectangle clipRect) {
        super(container, id, blackBox, null);
        this.m_shapeVC = shapeVC;
        this.m_fIntensity = 1.0;
    }

    DetShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox, Rectangle clipRect, double fIntensity) {
        super(container, id, blackBox, clipRect);
        this.m_shapeVC = shapeVC;
        this.m_fIntensity = fIntensity;
    }

    DetShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox, Rectangle clipRect, BlackBoxRenderer renderer) {
        this(container, id, shapeVC, blackBox, clipRect);
        this.m_renderer = renderer;
    }

    public void hilite(Graphics2D g2, VC vc) {
        AffineTransform trans = g2.getTransform();
        g2.setTransform(vc.getAffineTransform());
        g2.setXORMode(Color.yellow);
        g2.draw(this.m_shapeVC);
        g2.setTransform(trans);
        g2.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        AffineTransform vcToDestTransform = vc.getAffineTransform();
        double oldIntensity = this.blackBox.getIntensity();
        this.blackBox.setIntensity(this.m_fIntensity);
        this.blackBox.paintShape(g, vcToDestTransform.createTransformedShape(this.m_shapeVC));
        this.blackBox.setIntensity(oldIntensity);
    }

    public void drawShape(Graphics2D g2) {
        if (this.m_renderer != null) {
            this.m_renderer.updateFrom(this.blackBox);
            this.m_renderer.render(g2, this.m_shapeVC);
        } else {
            if (!this.blackBox.getTransparentFillColor()) {
                switch (this.blackBox.getFillType()) {
                    case 1: {
                        Color colFill = this.blackBox.getFillColor();
                        g2.setColor(colFill);
                        break;
                    }
                    case 2: {
                        Paint gp = this.setGradientPaint();
                        g2.setPaint(gp);
                        break;
                    }
                    default: {
                        g2.setColor(Color.black);
                    }
                }
                g2.fill(this.m_shapeVC);
            }
            if (!this.blackBox.getTransparentBorderColor()) {
                Color colBorder = this.blackBox.getBorderColor();
                g2.setColor(colBorder);
                g2.draw(this.m_shapeVC);
            }
        }
    }

    private Paint setGradientPaint() {
        GradientPaint gp = null;
        Rectangle rBounds = this.m_shapeVC.getBounds();
        Point ptCenter = new Point(rBounds.x + rBounds.width / 2, rBounds.y + rBounds.height / 2);
        FillGradientObj fgo = this.blackBox.getFillGradientObj();
        Color innerColor = fgo.getColorAt(0.0);
        Color outerColor = fgo.getColorAt(1.0);
        int gradientDirection = this.blackBox.getGradientDirection();
        switch (gradientDirection) {
            case 1: {
                gp = new GradientPaint(rBounds.x, ptCenter.y, innerColor, rBounds.x + rBounds.width, ptCenter.y, outerColor);
                break;
            }
            case 2: {
                gp = new GradientPaint(rBounds.x + rBounds.width, ptCenter.y, innerColor, rBounds.x, ptCenter.y, outerColor);
                break;
            }
            case 3: {
                gp = new GradientPaint(ptCenter.x, rBounds.y + rBounds.height, innerColor, ptCenter.x, rBounds.y, outerColor);
                break;
            }
            case 4: {
                gp = new GradientPaint(ptCenter.x, rBounds.y, innerColor, ptCenter.x, rBounds.y + rBounds.height, outerColor);
                break;
            }
            case 5: {
                gp = new GradientPaint(rBounds.x + rBounds.width, rBounds.y + rBounds.height, innerColor, rBounds.x, rBounds.y, outerColor);
                break;
            }
            case 6: {
                gp = new GradientPaint(rBounds.x + rBounds.width, rBounds.y, innerColor, rBounds.x, rBounds.y + rBounds.height, outerColor);
                break;
            }
            case 7: {
                gp = new GradientPaint(rBounds.x, rBounds.y + rBounds.height, innerColor, rBounds.x + rBounds.width, rBounds.y, outerColor);
                break;
            }
            case 8: {
                gp = new GradientPaint(rBounds.x, rBounds.y, innerColor, rBounds.x + rBounds.width, rBounds.y + rBounds.height, outerColor);
                break;
            }
        }
        return gp;
    }

    public Shape getShape() {
        return this.m_shapeVC;
    }
}

