/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class DetOval
extends DetObj {
    private Ellipse2D shape;
    private boolean m_bNoFill;

    DetOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox) {
        this(container, id, x, y, width, height, blackBox, null, false);
    }

    DetOval(IDrawContainer container, IdentObj id, Rectangle r, IBlackBox blackBox, Rectangle clipRect) {
        this(container, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false);
    }

    DetOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, Rectangle clipRect, boolean bNoFill, double fLineWidt) {
        this(container, id, x, y, width, height, blackBox, clipRect, bNoFill);
    }

    DetOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, Rectangle clipRect, boolean bNoFill) {
        super(container, id, blackBox, clipRect);
        VC vc = ((Detectiv)container).getPerspective().getVC();
        Rectangle rDest = vc.virtToDest(new Rectangle(x, y, width, height));
        int diameter = Math.min(rDest.width, rDest.height);
        rDest.x += (rDest.width - diameter) / 2;
        rDest.y += (rDest.height - diameter) / 2;
        rDest.width = rDest.height = diameter;
        Rectangle r = vc.destToVirt(rDest);
        this.shape = new Ellipse2D.Double(r.x, r.y, r.width, r.height);
        this.m_bNoFill = bNoFill;
    }

    private Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public void hilite(Graphics2D g, VC vc) {
        Rectangle dest = vc.virtToDest(this.getBounds());
        g.setXORMode(Color.yellow);
        g.drawOval(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        Rectangle destRect = vc.virtToDest(this.getBounds());
        this.blackBox.paintOval(g, destRect, this.m_bNoFill);
    }

    public Shape getShape() {
        return this.shape;
    }
}

