/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.util.Comparator;

public class PieSliceObj {
    public static final int SLICETYPE_SPANNING_RIGHT = 1;
    public static final int SLICETYPE_SPANNING_LEFT = 2;
    public static final int SLICETYPE_SPANNING_MANY = 3;
    public static final int SLICETYPE_SPLIT = 4;
    public static final int SLICETYPE_BACK = 10;
    public static final int SLICETYPE_BACKPOINTING = 10;
    public static final int SLICETYPE_BACKTHRESHOLD = 11;
    public static final int SLICETYPE_FRONT = 20;
    public static final int SLICETYPE_FRONTPOINTING = 20;
    public static final int SLICETYPE_FRONTTHRESHOLD = 21;
    public static final int SLICETYPE_FRONTMOST = 22;
    public static final int SLICESIDE_LEFT = 0;
    public static final int SLICESIDE_RIGHT = 1;
    public static final int SLICESIDE_BOTH = 2;
    public Arc2D m_arcCrust;
    public Arc2D m_arcRing;
    public Point m_ptTip;
    public Point m_ptCrustLeft;
    public Point m_ptCrustRight;
    public Point m_ptRingLeft;
    public Point m_ptRingRight;
    public Point m_ptFeelerAttachCenter;
    public Point m_ptFeelerJoint;
    public Point m_ptFeelerEnd;
    public double m_fHighestY;
    public double m_fLowestY;
    public double m_fAngleStart;
    public double m_fAngleEnd;
    public double m_fAngleAvg;
    public double m_fAngleDet;
    public double percentage;
    public double value;
    public int m_nDetach;
    public int m_nSliceType;
    public int m_nSliceSide;
    public int seriesID;
    public int groupID;
    public int m_nSliceIdx;
    public boolean m_bSliceDeleted;
    public boolean m_bSliceSplit;
    public String m_strInnerLabel;
    public String m_strLabel;
    public ITextStyle m_textStyleOuterLabel;
    public ITextStyle m_textStyleInnerLabel;
    private Dimension m_dimInnerLabelVC;
    private Dimension m_dimLabelVC;
    Rectangle m_rLabel;
    public boolean m_bShowStackedLabel = true;
    public int m_nLabelSide;

    public void setLabelRect(Rectangle rLabel) {
        this.m_rLabel = rLabel;
    }

    public Rectangle getLabelRect() {
        return this.m_rLabel;
    }

    public int getLabelWidth() {
        return this.m_dimLabelVC.width;
    }

    public int getLabelHeight() {
        return this.m_dimLabelVC.height;
    }

    public void setLabelDimension(Dimension d) {
        this.m_dimLabelVC = new Dimension(d);
    }

    public Dimension getLabelDimension() {
        return this.m_dimLabelVC;
    }

    public int getInnerLabelWidth() {
        return this.m_dimInnerLabelVC.width;
    }

    public int getInnerLabelHeight() {
        return this.m_dimInnerLabelVC.height;
    }

    public void setInnerLabelDimension(Dimension d) {
        this.m_dimInnerLabelVC = new Dimension(d.width, d.height);
    }

    public double getSpan() {
        return Math.abs(this.m_fAngleEnd - this.m_fAngleStart);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeightComparator
    implements Comparator<PieSliceObj> {
        @Override
        public int compare(PieSliceObj o1, PieSliceObj o2) {
            Point pt1 = o1.m_ptFeelerAttachCenter;
            Point pt2 = o2.m_ptFeelerAttachCenter;
            return Double.compare(pt2.getY(), pt1.getY());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportanceComparator
    implements Comparator<PieSliceObj> {
        @Override
        public int compare(PieSliceObj o1, PieSliceObj o2) {
            double span1 = o1.getSpan();
            double span2 = o2.getSpan();
            return Double.compare(span2, span1);
        }
    }
}

