/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ICVOMSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Annotations;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Pie;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.DateUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.StandardLookPFJ;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceMode;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.AnnotationType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IChartSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.KeyObject;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveBase
extends Panel
implements IChartSettings {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase");
    public static final double NO_LINEVALUE = 1.234567E301;
    public static final int MAX_EXCEPTIONAL_RISERS = 256;
    public static final int NUM_PRESET_SERIES = 64;
    private static final double POINTS_TO_TWIPS = 0.05;
    final Map<KeyObject, Object> m_look = new HashMap<KeyObject, Object>();
    boolean m_bPDECalc = false;
    boolean m_bPDELegendFontSizeSpacing;
    IStandardLook m_gaugeLook = null;
    Annotations m_annotations = null;
    int m_numAnnotations;
    Map<IdentObj, List<Object>> m_annotationData = new HashMap<IdentObj, List<Object>>();
    ICVOMSettings cvomSettings = null;
    KeyObject m_cachedKey = new KeyObject();
    boolean m_suppressLabelDrawing = false;
    private boolean m_usePGSDKViewing = false;

    @Override
    public Object getValue(IdentObj id, Attr attribute) {
        return this.getFromLook(id, attribute);
    }

    @Override
    public Object getValue(IdentObj id, Attr attribute, boolean useDefault) {
        return this.getFromLook(id, attribute, useDefault);
    }

    @Override
    public void setValue(IdentObj id, Attr attribute, Object value) {
        this.putToLook(id, attribute, value);
    }

    void sync3DPresetParameters(int newValue) {
    }

    public long getMillisFromDate(int year, int month, int day, int hour, int minute, int second) {
        return DateUtils.getDateTimeMillis(year, month, day, hour, minute, second);
    }

    public IdentObj getTimeScaleLevel0() {
        return this.getTimeScaleLevel(0);
    }

    public IdentObj getTimeScaleLevel1() {
        return this.getTimeScaleLevel(1);
    }

    public IdentObj getTimeScaleLevel2() {
        return this.getTimeScaleLevel(2);
    }

    public IdentObj getTimeScaleLevel(int level) {
        IdentObj id = null;
        if (level < 0 || level > 2) {
            logger.warn((Object)("getTimeScaleLevel was passed a value of " + level + " the acceptable range is from 0 to 2. Setting level to 0."));
            level = 0;
        }
        id = new IdentObj(9000 + level);
        return id;
    }

    public IdentObj getTimeScaleLevelText(int level) {
        IdentObj id = null;
        if (level < 0 || level > 2) {
            logger.warn((Object)("getTimeScaleLevel was passed a value of " + level + " the acceptable range is from 0 to 2. Setting level to 0."));
            level = 0;
        }
        id = new IdentObj(9003 + level);
        return id;
    }

    public static boolean isHeadless() {
        boolean bHeadless = false;
        try {
            String s = System.getProperty("java.awt.headless");
            bHeadless = "true".equals(s);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bHeadless;
    }

    protected Object getFromLook(IdentObj id, Attr AttrID) {
        return this.getFromLook(id, AttrID, true);
    }

    private Object getFromLook1(IdentObj id, Attr attrID) {
        return this.getFromLook1(new KeyObject(attrID, id));
    }

    private Object getFromLook1(KeyObject key) {
        if (this.cvomSettings != null) {
            Object obj = null;
            obj = this.cvomSettings.getValue(key);
            if (obj != null) {
                return obj;
            }
        }
        return this.m_look.get(key);
    }

    protected Object getFromLook(IdentObj id, Attr attrID, boolean useDefault) {
        IdentObj newId;
        boolean usingMisc;
        Object obj = this.getFromLook1(id, attrID);
        if (obj != null) {
            return obj;
        }
        boolean usingSeries = !id.isSERIES_NA();
        boolean usingGroups = !id.isGROUP_NA();
        boolean usingObject = !id.isOBJECT_NA();
        boolean bl = usingMisc = !id.isMISC_NA();
        if (usingMisc) {
            newId = id;
            if (usingMisc && (obj = this.m_look.get(this.m_cachedKey.set(attrID, newId = newId.changeMisc(-3)))) != null) {
                return obj;
            }
        }
        if ((usingSeries || usingGroups) && usingObject) {
            newId = id;
            if (usingGroups && usingSeries) {
                obj = this.m_look.get(this.m_cachedKey.set(attrID, newId = newId.changeGroup(-3)));
                if (obj != null) {
                    return obj;
                }
                newId = newId.changeSeries(-3);
                obj = this.m_look.get(this.m_cachedKey.set(attrID, newId = newId.changeGroup(id.getGroupID())));
                if (obj != null) {
                    return obj;
                }
            }
            newId = newId.changeGroup(-3);
            obj = this.m_look.get(this.m_cachedKey.set(attrID, newId = newId.changeSeries(-3)));
            if (obj != null) {
                return obj;
            }
        }
        if (!id.isSERIES_NA() && !id.isGROUP_NA() && (obj = this.m_look.get(this.m_cachedKey.set(attrID, new IdentObj(-3, id.getSeriesID(), id.getGroupID())))) != null) {
            return obj;
        }
        if (!id.isSERIES_NA() && (obj = this.m_look.get(this.m_cachedKey.set(attrID, new IdentObj(-3, id.getSeriesID())))) != null) {
            return obj;
        }
        if (!id.isGROUP_NA() && (obj = this.m_look.get(this.m_cachedKey.set(attrID, new IdentObj(-3, -3, id.getGroupID())))) != null) {
            return obj;
        }
        if (!id.isOBJECT_NA() && (obj = this.m_look.get(this.m_cachedKey.set(attrID, new IdentObj(id.getObjectID())))) != null) {
            return obj;
        }
        if (useDefault) {
            return attrID.getDefault();
        }
        return null;
    }

    protected void putToLook(IdentObj id, Attr attrID, Object newValue) {
        if (attrID == null) {
            assert (false);
            return;
        }
        attrID.rangeCheckIfPossible(newValue);
        KeyObject key = new KeyObject(attrID, id);
        if (this.cvomSettings == null || !this.cvomSettings.setValue(key, newValue)) {
            this.m_look.put(key, newValue);
        }
    }

    void removeFromLook(IdentObj id, Attr attr) {
        IdentObj NewId;
        Object RemovedKey = this.m_look.remove(this.m_cachedKey.set(attr, id));
        if (RemovedKey == null && !id.isSERIES_NA() && !id.isGROUP_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
            RemovedKey = this.m_look.remove(this.m_cachedKey.set(attr, NewId));
        }
        if (RemovedKey == null && !id.isSERIES_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID());
            RemovedKey = this.m_look.remove(this.m_cachedKey.set(attr, NewId));
        }
        if (RemovedKey == null && !id.isGROUP_NA()) {
            NewId = new IdentObj(-3, -3, id.getGroupID());
            RemovedKey = this.m_look.remove(this.m_cachedKey.set(attr, NewId));
        }
        if (RemovedKey == null && !id.isOBJECT_NA()) {
            NewId = new IdentObj(id.getObjectID());
            RemovedKey = this.m_look.remove(this.m_cachedKey.set(attr, NewId));
        }
    }

    void deleteAttribute(int seriesID, int groupID, Attr attr) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.removeFromLook(id, attr);
    }

    void deleteAttribute(int seriesID, Attr attr) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.removeFromLook(id, attr);
    }

    void deleteAttribute(IdentObj id, Attr attr) {
        this.removeFromLook(id, attr);
    }

    public boolean getPDECalc() {
        return this.m_bPDECalc;
    }

    public void setPDECalc(boolean bPDECalc) {
        this.m_bPDECalc = bPDECalc;
    }

    public void suppressLabelDrawing(boolean suppressLabelDrawing) {
        this.m_suppressLabelDrawing = suppressLabelDrawing;
    }

    public boolean getSuppressLabelDrawing() {
        return this.m_suppressLabelDrawing;
    }

    public int getLegendPosition() {
        return (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendPosition);
    }

    public void setLegendPosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendPosition, new Integer(newValue));
    }

    public boolean getBuildDefaultCube() {
        return (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.BuildDefaultCube);
    }

    public void setBuildDefaultCube(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.BuildDefaultCube, newValue);
    }

    public boolean getDrawTicksPerpendicular(IdentObj id) {
        return (Boolean)this.getFromLook(id, Attr.DrawTicksPerpendicular);
    }

    public void setDrawTicksPerpendicular(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.DrawTicksPerpendicular, newValue);
    }

    public int getMajorTickSide(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.MajorTickSide);
    }

    public void setMajorTickSide(IdentObj id, int newValue) {
        this.putToLook(id, Attr.MajorTickSide, new Integer(newValue));
    }

    public int getMinorTickSide(IdentObj id) {
        return (Integer)this.getFromLook(id, Attr.MinorTickSide);
    }

    public void setMinorTickSide(IdentObj id, int newValue) {
        this.putToLook(id, Attr.MinorTickSide, new Integer(newValue));
    }

    public boolean getO1MajorTickDisplay() {
        return this.getDisplay(new IdentObj(761));
    }

    public void setO1MajorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(761), newValue);
    }

    public int getO1MajorTickStyle() {
        return this.getTickStyle(new IdentObj(761));
    }

    public void setO1MajorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(761), newValue);
    }

    public boolean getO1MinorTickDisplay() {
        return this.getDisplay(new IdentObj(762));
    }

    public void setO1MinorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(762), newValue);
    }

    public int getO1MinorTickStyle() {
        return this.getTickStyle(new IdentObj(762));
    }

    public void setO1MinorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(762), newValue);
    }

    public int getTickCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TickCount);
        return m_Obj;
    }

    public int getTickCount(int objectID) {
        return this.getTickCount(new IdentObj(objectID));
    }

    public void setTickCount(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TickCount, new Integer(newValue));
    }

    public void setTickCount(int objectID, int newValue) {
        this.setTickCount(new IdentObj(objectID), newValue);
    }

    public int getTickWidth(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TickWidth);
        return m_Obj;
    }

    public int getTickWidth(int objectID) {
        return this.getTickWidth(new IdentObj(objectID));
    }

    public void setTickWidth(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TickWidth, new Integer(newValue));
    }

    public void setTickWidth(int objectID, int newValue) {
        this.setTickWidth(new IdentObj(objectID), newValue);
    }

    public int getTickLength(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TickLength);
        return m_Obj;
    }

    public int getTickLength(int objectID) {
        return this.getTickLength(new IdentObj(objectID));
    }

    public void setTickLength(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TickLength, new Integer(newValue));
    }

    public void setTickLength(int objectID, int newValue) {
        this.setTickLength(new IdentObj(objectID), newValue);
    }

    public boolean getX1MajorTickDisplay() {
        return this.getDisplay(new IdentObj(765));
    }

    public void setX1MajorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(765), newValue);
    }

    public double getX1MajorTickStep() {
        return this.getTickStep(new IdentObj(765));
    }

    public void setX1MajorTickStep(double newValue) {
        this.setTickStep(new IdentObj(765), newValue);
        if (this.getCascade()) {
            this.setX1MajorTickStepAuto(false);
        }
    }

    public boolean getX1MajorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(765));
    }

    public void setX1MajorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(765), newValue);
    }

    public int getX1MajorTickStyle() {
        return this.getTickStyle(new IdentObj(765));
    }

    public void setX1MajorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(765), newValue);
    }

    public boolean getX1MinorTickDisplay() {
        return this.getDisplay(new IdentObj(766));
    }

    public void setX1MinorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(766), newValue);
    }

    public double getX1MinorTickStep() {
        return this.getTickStep(new IdentObj(766));
    }

    public void setX1MinorTickStep(double newValue) {
        this.setTickStep(new IdentObj(766), newValue);
    }

    public boolean getX1MinorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(766));
    }

    public void setX1MinorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(766), newValue);
    }

    public int getX1MinorTickStyle() {
        return this.getTickStyle(new IdentObj(766));
    }

    public void setX1MinorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(766), newValue);
    }

    public boolean getY1MajorTickDisplay() {
        return this.getDisplay(new IdentObj(767));
    }

    public void setY1MajorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(767), newValue);
    }

    public double getY1MajorTickStep() {
        return this.getTickStep(new IdentObj(767));
    }

    public void setY1MajorTickStep(double newValue) {
        this.setTickStep(new IdentObj(767), newValue);
        if (this.getCascade()) {
            this.setY1MajorTickStepAuto(false);
        }
    }

    public boolean getY1MajorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(767));
    }

    public void setY1MajorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(767), newValue);
    }

    public int getY1MajorTickStyle() {
        return this.getTickStyle(new IdentObj(767));
    }

    public void setY1MajorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(767), newValue);
    }

    public boolean getY1MinorTickDisplay() {
        return this.getDisplay(new IdentObj(768));
    }

    public void setY1MinorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(768), newValue);
    }

    public double getY1MinorTickStep() {
        return this.getTickStep(new IdentObj(768));
    }

    public void setY1MinorTickStep(double newValue) {
        this.setTickStep(new IdentObj(768), newValue);
    }

    public boolean getY1MinorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(768));
    }

    public void setY1MinorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(768), newValue);
    }

    public int getY1MinorTickStyle() {
        return this.getTickStyle(new IdentObj(768));
    }

    public void setY1MinorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(768), newValue);
    }

    public boolean getY2MajorTickDisplay() {
        return this.getDisplay(new IdentObj(769));
    }

    public void setY2MajorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(769), newValue);
    }

    public double getY2MajorTickStep() {
        return this.getTickStep(new IdentObj(769));
    }

    public void setY2MajorTickStep(double newValue) {
        this.setTickStep(new IdentObj(769), newValue);
        if (this.getCascade()) {
            this.setY2MajorTickStepAuto(false);
        }
    }

    public boolean getY2MajorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(769));
    }

    public void setY2MajorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(769), newValue);
    }

    public int getY2MajorTickStyle() {
        return this.getTickStyle(new IdentObj(769));
    }

    public void setY2MajorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(769), newValue);
    }

    public boolean getY2MinorTickDisplay() {
        return this.getDisplay(new IdentObj(770));
    }

    public void setY2MinorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(770), newValue);
    }

    public double getY2MinorTickStep() {
        return this.getTickStep(new IdentObj(770));
    }

    public void setY2MinorTickStep(double newValue) {
        this.setTickStep(new IdentObj(770), newValue);
    }

    public boolean getY2MinorTickStepAuto() {
        return this.getTickStepAuto(new IdentObj(770));
    }

    public void setY2MinorTickStepAuto(boolean newValue) {
        this.setTickStepAuto(new IdentObj(770), newValue);
    }

    public int getY2MinorTickStyle() {
        return this.getTickStyle(new IdentObj(770));
    }

    public void setY2MinorTickStyle(int newValue) {
        this.setTickStyle(new IdentObj(770), newValue);
    }

    public int getO1MinorTickCount() {
        return this.getTickCount(new IdentObj(762));
    }

    public void setO1MinorTickCount(int newValue) {
        this.setTickCount(new IdentObj(762), newValue);
    }

    public boolean getZ1MinorTickDisplay() {
        return this.getDisplay(new IdentObj(772));
    }

    public void setZ1MinorTickDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(772), newValue);
    }

    public double getTickStep(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.TickStep);
        return m_Obj;
    }

    public double getTickStep(int objectID) {
        return this.getTickStep(new IdentObj(objectID));
    }

    public void setTickStep(IdentObj id, double newValue) {
        this.putToLook(id, Attr.TickStep, new Double(newValue));
    }

    public void setTickStep(int objectID, double newValue) {
        this.setTickStep(new IdentObj(objectID), newValue);
    }

    public boolean getTickStepAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.TickStepAuto);
        return m_Obj;
    }

    public boolean getTickStepAuto(int objectID) {
        return this.getTickStepAuto(new IdentObj(objectID));
    }

    public void setTickStepAuto(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.TickStepAuto, newValue);
    }

    public void setTickStepAuto(int objectID, boolean newValue) {
        this.setTickStepAuto(new IdentObj(objectID), newValue);
    }

    public int getTickStyle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TickStyle);
        return m_Obj;
    }

    public int getTickStyle(int objectID) {
        return this.getTickStyle(new IdentObj(objectID));
    }

    public void setTickStyle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TickStyle, new Integer(newValue));
    }

    public void setTickStyle(int objectID, int newValue) {
        this.setTickStyle(new IdentObj(objectID), newValue);
    }

    public boolean getIgnoreTickSkip() {
        return (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.IgnoreTickSkip);
    }

    public void setIgnoreTickSkip(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.IgnoreTickSkip, newValue);
    }

    public void setUseOffScreen(boolean newValue) {
        this.putToLook(IdentObj.GLOBAL, Attr.UseOffScreen, newValue);
    }

    public boolean getConnectLineMarkers() {
        return (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ConnectLineMarkers);
    }

    public void setConnectLineMarkers(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ConnectLineMarkers, new Boolean(newValue));
    }

    public boolean getConnectLineMarkers(int seriesID) {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(-3, seriesID, -3), Attr.ConnectLineMarkers, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getConnectLineMarkers();
    }

    public void setConnectLineMarkers(int seriesID, boolean newValue) {
        this.putToLook(new IdentObj(-3, seriesID, -3), Attr.ConnectLineMarkers, newValue);
    }

    public boolean getConnectScatterMarkers() {
        return (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ConnectScatterMarkers);
    }

    public void setConnectScatterMarkers(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ConnectScatterMarkers, newValue);
    }

    public double getCubeSizeX() {
        return (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeSizeX);
    }

    public void setCubeSizeX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeSizeX, new Double(newValue));
    }

    public double getCubeSizeY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeSizeY);
        return m_Obj;
    }

    public void setCubeSizeY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeSizeY, new Double(newValue));
    }

    public double getCubeSizeZ() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeSizeZ);
        return m_Obj;
    }

    public void setCubeSizeZ(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeSizeZ, new Double(newValue));
    }

    public double getCubeTranslationX() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeTranslationX);
        return m_Obj;
    }

    public void setCubeTranslationX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeTranslationX, new Double(newValue));
    }

    public double getCubeTranslationY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeTranslationY);
        return m_Obj;
    }

    public void setCubeTranslationY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeTranslationY, new Double(newValue));
    }

    public double getCubeTranslationZ() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeTranslationZ);
        return m_Obj;
    }

    public void setCubeTranslationZ(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeTranslationZ, new Double(newValue));
    }

    public double getCubeViewerX() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeViewerX);
        return m_Obj;
    }

    public void setCubeViewerX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeViewerX, new Double(newValue));
    }

    public double getCubeViewerY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeViewerY);
        return m_Obj;
    }

    public void setCubeViewerY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeViewerY, new Double(newValue));
    }

    public double getCubeViewerZ() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeViewerZ);
        return m_Obj;
    }

    public void setCubeViewerZ(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeViewerZ, new Double(newValue));
    }

    public boolean getCubeIsometricProjection() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeIsometricProjection);
        return m_Obj;
    }

    public void setCubeIsometricProjection(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeIsometricProjection, newValue);
    }

    public boolean getCubeSquareRisers() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeSquareRisers);
        return m_Obj;
    }

    public void setCubeSquareRisers(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeSquareRisers, newValue);
    }

    public int getColorMode() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ColorMode);
        return m_Obj;
    }

    public void setColorMode(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ColorMode, new Integer(newValue));
    }

    public boolean getAutoshading() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.Autoshading);
        return m_Obj;
    }

    public void setAutoshading(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Autoshading, newValue);
    }

    public boolean getAutoshadingWalls() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.AutoshadingWalls);
        return m_Obj;
    }

    public void setAutoshadingWalls(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.AutoshadingWalls, newValue);
    }

    public double getCubeWallThickX() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeWallThickX);
        return m_Obj;
    }

    public void setCubeWallThickX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeWallThickX, new Double(newValue));
    }

    public double getCubeWallThickY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeWallThickY);
        return m_Obj;
    }

    public void setCubeWallThickY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeWallThickY, new Double(newValue));
    }

    public double getCubeWallThickZ() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeWallThickZ);
        return m_Obj;
    }

    public void setCubeWallThickZ(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeWallThickZ, new Double(newValue));
    }

    public double getCubeZoomFactor() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeZoomFactor);
        return m_Obj;
    }

    public void setCubeZoomFactor(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeZoomFactor, new Double(newValue));
    }

    public boolean getDataItemsAlongSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.DataItemsAlongSeries);
        return m_Obj;
    }

    public void setDataItemsAlongSeries(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DataItemsAlongSeries, newValue);
    }

    public Format getTimeScaleDataTextFormat() {
        return this.getTextFormat(new IdentObj(606));
    }

    public void setTimeScaleDataTextFormat(Format newValue) {
        this.setTextFormat(new IdentObj(606), newValue);
    }

    public int getDataTextAngleDefault() {
        return this.getDataTextAngle(Identity.ID_GLOBAL);
    }

    public void setDataTextAngleDefault(int newValue) {
        this.setDataTextAngle(Identity.ID_GLOBAL, newValue);
    }

    public boolean getDataTextDisplay() {
        return this.getDisplay(Identity.DataText);
    }

    public void setDataTextDisplay(boolean newValue) {
        this.setDisplay(Identity.DataText, newValue);
    }

    public void setDataTextDisplay(IdentObj idSeries, boolean bNewValue) {
        this.putToLook(idSeries, Attr.DataTextDisplay, bNewValue);
    }

    public boolean getDataTextDisplay(IdentObj idSeries) {
        Boolean m_Obj = (Boolean)this.getFromLook(idSeries, Attr.DataTextDisplay);
        return m_Obj;
    }

    public boolean getCustomDataText(IdentObj idSeries) {
        Boolean m_Obj = (Boolean)this.getFromLook(idSeries, Attr.CustomDataText);
        return m_Obj;
    }

    public void setCustomDataText(IdentObj idSeries, boolean bNewValue) {
        this.putToLook(idSeries, Attr.CustomDataText, bNewValue);
    }

    public int getDataTextRadiusDefault() {
        return this.getDataTextRadius(Identity.ID_GLOBAL);
    }

    public void setDataTextRadiusDefault(int newValue) {
        this.setDataTextRadius(Identity.ID_GLOBAL, newValue);
    }

    public int getDepthAngle() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DepthAngle);
        return m_Obj;
    }

    public void setDepthAngle(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DepthAngle, new Integer(newValue));
    }

    public int getDepthRadius() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DepthRadius);
        return m_Obj;
    }

    public void setDepthRadius(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DepthRadius, new Integer(newValue));
    }

    public boolean getDisplay3DFloor() {
        return this.getDisplay(new IdentObj(1002));
    }

    public void setDisplay3DFloor(boolean newValue) {
        this.setDisplay(new IdentObj(1002), newValue);
    }

    public boolean getDisplay3DLeftWall() {
        return this.getDisplay(new IdentObj(1003));
    }

    public void setDisplay3DLeftWall(boolean newValue) {
        this.setDisplay(new IdentObj(1003), newValue);
    }

    public boolean getDisplay3DRightWall() {
        return this.getDisplay(new IdentObj(1004));
    }

    public void setDisplay3DRightWall(boolean newValue) {
        this.setDisplay(new IdentObj(1004), newValue);
    }

    public int getDualAxisSplitPosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DualAxisSplitPosition);
        return m_Obj;
    }

    public void setDualAxisSplitPosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DualAxisSplitPosition, new Integer(newValue));
    }

    public boolean getFootnoteAutofit() {
        return this.getAutofit(new IdentObj(3));
    }

    public void setFootnoteAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(3), newValue);
    }

    public boolean getFootnoteDisplay() {
        return this.getDisplay(new IdentObj(3));
    }

    public void setFootnoteDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(3), newValue);
    }

    public String getFootnoteString() {
        return this.getTextString(new IdentObj(3));
    }

    public void setFootnoteString(String newValue) {
        this.setTextString(new IdentObj(3), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setFootnoteDisplay(true);
        }
    }

    public boolean getFrameDisplay() {
        return this.getDisplay(new IdentObj(2));
    }

    public void setFrameDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(2), newValue);
    }

    public boolean getGrid3DFloorDisplayX() {
        return this.getDisplay(new IdentObj(1013));
    }

    public void setGrid3DFloorDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(1013), newValue);
    }

    public boolean getGrid3DFloorDisplayZ() {
        return this.getDisplay(new IdentObj(1014));
    }

    public void setGrid3DFloorDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(1014), newValue);
    }

    public boolean getGrid3DLeftWallDisplayY() {
        return this.getDisplay(new IdentObj(1015));
    }

    public void setGrid3DLeftWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(1015), newValue);
    }

    public boolean getGrid3DLeftWallDisplayZ() {
        return this.getDisplay(new IdentObj(1016));
    }

    public void setGrid3DLeftWallDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(1016), newValue);
    }

    public boolean getGrid3DRightWallDisplayX() {
        return this.getDisplay(new IdentObj(1017));
    }

    public void setGrid3DRightWallDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(1017), newValue);
    }

    public boolean getGrid3DRightWallDisplayY() {
        return this.getDisplay(new IdentObj(1018));
    }

    public void setGrid3DRightWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(1018), newValue);
    }

    public boolean getGrid3DRiserDisplayX() {
        return this.getDisplay(new IdentObj(1006));
    }

    public void setGrid3DRiserDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(1006), newValue);
    }

    public boolean getGrid3DRiserDisplayY() {
        return this.getDisplay(new IdentObj(1007));
    }

    public void setGrid3DRiserDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(1007), newValue);
    }

    public boolean getGrid3DRiserDisplayZ() {
        return this.getDisplay(new IdentObj(1008));
    }

    public void setGrid3DRiserDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(1008), newValue);
    }

    public boolean getLegendAutomatic() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendAutomatic);
        return m_Obj;
    }

    public void setLegendAutomatic(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendAutomatic, newValue);
    }

    public boolean getLegendDisplay() {
        return this.getDisplay(new IdentObj(12));
    }

    public void setLegendDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(12), newValue);
    }

    public int getLegendMarkerPosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendMarkerPosition);
        return m_Obj;
    }

    public void setLegendMarkerPosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendMarkerPosition, new Integer(newValue));
    }

    public boolean getLegendTextAutofit() {
        return this.getAutofit(Identity.LegendText);
    }

    public void setLegendTextAutofit(boolean newValue) {
        this.setAutofit(Identity.LegendText, newValue);
    }

    public boolean getMarkerDepth() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.MarkerDepth);
        return m_Obj;
    }

    public void setMarkerDepth(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MarkerDepth, newValue);
    }

    public boolean getMarkerDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.MarkerDisplay);
        return m_Obj;
    }

    public void setMarkerDisplay(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MarkerDisplay, newValue);
    }

    public boolean getMarkerDisplay(int seriesID) {
        Boolean m_Obj = (Boolean)this.getFromLook(this.getSeries(seriesID), Attr.MarkerDisplay, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getMarkerDisplay();
    }

    public void setMarkerDisplay(int seriesID, boolean newValue) {
        this.putToLook(this.getSeries(seriesID), Attr.MarkerDisplay, newValue);
    }

    public int getMarkerSizeDefault() {
        return this.getMarkerSize(Identity.ID_GLOBAL);
    }

    public void setMarkerSizeDefault(int newValue) {
        this.setMarkerSize(Identity.ID_GLOBAL, newValue);
    }

    public int getO1AxisSide() {
        return this.getAxisSide(new IdentObj(2001));
    }

    public void setO1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2001), newValue);
    }

    public boolean getO1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(Identity.O1Label);
    }

    public void setO1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(Identity.O1Label, newValue);
    }

    public boolean getO1ExcludeMinLabel() {
        return this.getExcludeMinLabel(Identity.O1Label);
    }

    public void setO1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(Identity.O1Label, newValue);
    }

    public boolean getO1LabelAutofit() {
        return this.getAutofit(Identity.O1Label);
    }

    public void setO1LabelAutofit(boolean newValue) {
        this.setAutofit(Identity.O1Label, newValue);
    }

    public boolean getO1LabelDisplay() {
        return this.getDisplay(Identity.O1Label);
    }

    public void setO1LabelDisplay(boolean newValue) {
        this.setDisplay(Identity.O1Label, newValue);
    }

    public boolean getO1LabelStagger() {
        return this.getLabelStagger(Identity.O1Label);
    }

    public void setO1LabelStagger(boolean newValue) {
        this.setLabelStagger(Identity.O1Label, newValue);
    }

    public boolean getO1LabelWrap() {
        return this.getTextWrap(Identity.O1Label);
    }

    public void setO1LabelWrap(boolean newValue) {
        this.setTextWrap(Identity.O1Label, newValue);
    }

    public boolean getO1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(515));
    }

    public void setO1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(515), newValue);
    }

    public int getO1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(515));
    }

    public void setO1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(515), newValue);
    }

    public boolean getO1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(516));
    }

    public void setO1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(516), newValue);
    }

    public int getO1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(516));
    }

    public void setO1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(516), newValue);
    }

    public boolean getO1TitleAutofit() {
        return this.getAutofit(new IdentObj(8));
    }

    public void setO1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(8), newValue);
    }

    public boolean getO1TitleDisplay() {
        return this.getDisplay(new IdentObj(8));
    }

    public void setO1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(8), newValue);
    }

    public String getO1TitleString() {
        return this.getTextString(new IdentObj(8));
    }

    public void setO1TitleString(String newValue) {
        this.setTextString(new IdentObj(8), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setO1TitleDisplay(true);
        }
    }

    public boolean getO2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(Identity.O2Label);
    }

    public void setO2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(Identity.O2Label, newValue);
    }

    public boolean getO2ExcludeMinLabel() {
        return this.getExcludeMinLabel(Identity.O2Label);
    }

    public void setO2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(Identity.O2Label, newValue);
    }

    public int getLegendLabelType() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendLabelType);
        return m_Obj;
    }

    public void setLegendLabelType(int newValue) {
        this.putToLook(new IdentObj(2000), Attr.LegendLabelType, new Integer(newValue));
    }

    public boolean getO2LabelAutofit() {
        return this.getAutofit(Identity.O2Label);
    }

    public void setO2LabelAutofit(boolean newValue) {
        this.setAutofit(Identity.O2Label, newValue);
    }

    public boolean getO2LabelDisplay() {
        return this.getDisplay(Identity.O2Label);
    }

    public void setO2LabelDisplay(boolean newValue) {
        this.setDisplay(Identity.O2Label, newValue);
    }

    public boolean getStockCloseTicksDisplay() {
        return this.getDisplay(new IdentObj(551));
    }

    public void setStockCloseTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(551), newValue);
    }

    public boolean getStockOpenTicksDisplay() {
        return this.getDisplay(new IdentObj(552));
    }

    public void setStockOpenTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(552), newValue);
    }

    public boolean getStockCloseSplitDisplay() {
        return this.getDisplay(new IdentObj(550));
    }

    public void setStockCloseSplitDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(550), newValue);
    }

    public boolean getO2LabelWrap() {
        return this.getTextWrap(Identity.O2Label);
    }

    public void setO2LabelWrap(boolean newValue) {
        this.setTextWrap(Identity.O2Label, newValue);
    }

    public boolean getO2TitleAutofit() {
        return this.getAutofit(new IdentObj(9));
    }

    public void setO2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(9), newValue);
    }

    public boolean getO2TitleDisplay() {
        return this.getDisplay(new IdentObj(9));
    }

    public void setO2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(9), newValue);
    }

    public String getO2TitleString() {
        return this.getTextString(new IdentObj(9));
    }

    public void setO2TitleString(String newValue) {
        this.setTextString(new IdentObj(9), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setO2TitleDisplay(true);
        }
    }

    public double getCubePanX() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubePanX);
        return m_Obj;
    }

    public void setCubePanX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubePanX, new Double(newValue));
    }

    public double getCubePanY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubePanY);
        return m_Obj;
    }

    public void setCubePanY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubePanY, new Double(newValue));
    }

    public int getPieDepth() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieDepth);
        return m_Obj;
    }

    public void setPieDepth(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieDepth, new Integer(newValue));
    }

    public int getPieLabelDisplay() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieLabelDisplay);
        return m_Obj;
    }

    public void setPieLabelDisplay(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieLabelDisplay, new Integer(newValue));
    }

    public int getPieRingSize() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieRingSize);
        return m_Obj;
    }

    public void setPieRingSize(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieRingSize, new Integer(newValue));
    }

    public boolean getPieRingTotalDisplay() {
        return this.getDisplay(new IdentObj(541));
    }

    public void setPieRingTotalDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(541), newValue);
    }

    public int getPieRotate() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieRotate);
        return m_Obj;
    }

    public void setPieRotate(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieRotate, new Integer(newValue));
    }

    public int getCircularChartStartAngle() {
        return this.getPieRotate();
    }

    public void setCircularChartStartAngle(int newValue) {
        this.setPieRotate(newValue);
    }

    public int getPiesPerRow() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PiesPerRow);
        return m_Obj;
    }

    public void setPiesPerRow(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PiesPerRow, new Integer(newValue));
    }

    public int getPieTilt() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieTilt);
        return m_Obj;
    }

    public void setPieTilt(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieTilt, new Integer(newValue));
    }

    public boolean getReshapeEnable() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ReshapeEnable);
        return m_Obj;
    }

    public void setReshapeEnable(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ReshapeEnable, newValue);
    }

    public boolean getResizeBarMode() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ResizeBarMode);
        return m_Obj;
    }

    public void setResizeBarMode(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ResizeBarMode, newValue);
    }

    public int getGridCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.GridCount);
        return m_Obj;
    }

    public int getGridCount(int objectID) {
        return this.getGridCount(new IdentObj(objectID));
    }

    public void setGridCount(IdentObj id, int newValue) {
        this.putToLook(id, Attr.GridCount, new Integer(newValue));
    }

    public void setGridCount(int objectID, int newValue) {
        this.setGridCount(new IdentObj(objectID), newValue);
    }

    public double getStock52WeekHighValue() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.Stock52WeekHighValue);
        return m_Obj;
    }

    public void setStock52WeekHighValue(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Stock52WeekHighValue, new Double(newValue));
        if (this.getCascade()) {
            this.setStock52WeekHighDisplay(true);
        }
    }

    public boolean getReverseGroups() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ReverseGroups);
        return m_Obj;
    }

    public void setReverseGroups(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ReverseGroups, newValue);
    }

    public boolean getReverseSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ReverseSeries);
        return m_Obj;
    }

    public void setReverseSeries(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ReverseSeries, newValue);
    }

    public int getRiser3DThicknessY() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.Riser3DThicknessY);
        return m_Obj;
    }

    public void setRiser3DThicknessY(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Riser3DThicknessY, new Integer(newValue));
    }

    public int getRiserBarGroupSpacing() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.RiserBarGroupSpacing);
        return m_Obj;
    }

    public void setRiserBarGroupSpacing(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.RiserBarGroupSpacing, new Integer(newValue));
    }

    public int getRiserWidth() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.RiserWidth);
        return m_Obj;
    }

    public void setRiserWidth(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.RiserWidth, new Integer(newValue));
    }

    public boolean getScaleFromZero() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ScaleFromZero);
        return m_Obj;
    }

    public void setScaleFromZero(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ScaleFromZero, newValue);
    }

    public int getSelectionEnable() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.SelectionEnable);
        return m_Obj;
    }

    public void setSelectionEnable(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SelectionEnable, new Integer(newValue));
    }

    public boolean getSelectionEnableMove() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.SelectionEnableMove);
        return m_Obj;
    }

    public void setSelectionEnableMove(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SelectionEnableMove, newValue);
    }

    public int getShadowXOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ShadowXOffsetDefault);
        return m_Obj;
    }

    public void setShadowXOffsetDefault(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ShadowXOffsetDefault, new Integer(newValue));
    }

    public int getShadowYOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ShadowYOffsetDefault);
        return m_Obj;
    }

    public void setShadowYOffsetDefault(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ShadowYOffsetDefault, new Integer(newValue));
    }

    public boolean getStock52WeekHighDisplay() {
        return this.getDisplay(new IdentObj(548));
    }

    public void setStock52WeekHighDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(548), newValue);
    }

    public boolean getStock52WeekLowDisplay() {
        return this.getDisplay(new IdentObj(549));
    }

    public void setStock52WeekLowDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(549), newValue);
    }

    public boolean getStockMovingAverageDisplay() {
        return this.getDisplay(new IdentObj(553));
    }

    public void setStockMovingAverageDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(553), newValue);
    }

    public int getStockRiserWidthVC() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.StockRiserWidthVC);
        return m_Obj;
    }

    public void setStockRiserWidthVC(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StockRiserWidthVC, new Integer(newValue));
    }

    public int getStockTickWidthVC() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.StockTickWidthVC);
        return m_Obj;
    }

    public void setStockTickWidthVC(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StockTickWidthVC, new Integer(newValue));
    }

    public int getStockTickHeightVC() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.StockTickHeightVC);
        return m_Obj;
    }

    public void setStockTickHeightVC(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StockTickHeightVC, new Integer(newValue));
    }

    public boolean getSubtitleAutofit() {
        return this.getAutofit(new IdentObj(4));
    }

    public void setSubtitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(4), newValue);
    }

    public boolean getSubtitleDisplay() {
        return this.getDisplay(new IdentObj(4));
    }

    public void setSubtitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(4), newValue);
    }

    public String getSubtitleString() {
        return this.getTextString(new IdentObj(4));
    }

    public void setSubtitleString(String newValue) {
        this.setTextString(new IdentObj(4), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setSubtitleDisplay(true);
        }
    }

    public boolean getTitleAutofit() {
        return this.getAutofit(new IdentObj(5));
    }

    public void setTitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(5), newValue);
    }

    public boolean getTitleDisplay() {
        return this.getDisplay(new IdentObj(5));
    }

    public void setTitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(5), newValue);
    }

    public String getTitleString() {
        return this.getTextString(new IdentObj(5));
    }

    public void setTitleString(String newValue) {
        this.setTextString(new IdentObj(5), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setTitleDisplay(true);
        }
    }

    public int getViewing3DAnglePreset() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.Viewing3DAnglePreset);
        return m_Obj;
    }

    public void setViewing3DAnglePreset(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Viewing3DAnglePreset, new Integer(newValue));
        if (this.getCascade()) {
            this.sync3DPresetParameters(newValue);
        }
    }

    public boolean getX1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2003));
    }

    public void setX1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2003), newValue);
    }

    public int getX1AxisSide() {
        return this.getAxisSide(new IdentObj(2003));
    }

    public void setX1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2003), newValue);
    }

    public boolean getX1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2003));
    }

    public void setX1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2003), newValue);
    }

    public boolean getX1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(524));
    }

    public void setX1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(524), newValue);
    }

    public boolean getX1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(524));
    }

    public void setX1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(524), newValue);
    }

    public boolean getX1LabelAutofit() {
        return this.getAutofit(new IdentObj(524));
    }

    public void setX1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(524), newValue);
    }

    public boolean getY2TitleDisplay() {
        return this.getDisplay(new IdentObj(7));
    }

    public void setY2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(7), newValue);
    }

    public boolean getX1LabelDisplay() {
        return this.getDisplay(new IdentObj(524));
    }

    public void setX1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(524), newValue);
    }

    public boolean getX1LabelStagger() {
        return this.getLabelStagger(new IdentObj(524));
    }

    public void setX1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(524), newValue);
    }

    public boolean getX1LogScale() {
        return this.getLogScale(new IdentObj(2003));
    }

    public void setX1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2003), newValue);
    }

    public boolean getX1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(525));
    }

    public void setX1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(525), newValue);
    }

    public double getX1MajorGridStep() {
        return this.getGridStep(new IdentObj(525));
    }

    public void setX1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(525), newValue);
        if (this.getCascade()) {
            this.setX1MajorGridStepAuto(false);
        }
    }

    public boolean getX1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(525));
    }

    public void setX1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(525), newValue);
    }

    public int getX1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(525));
    }

    public void setX1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(525), newValue);
    }

    public boolean getX1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(526));
    }

    public void setX1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(526), newValue);
    }

    public double getX1MinorGridStep() {
        return this.getGridStep(new IdentObj(526));
    }

    public void setX1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(526), newValue);
    }

    public boolean getX1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(526));
    }

    public void setX1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(526), newValue);
    }

    public int getX1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(526));
    }

    public void setX1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(526), newValue);
    }

    public boolean getX1MustIncludeZero() {
        if (this.getX1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2003));
    }

    public void setX1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMax() {
        return this.getScaleMax(new IdentObj(2003));
    }

    public void setX1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2003));
    }

    public void setX1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMin() {
        return this.getScaleMin(new IdentObj(2003));
    }

    public void setX1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2003));
    }

    public void setX1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2003), newValue);
    }

    public boolean getX1TitleAutofit() {
        return this.getAutofit(new IdentObj(10));
    }

    public void setX1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(10), newValue);
    }

    public boolean getX1TitleDisplay() {
        return this.getDisplay(new IdentObj(10));
    }

    public void setX1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(10), newValue);
    }

    public String getX1TitleString() {
        return this.getTextString(new IdentObj(10));
    }

    public void setX1TitleString(String newValue) {
        this.setTextString(new IdentObj(10), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setX1TitleDisplay(true);
        }
    }

    public boolean getX1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(535));
    }

    public void setX1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(535), newValue);
    }

    public boolean getY1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2004));
    }

    public void setY1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2004), newValue);
    }

    public int getY1AxisSide() {
        return this.getAxisSide(new IdentObj(2004));
    }

    public void setY1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2004), newValue);
    }

    public boolean getY1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2004));
    }

    public void setY1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2004), newValue);
    }

    public boolean getY1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(528));
    }

    public void setY1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(528), newValue);
    }

    public int getO1LabelAutoSkip() {
        return this.getAutoSkip(Identity.O1Label);
    }

    public void setO1LabelAutoSkip(int newValue) {
        this.setAutoSkip(Identity.O1Label, newValue);
    }

    public int getO1LabelSkipCount() {
        return this.getSkipCount(Identity.O1Label);
    }

    public void setO1LabelSkipCount(int newValue) {
        this.setSkipCount(Identity.O1Label, newValue);
    }

    public int getO1LabelSkipBegin() {
        return this.getSkipBegin(Identity.O1Label);
    }

    public void setO1LabelSkipBegin(int newValue) {
        this.setSkipBegin(Identity.O1Label, newValue);
    }

    public int getAutoSkip(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AutoSkip);
        return m_Obj;
    }

    public int getAutoSkip(int objectID) {
        return this.getAutoSkip(new IdentObj(objectID));
    }

    public void setAutoSkip(IdentObj id, int newValue) {
        this.putToLook(id, Attr.AutoSkip, newValue);
    }

    public void setAutoSkip(int objectID, int newValue) {
        this.setAutoSkip(new IdentObj(objectID), newValue);
    }

    public int getSkipBegin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SkipBegin);
        return m_Obj;
    }

    public int getSkipBegin(int objectID) {
        return this.getSkipBegin(new IdentObj(objectID));
    }

    public void setSkipBegin(IdentObj id, int newValue) {
        this.putToLook(id, Attr.SkipBegin, new Integer(newValue));
    }

    public void setSkipBegin(int objectID, int newValue) {
        this.setSkipBegin(new IdentObj(objectID), newValue);
    }

    public int getSkipCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SkipCount);
        return m_Obj;
    }

    public int getSkipCount(int objectID) {
        return this.getSkipCount(new IdentObj(objectID));
    }

    public void setSkipCount(IdentObj id, int newValue) {
        this.putToLook(id, Attr.SkipCount, new Integer(newValue));
    }

    public void setSkipCount(int objectID, int newValue) {
        this.setSkipCount(new IdentObj(objectID), newValue);
    }

    public boolean getExactColorByHeight() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ExactColorByHeight);
        return m_Obj;
    }

    public void setExactColorByHeight(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ExactColorByHeight, newValue);
    }

    public int getViewableSeries() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ViewableSeries);
        return m_Obj;
    }

    public void setViewableSeries(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ViewableSeries, new Integer(newValue));
    }

    public int getViewableGroups() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ViewableGroups);
        return m_Obj;
    }

    public void setViewableGroups(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ViewableGroups, new Integer(newValue));
    }

    public int getViewableSeriesStock() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ViewableSeriesStock);
        return m_Obj;
    }

    public void setViewableSeriesStock(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ViewableSeriesStock, new Integer(newValue));
    }

    public int getViewableGroupsStock() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ViewableGroupsStock);
        return m_Obj;
    }

    public void setViewableGroupsStock(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ViewableGroupsStock, new Integer(newValue));
    }

    public int getScrollOffsetSeries() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ScrollOffsetSeries);
        return m_Obj;
    }

    public void setScrollOffsetSeries(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ScrollOffsetSeries, new Integer(newValue));
    }

    public int getScrollOffsetGroup() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.ScrollOffsetGroup);
        return m_Obj;
    }

    public void setScrollOffsetGroup(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ScrollOffsetGroup, new Integer(newValue));
    }

    public int getSeriesLooping() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.SeriesLooping);
        return m_Obj;
    }

    public void setSeriesLooping(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SeriesLooping, new Integer(newValue));
    }

    public int getRiserBorderMode() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.RiserBorderMode);
        return m_Obj;
    }

    public void setRiserBorderMode(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.RiserBorderMode, new Integer(newValue));
    }

    public boolean getOverdrawSkip() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.OverdrawSkip);
        return m_Obj;
    }

    public void setOverdrawSkip(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.OverdrawSkip, newValue);
    }

    public boolean getInterpretAsHLOC() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.InterpretAsHLOC);
        return m_Obj;
    }

    public void setInterpretAsHLOC(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.InterpretAsHLOC, newValue);
    }

    public boolean getUseSeriesBorderDefaults() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.UseSeriesBorderDefaults);
        return m_Obj;
    }

    public void setUseSeriesBorderDefaults(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.UseSeriesBorderDefaults, newValue);
    }

    public Color getSeriesDefaultBorderColor() {
        Color m_Obj = (Color)this.getFromLook(Identity.ID_GLOBAL, Attr.SeriesDefaultBorderColor);
        return m_Obj;
    }

    public void setSeriesDefaultBorderColor(Color newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SeriesDefaultBorderColor, newValue);
    }

    public boolean getSeriesDefaultTransparentBorderColor() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.SeriesDefaultTransparentBorderColor);
        return m_Obj;
    }

    public void setSeriesDefaultTransparentBorderColor(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SeriesDefaultTransparentBorderColor, newValue);
    }

    public boolean getStackedDataValueSum() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.StackedDataValueSum);
        return m_Obj;
    }

    public void setStackedDataValueSum(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StackedDataValueSum, newValue);
    }

    public int getFillMissingData() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.FillMissingData);
        return m_Obj;
    }

    public void setFillMissingData(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.FillMissingData, new Integer(newValue));
    }

    public int getNumMissingDataSegments() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.NumMissingDataSegments);
        return m_Obj;
    }

    public void setNumMissingDataSegments(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.NumMissingDataSegments, new Integer(newValue));
    }

    public boolean getFontSizeAbsolute(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.FontSizeAbsolute);
        return m_Obj;
    }

    public boolean getFontSizeAbsolute(int objectID) {
        return this.getFontSizeAbsolute(new IdentObj(objectID));
    }

    public void setFontSizeAbsolute(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.FontSizeAbsolute, newValue);
    }

    public void setFontSizeAbsolute(int objectID, boolean newValue) {
        this.setFontSizeAbsolute(new IdentObj(objectID), newValue);
    }

    public int getLegendSeriesStart() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendSeriesStart);
        return m_Obj;
    }

    public void setLegendSeriesStart(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendSeriesStart, new Integer(newValue));
    }

    public int getLegendSeriesCount() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendSeriesCount);
        return m_Obj;
    }

    public void setLegendSeriesCount(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendSeriesCount, new Integer(newValue));
    }

    public int getLegendMarkerSizeMax() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendMarkerSizeMax);
        return m_Obj;
    }

    public void setLegendMarkerSizeMax(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendMarkerSizeMax, new Integer(newValue));
    }

    public int getO1LabelAutoAngle() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.O1LabelAutoAngle);
        return m_Obj;
    }

    public void setO1LabelAutoAngle(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.O1LabelAutoAngle, new Integer(newValue));
    }

    public int getO2LabelAutoSkip() {
        return this.getAutoSkip(Identity.O2Label);
    }

    public void setO2LabelAutoSkip(int newValue) {
        this.setAutoSkip(Identity.O2Label, newValue);
    }

    public int getO2LabelSkipCount() {
        return this.getSkipCount(Identity.O2Label);
    }

    public void setO2LabelSkipCount(int newValue) {
        this.setSkipCount(Identity.O2Label, newValue);
    }

    public int getO2LabelSkipBegin() {
        return this.getSkipBegin(Identity.O2Label);
    }

    public void setO2LabelSkipBegin(int newValue) {
        this.setSkipBegin(Identity.O2Label, newValue);
    }

    public boolean getY1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(528));
    }

    public void setY1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(528), newValue);
    }

    public boolean getY1LabelAutofit() {
        return this.getAutofit(new IdentObj(528));
    }

    public void setY1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(528), newValue);
    }

    public boolean getY1LabelDisplay() {
        return this.getDisplay(new IdentObj(528));
    }

    public void setY1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(528), newValue);
    }

    public boolean getY1LabelStagger() {
        return this.getLabelStagger(new IdentObj(528));
    }

    public void setY1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(528), newValue);
    }

    public boolean getY1LogScale() {
        return this.getLogScale(new IdentObj(2004));
    }

    public void setY1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2004), newValue);
    }

    public boolean getY1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(529));
    }

    public void setY1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(529), newValue);
    }

    public double getY1MajorGridStep() {
        return this.getGridStep(new IdentObj(529));
    }

    public void setY1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(529), newValue);
        if (this.getCascade()) {
            this.setY1MajorGridStepAuto(false);
        }
    }

    public boolean getY1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(529));
    }

    public void setY1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(529), newValue);
    }

    public int getY1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(529));
    }

    public void setY1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(529), newValue);
    }

    public boolean getY1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(530));
    }

    public void setY1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(530), newValue);
    }

    public double getY1MinorGridStep() {
        return this.getGridStep(new IdentObj(530));
    }

    public void setY1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(530), newValue);
    }

    public boolean getY1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(530));
    }

    public void setY1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(530), newValue);
    }

    public int getY1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(530));
    }

    public void setY1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(530), newValue);
    }

    public boolean getY1MustIncludeZero() {
        if (this.getY1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2004));
    }

    public void setY1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMax() {
        return this.getScaleMax(new IdentObj(2004));
    }

    public void setY1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2004));
    }

    public void setY1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMin() {
        return this.getScaleMin(new IdentObj(2004));
    }

    public void setY1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2004));
    }

    public void setY1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2004), newValue);
    }

    public boolean getY1TitleAutofit() {
        return this.getAutofit(new IdentObj(6));
    }

    public void setY1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(6), newValue);
    }

    public boolean getY1TitleDisplay() {
        return this.getDisplay(new IdentObj(6));
    }

    public void setY1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(6), newValue);
    }

    public String getY1TitleString() {
        return this.getTextString(new IdentObj(6));
    }

    public void setY1TitleString(String newValue) {
        this.setTextString(new IdentObj(6), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setY1TitleDisplay(true);
        }
    }

    public boolean getY1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(536));
    }

    public void setY1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(536), newValue);
    }

    public boolean getY2ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(537));
    }

    public void setY2ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(537), newValue);
    }

    public boolean getY3ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(688));
    }

    public void setY3ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(688), newValue);
    }

    public boolean getY4ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(693));
    }

    public void setY4ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(693), newValue);
    }

    public boolean getY5ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(698));
    }

    public void setY5ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(698), newValue);
    }

    public boolean getY2AxisDescending() {
        return this.getAxisDescending(new IdentObj(2005));
    }

    public void setY2AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2005), newValue);
    }

    public int getY2AxisSide() {
        return this.getAxisSide(new IdentObj(2005));
    }

    public void setY2AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2005), newValue);
    }

    public boolean getY2OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2005));
    }

    public void setY2OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2005), newValue);
    }

    public boolean getY2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(532));
    }

    public void setY2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(532), newValue);
    }

    public boolean getY2ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(532));
    }

    public void setY2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(532), newValue);
    }

    public boolean getY2LabelAutofit() {
        return this.getAutofit(new IdentObj(532));
    }

    public void setY2LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(532), newValue);
    }

    public boolean getY2LabelDisplay() {
        return this.getDisplay(new IdentObj(532));
    }

    public void setY2LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(532), newValue);
    }

    public boolean getY2LabelStagger() {
        return this.getLabelStagger(new IdentObj(532));
    }

    public void setY2LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(532), newValue);
    }

    public boolean getY2LogScale() {
        return this.getLogScale(new IdentObj(2005));
    }

    public void setY2LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2005), newValue);
    }

    public boolean getY2MajorGridDisplay() {
        return this.getDisplay(new IdentObj(533));
    }

    public void setY2MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(533), newValue);
    }

    public double getY2MajorGridStep() {
        return this.getGridStep(new IdentObj(533));
    }

    public void setY2MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(533), newValue);
        if (this.getCascade()) {
            this.setY2MajorGridStepAuto(false);
        }
    }

    public boolean getY2MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(533));
    }

    public void setY2MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(533), newValue);
    }

    public int getY2MajorGridStyle() {
        return this.getGridStyle(new IdentObj(533));
    }

    public void setY2MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(533), newValue);
    }

    public boolean getY2MinorGridDisplay() {
        return this.getDisplay(new IdentObj(534));
    }

    public void setY2MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(534), newValue);
    }

    public double getY2MinorGridStep() {
        return this.getGridStep(new IdentObj(534));
    }

    public void setY2MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(534), newValue);
    }

    public boolean getY2MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(534));
    }

    public void setY2MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(534), newValue);
    }

    public int getY2MinorGridStyle() {
        return this.getGridStyle(new IdentObj(534));
    }

    public void setY2MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(534), newValue);
    }

    public boolean getY2MustIncludeZero() {
        if (this.getY2LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2005));
    }

    public void setY2MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMax() {
        return this.getScaleMax(new IdentObj(2005));
    }

    public void setY2ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2005));
    }

    public void setY2ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMin() {
        return this.getScaleMin(new IdentObj(2005));
    }

    public void setY2ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2005));
    }

    public void setY2ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2005), newValue);
    }

    public boolean getY2TitleAutofit() {
        return this.getAutofit(new IdentObj(7));
    }

    public void setY2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(7), newValue);
    }

    public int getAxisAssignment(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisAssignment);
        return m_Obj;
    }

    public int getAxisAssignment(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getAxisAssignment(id);
    }

    public void setAxisAssignment(IdentObj id, int newValue) {
        this.putToLook(id, Attr.AxisAssignment, new Integer(newValue));
    }

    public void setAxisAssignment(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setAxisAssignment(id, newValue);
    }

    public boolean getAutofit(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.Autofit);
        return m_Obj;
    }

    public boolean getAutofit(int objectID) {
        return this.getAutofit(new IdentObj(objectID));
    }

    public void setAutofit(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.Autofit, false);
    }

    public void setAutofit(int objectID, boolean newValue) {
        this.setAutofit(new IdentObj(objectID), newValue);
    }

    public void autofitBackwardsCompatability(IdentObj id) {
        boolean isLegend;
        Perspective p = (Perspective)this;
        boolean isPie = p.getGraphObject() instanceof JChart_2D_Pie;
        boolean bl = isLegend = 14 == id.getObjectID();
        if (!isLegend && isPie) {
            id = Identity.PieGroupLabel;
        }
        PlaceUtilities.shrinkToFit(p, id);
    }

    public int getO1MinorGridCount() {
        return this.getGridCount(new IdentObj(516));
    }

    public void setO1MinorGridCount(int newValue) {
        this.setGridCount(new IdentObj(516), newValue);
    }

    public int getDataTextPosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.DataText, Attr.DataTextPosition);
        return m_Obj;
    }

    public int getDataTextPosition(int s, int g) {
        Integer m_Obj = (Integer)this.getFromLook(this.getDataText(s, g), Attr.DataTextPosition);
        return m_Obj;
    }

    public void setDataTextPosition(int newValue) {
        this.putToLook(Identity.DataText, Attr.DataTextPosition, new Integer(newValue));
    }

    public void setDataTextPosition(int newValue, int s, int g) {
        this.putToLook(this.getDataText(s, g), Attr.DataTextPosition, new Integer(newValue));
    }

    public int getDataTextPositionSecondary() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.DataText, Attr.DataTextPositionSecondary);
        return m_Obj;
    }

    public void setDataTextPositionSecondary(int newValue) {
        this.putToLook(Identity.DataText, Attr.DataTextPositionSecondary, new Integer(newValue));
    }

    public boolean getX1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(523));
    }

    public void setX1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(523), newValue);
    }

    public boolean getY1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(527));
    }

    public void setY1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(527), newValue);
    }

    public boolean getY2AxisLineDisplay() {
        return this.getDisplay(new IdentObj(531));
    }

    public void setY2AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(531), newValue);
    }

    public boolean getO1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(513));
    }

    public void setO1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(513), newValue);
    }

    public boolean getDualAxisLineDisplay() {
        return this.getDisplay(new IdentObj(17));
    }

    public void setDualAxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(17), newValue);
    }

    public double getStock52WeekLowValue() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.Stock52WeekLowValue);
        return m_Obj;
    }

    public void setStock52WeekLowValue(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Stock52WeekLowValue, new Double(newValue));
        if (this.getCascade()) {
            this.setStock52WeekLowDisplay(true);
        }
    }

    public boolean getAxisDescending(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.AxisDescending);
        return m_Obj;
    }

    public boolean getAxisDescending(int objectID) {
        return this.getAxisDescending(new IdentObj(objectID));
    }

    public void setAxisDescending(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.AxisDescending, newValue);
    }

    public void setAxisDescending(int objectID, boolean newValue) {
        this.setAxisDescending(new IdentObj(objectID), newValue);
    }

    public int getAxisSide(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisSide);
        return m_Obj;
    }

    public int getAxisSide(int objectID) {
        return this.getAxisSide(new IdentObj(objectID));
    }

    public void setAxisSide(IdentObj id, int newValue) {
        this.putToLook(id, Attr.AxisSide, new Integer(newValue));
    }

    public void setAxisSide(int objectID, int newValue) {
        this.setAxisSide(new IdentObj(objectID), newValue);
    }

    public int getDataTextAngle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle);
        return m_Obj;
    }

    public int getDataTextAngle(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngleDefault();
    }

    public int getDataTextAngle(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngle(seriesID);
    }

    public void setDataTextAngle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.DataTextAngle, new Integer(newValue));
    }

    public void setDataTextAngle(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextAngle(id, newValue);
    }

    public void setDataTextAngle(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextAngle(id, newValue);
    }

    public int getDataTextRadius(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius);
        return m_Obj;
    }

    public int getDataTextRadius(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadiusDefault();
    }

    public int getDataTextRadius(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadius(seriesID);
    }

    public void setDataTextRadius(IdentObj id, int newValue) {
        this.putToLook(id, Attr.DataTextRadius, new Integer(newValue));
    }

    public void setDataTextRadius(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextRadius(id, newValue);
    }

    public void setDataTextRadius(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextRadius(id, newValue);
    }

    public boolean getDisplay(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.Display);
        return m_Obj;
    }

    public boolean getDisplay(int objectID) {
        return this.getDisplay(new IdentObj(objectID));
    }

    public void setDisplay(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.Display, newValue);
    }

    public void setDisplay(int objectID, boolean newValue) {
        this.setDisplay(new IdentObj(objectID), newValue);
    }

    public boolean getDisplayOffScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.DisplayOffScale);
        return m_Obj;
    }

    public boolean getDisplayOffScale(int objectID) {
        return this.getDisplayOffScale(new IdentObj(objectID));
    }

    public void setDisplayOffScale(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.DisplayOffScale, newValue);
    }

    public void setDisplayOffScale(int objectID, boolean newValue) {
        this.setDisplayOffScale(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMaxLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ExcludeMaxLabel);
        return m_Obj;
    }

    public boolean getExcludeMaxLabel(int objectID) {
        return this.getExcludeMaxLabel(new IdentObj(objectID));
    }

    public void setExcludeMaxLabel(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ExcludeMaxLabel, newValue);
    }

    public void setExcludeMaxLabel(int objectID, boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMinLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ExcludeMinLabel);
        return m_Obj;
    }

    public boolean getExcludeMinLabel(int objectID) {
        return this.getExcludeMinLabel(new IdentObj(objectID));
    }

    public void setExcludeMinLabel(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ExcludeMinLabel, newValue);
    }

    public void setExcludeMinLabel(int objectID, boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(objectID), newValue);
    }

    public String getFontName(IdentObj id) {
        String strFontName = null;
        if (this.getCascade()) {
            strFontName = (String)this.getFromLook(id, Attr.FontName, false);
            if (strFontName == null) {
                strFontName = this.getDefaultFontName();
            }
        } else {
            strFontName = (String)this.getFromLook(id, Attr.FontName);
        }
        return strFontName;
    }

    public String getFontName(int objectID) {
        return this.getFontName(new IdentObj(objectID));
    }

    public void setFontName(IdentObj id, String newValue) {
        this.putToLook(id, Attr.FontName, newValue);
    }

    public void setFontName(int objectID, String newValue) {
        this.setFontName(new IdentObj(objectID), newValue);
    }

    public String getDefaultFontName() {
        String m_Obj = (String)this.getFromLook(Identity.ID_GLOBAL, Attr.DefaultFontName, true);
        return m_Obj;
    }

    public void setDefaultFontName(String newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DefaultFontName, newValue);
    }

    public int getFontSizeVC(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.FontSizeVC);
        return m_Obj;
    }

    public int getFontSizeVC(int objectID) {
        return this.getFontSizeVC(new IdentObj(objectID));
    }

    public void setFontSizeVC(IdentObj id, int newValue) {
        this.putToLook(id, Attr.FontSizeVC, new Integer(newValue));
    }

    public void setFontSizeVC(int objectID, int newValue) {
        this.setFontSizeVC(new IdentObj(objectID), newValue);
    }

    public int getFontStyle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.FontStyle);
        return m_Obj;
    }

    public int getFontStyle(int objectID) {
        return this.getFontStyle(new IdentObj(objectID));
    }

    public void setFontStyle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.FontStyle, new Integer(newValue));
    }

    public void setFontStyle(int objectID, int newValue) {
        this.setFontStyle(new IdentObj(objectID), newValue);
    }

    public double getGridStep(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.GridStep);
        return m_Obj;
    }

    public double getGridStep(int objectID) {
        return this.getGridStep(new IdentObj(objectID));
    }

    public void setGridStep(IdentObj id, double newValue) {
        this.putToLook(id, Attr.GridStep, new Double(newValue));
    }

    public void setGridStep(int objectID, double newValue) {
        this.setGridStep(new IdentObj(objectID), newValue);
    }

    public boolean getGridStepAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.GridStepAuto);
        return m_Obj;
    }

    public boolean getGridStepAuto(int objectID) {
        return this.getGridStepAuto(new IdentObj(objectID));
    }

    public void setGridStepAuto(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.GridStepAuto, newValue);
    }

    public void setGridStepAuto(int objectID, boolean newValue) {
        this.setGridStepAuto(new IdentObj(objectID), newValue);
    }

    public int getGridStyle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.GridStyle);
        return m_Obj;
    }

    public int getGridStyle(int objectID) {
        return this.getGridStyle(new IdentObj(objectID));
    }

    public void setGridStyle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.GridStyle, new Integer(newValue));
    }

    public void setGridStyle(int objectID, int newValue) {
        this.setGridStyle(new IdentObj(objectID), newValue);
    }

    public String getGroupLabel(int groupID) {
        if (this.getReverseGroups()) {
            groupID = ((Perspective)this).getNumTotalGroups() - 1 - groupID;
        }
        return (String)this.getFromLook(new IdentObj(-3, -3, groupID), Attr.GroupLabel);
    }

    public void setGroupLabel(IdentObj id, String newValue) {
        this.putToLook(id, Attr.GroupLabel, newValue);
    }

    public void setGroupLabel(int groupID, String newValue) {
        IdentObj id = new IdentObj(-3, -3, groupID);
        this.setGroupLabel(id, newValue);
    }

    public boolean getLabelStagger(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.LabelStagger);
        return m_Obj;
    }

    public boolean getLabelStagger(int objectID) {
        return this.getLabelStagger(new IdentObj(objectID));
    }

    public void setLabelStagger(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.LabelStagger, newValue);
    }

    public void setLabelStagger(int objectID, boolean newValue) {
        this.setLabelStagger(new IdentObj(objectID), newValue);
    }

    public boolean getLogScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.LogScale);
        return m_Obj;
    }

    public boolean getLogScale(int objectID) {
        return this.getLogScale(new IdentObj(objectID));
    }

    public void setLogScale(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.LogScale, newValue);
    }

    public void setLogScale(int objectID, boolean newValue) {
        this.setLogScale(new IdentObj(objectID), newValue);
    }

    public int getMarkerSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize);
        return m_Obj;
    }

    public int getMarkerSize(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getMarkerSizeDefault();
    }

    public int getMarkerSize(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getMarkerSize(seriesID);
    }

    public void setMarkerSize(IdentObj id, int newValue) {
        this.putToLook(id, Attr.MarkerSize, new Integer(newValue));
    }

    public void setMarkerSize(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setMarkerSize(id, newValue);
    }

    public void setMarkerSize(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setMarkerSize(id, newValue);
    }

    public boolean getPieSliceDelete(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.PieSliceDelete);
        return m_Obj;
    }

    public boolean getPieSliceDelete(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDelete(id);
    }

    public boolean getPieSliceDelete(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDelete(id);
    }

    public void setPieSliceDelete(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.PieSliceDelete, newValue);
    }

    public void setPieSliceDelete(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDelete(id, newValue);
    }

    public void setPieSliceDelete(int seriesID, int groupID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDelete(id, newValue);
    }

    public int getPieSliceDetach(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PieSliceDetach);
        return m_Obj;
    }

    public int getPieSliceDetach(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDetach(id);
    }

    public int getPieSliceDetach(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDetach(id);
    }

    public void setPieSliceDetach(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PieSliceDetach, new Integer(newValue));
    }

    public void setPieSliceDetach(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDetach(id, newValue);
    }

    public void setPieSliceDetach(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDetach(id, newValue);
    }

    public Rectangle getRect(IdentObj id) {
        Rectangle m_Obj = (Rectangle)this.getFromLook(id, Attr.Rect);
        return m_Obj;
    }

    public Rectangle getRect(int objectID) {
        return this.getRect(new IdentObj(objectID));
    }

    public void setRect(IdentObj id, Rectangle newValue) {
        this.putToLook(id, Attr.Rect, newValue);
    }

    public void setRect(int objectID, Rectangle newValue) {
        this.setRect(new IdentObj(objectID), newValue);
    }

    public double getScaleMax(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.ScaleMax);
        return m_Obj;
    }

    public double getScaleMax(int objectID) {
        return this.getScaleMax(new IdentObj(objectID));
    }

    public void setScaleMax(IdentObj id, double newValue) {
        this.putToLook(id, Attr.ScaleMax, new Double(newValue));
    }

    public void setScaleMax(int objectID, double newValue) {
        this.setScaleMax(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMaxAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMaxAuto);
        return m_Obj;
    }

    public boolean getScaleMaxAuto(int objectID) {
        return this.getScaleMaxAuto(new IdentObj(objectID));
    }

    public void setScaleMaxAuto(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ScaleMaxAuto, newValue);
    }

    public void setScaleMaxAuto(int objectID, boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(objectID), newValue);
    }

    public double getScaleMin(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.ScaleMin);
        return m_Obj;
    }

    public double getScaleMin(int objectID) {
        return this.getScaleMin(new IdentObj(objectID));
    }

    public void setScaleMin(IdentObj id, double newValue) {
        this.putToLook(id, Attr.ScaleMin, new Double(newValue));
    }

    public void setScaleMin(int objectID, double newValue) {
        this.setScaleMin(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMinAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMinAuto);
        return m_Obj;
    }

    public boolean getScaleMinAuto(int objectID) {
        return this.getScaleMinAuto(new IdentObj(objectID));
    }

    public void setScaleMinAuto(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ScaleMinAuto, newValue);
    }

    public void setScaleMinAuto(int objectID, boolean newValue) {
        this.setScaleMinAuto(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMustIncludeZero(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMustIncludeZero);
        return m_Obj;
    }

    public boolean getScaleMustIncludeZero(int objectID) {
        return this.getScaleMustIncludeZero(new IdentObj(objectID));
    }

    public void setScaleMustIncludeZero(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ScaleMustIncludeZero, newValue);
    }

    public void setScaleMustIncludeZero(int objectID, boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(objectID), newValue);
    }

    public String getSeriesLabel(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.SeriesLabel);
        return m_Obj;
    }

    public String getSeriesLabel(int seriesID) {
        if (this.getReverseSeries()) {
            seriesID = ((Perspective)this).getNumTotalSeries() - 1 - seriesID;
        }
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getSeriesLabel(id);
    }

    public void setSeriesLabel(IdentObj id, String newValue) {
        this.putToLook(id, Attr.SeriesLabel, newValue);
    }

    public void setSeriesLabel(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setSeriesLabel(id, newValue);
    }

    public boolean getShadowDisplay(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ShadowDisplay);
        return m_Obj;
    }

    public boolean getShadowDisplay(int objectID) {
        return this.getShadowDisplay(new IdentObj(objectID));
    }

    public void setShadowDisplay(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ShadowDisplay, newValue);
    }

    public void setShadowDisplay(int objectID, boolean newValue) {
        this.setShadowDisplay(new IdentObj(objectID), newValue);
    }

    public int getShadowXOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowXOffset);
        return m_Obj;
    }

    public int getShadowXOffset(int objectID) {
        return this.getShadowXOffset(new IdentObj(objectID));
    }

    public void setShadowXOffset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.ShadowXOffset, new Integer(newValue));
    }

    public void setShadowXOffset(int objectID, int newValue) {
        this.setShadowXOffset(new IdentObj(objectID), newValue);
    }

    public int getShadowYOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowYOffset);
        return m_Obj;
    }

    public int getShadowYOffset(int objectID) {
        return this.getShadowYOffset(new IdentObj(objectID));
    }

    public void setShadowYOffset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.ShadowYOffset, new Integer(newValue));
    }

    public void setShadowYOffset(int objectID, int newValue) {
        this.setShadowYOffset(new IdentObj(objectID), newValue);
    }

    public int getTextJustHoriz(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TextJustHoriz);
        return m_Obj;
    }

    public int getTextJustHoriz(int objectID) {
        return this.getTextJustHoriz(new IdentObj(objectID));
    }

    public void setTextJustHoriz(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextJustHoriz, new Integer(newValue));
    }

    public void setTextJustHoriz(int objectID, int newValue) {
        this.setTextJustHoriz(new IdentObj(objectID), newValue);
    }

    public int getTextJustVert(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TextJustVert);
        return m_Obj;
    }

    public int getTextJustVert(int objectID) {
        return this.getTextJustVert(new IdentObj(objectID));
    }

    public void setTextJustVert(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextJustVert, new Integer(newValue));
    }

    public void setTextJustVert(int objectID, int newValue) {
        this.setTextJustVert(new IdentObj(objectID), newValue);
    }

    public int getTextRotation(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TextRotation);
        return m_Obj;
    }

    public int getTextRotation(int objectID) {
        return this.getTextRotation(new IdentObj(objectID));
    }

    public void setTextRotation(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextRotation, new Integer(newValue));
    }

    public void setTextRotation(int objectID, int newValue) {
        this.setTextRotation(new IdentObj(objectID), newValue);
    }

    public String getTextString(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.TextString);
        return m_Obj;
    }

    public String getTextString(int objectID) {
        return this.getTextString(new IdentObj(objectID));
    }

    public void setTextString(IdentObj id, String newValue) {
        this.putToLook(id, Attr.TextString, newValue);
    }

    public void setTextString(int objectID, String newValue) {
        this.setTextString(new IdentObj(objectID), newValue);
    }

    public boolean getTextWrap(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.TextWrap);
        return m_Obj;
    }

    public boolean getTextWrap(int objectID) {
        return this.getTextWrap(new IdentObj(objectID));
    }

    public void setTextWrap(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.TextWrap, newValue);
    }

    public void setTextWrap(int objectID, boolean newValue) {
        this.setTextWrap(new IdentObj(objectID), newValue);
    }

    public boolean getForecast() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.Forecast);
        return m_Obj;
    }

    public boolean getForecast(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.Forecast);
        return m_Obj;
    }

    public boolean getForecast(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getForecast(id);
    }

    public boolean getForecast(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getForecast(id);
    }

    public void setForecast(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Forecast, newValue);
    }

    public void setForecast(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.Forecast, newValue);
    }

    public void setForecast(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setForecast(id, newValue);
    }

    public void setForecast(int seriesID, int groupID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setForecast(id, newValue);
    }

    public Color getTextureBGColor(IdentObj id) {
        Color m_Obj = (Color)this.getFromLook(id, Attr.TextureBGColor);
        return m_Obj;
    }

    public Color getTextureBGColor(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getTextureBGColor(id);
    }

    public Color getTextureBGColor(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getTextureBGColor(id);
    }

    public void setTextureBGColor(IdentObj id, Color newValue) {
        this.putToLook(id, Attr.TextureBGColor, newValue);
    }

    public void setTextureBGColor(int seriesID, Color newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setTextureBGColor(id, newValue);
    }

    public void setTextureBGColor(int seriesID, int groupID, Color newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setTextureBGColor(id, newValue);
    }

    public int getSeriesType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SeriesType);
        return m_Obj;
    }

    public int getSeriesType(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getSeriesType(id);
    }

    public void setSeriesType(IdentObj id, int newValue) {
        this.putToLook(id, Attr.SeriesType, new Integer(newValue));
    }

    public void setSeriesType(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setSeriesType(id, newValue);
    }

    public int getDataLineThickness() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DataLineThickness);
        return m_Obj;
    }

    public void setDataLineThickness(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DataLineThickness, new Integer(newValue));
    }

    public boolean getLegendReverse() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendReverse);
        return m_Obj;
    }

    public void setLegendReverse(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendReverse, newValue);
    }

    public String getY2TitleString() {
        return this.getTextString(new IdentObj(7));
    }

    public void setY2TitleString(String newValue) {
        this.setTextString(new IdentObj(7), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setY2TitleDisplay(true);
        }
    }

    public boolean getDisplayBarAsPictograph() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.DisplayBarAsPictograph);
        return m_Obj;
    }

    public void setDisplayBarAsPictograph(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DisplayBarAsPictograph, newValue);
    }

    public String getDataTextTemplateHiLo() {
        String m_Obj = (String)this.getFromLook(Identity.ID_GLOBAL, Attr.DataTextTemplateHiLo);
        return m_Obj;
    }

    public void setDataTextTemplateHiLo(String newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DataTextTemplateHiLo, newValue);
    }

    public String getDataTextTemplate() {
        String m_Obj = (String)this.getFromLook(Identity.DataText, Attr.DataTextTemplate);
        return m_Obj;
    }

    public String getDataTextTemplate(int series) {
        String m_Obj = (String)this.getFromLook(this.getDataText(series), Attr.DataTextTemplate);
        return m_Obj;
    }

    public String getDataTextTemplate(int series, int group) {
        String m_Obj = (String)this.getFromLook(this.getDataText(series, group), Attr.DataTextTemplate);
        return m_Obj;
    }

    public void setDataTextTemplate(String newValue) {
        this.putToLook(Identity.DataText, Attr.DataTextTemplate, newValue);
    }

    public void setDataTextTemplate(String newValue, int series) {
        this.putToLook(this.getDataText(series), Attr.DataTextTemplate, newValue);
    }

    public void setDataTextTemplate(String newValue, int series, int group) {
        this.putToLook(this.getDataText(series, group), Attr.DataTextTemplate, newValue);
    }

    public Format getTextFormat(IdentObj id) {
        Format m_Obj = (Format)this.getFromLook(id, Attr.TextFormat);
        return m_Obj;
    }

    public Format getTextFormat(int objectID) {
        return this.getTextFormat(new IdentObj(objectID));
    }

    public void setTextFormat(IdentObj id, Format newValue) {
        this.putToLook(id, Attr.TextFormat, newValue);
    }

    public void setTextFormat(int objectID, Format newValue) {
        this.setTextFormat(new IdentObj(objectID), newValue);
    }

    public void setTextFormatAlwaysLocalized(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.TextFormatAlwaysLocalized, newValue);
    }

    public Format getDataTextFormat(IdentObj id) {
        Format m_Obj = (Format)this.getFromLook(id, Attr.DataTextFormat);
        return m_Obj;
    }

    public Format getDataTextFormat(int objectID) {
        return this.getDataTextFormat(new IdentObj(objectID));
    }

    public void setDataTextFormat(IdentObj id, Format newValue) {
        this.putToLook(id, Attr.DataTextFormat, newValue);
    }

    public void setDataTextFormat(int objectID, Format newValue) {
        this.setDataTextFormat(new IdentObj(objectID), newValue);
    }

    public void setDataTextFormatAlwaysLocalized(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.DataTextFormatAlwaysLocalized, newValue);
    }

    public int getTextureDisplayMode() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TextureDisplayMode);
        return m_Obj;
    }

    public void setTextureDisplayMode(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TextureDisplayMode, new Integer(newValue));
    }

    public double getCubeLightSourceX() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeLightSourceX);
        return m_Obj;
    }

    public void setCubeLightSourceX(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeLightSourceX, new Double(newValue));
    }

    public double getCubeLightSourceY() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeLightSourceY);
        return m_Obj;
    }

    public void setCubeLightSourceY(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeLightSourceY, new Double(newValue));
    }

    public Format getPieSliceValueLabelTextFormat() {
        return this.getTextFormat(Identity.PieSliceValueLabel);
    }

    public void setPieSliceValueLabelTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.PieSliceValueLabel;
        this.setTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setTextFormat(id, newValue);
    }

    public Format getPieRingTotalTextFormat() {
        return this.getTextFormat(Identity.PieRingLabel);
    }

    public void setPieRingTotalTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.PieRingLabel;
        this.setTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setTextFormat(id, newValue);
    }

    public boolean getPieRingTotalIsPercent() {
        return (Boolean)this.getFromLook(Identity.PieRingLabel, Attr.IsPercentFormat);
    }

    public void setPieRingTotalIsPercent(boolean newValue) {
        this.putToLook(Identity.PieRingLabel, Attr.IsPercentFormat, newValue);
    }

    public Format getX1LabelFormat() {
        return this.getTextFormat(Identity.X1Label);
    }

    public void setX1LabelFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.X1Label;
        this.setTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setTextFormat(id, newValue);
    }

    public Format getX1DataTextFormat() {
        return this.getDataTextFormat(Identity.X1Axis);
    }

    public void setX1DataTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.X1Axis;
        this.setDataTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setDataTextFormat(id, newValue);
    }

    public int getQuadrantLineCountX() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.QuadrantLineCountX);
        return m_Obj;
    }

    public void setQuadrantLineCountX(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.QuadrantLineCountX, new Integer(newValue));
    }

    public int getO1LabelRotate() {
        return this.getTextRotation(Identity.O1Label);
    }

    public void setO1LabelRotate(int newValue) {
        this.setTextRotation(Identity.O1Label, newValue);
    }

    public int getO2LabelRotate() {
        return this.getTextRotation(Identity.O2Label);
    }

    public void setO2LabelRotate(int newValue) {
        this.setTextRotation(Identity.O2Label, newValue);
    }

    public int getY1LabelRotate() {
        return this.getTextRotation(new IdentObj(528));
    }

    public void setY1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(528), newValue);
    }

    public int getY2LabelRotate() {
        return this.getTextRotation(new IdentObj(532));
    }

    public void setY2LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(532), newValue);
    }

    public int getX1LabelRotate() {
        return this.getTextRotation(new IdentObj(524));
    }

    public void setX1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(524), newValue);
    }

    public double getCubeLightSourceZ() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CubeLightSourceZ);
        return m_Obj;
    }

    public void setCubeLightSourceZ(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CubeLightSourceZ, new Double(newValue));
    }

    public Format getY1LabelFormat() {
        return this.getTextFormat(Identity.Y1Label);
    }

    public void setY1LabelFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.Y1Label;
        this.setTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setTextFormat(id, newValue);
    }

    public Format getY1DataTextFormat() {
        return this.getDataTextFormat(Identity.Y1Axis);
    }

    public void setY1DataTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.Y1Axis;
        this.setDataTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setDataTextFormat(id, newValue);
    }

    public Format getY2LabelFormat() {
        return this.getTextFormat(Identity.Y2Label);
    }

    public void setY2LabelFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.Y2Label;
        this.setTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setTextFormat(id, newValue);
    }

    public Format getY2DataTextFormat() {
        return this.getDataTextFormat(Identity.Y2Axis);
    }

    public void setY2DataTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.Y2Axis;
        this.setDataTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setDataTextFormat(id, newValue);
    }

    public Format getZ1LabelFormat() {
        return this.getTextFormat(new IdentObj(568));
    }

    public void setZ1LabelFormat(Format newValue) {
        this.setTextFormat(new IdentObj(568), newValue);
    }

    public Format getZ1DataTextFormat() {
        return this.getDataTextFormat(Identity.Z1Axis);
    }

    public void setZ1DataTextFormat(Format newValue, boolean alwaysLocalized) {
        IdentObj id = Identity.Z1Axis;
        this.setDataTextFormatAlwaysLocalized(id, alwaysLocalized);
        this.setDataTextFormat(id, newValue);
    }

    public int getTextAutofitMin() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TextAutofitMin);
        return m_Obj;
    }

    public void setTextAutofitMin(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TextAutofitMin, new Integer(newValue));
    }

    public int getTextAutofitMax() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TextAutofitMax);
        return m_Obj;
    }

    public void setTextAutofitMax(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TextAutofitMax, new Integer(newValue));
    }

    public int getQuadrantLineCountY() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.QuadrantLineCountY);
        return m_Obj;
    }

    public void setQuadrantLineCountY(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.QuadrantLineCountY, new Integer(newValue));
    }

    public boolean getIgnoreSeries(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.IgnoreSeries);
        return m_Obj;
    }

    public boolean getIgnoreSeries(int seriesID) {
        return this.getIgnoreSeries(new IdentObj(-3, seriesID, -3));
    }

    public void setIgnoreSeries(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.IgnoreSeries, newValue);
    }

    public void setIgnoreSeries(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setIgnoreSeries(id, newValue);
    }

    public void setForceSeriesAbsolute(int nSeriesID, boolean newValue) {
        IdentObj id = this.getSeries(nSeriesID);
        this.putToLook(id, Attr.ForceSeriesAbsolute, newValue);
    }

    public boolean getForceSeriesAbsolute(int nSeriesID) {
        IdentObj id = this.getSeries(nSeriesID);
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ForceSeriesAbsolute);
        return m_Obj;
    }

    public void setForceSeriesAbsolute(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.ForceSeriesAbsolute, newValue);
    }

    public boolean getForceSeriesAbsolute(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ForceSeriesAbsolute);
        return m_Obj;
    }

    public int getO1LabelMargin() {
        return this.getLabelMargin(Identity.O1Label);
    }

    public void setO1LabelMargin(int newValue) {
        this.setLabelMargin(Identity.O1Label, newValue);
    }

    public int getLabelMargin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LabelMargin);
        return m_Obj;
    }

    public int getLabelMargin(int objectID) {
        return this.getLabelMargin(new IdentObj(objectID));
    }

    public void setLabelMargin(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LabelMargin, new Integer(newValue));
    }

    public void setLabelMargin(int objectID, int newValue) {
        this.setLabelMargin(new IdentObj(objectID), newValue);
    }

    public boolean getBiDirectional() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.BiDirectional);
        return m_Obj;
    }

    public void setBiDirectional(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.BiDirectional, newValue);
    }

    public int getAxisTextAutofitMin() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.AxisTextAutofitMin);
        return m_Obj;
    }

    public void setAxisTextAutofitMin(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.AxisTextAutofitMin, new Integer(newValue));
    }

    public int getAxisTextAutofitMode() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.AxisTextAutofitMode);
        return m_Obj;
    }

    public void setAxisTextAutofitMode(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.AxisTextAutofitMode, new Integer(newValue));
    }

    public String getDataTextTemplateScatter() {
        String m_Obj = (String)this.getFromLook(Identity.ID_GLOBAL, Attr.DataTextTemplateScatter);
        return m_Obj;
    }

    public void setDataTextTemplateScatter(String newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DataTextTemplateScatter, newValue);
    }

    public String getDataTextTemplateBubble() {
        String m_Obj = (String)this.getFromLook(Identity.ID_GLOBAL, Attr.DataTextTemplateBubble);
        return m_Obj;
    }

    public void setDataTextTemplateBubble(String newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DataTextTemplateBubble, newValue);
    }

    public float getFontSize(IdentObj id) {
        return this.pointsToPixels(this.getFontSizeInPoints(id));
    }

    public float getFontSizeInPoints(IdentObj id) {
        Float m_Obj = (Float)this.getFromLook(id, Attr.FontSizeInPoints);
        return m_Obj.floatValue();
    }

    public void setFontSizeInPoints(IdentObj id, int newValue) {
        if (this.getCascade()) {
            this.setAutofit(id, false);
        }
        this.putToLook(id, Attr.FontSizeInPoints, new Float(newValue));
    }

    public void setFontSizeInPoints(IdentObj id, float newValue) {
        if (this.getCascade()) {
            this.setAutofit(id, false);
        }
        this.putToLook(id, Attr.FontSizeInPoints, new Float(newValue));
    }

    private float pointsToPixels(float points) {
        if (this.getDocumentHeightInTwips() > 0) {
            int dpi = this.getHeight() * 1440 / this.getDocumentHeightInTwips();
            return (float)Math.floor((double)points * (double)dpi / 72.0 + 0.5);
        }
        if (!PerspectiveBase.isHeadless()) {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            return (float)Math.floor((double)points * (double)dpi / 72.0 + 0.5);
        }
        return points;
    }

    public int getLegendMarkersPerRow() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendMarkersPerRow);
        return m_Obj;
    }

    public void setLegendMarkersPerRow(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendMarkersPerRow, new Integer(newValue));
    }

    public int getLegendOrient() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.LegendOrient);
        return m_Obj;
    }

    public void setLegendOrient(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.LegendOrient, new Integer(newValue));
    }

    public int getTextDirection() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TextDirection);
        return m_Obj;
    }

    public void setTextDirection(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TextDirection, new Integer(newValue));
    }

    public double getLogScaleBase(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.LogScaleBase);
        return m_Obj;
    }

    public double getLogScaleBase(int objectID) {
        return this.getLogScaleBase(new IdentObj(objectID));
    }

    public void setLogScaleBase(IdentObj id, double newValue) {
        this.putToLook(id, Attr.LogScaleBase, new Double(newValue));
    }

    public void setLogScaleBase(int objectID, double newValue) {
        this.setLogScaleBase(new IdentObj(objectID), newValue);
    }

    public boolean getCascade() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.Cascade);
        return m_Obj;
    }

    public void setCascade(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Cascade, newValue);
    }

    public int getTextureFlipMode() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TextureFlipMode);
        return m_Obj;
    }

    public void setTextureFlipMode(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TextureFlipMode, new Integer(newValue));
    }

    public boolean getExtendToFrameEdge() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ExtendToFrameEdge);
        return m_Obj;
    }

    public void setExtendToFrameEdge(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ExtendToFrameEdge, newValue);
    }

    public double getStartDate() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.StartDate);
        return m_Obj;
    }

    public void setStartDate(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StartDate, new Double(newValue));
    }

    public void setStartDate(long newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.StartDate, new Double(newValue));
    }

    public double getEndDate() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.EndDate);
        return m_Obj;
    }

    public void setEndDate(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.EndDate, new Double(newValue));
    }

    public void setEndDate(long newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.EndDate, new Double(newValue));
    }

    public double getCurrentDate() {
        Double m_Obj = (Double)this.getFromLook(Identity.ID_GLOBAL, Attr.CurrentDate);
        return m_Obj;
    }

    public void setCurrentDate(double newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.CurrentDate, new Double(newValue));
    }

    public int getTaskHeight() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TaskHeight);
        return m_Obj;
    }

    public void setTaskHeight(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TaskHeight, new Integer(newValue));
    }

    public int getDateScale() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DateScale);
        return m_Obj;
    }

    public void setDateScale(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DateScale, new Integer(newValue));
    }

    public boolean getPlace() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.Place);
        return m_Obj;
    }

    public void setPlace(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.Place, new Boolean(newValue));
    }

    public Rectangle getPlaceRect(IdentObj id) {
        Rectangle m_Obj = (Rectangle)this.getFromLook(id, Attr.PlaceRect);
        return m_Obj;
    }

    public void setPlaceRect(IdentObj id, Rectangle newValue) {
        this.putToLook(id, Attr.PlaceRect, new Rectangle(newValue));
    }

    public Rectangle getPlaceMargin() {
        Rectangle r = (Rectangle)this.getFromLook(Identity.ID_GLOBAL, Attr.PlaceMargin);
        return new Rectangle(r);
    }

    public void setPlaceMargin(Rectangle newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PlaceMargin, newValue);
    }

    public int getPlaceMinFontSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceMinFontSize);
        return m_Obj;
    }

    public void setPlaceMinFontSize(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceMinFontSize, new Integer(newValue));
    }

    public int getPlaceWordWrap(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceWordWrap);
        return m_Obj;
    }

    public void setPlaceWordWrap(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceWordWrap, new Integer(newValue));
    }

    public int getPlaceAlign(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceAlign);
        return m_Obj;
    }

    public void setPlaceAlign(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceAlign, new Integer(newValue));
    }

    public int getPlaceRotate(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceRotate);
        return m_Obj;
    }

    public void setPlaceRotate(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceRotate, new Integer(newValue));
    }

    public PlaceMode getPlaceResize(IdentObj id) {
        return (PlaceMode)((Object)this.getFromLook(id, Attr.PlaceResize));
    }

    public void setPlaceResize(IdentObj id, PlaceMode newValue) {
        this.putToLook(id, Attr.PlaceResize, (Object)newValue);
    }

    public int getPlaceTruncateCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceTruncateCount);
        return m_Obj;
    }

    public void setPlaceTruncateCount(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceTruncateCount, new Integer(newValue));
    }

    public int getPlaceSkip(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceSkip);
        return m_Obj;
    }

    public void setPlaceSkip(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceSkip, new Integer(newValue));
    }

    public int getPlaceMaxNumWordWrapLines(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlaceMaxNumWordWrapLines);
        return m_Obj;
    }

    public void setPlaceMaxNumWordWrapLines(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlaceMaxNumWordWrapLines, new Integer(newValue));
    }

    public int getPlacePosition(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PlacePosition);
        return m_Obj;
    }

    public void setPlacePosition(IdentObj id, int newValue) {
        this.putToLook(id, Attr.PlacePosition, new Integer(newValue));
    }

    public int getAxisSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisSize);
        return m_Obj;
    }

    public int getAxisSize(int objectID) {
        return this.getAxisSize(new IdentObj(objectID));
    }

    public void setAxisSize(IdentObj id, int newValue) {
        this.putToLook(id, Attr.AxisSize, new Integer(newValue));
    }

    public void setAxisSize(int objectID, int newValue) {
        this.setAxisSize(new IdentObj(objectID), newValue);
    }

    public int getAxisOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisOffset);
        return m_Obj;
    }

    public int getAxisOffset(int objectID) {
        return this.getAxisOffset(new IdentObj(objectID));
    }

    public void setAxisOffset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.AxisOffset, new Integer(newValue));
    }

    public void setAxisOffset(int objectID, int newValue) {
        this.setAxisOffset(new IdentObj(objectID), newValue);
    }

    public boolean getNonZeroBaseline(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.NonZeroBaseline);
        return m_Obj;
    }

    public boolean getNonZeroBaseline(int objectID) {
        return this.getNonZeroBaseline(new IdentObj(objectID));
    }

    public void setNonZeroBaseline(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.NonZeroBaseline, new Boolean(newValue));
    }

    public void setNonZeroBaseline(int objectID, boolean newValue) {
        this.setNonZeroBaseline(new IdentObj(objectID), newValue);
    }

    public boolean getTransparentMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.TransparentMarkers);
        return m_Obj;
    }

    public void setTransparentMarkers(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TransparentMarkers, new Boolean(newValue));
    }

    public int getTransparentMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.TransparentMarkerSize);
        return m_Obj;
    }

    public void setTransparentMarkerSize(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.TransparentMarkerSize, new Integer(newValue));
    }

    public int getSeriesLineWidthDefault() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.SeriesLineWidthDefault);
        return m_Obj;
    }

    public void setSeriesLineWidthDefault(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SeriesLineWidthDefault, new Integer(newValue));
    }

    public boolean getIgnoreGridSkip() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.IgnoreGridSkip);
        return m_Obj;
    }

    public void setIgnoreGridSkip(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.IgnoreGridSkip, new Boolean(newValue));
    }

    public boolean getToolTipTimeOutEnabled() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ToolTipTimeOutEnabled);
        return m_Obj;
    }

    public void setToolTipTimeOutEnabled(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ToolTipTimeOutEnabled, new Boolean(newValue));
    }

    public boolean getToolTipDisplayTimeOut() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.ToolTipDisplayTimeOut);
        return m_Obj;
    }

    public void setToolTipDisplayTimeOut(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.ToolTipDisplayTimeOut, new Boolean(newValue));
    }

    public boolean getUseDefaultBubbleMarker() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.UseDefaultBubbleMarker);
        return m_Obj;
    }

    public void setUseDefaultBubbleMarker(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.UseDefaultBubbleMarker, new Boolean(newValue));
    }

    public boolean getSizeToContainer() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.SizeToContainer);
        return m_Obj;
    }

    public void setSizeToContainer(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SizeToContainer, new Boolean(newValue));
    }

    public boolean getPDELegendFontSizeSpacing() {
        return this.m_bPDELegendFontSizeSpacing;
    }

    public void setPDELegendFontSizeSpacing(boolean newValue) {
        this.m_bPDELegendFontSizeSpacing = newValue;
    }

    public IdentObj getDataText(int nSeries) {
        return new IdentObj(504, nSeries);
    }

    public IdentObj getDataTextBox(int nSeries) {
        return new IdentObj(645, nSeries);
    }

    public IdentObj getCubeDataTextLine(int s) {
        return new IdentObj(1019, s);
    }

    public IdentObj getSeries(int nSeries) {
        return new IdentObj(-3, nSeries);
    }

    public IdentObj getGroup(int nGroup) {
        return new IdentObj(-3, -3, nGroup);
    }

    public IdentObj getSeriesGroup(int nSeries, int nGroup) {
        return new IdentObj(-3, nSeries, nGroup);
    }

    public IdentObj getGlobal(int misc) {
        IdentObj id = Identity.ID_GLOBAL;
        id = id.changeMisc(misc);
        return id;
    }

    public IdentObj getAreaRiser(int s, int g) {
        return new IdentObj(500, s, g);
    }

    public IdentObj getBarRiser(int s) {
        return new IdentObj(521, s);
    }

    public IdentObj getBarRiser(int s, int g) {
        return new IdentObj(521, s, g);
    }

    public IdentObj getDataText(int s, int g) {
        return new IdentObj(504, s, g);
    }

    public IdentObj getDataTextBox(int s, int g) {
        return new IdentObj(645, s, g);
    }

    public IdentObj getLegendMarker(int s) {
        return new IdentObj(13, s);
    }

    public IdentObj getLineMarker(int s) {
        return new IdentObj(503, s);
    }

    public IdentObj getLineMarker(int s, int g) {
        return new IdentObj(503, s, g);
    }

    public IdentObj getPieFeelerLine(int s) {
        return new IdentObj(538, s);
    }

    public IdentObj getPieGroupLabel(int s, int g) {
        return new IdentObj(540, s, g);
    }

    public IdentObj getPieGroupLabelBox(int s, int g) {
        return new IdentObj(652, s, g);
    }

    public IdentObj getPieSliceLabel(int s) {
        return new IdentObj(539, s);
    }

    public IdentObj getPieSliceValueLabel(int s) {
        return new IdentObj(823, s);
    }

    public IdentObj getStockCloseTick(int s, int g) {
        return new IdentObj(551, s, g);
    }

    public IdentObj getStockOpenTick(int s, int g) {
        return new IdentObj(552, s, g);
    }

    public int getLabelTextAngle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LabelTextAngle);
        return m_Obj;
    }

    public int getLabelTextAngle(int objectID) {
        return this.getLabelTextAngle(new IdentObj(objectID));
    }

    public void setLabelTextAngle(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LabelTextAngle, new Integer(newValue));
    }

    public void setLabelTextAngle(int objectID, int newValue) {
        this.setLabelTextAngle(new IdentObj(objectID), newValue);
    }

    public int getO1LabelTextAngle() {
        return this.getLabelTextAngle(Identity.O1Label);
    }

    public void setO1LabelTextAngle(int newValue) {
        this.setLabelTextAngle(Identity.O1Label, newValue);
        if (newValue > -1) {
            this.setO1LabelRotate(3);
        }
    }

    public int getO2LabelTextAngle() {
        return this.getLabelTextAngle(Identity.O2Label);
    }

    public void setO2LabelTextAngle(int newValue) {
        this.setLabelTextAngle(Identity.O2Label, newValue);
        if (newValue > -1) {
            this.setO2LabelRotate(3);
        }
    }

    public int getY1LabelTextAngle() {
        return this.getLabelTextAngle(Identity.Y1Label);
    }

    public void setY1LabelTextAngle(int newValue) {
        this.setLabelTextAngle(Identity.Y1Label, newValue);
        if (newValue > -1) {
            this.setY1LabelRotate(3);
        }
    }

    public int getY2LabelTextAngle() {
        return this.getLabelTextAngle(Identity.Y2Label);
    }

    public void setY2LabelTextAngle(int newValue) {
        this.setLabelTextAngle(Identity.Y2Label, newValue);
        if (newValue > -1) {
            this.setY2LabelRotate(3);
        }
    }

    public int getX1LabelTextAngle() {
        return this.getLabelTextAngle(Identity.X1Label);
    }

    public void setX1LabelTextAngle(int newValue) {
        this.setLabelTextAngle(Identity.X1Label, newValue);
        if (newValue > -1) {
            this.setX1LabelRotate(3);
        }
    }

    public boolean getUseTextBackgroundColor(IdentObj id) {
        return (Boolean)this.getFromLook(id, Attr.UseTextBackgroundColor);
    }

    public void setUseTextBackgroundColor(IdentObj id, boolean newValue) {
        this.putToLook(id, Attr.UseTextBackgroundColor, new Boolean(newValue));
    }

    public Color getTextBackgroundColor(IdentObj id) {
        return (Color)this.getFromLook(id, Attr.TextBackgroundColor);
    }

    public void setTextBackgroundColor(IdentObj idObj, Color col) {
        this.putToLook(idObj, Attr.TextBackgroundColor, col);
    }

    public void setTextUnderlineType(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TextUnderlineType, new Integer(newValue));
    }

    public int getTextUnderlineType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TextUnderlineType);
        return m_Obj;
    }

    public boolean getTextStrikethrough(IdentObj idObj) {
        return (Boolean)this.getFromLook(idObj, Attr.TextStrikethrough);
    }

    public void setTextStrikethrough(IdentObj idObj, boolean newValue) {
        this.putToLook(idObj, Attr.TextStrikethrough, new Boolean(newValue));
    }

    public void setShadowFillType(IdentObj id, int newValue) {
        this.putToLook(id, Attr.ShadowFillType, new Integer(newValue));
    }

    public int getShadowFillType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowFillType);
        return m_Obj;
    }

    public Color getShadowGradientStartColor(IdentObj id) {
        return (Color)this.getFromLook(id, Attr.ShadowGradientStartColor);
    }

    public void setShadowGradientStartColor(IdentObj idObj, Color col) {
        this.putToLook(idObj, Attr.ShadowGradientStartColor, col);
    }

    public Color getShadowGradientEndColor(IdentObj id) {
        return (Color)this.getFromLook(id, Attr.ShadowGradientEndColor);
    }

    public void setShadowGradientEndColor(IdentObj idObj, Color col) {
        this.putToLook(idObj, Attr.ShadowGradientEndColor, col);
    }

    public void setLineBasicStrokeType(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LineBasicStrokeType, new Integer(newValue));
    }

    public int getLineBasicStrokeType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LineBasicStrokeType);
        return m_Obj;
    }

    public void setLineCap(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LineCap, new Integer(newValue));
    }

    public int getLineCap(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LineCap);
        return m_Obj;
    }

    public void setLineJoin(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LineJoin, new Integer(newValue));
    }

    public int getLineJoin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LineJoin);
        return m_Obj;
    }

    public void setLineMiterLimit(IdentObj id, float fNewValue) {
        this.putToLook(id, Attr.LineMiterLimit, new Float(fNewValue));
    }

    public float getLineMiterLimit(IdentObj id) {
        Float FloatLineMiterLimit = (Float)this.getFromLook(id, Attr.LineMiterLimit);
        return FloatLineMiterLimit.floatValue();
    }

    public void setLineDash(IdentObj id, List<Double> lineDashList) {
        this.putToLook(id, Attr.LineDash, lineDashList);
    }

    public List<Double> getLineDash(IdentObj id) {
        List lineDashList = (List)this.getFromLook(id, Attr.LineDash);
        return lineDashList;
    }

    public double[] getLineDashArray(IdentObj id) {
        double[] fDashArray;
        List<Double> vectLineDashFloat = this.getLineDash(id);
        int nSize = vectLineDashFloat.size();
        if (nSize > 0) {
            fDashArray = new double[nSize];
            for (int n = 0; n < nSize; ++n) {
                Double value = vectLineDashFloat.get(n);
                fDashArray[n] = this.ptsWidthToDC(value);
            }
        } else {
            fDashArray = new double[]{this.ptsWidthToDC(2.0)};
        }
        return fDashArray;
    }

    public double ptsWidthToDC(double pointSize) {
        double actualHeight = this.getDocumentHeightInPoints();
        if (actualHeight < 1.0) {
            return pointSize;
        }
        double ratio = (double)this.getSize().height / actualHeight;
        if (pointSize <= 0.0) {
            pointSize = 0.75 / ratio;
        }
        return pointSize * ratio;
    }

    public float getLineDashPhase(IdentObj id) {
        Float FloatLineDashPhase = (Float)this.getFromLook(id, Attr.LineDashPhase);
        return FloatLineDashPhase.floatValue();
    }

    public void setLineDashPhase(IdentObj id, float fNewValue) {
        this.putToLook(id, Attr.LineDashPhase, new Float(fNewValue));
    }

    public void setY3LogScale(boolean newValue) {
        this.setLogScale(Identity.Y3Axis, newValue);
    }

    public boolean getY3LogScale() {
        return this.getLogScale(Identity.Y3Axis);
    }

    public void setY4LogScale(boolean newValue) {
        this.setLogScale(Identity.Y4Axis, newValue);
    }

    public boolean getY4LogScale() {
        return this.getLogScale(Identity.Y4Axis);
    }

    public void setY5LogScale(boolean newValue) {
        this.setLogScale(Identity.Y5Axis, newValue);
    }

    public boolean getY5LogScale() {
        return this.getLogScale(Identity.Y5Axis);
    }

    public boolean getY3AxisDescending() {
        return this.getAxisDescending(Identity.Y3Axis);
    }

    public void setY3AxisDescending(boolean newValue) {
        this.setAxisDescending(Identity.Y3Axis, newValue);
    }

    public boolean getY4AxisDescending() {
        return this.getAxisDescending(Identity.Y4Axis);
    }

    public void setY4AxisDescending(boolean newValue) {
        this.setAxisDescending(Identity.Y4Axis, newValue);
    }

    public boolean getY5AxisDescending() {
        return this.getAxisDescending(Identity.Y5Axis);
    }

    public void setY5AxisDescending(boolean newValue) {
        this.setAxisDescending(Identity.Y5Axis, newValue);
    }

    public boolean getAlignMultiYBars() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.AlignMultiYBars);
        return m_Obj;
    }

    public void setAlignMultiYBars(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.AlignMultiYBars, new Boolean(newValue));
    }

    public void setWaterfallGroupMode(int nGroup, int nGroupMode) {
        IdentObj id = this.getGroup(nGroup);
        this.putToLook(id, Attr.WaterfallGroupMode, new Integer(nGroupMode));
    }

    public int getWaterfallGroupMode(int nGroup) {
        IdentObj id = this.getGroup(nGroup);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.WaterfallGroupMode);
        return m_Obj;
    }

    public void setDisplayFunnelGroup(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DisplayFunnelGroup, new Integer(newValue));
    }

    public int getDisplayFunnelGroup() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DisplayFunnelGroup);
        return m_Obj;
    }

    public void setFunnelVertExplosionFactor(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.FunnelVertExplosionFactor, new Integer(newValue));
    }

    public int getFunnelVertExplosionFactor() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.FunnelVertExplosionFactor);
        return m_Obj;
    }

    public void setFunnelLabelValueLocation(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.FunnelLabelValueLocation, new Integer(newValue));
    }

    public int getFunnelLabelValueLocation() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.FunnelLabelValueLocation);
        return m_Obj;
    }

    public IdentObj getFunnelGroupLabel(int s, int g) {
        return new IdentObj(821, s, g);
    }

    public IdentObj getFunnelGroupLabelBox(int s, int g) {
        return new IdentObj(822, s, g);
    }

    public double getNonZeroBaselineValue(IdentObj id) {
        Double fBaseline = (Double)this.getFromLook1(this.m_cachedKey.set(Attr.NonZeroBaselineValue, id));
        if (fBaseline != null) {
            return fBaseline;
        }
        return 1.234567E301;
    }

    public void setNonZeroBaselineValue(IdentObj id, double fValue) {
        this.putToLook(id, Attr.NonZeroBaselineValue, new Double(fValue));
    }

    public IdentObj getNonZeroBaseLineZeroLine() {
        return new IdentObj(251);
    }

    public IdentObj getNonZeroBaseLineZeroLine(IdentObj axisObj) {
        return new IdentObj(251, axisObj.getObjectID());
    }

    public int getPercentValueFormat() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PercentValueFormat);
        return m_Obj;
    }

    public void setPercentValueFormat(int newValue) {
        this.putToLook(new IdentObj(2000), Attr.PercentValueFormat, new Integer(newValue));
    }

    public boolean getShowTotalsDisplay() {
        return (Boolean)this.getFromLook(new IdentObj(2000), Attr.ShowTotalsDisplay);
    }

    public void setShowTotalsDisplay(boolean newValue) {
        this.putToLook(new IdentObj(2000), Attr.ShowTotalsDisplay, new Boolean(newValue));
    }

    public IStandardLook getGaugeLook() {
        return this.m_gaugeLook;
    }

    private IdentObj makeIdentObjFromObjectID(String strObjectID) {
        return StandardLookPFJ.makeIdentObj(this.m_gaugeLook.getObjectID(strObjectID));
    }

    public IdentObj getGaugeBackground() {
        return this.makeIdentObjFromObjectID("GaugeBackground");
    }

    public IdentObj getGaugeArea() {
        return this.makeIdentObjFromObjectID("GaugeArea");
    }

    public IdentObj getGaugeScaleArea() {
        return this.makeIdentObjFromObjectID("GaugeScaleArea");
    }

    public IdentObj getGaugeLabel() {
        return this.makeIdentObjFromObjectID("GaugeLabel");
    }

    public IdentObj getGaugeNeedle() {
        return this.makeIdentObjFromObjectID("GaugeNeedle");
    }

    public IdentObj getGaugeMajorTick() {
        return this.makeIdentObjFromObjectID("GaugeMajorGrid");
    }

    public IdentObj getGaugeMinorTick() {
        return this.makeIdentObjFromObjectID("GaugeMinorGrid");
    }

    public IdentObj getGaugeBand1() {
        return this.makeIdentObjFromObjectID("GaugeBand1");
    }

    public IdentObj getGaugeBand2() {
        return this.makeIdentObjFromObjectID("GaugeBand2");
    }

    public IdentObj getGaugeBand3() {
        return this.makeIdentObjFromObjectID("GaugeBand3");
    }

    public IdentObj getGaugeBand4() {
        return this.makeIdentObjFromObjectID("GaugeBand4");
    }

    public IdentObj getGaugeBand5() {
        return this.makeIdentObjFromObjectID("GaugeBand5");
    }

    public IdentObj getGaugeBand1Label() {
        return this.makeIdentObjFromObjectID("GaugeBand1Label");
    }

    public IdentObj getGaugeBand2Label() {
        return this.makeIdentObjFromObjectID("GaugeBand2Label");
    }

    public IdentObj getGaugeBand3Label() {
        return this.makeIdentObjFromObjectID("GaugeBand3Label");
    }

    public IdentObj getGaugeBand4Label() {
        return this.makeIdentObjFromObjectID("GaugeBand4Label");
    }

    public IdentObj getGaugeBand5Label() {
        return this.makeIdentObjFromObjectID("GaugeBand5Label");
    }

    public IdentObj getGaugeGlass() {
        return this.makeIdentObjFromObjectID("GaugeGlass");
    }

    public IdentObj getGaugeTitle() {
        return this.makeIdentObjFromObjectID("GaugeTitle");
    }

    public IdentObj getGaugeCenterCircle() {
        return this.makeIdentObjFromObjectID("GaugeCenterCircle");
    }

    public IdentObj getGaugeStyledBackground() {
        return this.makeIdentObjFromObjectID("GaugeStyledBackground");
    }

    public boolean getGaugeDescending() {
        Boolean m_Obj = (Boolean)this.getFromLook(this.getGaugeArea(), Attr.AxisDescending);
        return m_Obj;
    }

    public void setGaugeDescending(boolean newValue) {
        this.putToLook(this.getGaugeArea(), Attr.AxisDescending, new Boolean(newValue));
    }

    public double getGaugeMajorTickRelativeTickLength() {
        Double m_Obj = (Double)this.getFromLook(this.getGaugeMajorTick(), Attr.GaugeRelativeTickLength);
        return m_Obj;
    }

    public void setGaugeMajorTickRelativeTickLength(double newValue) {
        this.putToLook(this.getGaugeMajorTick(), Attr.GaugeRelativeTickLength, new Double(newValue));
    }

    public double getGaugeMinorTickRelativeTickLength() {
        Double m_Obj = (Double)this.getFromLook(this.getGaugeMinorTick(), Attr.GaugeRelativeTickLength);
        return m_Obj;
    }

    public void setGaugeMinorTickRelativeTickLength(double newValue) {
        this.putToLook(this.getGaugeMinorTick(), Attr.GaugeRelativeTickLength, new Double(newValue));
    }

    public boolean getGaugeMinorAutoStep() {
        Boolean m_Obj = (Boolean)this.getFromLook(this.getGaugeArea(), Attr.GaugeMinorAutoStep);
        return m_Obj;
    }

    public void setGaugeMinorAutoStep(boolean newValue) {
        this.putToLook(this.getGaugeArea(), Attr.GaugeMinorAutoStep, new Boolean(newValue));
    }

    public boolean getGaugeMajorAutoStep() {
        Boolean m_Obj = (Boolean)this.getFromLook(this.getGaugeArea(), Attr.GaugeMajorAutoStep);
        return m_Obj;
    }

    public void setGaugeMajorAutoStep(boolean newValue) {
        this.putToLook(this.getGaugeArea(), Attr.GaugeMajorAutoStep, new Boolean(newValue));
    }

    public int getGaugeBandThicknessVC() {
        Integer m_Obj = (Integer)this.getFromLook(this.getGaugeScaleArea(), Attr.GaugeBandThicknessVC);
        return m_Obj;
    }

    public void setGaugeBandThicknessVC(int newValue) {
        this.putToLook(this.getGaugeScaleArea(), Attr.GaugeBandThicknessVC, new Integer(newValue));
    }

    public double getGaugeRelativeThickness() {
        Double m_Obj = (Double)this.getFromLook(this.getGaugeScaleArea(), Attr.GaugeRelativeThickness);
        return m_Obj;
    }

    public void setGaugeRelativeThickness(double newValue) {
        this.putToLook(this.getGaugeScaleArea(), Attr.GaugeRelativeThickness, new Double(newValue));
    }

    public double getGaugeStartAngle() {
        Double m_Obj = (Double)this.getFromLook(this.getGaugeScaleArea(), Attr.GaugeStartAngle);
        return m_Obj;
    }

    public void setGaugeStartAngle(double newValue) {
        this.putToLook(this.getGaugeScaleArea(), Attr.GaugeStartAngle, new Double(newValue));
    }

    public double getGaugeStopAngle() {
        Double m_Obj = (Double)this.getFromLook(this.getGaugeScaleArea(), Attr.GaugeStopAngle);
        return m_Obj;
    }

    public void setGaugeStopAngle(double newValue) {
        this.putToLook(this.getGaugeScaleArea(), Attr.GaugeStopAngle, new Double(newValue));
    }

    public double getGaugeAlphaChannel(IdentObj identObj) {
        Double m_Obj = (Double)this.getFromLook(identObj, Attr.GaugeAlphaChannel);
        return m_Obj;
    }

    public void setGaugeAlphaChannel(IdentObj identObj, double newValue) {
        this.putToLook(identObj, Attr.GaugeAlphaChannel, new Double(newValue));
    }

    public int getGaugeBackgroundStyle() {
        Integer m_Obj = (Integer)this.getFromLook(this.getGaugeArea(), Attr.GaugeBackgroundStyle);
        return m_Obj;
    }

    public void setGaugeBackgroundStyle(int newValue) {
        this.putToLook(this.getGaugeArea(), Attr.GaugeBackgroundStyle, new Integer(newValue));
    }

    public boolean getGaugeIgnoreBackgroundStyle() {
        Boolean m_Obj = (Boolean)this.getFromLook(this.getGaugeArea(), Attr.GaugeIgnoreBackgroundStyle);
        return m_Obj;
    }

    public void setGaugeIgnoreBackgroundStyle(boolean newValue) {
        this.putToLook(this.getGaugeArea(), Attr.GaugeIgnoreBackgroundStyle, new Boolean(newValue));
    }

    public int getGaugeNeedleStyle() {
        Integer m_Obj = (Integer)this.getFromLook(this.getGaugeNeedle(), Attr.GaugeNeedleStyle);
        return m_Obj;
    }

    public void setGaugeNeedleStyle(int newValue) {
        this.putToLook(this.getGaugeNeedle(), Attr.GaugeNeedleStyle, new Integer(newValue));
    }

    public void setGaugeBandMin(IdentObj id, double min) {
        this.putToLook(id, Attr.GaugeBandMin, new Double(min));
    }

    public double getGaugeBandMin(IdentObj id) {
        Number min = (Number)this.getFromLook(id, Attr.GaugeBandMin);
        return min.doubleValue();
    }

    public void setGaugeBandMax(IdentObj id, double max) {
        this.putToLook(id, Attr.GaugeBandMax, new Double(max));
    }

    public double getGaugeBandMax(IdentObj id) {
        Number max = (Number)this.getFromLook(id, Attr.GaugeBandMax);
        return max.doubleValue();
    }

    public void setGaugeTitlePosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.GaugeTitlePosition, new Integer(newValue));
    }

    public int getGaugeTitlePosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.GaugeTitlePosition);
        return m_Obj;
    }

    public static String getPackageName(Class clazz) {
        String classname = clazz.getName();
        return classname.substring(0, classname.lastIndexOf("."));
    }

    public void setDocumentWidthInTwips(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DocumentWidthInTwips, new Integer(newValue));
    }

    public int getDocumentWidthInTwips() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DocumentWidthInTwips);
        return m_Obj;
    }

    public int getDocumentWidthInPoints() {
        return (int)Math.round((double)this.getDocumentWidthInTwips() * 0.05);
    }

    public void setDocumentHeightInTwips(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DocumentHeightInTwips, new Integer(newValue));
    }

    public int getDocumentHeightInTwips() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.DocumentHeightInTwips);
        return m_Obj;
    }

    public int getDocumentHeightInPoints() {
        return (int)Math.round((double)this.getDocumentHeightInTwips() * 0.05);
    }

    public void setBorderType(IdentObj id, int newValue) {
        this.putToLook(id, Attr.BorderType, new Integer(newValue));
    }

    public int getBorderType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.BorderType);
        return m_Obj;
    }

    public void setCornerArcWidth(IdentObj id, int newValue) {
        this.putToLook(id, Attr.CornerArcWidth, new Integer(newValue));
    }

    public int getCornerArcWidth(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.CornerArcWidth);
        return m_Obj;
    }

    public void setCornerArcHeight(IdentObj id, int newValue) {
        this.putToLook(id, Attr.CornerArcHeight, new Integer(newValue));
    }

    public int getCornerArcHeight(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.CornerArcHeight);
        return m_Obj;
    }

    public int getNumAnnotations() {
        return this.m_numAnnotations;
    }

    public void setNumAnnotations(int i) {
        this.m_numAnnotations = i;
    }

    public void setAnnotationType(IdentObj annodeId, AnnotationType type) {
        this.putToLook(annodeId, Attr.AnnotationType, type.ordinal());
    }

    public AnnotationType getAnnotationType(IdentObj annodeId) {
        Integer obj = (Integer)this.getFromLook(annodeId, Attr.AnnotationType);
        return AnnotationType.fromInt(obj);
    }

    public void setAnnotationOrder(IdentObj annodeId, int i) {
        this.putToLook(annodeId, Attr.AnnotationOrder, new Integer(i));
    }

    public int getAnnotationOrder(IdentObj annodeId) {
        Integer obj = (Integer)this.getFromLook(annodeId, Attr.AnnotationOrder);
        return obj;
    }

    public void addAnnotationObject(IdentObj annodeId, Object object) {
        List<Object> aData = this.m_annotationData.get(annodeId);
        if (aData == null) {
            aData = new ArrayList<Object>();
            this.m_annotationData.put(annodeId, aData);
        }
        aData.add(object);
    }

    public int getNumAnnotationObjects(IdentObj annodeId) {
        List<Object> list = this.m_annotationData.get(annodeId);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Object getAnnotationObject(IdentObj annodeId, int position) {
        List<Object> list = this.m_annotationData.get(annodeId);
        return list == null ? null : list.get(position);
    }

    public void setArrowHeadLength(IdentObj annodeId, int i) {
        this.putToLook(annodeId, Attr.ArrowHeadLength, new Integer(i));
    }

    public int getArrowHeadLength(IdentObj annodeId) {
        Integer obj = (Integer)this.getFromLook(annodeId, Attr.ArrowHeadLength);
        return obj;
    }

    public void setTopInset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.TopInset, new Integer(newValue));
    }

    public int getTopInset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.TopInset);
        return m_Obj;
    }

    public void setLeftInset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.LeftInset, new Integer(newValue));
    }

    public int getLeftInset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LeftInset);
        return m_Obj;
    }

    public void setBottomInset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.BottomInset, new Integer(newValue));
    }

    public int getBottomInset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.BottomInset);
        return m_Obj;
    }

    public void setRightInset(IdentObj id, int newValue) {
        this.putToLook(id, Attr.RightInset, new Integer(newValue));
    }

    public int getRightInset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.RightInset);
        return m_Obj;
    }

    public Insets getInsets(IdentObj id) {
        return new Insets(this.getTopInset(id), this.getLeftInset(id), this.getBottomInset(id), this.getRightInset(id));
    }

    public void setInsets(IdentObj id, Insets insets) {
        this.setTopInset(id, insets.top);
        this.setLeftInset(id, insets.left);
        this.setBottomInset(id, insets.bottom);
        this.setRightInset(id, insets.right);
    }

    public int getMaxNumAnnotations() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.MaxNumAnnotations);
        return m_Obj;
    }

    public void setMaxNumAnnotations(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.MaxNumAnnotations, new Integer(newValue));
    }

    public IdentObj getAnnotationBox(int nIndex) {
        return new IdentObj(757, nIndex);
    }

    public IdentObj getAnnotation(int nIndex) {
        return new IdentObj(756, nIndex);
    }

    public boolean getSpecularLight() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.SpecularLight);
        return m_Obj;
    }

    public void setSpecularLight(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.SpecularLight, new Boolean(newValue));
    }

    public boolean getDualAxisStackedSpacingException() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.DualAxisStackedSpacingException);
        return m_Obj;
    }

    public void setDualAxisStackedSpacingException(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.DualAxisStackedSpacingException, new Boolean(newValue));
    }

    public int getRepositionDataTextCollision() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.RepositionDataTextCollision);
        return m_Obj;
    }

    public void setRepositionDataTextCollision(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.RepositionDataTextCollision, new Integer(newValue));
    }

    public void setUsePGSDKViewing(boolean value) {
        this.m_usePGSDKViewing = value;
    }

    public boolean getUsePGSDKViewing() {
        return this.m_usePGSDKViewing;
    }

    public int getNPatternFill(IdentObj identObj) {
        Integer m_Obj = (Integer)this.getFromLook(identObj, Attr.NPatternFill);
        return m_Obj;
    }

    public void setNPatternFill(IdentObj identObj, int nPattern) {
        this.putToLook(identObj, Attr.NPatternFill, new Integer(nPattern));
    }

    public Paint getPaintObject(IdentObj identObj) {
        Paint m_Obj = (Paint)this.getFromLook(identObj, Attr.PaintObject);
        return m_Obj;
    }

    public void setPaintObject(IdentObj identObj, Paint newValue) {
        this.putToLook(identObj, Attr.PaintObject, newValue);
    }

    public Color getPatternBackground(IdentObj identObj) {
        Color m_Obj = (Color)this.getFromLook(identObj, Attr.PatternBackground);
        return m_Obj;
    }

    public void setPatternBackground(IdentObj identObj, Color bg) {
        this.putToLook(identObj, Attr.PatternBackground, bg);
    }

    public int getPieSliceValueLabelPosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieSliceValueLabelPosition);
        return m_Obj;
    }

    public void setPieSliceValueLabelPosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieSliceValueLabelPosition, new Integer(newValue));
    }

    public int getPieSliceLabelPosition() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieSliceLabelPosition);
        return m_Obj;
    }

    public void setPieSliceLabelPosition(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieSliceLabelPosition, new Integer(newValue));
    }

    public int getPieValueFormat() {
        Integer m_Obj = (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.PieValueFormat);
        return m_Obj;
    }

    public void setPieValueFormat(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.PieValueFormat, new Integer(newValue));
    }

    public double getMaxBubbleSize() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.MaxBubbleSize);
        return m_Obj;
    }

    public void setMaxBubbleSize(double newValue) {
        this.putToLook(new IdentObj(2000), Attr.MaxBubbleSize, new Double(newValue));
    }

    public double getMinBubbleSize() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.MinBubbleSize);
        return m_Obj;
    }

    public void setMinBubbleSize(double newValue) {
        this.putToLook(new IdentObj(2000), Attr.MinBubbleSize, new Double(newValue));
    }

    public boolean getGridUnitAuto(IdentObj objectID) {
        Boolean m_Obj = (Boolean)this.getFromLook(objectID, Attr.GridUnitAuto);
        return m_Obj;
    }

    public void setGridUnitAuto(IdentObj objectID, boolean newValue) {
        this.putToLook(objectID, Attr.GridUnitAuto, new Boolean(newValue));
    }

    public int getGridUnitCount(IdentObj objectID) {
        Integer m_Obj = (Integer)this.getFromLook(objectID, Attr.GridUnitCount);
        return m_Obj;
    }

    public void setGridUnitCount(IdentObj objectID, int newValue) {
        this.putToLook(objectID, Attr.GridUnitCount, new Integer(newValue));
    }

    public boolean getBreakAbsoluteLines() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.BreakAbsoluteLines);
        return m_Obj;
    }

    public void setBreakAbsoluteLines(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.BreakAbsoluteLines, new Boolean(newValue));
    }

    public boolean getBreakStackedLines() {
        Boolean m_Obj = (Boolean)this.getFromLook(Identity.ID_GLOBAL, Attr.BreakStackedLines);
        return m_Obj;
    }

    public void setBreakStackedLines(boolean newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.BreakStackedLines, new Boolean(newValue));
    }

    public void setCvomSettings(ICVOMSettings cvomSettings) {
        this.cvomSettings = cvomSettings;
    }

    public IdentObj getUserLine(int number) {
        switch (number) {
            case 0: {
                return Identity.UserLine1;
            }
            case 1: {
                return Identity.UserLine2;
            }
            case 2: {
                return Identity.UserLine3;
            }
            case 3: {
                return Identity.UserLine4;
            }
        }
        return null;
    }

    public void setColorHighlight(int series, int group, Color c) {
        this.putToLook(this.getSeriesGroup(series, group), Attr.ColorHighlight, c);
    }

    public void setColorHighlight(int series, Color c) {
        this.putToLook(this.getSeries(series), Attr.ColorHighlight, c);
    }

    public Color getColorHighlight(int s, int g) {
        return (Color)this.getFromLook1(this.getSeriesGroup(s, g), Attr.ColorHighlight);
    }

    public Color getColorHighlight(int series) {
        return (Color)this.getFromLook(this.getSeries(series), Attr.ColorHighlight);
    }

    public void setPlaceLocation(IdentObj objectID, PlaceMode mode) {
        this.putToLook(objectID, Attr.PlaceLocation, (Object)mode);
    }

    public PlaceMode getPlaceLocation(IdentObj objectID) {
        return (PlaceMode)((Object)this.getFromLook(objectID, Attr.PlaceLocation));
    }

    public void setAutoPlacmentMask(int newValue) {
        this.putToLook(Identity.ID_GLOBAL, Attr.AutoPlacementMask, new Integer(newValue));
    }

    public int getAutoPlacmentMask() {
        return (Integer)this.getFromLook(Identity.ID_GLOBAL, Attr.AutoPlacementMask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RiserType3D {
        Default,
        Bar3D,
        ColumnArea,
        ColumnLine,
        RowArea,
        RowLine,
        Cube,
        Sphere,
        CutCorner,
        Diamond,
        Octagon,
        Pyramid,
        Cone,
        Cylinder;

    }
}

