/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.converter;

import com.businessobjects.visualization.pfjgraphics.rendering.common.ChartNotSupportedException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AnodeInfoRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AreaInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.AxisLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BLADepthClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.BoxInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.ColorInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.DLook;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.DataAxisClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.FontInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.FontNameInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Graph;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphLoader;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphPresetType;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.LineInstRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.Look;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.PatternTable;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.RGB16;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.SerDepDataClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.SerDepLookClass;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TTFLoadException;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.TimeAxisRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.UserLineRec;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.AdvancedWashRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.LayerStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.sfx.PictureRecord;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.TTFNumberFormatCallback;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.GraphicsUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceMode;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.AnnotationType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.MathUtilities;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.io.DataInputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GraphConverter {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.converter.GraphConverter");
    private Graph graph;
    private Perspective perspective;
    public static final double xScale = 0.9766221082829762;
    public static final double yScale = 0.9766221082829762;
    private static final int BQUADRATICREGRESS = 1;
    private static final int BMODIFIEDHYPERBOLIC = 2;
    private static final int BRATIONAL = 4;
    private static final int BLOGQUADRATIC = 8;
    private static final int BHYPERBOLIC = 16;
    private static final int BMODIFIEDEXPONENTIAL = 32;
    private static final int MAX_DASH_STYLE = 15;
    private static final int[][] DASH_STYLE = new int[][]{{1, 39, 0, 0, 0, 0, 0, 0, 0}, {2, 21, 10, 0, 0, 0, 0, 0, 0}, {2, 3, 3, 0, 0, 0, 0, 0, 0}, {4, 23, 8, 3, 8, 0, 0, 0, 0}, {6, 21, 5, 3, 5, 3, 5, 0, 0}, {2, 9, 2, 0, 0, 0, 0, 0, 0}, {2, 3, 8, 0, 0, 0, 0, 0, 0}, {2, 30, 10, 0, 0, 0, 0, 0, 0}, {2, 10, 10, 0, 0, 0, 0, 0, 0}, {6, 3, 8, 3, 8, 3, 17, 0, 0}, {6, 12, 8, 12, 8, 3, 8, 0, 0}, {8, 12, 5, 12, 5, 3, 5, 3, 5}, {4, 25, 10, 10, 10, 0, 0, 0, 0}, {6, 25, 5, 8, 5, 8, 5, 0, 0}, {6, 35, 10, 35, 10, 10, 10, 0, 0}, {8, 37, 5, 37, 5, 8, 5, 8, 5}};
    static final int PFJ_BAR = 1;
    static final int PFJ_LINE = 2;
    static final int PFJ_AREA = 3;
    public static final int SIZE = 1;
    public static final int WALL = 2;
    public static final int TRANSLATE = 3;
    public static final int VIEW_XY = 4;
    public static final int VIEW_Z = 5;
    public static final int PAN = 6;
    public static final int LIGHTSOURCE = 7;

    public static byte[] LoadChart(DataInputStream input, Perspective chart) throws TTFLoadException, ChartNotSupportedException {
        GraphLoader loader = new GraphLoader(input);
        loader.loadChart();
        GraphConverter c = new GraphConverter(loader.pGraph, chart);
        c.convertToPerspective();
        chart.setMissingTextures(loader.getMissingTextures());
        return loader.getSkippedRecords();
    }

    public static PerspectiveSummary loadPerspectiveSummary(DataInputStream input) throws TTFLoadException, ChartNotSupportedException {
        GraphLoader loader = new GraphLoader(input);
        loader.setSkipRecordsMode();
        loader.loadChart(true);
        GraphConverter c = new GraphConverter(loader.pGraph);
        PerspectiveSummary perspectiveSummary = c.convertToPerspectiveSummary();
        perspectiveSummary.numMissingTextures = loader.getMissingTextures();
        return perspectiveSummary;
    }

    public static void LoadSkippedRecords(DataInputStream input, Perspective chart) throws TTFLoadException, ChartNotSupportedException {
        GraphLoader loader = new GraphLoader(input);
        loader.loadChart();
        GraphConverter c = new GraphConverter(loader.pGraph, chart);
        c.convertToPerspective();
    }

    GraphConverter(Graph g, Perspective p) {
        this.graph = g;
        this.perspective = p;
    }

    GraphConverter(Graph g) {
        this.graph = g;
    }

    void useTestData(boolean useIt) {
        if (!useIt) {
            return;
        }
        boolean a = true;
        if (!a) {
            this.perspective.setData(0, 0, 100.0);
            this.perspective.setData(0, 1, 200.0);
            this.perspective.setData(0, 2, 300.0);
            this.perspective.setData(0, 3, 400.0);
            this.perspective.setData(1, 0, 200.0);
            this.perspective.setData(1, 1, 300.0);
            this.perspective.setData(1, 2, 400.0);
            this.perspective.setData(1, 3, 500.0);
            this.perspective.setData(2, 0, 300.0);
            this.perspective.setData(2, 1, 400.0);
            this.perspective.setData(2, 2, 500.0);
            this.perspective.setData(2, 3, 600.0);
            this.perspective.setDataRangeToExtent();
            this.perspective.setGroupLabel(0, "BC");
            this.perspective.setGroupLabel(1, "CA");
            this.perspective.setGroupLabel(2, "NY");
            this.perspective.setGroupLabel(3, "WA");
            this.perspective.setSeriesLabel(0, "2000");
            this.perspective.setSeriesLabel(1, "2001");
            this.perspective.setSeriesLabel(2, "2002");
            this.perspective.setY1TitleString("Data Title");
            this.perspective.setX1TitleString("Data Title");
            this.perspective.setO1TitleString("Data Title");
            this.perspective.setFootnoteString("Footnote");
        }
        if (a) {
            this.perspective.setY1TitleString("Data Title");
            this.perspective.setData(0, 0, 100.0);
            this.perspective.setData(0, 1, 200.0);
            this.perspective.setData(0, 2, 300.0);
            this.perspective.setDataRangeToExtent();
            this.perspective.setSeriesLabel(0, "BC");
            this.perspective.setGroupLabel(0, "2000");
            this.perspective.setGroupLabel(1, "2001");
            this.perspective.setGroupLabel(2, "2002");
            this.perspective.setY1TitleString("Data Title");
            this.perspective.setX1TitleString("Data Title");
            this.perspective.setO1TitleString("Data Title");
            this.perspective.setFootnoteString("Footnote");
        }
    }

    PerspectiveSummary convertToPerspectiveSummary() throws ChartNotSupportedException {
        PerspectiveSummary perspectiveSummary = new PerspectiveSummary();
        perspectiveSummary.seriesAreSwapped = !this.graph.DLObj.bAxisSwap;
        perspectiveSummary.jChartType = this.convertGraphType();
        JGraphType graphType = JGraphType.getJGraphType(perspectiveSummary.jChartType);
        perspectiveSummary.isNumericAxis = this.graph.TimeAxis.bXYData && !graphType.isGanttType();
        perspectiveSummary.isDateTimeAxis = this.graph.TimeAxis.bShowTimeAxis;
        return perspectiveSummary;
    }

    void convertToPerspective() throws ChartNotSupportedException {
        this.perspective.setUsePGSDKViewing(true);
        this.useTestData(false);
        this.convertTextAutofit();
        this.convertChartType();
        this.convert2DHalfMode();
        this.convertLegend();
        this.convertBackground();
        this.convertRisers();
        this.convertSeriesGroupMisc();
        this.convertAxis();
        this.convertMarkerShapeAndSize();
        this.convertFrame();
        this.convertAnnotations();
        this.convertTrendlines();
        this.convertDataText();
        this.convertMisc();
        this.convertUserLines();
        this.convertBar();
        this.convertPie();
        this.convertStock();
        this.convertScatter();
        this.convert3DChart();
        this.convertBubble();
        this.convertFunnel();
        this.convertGauge();
        this.convertGantt();
        this.convertSFX();
        this.convertHistogram();
    }

    void convertSkippedRecords() throws ChartNotSupportedException {
        this.convertBackground();
        this.convertRisers();
        this.convertSeriesGroupMisc();
        this.convertMarkerShapeAndSize();
        this.convertFrame();
        this.convertTrendlines();
        this.convertDataText();
        this.convertUserLines();
        this.convertPie();
        this.convertSFX();
    }

    private void convertUserLines() {
        this.convertUserLine(this.graph.UserLine1, 0);
        this.convertUserLine(this.graph.UserLine2, 1);
        this.convertUserLine(this.graph.UserLine3, 2);
        this.convertUserLine(this.graph.UserLine4, 3);
    }

    private void convertUserLine(UserLineRec userLineRec, int number) {
        if (userLineRec == null) {
            return;
        }
        IdentObj customLineID = this.perspective.getUserLine(number);
        this.perspective.setDisplay(customLineID, userLineRec.bShowLine);
        this.perspective.setUserLineValue(customLineID, userLineRec.value);
        this.perspective.setUserLineAxis(customLineID, this.convertUserLineAxis(userLineRec.nAxisID));
        this.setLineAttributes(customLineID, userLineRec.LineInst, false);
    }

    private int convertUserLineAxis(int axisID) {
        switch (axisID) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 8;
            }
        }
        return -1;
    }

    private void convertSFX() {
        Look look = this.graph.LObj;
        this.convertSFX(Identity.Frame, look.getArea(3));
        this.convertSFX(Identity.PieFrame, look.getArea(3));
        this.convertSFX(Identity.FrameSide, look.getArea(3));
        this.convertSFX(Identity.FrameBottom, look.getArea(3));
        this.convertSFX(Identity.LegendArea, look.getArea(2));
        this.convertSFX(Identity.ChartBackground, look.getArea(1));
        this.convertSFX(Identity.CubeFloor, look.getArea(28));
        this.convertSFX(Identity.CubeLeftWall, look.getArea(28));
        this.convertSFX(Identity.CubeRightWall, look.getArea(28));
        for (int i = 0; i < this.graph.LObj.vaRiserColors.size(); ++i) {
            AreaInstRec area = this.graph.LObj.vaRiserColors.getAt(i);
            this.convertSFX(this.perspective.getSeries(i), area);
        }
    }

    private void convertSFX(IdentObj identObj, AreaInstRec area) {
        if (null == area) {
            return;
        }
        this.convertPatternFill(identObj, area);
        ColorInstRec color = area.color;
        if (null == color || !color.useMaytag) {
            return;
        }
        LayerStruct[] layer = color.hMaytag.aLayer;
        for (int i = 0; i < color.hMaytag.layerCount; ++i) {
            Object sfxType = layer[i].effectRecord;
            if (sfxType == null) continue;
            if (sfxType instanceof AdvancedWashRecord) {
                this.convertGradientObject(identObj, (AdvancedWashRecord)sfxType);
            }
            if (!(sfxType instanceof PictureRecord)) continue;
            this.convertPictureObject(identObj, (PictureRecord)sfxType);
        }
    }

    private void convertPictureObject(IdentObj identObj, PictureRecord picture) {
        if (this.graph.universalPictureStructMap.containsKey(picture.pictName)) {
            this.perspective.setFillType(identObj, 3);
            this.perspective.setTextureImage(identObj, this.graph.universalPictureStructMap.get(picture.pictName));
            this.perspective.setTextureFlipMode(identObj, this.convertTextureFlip(picture.pictFlip));
            this.perspective.setTextureDisplayMode(identObj, this.convertTextureScale(picture.pictScale));
        }
    }

    private int convertTextureFlip(int flip) {
        if (flip == 1) {
            flip = 2;
        } else if (flip == 2) {
            flip = 1;
        }
        return flip;
    }

    private int convertTextureScale(int value) {
        if (value == 1) {
            return 2;
        }
        if (value > 3) {
            return 0;
        }
        return 1;
    }

    private void convertGradientObject(IdentObj identObj, AdvancedWashRecord washRecord) {
        int roundedAngle = (int)Math.round((double)washRecord.nAngle / 45.0) * 45;
        int gradientDirection = this.convertGradientDirection(washRecord, roundedAngle);
        int numPins = this.convertNumPins(washRecord, roundedAngle);
        double[] pin = this.convertPinPositions(washRecord, roundedAngle, numPins);
        Color[] color = this.convertColors(washRecord, roundedAngle, numPins);
        this.perspective.setFillType(identObj, 2);
        this.perspective.setGradientDirection(identObj, gradientDirection);
        this.perspective.setGradientNumPins(identObj, numPins);
        for (int i = 0; i < numPins; ++i) {
            this.perspective.setGradientPinPosition(identObj, pin[i], i);
            this.perspective.setGradientPinLeftColor(identObj, color[i], i);
            this.perspective.setGradientPinRightColor(identObj, color[i], i);
        }
    }

    private Color[] convertColors(AdvancedWashRecord washRecord, int roundedAngle, int numPins) {
        Color endColor;
        Color[] colors = new Color[numPins];
        Color startColor = this.WriteJAVA_ScaleColor(washRecord.startColor);
        colors[0] = endColor = this.WriteJAVA_ScaleColor(washRecord.endColor);
        colors[1] = startColor;
        if (numPins == 3) {
            colors[2] = endColor;
            return colors;
        }
        switch (washRecord.nWashType) {
            case 14: {
                switch (roundedAngle) {
                    case 0: 
                    case 180: 
                    case 360: {
                        if (washRecord.nOffsetX != 0) break;
                        colors[1] = endColor;
                        colors[0] = startColor;
                        break;
                    }
                    case 45: 
                    case 225: {
                        if (washRecord.nOffsetX - washRecord.nOffsetY != -100) break;
                        colors[1] = endColor;
                        colors[0] = startColor;
                        break;
                    }
                    case 90: 
                    case 270: {
                        if (washRecord.nOffsetY != 0) break;
                        colors[1] = endColor;
                        colors[0] = startColor;
                        break;
                    }
                    case 135: 
                    case 315: {
                        if (washRecord.nOffsetX != 0 || washRecord.nOffsetY != 0) break;
                        colors[1] = endColor;
                        colors[0] = startColor;
                    }
                }
                break;
            }
            case 9: {
                colors[1] = endColor;
                colors[0] = startColor;
                break;
            }
            case 10: {
                colors[1] = endColor;
                colors[0] = startColor;
                break;
            }
        }
        return colors;
    }

    private double[] convertPinPositions(AdvancedWashRecord washRecord, int roundedAngle, int numPins) {
        double[] pinPositions = new double[numPins];
        block0 : switch (washRecord.nWashType) {
            case 9: 
            case 10: 
            case 14: {
                pinPositions[0] = 0.0;
                if (numPins == 2) {
                    pinPositions[1] = 1.0;
                    break;
                }
                pinPositions[2] = 1.0;
                switch (roundedAngle) {
                    case 0: 
                    case 180: 
                    case 360: {
                        pinPositions[1] = (double)washRecord.nOffsetX / 100.0;
                        break block0;
                    }
                    case 45: 
                    case 225: {
                        pinPositions[1] = ((double)(washRecord.nOffsetX - washRecord.nOffsetY) / 2.0 + 50.0) / 100.0;
                        break block0;
                    }
                    case 90: 
                    case 270: {
                        pinPositions[1] = (double)washRecord.nOffsetY / 100.0;
                        break block0;
                    }
                    case 135: 
                    case 315: {
                        pinPositions[1] = (double)(washRecord.nOffsetX + washRecord.nOffsetY) / 2.0 / 100.0;
                    }
                }
            }
        }
        return pinPositions;
    }

    private int convertNumPins(AdvancedWashRecord washRecord, int roundedAngle) {
        int numPins = 2;
        switch (washRecord.nWashType) {
            case 14: {
                switch (roundedAngle) {
                    case 0: 
                    case 180: 
                    case 360: {
                        if (washRecord.nOffsetX <= 0 || washRecord.nOffsetX >= 100) break;
                        ++numPins;
                        break;
                    }
                    case 45: 
                    case 225: {
                        if (Math.abs(washRecord.nOffsetX - washRecord.nOffsetY) == 100) break;
                        ++numPins;
                        break;
                    }
                    case 90: 
                    case 270: {
                        if (washRecord.nOffsetY <= 0 || washRecord.nOffsetY >= 100) break;
                        ++numPins;
                        break;
                    }
                    case 135: 
                    case 315: {
                        if (washRecord.nOffsetX == 0 && washRecord.nOffsetY == 0 && (washRecord.nOffsetX != 100 || washRecord.nOffsetY != 100)) break;
                        ++numPins;
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        return numPins;
    }

    private int convertGradientDirection(AdvancedWashRecord washRecord, int roundedAngle) {
        int gradientDirection = 1;
        switch (washRecord.nWashType) {
            case 14: {
                switch (roundedAngle) {
                    case 0: 
                    case 180: 
                    case 360: {
                        gradientDirection = 1;
                        break;
                    }
                    case 45: 
                    case 225: {
                        gradientDirection = 5;
                        break;
                    }
                    case 90: 
                    case 270: {
                        gradientDirection = 3;
                        break;
                    }
                    case 135: 
                    case 315: {
                        gradientDirection = 7;
                    }
                }
                break;
            }
            case 9: {
                if (washRecord.nOffsetX <= 25 && washRecord.nOffsetY <= 25) {
                    gradientDirection = 10;
                    break;
                }
                if (washRecord.nOffsetX <= 25 && washRecord.nOffsetY >= 75) {
                    gradientDirection = 12;
                    break;
                }
                if (washRecord.nOffsetX >= 75 && washRecord.nOffsetY <= 25) {
                    gradientDirection = 11;
                    break;
                }
                if (washRecord.nOffsetX >= 75 && washRecord.nOffsetY >= 75) {
                    gradientDirection = 13;
                    break;
                }
                gradientDirection = 9;
                break;
            }
            case 10: {
                gradientDirection = 14;
                break;
            }
        }
        return gradientDirection;
    }

    private void convertAxis() throws ChartNotSupportedException {
        JGraphType graphType = this.getCurrentGraphType();
        boolean useTimeScale = false;
        boolean useNumericScale = false;
        boolean usePGSDKTimeScale = false;
        if (this.graph.TimeAxis.bXYData && !graphType.isGanttType()) {
            useNumericScale = true;
        }
        if (this.graph.TimeAxis.bShowTimeAxis) {
            if (graphType.isBLAType() || graphType.isGanttType()) {
                usePGSDKTimeScale = true;
            } else {
                useTimeScale = true;
            }
        }
        this.perspective.setUsePGSDKTimeScaleAxis(usePGSDKTimeScale);
        this.perspective.setUseTimeScaleAxis(useTimeScale);
        this.perspective.setUseNumericScaleAxis(useNumericScale);
        boolean isTimeScaleX = usePGSDKTimeScale && graphType.isBLAType();
        boolean isTimeScaleY = usePGSDKTimeScale && graphType.isGanttType();
        this.convertX1Axis(isTimeScaleX);
        this.convertY1Axis(isTimeScaleY);
        this.convertY2Axis();
        this.convertO1Axis();
        this.convertO2Axis();
        this.perspective.setScaleFromZero(this.graph.LObj.nDrawBase != 1);
        this.convert2DGridlines();
    }

    private void convertScatter() {
        this.perspective.setDataTextTemplateScatter("([X], [Y])");
    }

    private void convertAnnotations() {
        int numAnnotations = this.graph.annotations.size();
        this.perspective.setNumAnnotations(numAnnotations);
        block10: for (int i = 0; i < numAnnotations; ++i) {
            IdentObj annodeId = this.perspective.getAnnotation(i);
            AnodeInfoRec anAnnotation = (AnodeInfoRec)this.graph.annotations.get(i);
            Rectangle convertedBounds = this.WriteJAVA_TransformRect(anAnnotation.bounds);
            this.perspective.setRect(annodeId, convertedBounds);
            this.perspective.setAnnotationType(annodeId, AnnotationType.fromInt(anAnnotation.NodeType));
            this.perspective.setAnnotationOrder(annodeId, anAnnotation.linkSeries);
            this.perspective.setLineWidth(annodeId, this.convertAnnotationLineWidth(anAnnotation.pLine.nThick));
            this.perspective.setBorderColor(annodeId, this.WriteJAVA_ScaleColor(anAnnotation.pLine.color));
            this.perspective.setFillColor(annodeId, this.WriteJAVA_ScaleColor(anAnnotation.pArea.color));
            this.perspective.setTransparentFillColor(annodeId, anAnnotation.pArea.color.nSpectrumBin == 9999);
            this.perspective.setTransparentBorderColor(annodeId, anAnnotation.pLine.color.nSpectrumBin == 9999);
            switch (anAnnotation.NodeType) {
                case 9: {
                    this.setTextAttributes(anAnnotation.pFont, annodeId);
                    this.perspective.setTextString(annodeId, anAnnotation.text.text);
                    continue block10;
                }
                case 2: 
                case 7: {
                    continue block10;
                }
                case 5: {
                    this.perspective.addAnnotationObject(annodeId, this.convertPoint(anAnnotation.line.p1));
                    this.perspective.addAnnotationObject(annodeId, this.convertPoint(anAnnotation.line.p2));
                    continue block10;
                }
                case 0: {
                    this.perspective.addAnnotationObject(annodeId, this.convertPoint(anAnnotation.arrow.p0));
                    this.perspective.addAnnotationObject(annodeId, this.convertPoint(anAnnotation.arrow.p1));
                    this.perspective.setArrowHeadLength(annodeId, anAnnotation.arrow.headSides);
                    continue block10;
                }
                case 3: {
                    this.perspective.setAnnotationType(annodeId, AnnotationType.fromInt(18));
                }
                case 18: {
                    int j;
                    for (j = 0; j < anAnnotation.poly.numPoints; ++j) {
                        this.perspective.addAnnotationObject(annodeId, this.convertPoint(anAnnotation.poly.polyPoints[j]));
                    }
                    continue block10;
                }
                case 6: {
                    int j;
                    Polygon polygon = new Polygon();
                    for (j = 0; j < anAnnotation.poly.numPoints; ++j) {
                        Point point = this.convertPoint(anAnnotation.poly.polyPoints[j]);
                        polygon.addPoint(point.x, point.y);
                    }
                    this.perspective.addAnnotationObject(annodeId, polygon);
                    continue block10;
                }
                case 17: {
                    double startAngle = this.convertArcStartAngle(this.convertPoint(anAnnotation.wedge.ptStart), convertedBounds);
                    double arcLength = this.convertArcLength(startAngle, this.convertPoint(anAnnotation.wedge.ptEnd), convertedBounds);
                    this.perspective.addAnnotationObject(annodeId, new Integer((int)Math.toDegrees(startAngle)));
                    this.perspective.addAnnotationObject(annodeId, new Integer((int)Math.toDegrees(arcLength)));
                    continue block10;
                }
            }
        }
    }

    private double convertArcLength(double startAngle, Point endArc, Rectangle arcbox) {
        double y;
        double x = (double)endArc.x - arcbox.getCenterX();
        double endAngle = MathUtilities.calcAngle((int)x, (int)(y = (double)endArc.y - arcbox.getCenterY()));
        if (endAngle < startAngle) {
            endAngle += Math.PI * 2;
        }
        return endAngle - startAngle;
    }

    private double convertArcStartAngle(Point startArc, Rectangle arcbox) {
        double x = (double)startArc.x - arcbox.getCenterX();
        double y = (double)startArc.y - arcbox.getCenterY();
        return MathUtilities.calcAngle((int)x, (int)y);
    }

    private float convertAnnotationLineWidth(int i) {
        return this.scaleLineWidthToPointSize(i, false);
    }

    private Point convertPoint(Point point) {
        point.x = (int)((double)point.x * 0.9766221082829762);
        point.y = (int)((double)point.y * 0.9766221082829762);
        return point;
    }

    private void convertTrendlines() {
        TrendlineSettings settings = this.perspective.getTrendlineSettings();
        int nNumItems = this.graph.DLObj.vaSerDep.size();
        for (int series = 0; series < nNumItems; ++series) {
            SerDepDataClass sd = (SerDepDataClass)this.graph.DLObj.vaSerDep.getAt(series);
            if (sd == null) continue;
            TrendlineType curveFitType = TrendlineType.FIT_NONE;
            if (sd.bCurv) {
                curveFitType = TrendlineType.FIT_SMOOTH;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bMovA) {
                curveFitType = TrendlineType.FIT_MOVINGAVG;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bConn) {
                curveFitType = TrendlineType.FIT_CONNECTED;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bMean) {
                curveFitType = TrendlineType.FIT_MEAN;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bStdD) {
                curveFitType = TrendlineType.FIT_STDDEV;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bLinRLine) {
                curveFitType = TrendlineType.FIT_LINEAR;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bLinRNaturalLog) {
                curveFitType = TrendlineType.FIT_LOGARITHMIC;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bLinRExp) {
                curveFitType = TrendlineType.FIT_EXPONENTIAL;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bLinRLog) {
                curveFitType = TrendlineType.FIT_GEOMETRIC;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            if (sd.bLinRNPoly) {
                settings.setPolynomialOrder(series, sd.nLinRNPolyFactor);
                curveFitType = TrendlineType.FIT_POLYNOMIAL;
                settings.setTrendlineType(series, curveFitType, curveFitType);
            }
            switch (sd.nDummy5) {
                case 1: {
                    curveFitType = TrendlineType.FIT_QUADRATIC;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                    break;
                }
                case 2: {
                    curveFitType = TrendlineType.FIT_MODHYPERBOLIC;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                    break;
                }
                case 4: {
                    curveFitType = TrendlineType.FIT_RATIONAL;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                    break;
                }
                case 8: {
                    curveFitType = TrendlineType.FIT_LOGQUADRATIC;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                    break;
                }
                case 16: {
                    curveFitType = TrendlineType.FIT_HYPERBOLIC;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                    break;
                }
                case 32: {
                    curveFitType = TrendlineType.FIT_MODEXPONENTIAL;
                    settings.setTrendlineType(series, curveFitType, curveFitType);
                }
            }
            settings.setColorAsSeries(this.graph.LObj.bCurveColorAsSeries != 0);
            settings.setSciMovAvg(this.graph.LObj.bSciMovAvg == 0);
            settings.setCurveMoving(this.graph.LObj.nCurveMoving);
            settings.setSmoothFactor(this.graph.LObj.nCurveSmooth);
            if (curveFitType == TrendlineType.FIT_NONE) continue;
            IdentObj curveFitEquationText = TrendlineSettings.getEquationText(series);
            IdentObj curveFitCorrelationText = TrendlineSettings.getCorrelationText(series);
            this.perspective.setRect(curveFitEquationText, this.WriteJAVA_TransformRect(sd.biCurveText));
            this.perspective.setDisplay(curveFitEquationText, sd.bShowFormula);
            this.perspective.setDisplay(curveFitCorrelationText, sd.bShowCorr);
            SerDepLookClass sdlc = this.graph.LObj.vaSerDepLook.getAt(series);
            IdentObj lineRiserID = TrendlineSettings.getLineRiser(series);
            this.setTextAttributes(sdlc.pFont, curveFitEquationText);
            if (this.graph.LObj.bCurveColorAsSeries == 0) {
                this.setLineColor(lineRiserID, sdlc.pLine.color);
            } else {
                this.setLineColor(lineRiserID, this.graph.LObj.vaRiserColors.getAt((int)series).color);
            }
            this.setLineDash(lineRiserID, sdlc.pLine);
            this.setLineWidth(lineRiserID, sdlc.pLine);
            int borderStyle = this.convertBorderStyle(sdlc.pFont.FancyBoxInfo.nStyle);
            if (borderStyle != 0) {
                IdentObj boxID = TrendlineSettings.getEquationTextBox(series);
                this.setBorderAttributes(boxID, borderStyle, 200);
                this.setFillColor(boxID, sdlc.pFont.FancyBoxArea.color);
                this.setLineAttributes(boxID, sdlc.pFont.FancyBoxLine, false);
                this.convertSFX(boxID, sdlc.pFont.FancyBoxArea);
            }
            if (settings.getTrendlineType(series, TrendlineType.FIT_CONNECTED) == TrendlineType.FIT_NONE) continue;
            LineInstRec lineInst = this.graph.LObj.vaRiserBorders.getAt(series + 1);
            IdentObj curveId = TrendlineSettings.getLineRiser(series, TrendlineType.FIT_CONNECTED);
            this.setLineDash(curveId, lineInst);
            this.setLineWidth(curveId, lineInst);
            this.setLineColor(curveId, lineInst.color);
        }
    }

    private void convert3DChart() {
        if (!this.perspective.isChart3DType()) {
            return;
        }
        Look look = this.graph.LObj;
        int[][] showGrid = look.Grid3D;
        this.perspective.setGrid3DFloorDisplayX(showGrid[1][0] != 0);
        this.perspective.setGrid3DFloorDisplayZ(showGrid[1][2] != 0);
        this.perspective.setGrid3DLeftWallDisplayY(showGrid[0][1] != 0);
        this.perspective.setGrid3DLeftWallDisplayZ(showGrid[0][2] != 0);
        this.perspective.setGrid3DRightWallDisplayX(showGrid[2][0] != 0);
        this.perspective.setGrid3DRightWallDisplayY(showGrid[2][1] != 0);
        this.perspective.setDisplay3DLeftWall(look.ShowWall[0] == 1);
        this.perspective.setDisplay3DRightWall(look.ShowWall[2] == 1);
        this.perspective.setDisplay3DFloor(look.ShowWall[1] == 1);
        this.perspective.setGrid3DRiserDisplayX(false);
        this.perspective.setGrid3DRiserDisplayY(false);
        this.perspective.setGrid3DRiserDisplayZ(false);
        this.setTextAttributes(look.Font3D[1].FontInst, Identity.O1Label);
        this.setTextAttributes(look.Font3D[0].FontInst, Identity.O2Label);
        this.setTextAttributes(look.Font3D[2].FontInst, Identity.Y1Label);
        this.setTextAttributes(look.Font3D[5].FontInst, Identity.O1Title);
        this.setTextAttributes(look.Font3D[4].FontInst, Identity.O2Title);
        this.setTextAttributes(look.Font3D[6].FontInst, Identity.Y1Title);
        this.setTextAttributes(look.Font3D[7].FontInst, Identity.Y2Title);
        this.perspective.setRect(Identity.Y1Title, this.WriteJAVA_TransformRect(look.LocateLYTitle));
        this.perspective.setRect(Identity.Y2Title, this.WriteJAVA_TransformRect(look.LocateRYTitle));
        this.perspective.setRect(Identity.O1Title, this.WriteJAVA_TransformRect(look.LocateColTitle));
        this.perspective.setRect(Identity.O2Title, this.WriteJAVA_TransformRect(look.LocateRowTitle));
        boolean rightNumbers = look.Font3D[3].ShowMe;
        boolean leftNumbers = look.Font3D[2].ShowMe;
        boolean o2Display = look.Font3D[0].ShowMe;
        boolean o1Display = look.Font3D[1].ShowMe;
        if (leftNumbers & !rightNumbers) {
            this.perspective.setY1AxisSide(0);
        } else if (!leftNumbers & rightNumbers) {
            this.perspective.setY1AxisSide(1);
        } else if (leftNumbers & rightNumbers) {
            this.perspective.setY1AxisSide(2);
        } else {
            this.perspective.setY1LabelDisplay(false);
        }
        this.perspective.setO1LabelDisplay(o1Display);
        this.perspective.setO2LabelDisplay(o2Display);
        int o1LabelSkipCount = this.graph.LObj.Z1Axis.nLabelSkip;
        int o2LabelSkipCount = this.graph.LObj.X1Axis.nLabelSkip;
        if (this.graph.LObj.Z1Axis.nOrdLabelMode == 2 && o1LabelSkipCount > 0) {
            this.perspective.setO1LabelAutoSkip(2);
            this.perspective.setO1LabelSkipBegin(0);
            this.perspective.setO1LabelSkipCount(o1LabelSkipCount - 1);
        } else {
            this.perspective.setO1LabelAutoSkip(1);
        }
        if (this.graph.LObj.X1Axis.nOrdLabelMode == 2 && o2LabelSkipCount > 0) {
            this.perspective.setO2LabelAutoSkip(2);
            this.perspective.setO2LabelSkipBegin(0);
            this.perspective.setO2LabelSkipCount(o2LabelSkipCount - 1);
        } else {
            this.perspective.setO2LabelAutoSkip(1);
        }
        if (this.perspective.getGraphType() == 12) {
            this.perspective.setDataTextDisplay(false);
        }
        this.setAreaAttributes(Identity.CubeFloor, 28, 29);
        this.setAreaAttributes(Identity.CubeLeftWall, 28, 29);
        this.setAreaAttributes(Identity.CubeRightWall, 28, 29);
        this.setLineAttributes(Identity.O1MajorGrid, this.graph.LObj.LineColors[22], true);
        this.setLineAttributes(Identity.O2MajorGrid, this.graph.LObj.LineColors[24], true);
        double[][] m = look.fMatrix.value;
        Matrix3d matrix3d = new Matrix3d(m[0][0], m[0][1], -m[0][2], m[1][0], m[1][1], -m[1][2], -m[2][0], -m[2][1], m[2][2]);
        double vx = look.Viewer.x;
        double vy = look.Viewer.y;
        double vz = look.Viewer.z;
        double px = look.xPan;
        double py = look.yPan;
        double tx = m[3][0];
        double ty = m[3][1];
        double tz = m[3][2];
        double sx = look.Size3D.x;
        double sy = look.Size3D.y;
        double sz = look.Size3D.z;
        double wx = look.Wall3D.x;
        double wy = look.Wall3D.y;
        double wz = look.Wall3D.z;
        this.perspective.setCubeIsometricProjection(false);
        this.perspective.setCubeLightSourceX(0.0);
        this.perspective.setCubeLightSourceY(40.0);
        this.perspective.setCubeLightSourceZ(100.0);
        this.perspective.setCubePanX(px);
        this.perspective.setCubePanY(py);
        this.perspective.setCubeRotationMatrix(matrix3d);
        this.perspective.setCubeSizeX(sx);
        this.perspective.setCubeSizeY(sy);
        this.perspective.setCubeSizeZ(sz);
        this.perspective.setCubeTranslationX(tx);
        this.perspective.setCubeTranslationY(ty);
        this.perspective.setCubeTranslationZ(-tz);
        this.perspective.setCubeViewerX(vx);
        this.perspective.setCubeViewerY(vy);
        this.perspective.setCubeViewerZ(-vz);
        this.perspective.setCubeWallThickX(wx);
        this.perspective.setCubeWallThickY(wy);
        this.perspective.setCubeWallThickZ(wz);
        this.perspective.setCubeZoomFactor(1.0);
    }

    private void setFormattingProperties() {
        DLook dlook = this.graph.DLObj;
        this.perspective.setX1LabelFormat(this.convertAdvFormat(dlook.X1Data.AdvStdFormat, dlook.X1Data.nStdFormat), dlook.X1Data.AdvStdFormat.isAlwaysLocalized());
        this.perspective.setX1DataTextFormat(this.convertAdvFormat(dlook.X1Data.AdvStdFormatDTXT, dlook.X1Data.nStdFormatDTXT), dlook.X1Data.AdvStdFormatDTXT.isAlwaysLocalized());
        this.perspective.setY1LabelFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormat, dlook.Y1Data.nStdFormat), dlook.Y1Data.AdvStdFormat.isAlwaysLocalized());
        this.perspective.setY1DataTextFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormatDTXT, dlook.Y1Data.nStdFormatDTXT), dlook.Y1Data.AdvStdFormatDTXT.isAlwaysLocalized());
        this.perspective.setY2LabelFormat(this.convertAdvFormat(dlook.Y2Data.AdvStdFormat, dlook.Y2Data.nStdFormat), dlook.Y2Data.AdvStdFormat.isAlwaysLocalized());
        this.perspective.setY2DataTextFormat(this.convertAdvFormat(dlook.Y2Data.AdvStdFormatDTXT, dlook.Y2Data.nStdFormatDTXT), dlook.Y2Data.AdvStdFormatDTXT.isAlwaysLocalized());
        this.perspective.setPieRingTotalTextFormat(this.convertAdvFormat(dlook.AdvStdFormatSum, dlook.nStdFormatSum), dlook.AdvStdFormatSum.isAlwaysLocalized());
        this.perspective.setPieRingTotalIsPercent(dlook.nStdFormatSum == 4);
        this.perspective.setPieSliceValueLabelTextFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormatDTXT, dlook.Y1Data.nStdFormatDTXT), dlook.Y1Data.AdvStdFormatDTXT.isAlwaysLocalized());
        if (this.getCurrentGraphType().isStockType()) {
            this.perspective.setY1DataTextFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormatDTXT, dlook.Y1Data.nStdFormatDTXT), dlook.Y1Data.AdvStdFormatDTXT.isAlwaysLocalized());
        } else if (this.getCurrentGraphType().isBubble() || this.getCurrentGraphType().isScatter()) {
            this.perspective.setX1DataTextFormat(this.convertAdvFormat(dlook.X1Data.AdvStdFormat, dlook.X1Data.nStdFormat), dlook.X1Data.AdvStdFormat.isAlwaysLocalized());
            this.perspective.setY1DataTextFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormat, dlook.Y1Data.nStdFormat), dlook.Y1Data.AdvStdFormat.isAlwaysLocalized());
            this.perspective.setZ1DataTextFormat(this.convertAdvFormat(dlook.Y1Data.AdvStdFormatDTXT, dlook.Y1Data.nStdFormatDTXT), dlook.Y1Data.AdvStdFormatDTXT.isAlwaysLocalized());
        }
    }

    private Format convertAdvFormat(AdvFormatStruct advFormatStruct, int nStdFormat) {
        if (advFormatStruct.formatType == 0) {
            if (nStdFormat == 1) {
                advFormatStruct.stdFormat = nStdFormat;
                advFormatStruct.isPercentGraph = this.getCurrentGraphType().isPercent();
            } else {
                this.PGSDKFormatToAdvFormatStruct(advFormatStruct, nStdFormat);
            }
        }
        return TTFNumberFormatCallback.createJavaFormat(advFormatStruct, this.perspective.getLocale());
    }

    private boolean convertExcludeLabel(int i, boolean max) {
        boolean MAX_ENDPOINT = true;
        int MIN_ENDPOINT = 2;
        int BOTH_ENDPOINTS = 3;
        if (max) {
            return i == 1 | i == 3;
        }
        return i == 2 | i == 3;
    }

    private void convert2DHalfMode() {
        BLADepthClass bla = this.graph.LObj.BLADepth;
        if (bla.nDepthMode == 1) {
            this.perspective.setDepthRadius(Math.min(Math.max(bla.nDepth, 0), 100));
            int angle = bla.nAngle;
            if (angle >= 0 & angle <= 180) {
                this.perspective.setDepthAngle(angle);
            }
        } else {
            this.perspective.setDepthRadius(0);
        }
    }

    private void convert2DGridlines() {
        Look look = this.graph.LObj;
        DLook dlook = this.graph.DLObj;
        if (this.perspective.hasX1()) {
            if (this.perspective.getUseTimeScaleAxis() || this.perspective.getUsePGSDKTimeScaleAxis()) {
                this.setNumericGridProperties(this.graph.LObj.O1Axis, null, Identity.X1MajorGrid, true);
                this.setNumericGridProperties(this.graph.LObj.O1Axis, null, Identity.X1MinorGrid, false);
                this.setLineAttributes(Identity.X1MinorGrid, 27);
                this.setLineAttributes(Identity.X1MajorGrid, 25);
            } else {
                this.setNumericGridProperties(look.X1Axis, dlook.X1Data, Identity.X1MajorGrid, true);
                this.setNumericGridProperties(look.X1Axis, dlook.X1Data, Identity.X1MinorGrid, false);
                this.setLineAttributes(Identity.X1MinorGrid, 10);
                this.setLineAttributes(Identity.X1MajorGrid, 9);
            }
        }
        this.setNumericGridProperties(look.Y1Axis, dlook.Y1Data, Identity.Y1MajorGrid, true);
        this.setNumericGridProperties(look.Y1Axis, dlook.Y1Data, Identity.Y1MinorGrid, false);
        this.setLineAttributes(Identity.Y1MinorGrid, 6);
        this.setLineAttributes(Identity.Y1MajorGrid, 5);
        this.setNumericGridProperties(look.Y2Axis, dlook.Y2Data, Identity.Y2MajorGrid, true);
        this.setNumericGridProperties(look.Y2Axis, dlook.Y2Data, Identity.Y2MinorGrid, false);
        this.setLineAttributes(Identity.Y2MinorGrid, 28);
        this.setLineAttributes(Identity.Y2MajorGrid, 26);
        if (this.perspective.hasO1()) {
            if (this.perspective.pgsdkToPfjO1MajorMinorGridlinesSwapped()) {
                this.setLineAttributes(Identity.O1MajorGrid, 27);
                this.setLineAttributes(Identity.O1MinorGrid, 25);
                if (look.O1Axis.MajorHashFrame.HashStyle != 0) {
                    this.perspective.setO1MinorGridStyle(look.O1Axis.MajorHashFrame.HashStyle - 1);
                }
                if (look.O1Axis.MinorHashFrame.HashStyle != 0) {
                    this.perspective.setO1MajorGridStyle(look.O1Axis.MinorHashFrame.HashStyle - 1);
                }
            } else {
                this.setLineAttributes(Identity.O1MinorGrid, 27);
                this.setLineAttributes(Identity.O1MajorGrid, 25);
                if (look.O1Axis.MajorHashFrame.HashStyle != 0) {
                    this.perspective.setO1MajorGridStyle(look.O1Axis.MajorHashFrame.HashStyle - 1);
                }
                if (look.O1Axis.MinorHashFrame.HashStyle != 0) {
                    this.perspective.setO1MinorGridStyle(look.O1Axis.MinorHashFrame.HashStyle - 1);
                }
            }
        }
    }

    private void setNumericGridProperties(AxisLookClass axis, DataAxisClass dataAxis, IdentObj objectID, boolean major) {
        int SHOW_GRIDLINES = major ? 4 : 8;
        int hashStyle = major ? axis.MajorHashFrame.HashStyle : axis.MinorHashFrame.HashStyle;
        boolean showGridlines = this.bitwiseAND(axis.nShowStatus, SHOW_GRIDLINES) && hashStyle != 0;
        this.perspective.setDisplay(objectID, showGridlines);
        if (hashStyle != 0) {
            this.perspective.setGridStyle(objectID, hashStyle - 1);
        }
        boolean isAuto = false;
        isAuto = dataAxis == null ? true : (major ? !axis.bUseGridStep : !dataAxis.bManualMinorHash);
        this.perspective.setGridStepAuto(objectID, isAuto);
        if (!isAuto) {
            if (major) {
                this.perspective.setGridStep(objectID, axis.fGridStep);
            } else {
                this.perspective.setGridCount(objectID, Math.max(1, axis.nMinorHash));
            }
        }
    }

    private void convertAxisScale(IdentObj axisID, DataAxisClass axisClass) {
        double min = axisClass.fManualScaleMin;
        double max = axisClass.fManualScaleMax;
        if (min > max) {
            min = axisClass.fManualScaleMax;
            max = axisClass.fManualScaleMin;
        }
        this.perspective.setLogScale(axisID, axisClass.bIsLog);
        switch (axisClass.nManualScale) {
            case 0: {
                this.perspective.setScaleMinAuto(axisID, true);
                this.perspective.setScaleMaxAuto(axisID, true);
                break;
            }
            case 1: {
                this.perspective.setScaleMinAuto(axisID, false);
                this.perspective.setScaleMaxAuto(axisID, false);
                this.perspective.setScaleMin(axisID, min);
                this.perspective.setScaleMax(axisID, max);
                break;
            }
            case 2: {
                this.perspective.setScaleMinAuto(axisID, false);
                this.perspective.setScaleMin(axisID, min);
                this.perspective.setScaleMaxAuto(axisID, true);
                break;
            }
            case 3: {
                this.perspective.setScaleMinAuto(axisID, true);
                this.perspective.setScaleMaxAuto(axisID, false);
                this.perspective.setScaleMax(axisID, max);
            }
        }
    }

    private void convertMarkerShapeAndSize() {
        int i;
        int j = this.graph.DLObj.vaSerDep.size();
        for (i = 0; i < j; ++i) {
            SerDepDataClass sddc = (SerDepDataClass)this.graph.DLObj.vaSerDep.get(i);
            if (sddc == null) continue;
            int val = sddc.nDummy4 == 0 ? this.graph.LObj.nMarkerSize : sddc.nDummy4;
            this.perspective.setMarkerSize(i, this.convertMarkerSize(val));
            if (i != 0) continue;
            this.perspective.setMarkerSizeDefault(this.convertMarkerSize(val));
        }
        j = this.graph.LObj.vaSerDepLook.size();
        boolean hasLine = false;
        boolean hasLineMarker = false;
        for (i = 0; i < j; ++i) {
            boolean showMarkers;
            SerDepLookClass sdlc = (SerDepLookClass)this.graph.LObj.vaSerDepLook.get(i);
            if (sdlc == null) continue;
            int lineType = sdlc.nDataLineType;
            boolean showConnectorLine = this.convertShowLine(lineType);
            boolean bl = showMarkers = this.convertShowMarkers(lineType) && this.getRiserType(i) != 3;
            if (showConnectorLine) {
                hasLine = true;
            }
            if (showMarkers) {
                hasLineMarker = true;
            }
            this.perspective.setMarkerDisplay(i, showMarkers);
            this.perspective.setConnectLineMarkers(i, showConnectorLine);
        }
        this.perspective.setConnectLineMarkers(hasLine);
        this.perspective.setMarkerDisplay(hasLineMarker);
        boolean isBLAChart = this.getCurrentGraphType().isBLAType();
        j = this.graph.LObj.vaRiserShapes.size();
        for (i = 0; i < j; ++i) {
            int markerShape = this.convertMarkerShapes((Integer)this.graph.LObj.vaRiserShapes.get(i));
            if (this.perspective.getSeriesType(i) != 2 && isBLAChart) {
                markerShape = 1;
            }
            this.perspective.setMarkerShape(this.perspective.getSeries(i), markerShape);
            this.perspective.setMarkerShape(this.perspective.getLegendMarker(i), markerShape);
        }
    }

    private boolean convertShowMarkers(int type) {
        return type == 1 || type == 3;
    }

    private boolean convertShowLine(int type) {
        return type == 2 || type == 3;
    }

    private int convertMarkerShapes(int val) {
        switch (val) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 18;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 6;
            }
            case 10: {
                return 17;
            }
            case 13: {
                return 7;
            }
            case 16: {
                return 5;
            }
            case 17: {
                return 8;
            }
            case 18: {
                return 9;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return 11;
            }
            case 27: {
                return 10;
            }
            case 32: {
                return 15;
            }
            case 37: {
                return 13;
            }
            case 38: {
                return 14;
            }
            case 40: {
                return 1;
            }
            case 41: {
                return 1;
            }
            case 48: {
                return 16;
            }
        }
        return 1;
    }

    private int convertMarkerSize(int i) {
        if ((i /= 30) > 100) {
            i = 100;
        }
        return i;
    }

    private void convertMisc() {
        this.perspective.set3TFCreationRevision(this.graph.creationRevision);
        this.perspective.set3TFCreationSubRevision(this.graph.creationSubRevision);
        this.perspective.setDualAxisSplitPosition(this.graph.nSplitPosition);
        this.perspective.setDisplay(Identity.StackedConnectorLines, this.graph.bShowStackBarConnectLines);
        this.setLineAttributes(Identity.StackedConnectorLines, 33);
        if (this.graph.LObj.DivBipolar.bIsWanted) {
            this.perspective.setDualAxisLineDisplay(true);
        } else {
            this.perspective.setDualAxisLineDisplay(false);
        }
        this.perspective.setRiserBorderMode(1);
        BoxInstRec xyTitle = this.convertTitleFrame(this.graph.LObj.xyTitle, this.convertTextRotation(this.graph.LObj.Title.nFlags) != 0);
        BoxInstRec xyFootnote = this.convertTitleFrame(this.graph.LObj.xyFootnote, this.convertTextRotation(this.graph.LObj.Footnote.nFlags) != 0);
        BoxInstRec xySubTitle = this.convertTitleFrame(this.graph.LObj.xySubTitle, this.convertTextRotation(this.graph.LObj.SubTitle.nFlags) != 0);
        BoxInstRec Y1AxisTitle = this.convertTitleFrame(this.graph.LObj.Y1AxisTitle, this.convertTextRotation(this.graph.LObj.TitleY1Axis.nFlags) != 0);
        BoxInstRec XAxisTitle = this.convertTitleFrame(this.graph.LObj.XAxisTitle, this.convertTextRotation(this.graph.LObj.TitleXAxis.nFlags) != 0);
        this.perspective.setRect(Identity.Title, this.WriteJAVA_TransformRect(xyTitle));
        this.perspective.setRect(Identity.Footnote, this.WriteJAVA_TransformRect(xyFootnote));
        this.perspective.setRect(Identity.Subtitle, this.WriteJAVA_TransformRect(xySubTitle));
        this.perspective.setRect(Identity.Y1Title, this.WriteJAVA_TransformRect(Y1AxisTitle));
        this.perspective.setRect(Identity.O1Title, this.WriteJAVA_TransformRect(XAxisTitle));
        this.perspective.setRect(Identity.X1Title, this.WriteJAVA_TransformRect(XAxisTitle));
        this.setFormattingProperties();
        for (int i = 0; i < this.perspective.getNumGroups(); ++i) {
            this.setTextAttributes(this.graph.LObj.Header1, this.perspective.getGroup(i));
            this.setTitleBoxAttributes(this.graph.LObj.Header1, this.perspective.getGroup(i));
        }
        this.setTextAttributes(this.graph.LObj.Label3, Identity.Y1Label);
        this.setTextAttributes(this.graph.LObj.Label3, Identity.PieRingLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Label3, Identity.Y1LabelBox);
        this.setTitleBoxAttributes(this.graph.LObj.Label3, Identity.PieRingLabelBox);
        this.setTextAttributes(this.graph.LObj.Header3, Identity.Y2Label);
        this.setTitleBoxAttributes(this.graph.LObj.Header3, Identity.Y2LabelBox);
        if (this.perspective.getUsePGSDKTimeScaleAxis() && this.getCurrentGraphType().isBLAType()) {
            this.setTextAttributes(this.graph.LObj.Header2, Identity.X1Label);
            this.setTitleBoxAttributes(this.graph.LObj.Header2, Identity.X1LabelBox);
        } else if (this.perspective.isX1AxisPresent()) {
            this.setTextAttributes(this.graph.LObj.Label2, Identity.X1Label);
            this.setTitleBoxAttributes(this.graph.LObj.Label2, Identity.X1LabelBox);
        } else {
            this.setTextAttributes(this.graph.LObj.Header2, Identity.O1Label);
            this.setTitleBoxAttributes(this.graph.LObj.Header2, Identity.O1LabelBox);
        }
        this.setTextAttributes(this.graph.LObj.TitleXAxis, Identity.X1Title);
        this.setTextAttributes(this.graph.LObj.TitleY1Axis, Identity.Y1Title);
        this.setTextAttributes(this.graph.LObj.TitleY2Axis, Identity.Y2Title);
        this.setTextAttributes(this.graph.LObj.TitleXAxis, Identity.O1Title);
        this.setTextAttributes(this.graph.LObj.Title, Identity.Title);
        this.setTextAttributes(this.graph.LObj.SubTitle, Identity.Subtitle);
        this.setTextAttributes(this.graph.LObj.Footnote, Identity.Footnote);
        this.setTitleBoxAttributes(this.graph.LObj.Title, Identity.TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.TitleY1Axis, Identity.Y1TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.TitleY2Axis, Identity.Y2TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.TitleXAxis, Identity.O1TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.TitleXAxis, Identity.X1TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.Title, Identity.TitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.SubTitle, Identity.SubtitleBox);
        this.setTitleBoxAttributes(this.graph.LObj.Footnote, Identity.FootnoteBox);
        this.perspective.setReverseGroups(this.graph.DLObj.bColReverse);
        int o1LabelSkipCount = this.graph.LObj.O1Axis.nLabelSkip;
        int o2LabelSkipCount = this.graph.LObj.O2Axis.nLabelSkip;
        if (this.graph.LObj.O1Axis.nOrdLabelMode == 2 && o1LabelSkipCount > 0) {
            this.perspective.setO1LabelAutoSkip(2);
            this.perspective.setO1LabelSkipBegin(0);
            this.perspective.setO1LabelSkipCount(o1LabelSkipCount - 1);
        } else {
            this.perspective.setO1LabelAutoSkip(1);
        }
        if (this.graph.LObj.O2Axis.nOrdLabelMode == 2 && o2LabelSkipCount > 0) {
            this.perspective.setO2LabelAutoSkip(2);
            this.perspective.setO2LabelSkipBegin(0);
            this.perspective.setO2LabelSkipCount(o2LabelSkipCount - 1);
        } else {
            this.perspective.setO2LabelAutoSkip(1);
        }
        this.perspective.setBreakAbsoluteLines(this.bitwiseAND(this.graph.LObj.NullBehaviourMask, 1));
        this.perspective.setBreakStackedLines(this.bitwiseAND(this.graph.LObj.NullBehaviourMask, 2));
        if (this.graph.LObj.hasAutoPlacementMask) {
            this.perspective.setAutoPlacmentMask(this.graph.LObj.AutoPlacementMask);
            if ((this.graph.LObj.AutoPlacementMask & 2) == 0) {
                this.perspective.setPlaceLocation(Identity.Title, PlaceMode.MANUAL);
            } else {
                this.perspective.setPlaceLocation(Identity.Title, PlaceMode.FULL_AUTO);
            }
            if ((this.graph.LObj.AutoPlacementMask & 4) == 0) {
                this.perspective.setPlaceLocation(Identity.Subtitle, PlaceMode.MANUAL);
            } else {
                this.perspective.setPlaceLocation(Identity.Subtitle, PlaceMode.FULL_AUTO);
            }
            this.perspective.setPlaceLocation(Identity.Footnote, PlaceMode.MANUAL);
        }
    }

    private void setTitleBoxAttributes(FontInstRec titleBox, IdentObj identObj) {
        int pfjBorderStyle = this.convertBorderStyle(titleBox.FancyBoxInfo.nStyle);
        double fontSizeVC = (double)titleBox.nSize * 0.9766221082829762;
        this.setBorderAttributes(identObj, pfjBorderStyle, Math.max(1, (int)(fontSizeVC * 0.1)));
        if (pfjBorderStyle == 0) {
            return;
        }
        if (0 != titleBox.FancyBoxArea.nPattern) {
            this.convertPatternFill(identObj, titleBox.FancyBoxArea);
        } else {
            this.setFillColor(identObj, titleBox.FancyBoxArea.color);
        }
        this.setLineAttributes(identObj, titleBox.FancyBoxLine, false);
    }

    private void setBorderAttributes(IdentObj identObj, int pfjStyle, int insetVC) {
        this.perspective.setBorderType(identObj, pfjStyle);
        if (pfjStyle == 1 || pfjStyle == 2 || pfjStyle == 3 || pfjStyle == 5) {
            this.perspective.setTopInset(identObj, insetVC);
            this.perspective.setLeftInset(identObj, insetVC);
            this.perspective.setBottomInset(identObj, insetVC);
            this.perspective.setRightInset(identObj, insetVC);
        }
    }

    private int convertBorderStyleFromMarkerShape(int shape) {
        switch (shape) {
            case 0: {
                return 0;
            }
            case 40: {
                return 2;
            }
            case 41: {
                return 3;
            }
        }
        return 4;
    }

    private int convertBorderStyle(int style) {
        switch (style) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }

    private BoxInstRec convertTitleFrame(BoxInstRec boxInstRec, boolean rotated) {
        if (rotated) {
            int x = boxInstRec.xULC;
            int y = boxInstRec.yULC;
            int x1 = boxInstRec.xLRC;
            int y1 = boxInstRec.yLRC;
            int w = Math.abs(x - x1);
            int h = Math.abs(y - y1);
            int w2 = w / 2;
            int h2 = h / 2;
            BoxInstRec box = new BoxInstRec();
            box.xULC = x + (w2 - h2);
            box.yULC = y + (w2 - h2);
            box.xLRC = x + (w2 + h2);
            box.yLRC = y - (w2 + h2);
            return box;
        }
        return boxInstRec;
    }

    private void convertPie() {
        SerDepDataClass seriesDependantData;
        if (!this.perspective.isChartPieType()) {
            return;
        }
        int bAutoFit = this.graph.LObj.PieLook.ctGroupLabel.bAutoFit;
        if (bAutoFit == 1) {
            this.perspective.setAutofit(Identity.PieGroupLabel, true);
        } else {
            this.perspective.setAutofit(Identity.PieGroupLabel, false);
        }
        if (bAutoFit == 1) {
            this.perspective.setAutofit(Identity.PieRingLabel, true);
        } else {
            this.perspective.setAutofit(Identity.PieRingLabel, false);
        }
        int size = this.graph.DLObj.vaSerDep.size();
        for (int i = 0; i < size; ++i) {
            seriesDependantData = (SerDepDataClass)this.graph.DLObj.vaSerDep.get(i);
            if (seriesDependantData == null) continue;
            if (seriesDependantData.bDeleted) {
                this.perspective.setPieSliceDelete(this.perspective.getSeries(i), true);
                continue;
            }
            this.perspective.setPieSliceDetach(this.perspective.getSeries(i), seriesDependantData.PieSerDepData.nMove);
            this.perspective.setDisplay(this.perspective.getPieSliceLabel(i), (seriesDependantData.PieSerDepData.nShowPieLabel & 2) != 0);
            this.perspective.setDisplay(this.perspective.getPieSliceValueLabel(i), (seriesDependantData.PieSerDepData.nShowPieLabel & 1) != 0);
            this.perspective.setDisplay(this.perspective.getPieFeelerLine(i), seriesDependantData.PieSerDepData.bShowFeeler);
            if (i != 0) continue;
            this.perspective.setDisplay(Identity.PieSliceLabel, (seriesDependantData.PieSerDepData.nShowPieLabel & 2) != 0);
            this.perspective.setDisplay(Identity.PieSliceValueLabel, (seriesDependantData.PieSerDepData.nShowPieLabel & 1) != 0);
            this.perspective.setDisplay(Identity.PieFeelerLine, seriesDependantData.PieSerDepData.bShowFeeler);
        }
        this.setLineAttributes(Identity.PieFeelerLine, 27);
        this.perspective.setDisplay(Identity.PieGroupLabel, this.graph.LObj.PieLook.bShowGroupLabels);
        this.perspective.setPieSliceLabelPosition(this.convertPieLabelPosition(this.graph.LObj.PieLook.nPlaceDataLabel));
        this.perspective.setPieSliceValueLabelPosition(this.convertPieLabelPosition(this.graph.LObj.PieLook.nPlaceValueLabel));
        seriesDependantData = (SerDepDataClass)this.graph.DLObj.vaSerDep.get(0);
        if (seriesDependantData != null && this.bitwiseAND(seriesDependantData.PieSerDepData.nShowPieLabel, 32)) {
            this.perspective.setPieValueFormat(0);
        } else {
            this.perspective.setPieValueFormat(1);
        }
        int nDataINT16 = this.graph.LObj.PieLook.PieDepth / 30;
        if (nDataINT16 > 100) {
            nDataINT16 = 100;
        }
        this.perspective.setPieDepth(nDataINT16);
        int nPGSDKPieRotation = this.graph.LObj.PieLook.nPieRotate;
        int nJAVAPieRotation = 0;
        switch (nPGSDKPieRotation) {
            case 0: {
                nJAVAPieRotation = 90;
                break;
            }
            case 90: {
                nJAVAPieRotation = 0;
                break;
            }
            case 180: {
                nJAVAPieRotation = 270;
                break;
            }
            case 270: {
                nJAVAPieRotation = 180;
                break;
            }
            default: {
                if (nPGSDKPieRotation > 0 && nPGSDKPieRotation < 90) {
                    nJAVAPieRotation = 90 - nPGSDKPieRotation + 0;
                    break;
                }
                if (nPGSDKPieRotation > 90 && nPGSDKPieRotation < 180) {
                    nJAVAPieRotation = 180 - nPGSDKPieRotation + 270;
                    break;
                }
                if (nPGSDKPieRotation > 180 && nPGSDKPieRotation < 270) {
                    nJAVAPieRotation = 270 - nPGSDKPieRotation + 180;
                    break;
                }
                if (nPGSDKPieRotation <= 270 || nPGSDKPieRotation >= 360) break;
                nJAVAPieRotation = 360 - nPGSDKPieRotation + 90;
            }
        }
        this.perspective.setPieRotate((short)nJAVAPieRotation);
        boolean bShowRingLabels = this.graph.LObj.PieLook.bShowRingLabels;
        this.perspective.setPieRingTotalDisplay(bShowRingLabels);
        nDataINT16 = this.graph.LObj.PieLook.nHoleSize;
        this.perspective.setPieRingSize(nDataINT16);
        nDataINT16 = this.graph.LObj.PieLook.PiesPerRow;
        this.perspective.setPiesPerRow(nDataINT16);
        boolean bPieTilt = this.graph.LObj.PieLook.bPieTilt;
        if (bPieTilt) {
            nDataINT16 = this.graph.LObj.PieLook.nPieTilt;
            this.perspective.setPieTilt(nDataINT16);
        } else {
            this.perspective.setPieTilt(0);
        }
        this.perspective.setInsets(Identity.PieFrame, new Insets(this.graph.LObj.PieLook.ctPie.nFracParaHigh, this.graph.LObj.PieLook.ctPie.nFracOrthLow, this.graph.LObj.PieLook.ctPie.nFracParaLow, this.graph.LObj.PieLook.ctPie.nFracOrthHigh));
        this.setTextAttributes(this.graph.LObj.Label1, Identity.PieSliceLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Label1, Identity.PieSliceLabelBox);
        this.setTextAttributes(this.graph.LObj.Label2, Identity.PieSliceValueLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Label2, Identity.PieSliceValueLabelBox);
        this.setTextAttributes(this.graph.LObj.Header1, Identity.PieGroupLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Header1, Identity.PieGroupLabelBox);
        this.setAreaAttributes(Identity.PieFrame, 3, 21);
    }

    private int convertPieLabelPosition(int valuePosition) {
        switch (valuePosition) {
            default: {
                return 1;
            }
            case 1: 
            case 4: 
            case 5: 
        }
        return 2;
    }

    boolean bitwiseAND(int i, int j) {
        return (i & j) == j;
    }

    private void convertBar() {
        this.perspective.setRiserBarGroupSpacing(this.graph.LObj.nInterGrpThick);
        this.perspective.setRiserWidth(this.convertRiserWidth(this.graph.LObj.nIntraGrpThick));
        boolean bPictograph = this.graph.LObj.BarLook.bPictograph;
        this.perspective.setDisplayBarAsPictograph(bPictograph);
    }

    private int convertRiserWidth(int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        return 100 - thickness;
    }

    private void convertY1Axis(boolean isTimeScaleAxis) {
        Look look = this.graph.LObj;
        AxisLookClass y1Axis = look.Y1Axis;
        boolean isStacked = this.getCurrentGraphType().isStacked();
        if (isTimeScaleAxis) {
            this.perspective.setY1ZeroLineDisplay(false);
            this.perspective.setY1MustIncludeZero(false);
            this.perspective.setY1LogScale(false);
            TimeAxisRec timeAxisRec = this.graph.TimeAxis;
            this.perspective.setGridUnitAuto(Identity.Y1MajorGrid, timeAxisRec.bAutomaticMajorUnit);
            this.perspective.setGridUnitAuto(Identity.Y1MinorGrid, timeAxisRec.bAutomaticMinorUnit);
            this.perspective.setGridUnitCount(Identity.Y1MajorGrid, timeAxisRec.nMajorInterval);
            this.perspective.setGridUnitCount(Identity.Y1MinorGrid, timeAxisRec.nMinorInterval);
            this.perspective.setMajorGridTickInterval(this.convertTimeUnit(timeAxisRec.nMajorUnit));
            this.perspective.setMinorGridTickInterval(this.convertTimeUnit(timeAxisRec.nMinorUnit));
            this.perspective.setY1ScaleMinAuto(timeAxisRec.bAutomaticMinimum);
            this.perspective.setY1ScaleMaxAuto(timeAxisRec.bAutomaticMaximum);
            this.perspective.setY1ScaleMin(this.convertDate1900(timeAxisRec.fTimeAxisMinimum));
            this.perspective.setY1ScaleMax(this.convertDate1900(timeAxisRec.fTimeAxisMaximum));
        } else {
            DataAxisClass y1Data = this.graph.DLObj.Y1Data;
            this.convertAxisScale(Identity.Y1Axis, this.graph.DLObj.Y1Data);
            this.perspective.setExcludeMaxLabel(Identity.Y1Label, this.convertExcludeLabel(y1Axis.nScaleEnd, true));
            this.perspective.setExcludeMinLabel(Identity.Y1Label, this.convertExcludeLabel(y1Axis.nScaleEnd, false));
            this.perspective.setY1ZeroLineDisplay(y1Axis.ZeroLine.bIsWanted);
            this.perspective.setY1MustIncludeZero(!y1Data.bAutoExcludeZero || isStacked);
            this.perspective.setY1OffScaleDisplay(y1Data.bShowOffScale);
        }
        this.perspective.setY1AxisLineDisplay(this.bitwiseAND(y1Axis.nShowStatus, 1));
        this.perspective.setY1LabelDisplay(this.bitwiseAND(y1Axis.nShowStatus, 2));
        this.perspective.setY1AxisDescending(y1Axis.bInvertNumScale);
        this.perspective.setY1LabelStagger(y1Axis.bStaggered);
        this.setLineAttributes(Identity.Y1ZeroLine, 11);
        this.setLineAttributes(Identity.Y1AxisLine, 31);
        if (y1Axis.Side >= 0 && y1Axis.Side <= 2) {
            this.perspective.setY1AxisSide(y1Axis.Side);
        }
        Color scaledColor = this.WriteJAVA_ScaleColor(this.graph.LObj.Label3.color);
        this.perspective.setFillColor(Identity.Y1Label, scaledColor);
    }

    private void convertY2Axis() {
        AxisLookClass y2Axis = this.graph.LObj.Y2Axis;
        DataAxisClass y2Data = this.graph.DLObj.Y2Data;
        this.convertAxisScale(Identity.Y2Axis, this.graph.DLObj.Y2Data);
        switch (y2Axis.Side) {
            case 0: 
            case 1: 
            case 2: {
                this.perspective.setY2AxisSide(y2Axis.Side);
            }
        }
        if ((y2Axis.nShowStatus & 1) == 1) {
            this.perspective.setY2AxisLineDisplay(true);
        } else {
            this.perspective.setY2AxisLineDisplay(false);
        }
        if ((y2Axis.nShowStatus & 2) == 2) {
            this.perspective.setY2LabelDisplay(true);
        } else {
            this.perspective.setY2LabelDisplay(false);
        }
        if (y2Axis.bInvertNumScale) {
            this.perspective.setY2AxisDescending(true);
        } else {
            this.perspective.setY2AxisDescending(false);
        }
        if (y2Data.bAutoExcludeZero) {
            this.perspective.setY2MustIncludeZero(false);
        } else {
            this.perspective.setY2MustIncludeZero(true);
        }
        Color scaledColor = this.WriteJAVA_ScaleColor(this.graph.LObj.Label3.color);
        this.perspective.setFillColor(Identity.Y2Label, scaledColor);
        if (y2Axis.bStaggered) {
            this.perspective.setY2LabelStagger(true);
        } else {
            this.perspective.setY2LabelStagger(false);
        }
        this.setLineAttributes(Identity.Y2AxisLine, 32);
        this.setLineAttributes(Identity.Y2ZeroLine, 12);
        this.perspective.setY2ZeroLineDisplay(y2Axis.ZeroLine.bIsWanted);
        this.perspective.setY2OffScaleDisplay(y2Data.bShowOffScale);
    }

    private void convertX1Axis(boolean isTimeScale) {
        AxisLookClass xAxis;
        if (isTimeScale) {
            xAxis = this.graph.LObj.O1Axis;
            this.perspective.setX1ZeroLineDisplay(false);
            this.perspective.setX1MustIncludeZero(false);
            this.perspective.setX1LabelStagger(false);
            this.perspective.setX1LogScale(false);
            TimeAxisRec timeAxisRec = this.graph.TimeAxis;
            this.perspective.setGridUnitAuto(Identity.X1MajorGrid, timeAxisRec.bAutomaticMajorUnit);
            this.perspective.setGridUnitAuto(Identity.X1MinorGrid, timeAxisRec.bAutomaticMinorUnit);
            this.perspective.setGridUnitCount(Identity.X1MajorGrid, timeAxisRec.nMajorInterval);
            this.perspective.setGridUnitCount(Identity.X1MinorGrid, timeAxisRec.nMinorInterval);
            this.perspective.setMajorGridTickInterval(this.convertTimeUnit(timeAxisRec.nMajorUnit));
            this.perspective.setMinorGridTickInterval(this.convertTimeUnit(timeAxisRec.nMinorUnit));
            this.perspective.setX1ScaleMinAuto(timeAxisRec.bAutomaticMinimum);
            this.perspective.setX1ScaleMaxAuto(timeAxisRec.bAutomaticMaximum);
            this.perspective.setX1ScaleMin(this.convertDate1900(timeAxisRec.fTimeAxisMinimum));
            this.perspective.setX1ScaleMax(this.convertDate1900(timeAxisRec.fTimeAxisMaximum));
        } else {
            xAxis = this.graph.LObj.X1Axis;
            DataAxisClass x1Data = this.graph.DLObj.X1Data;
            this.convertAxisScale(Identity.X1Axis, this.graph.DLObj.X1Data);
            this.perspective.setExcludeMaxLabel(Identity.X1Label, this.convertExcludeLabel(xAxis.nScaleEnd, true));
            this.perspective.setExcludeMinLabel(Identity.X1Label, this.convertExcludeLabel(xAxis.nScaleEnd, false));
            this.perspective.setX1ZeroLineDisplay(xAxis.ZeroLine.bIsWanted);
            this.perspective.setX1AxisDescending(xAxis.bInvertNumScale);
            this.perspective.setX1MustIncludeZero(!x1Data.bAutoExcludeZero);
            this.perspective.setX1LabelStagger(xAxis.bStaggered);
            this.perspective.setX1OffScaleDisplay(x1Data.bShowOffScale);
        }
        this.perspective.setX1AxisLineDisplay(this.bitwiseAND(xAxis.nShowStatus, 1));
        this.perspective.setX1LabelDisplay(this.bitwiseAND(xAxis.nShowStatus, 2));
        if (xAxis.Side >= 0 && xAxis.Side <= 2) {
            this.perspective.setX1AxisSide(xAxis.Side);
        }
        Color scaledColor = this.WriteJAVA_ScaleColor(this.graph.LObj.Header2.color);
        this.perspective.setFillColor(Identity.X1Label, scaledColor);
        this.setLineAttributes(Identity.X1AxisLine, 30);
        this.setLineAttributes(Identity.X1ZeroLine, 13);
    }

    private void convertDataText() {
        boolean seriesDependent = this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 256);
        String textPattern = this.getDataTextTemplate(this.graph.LObj.nShowQDRLabels);
        boolean showLabels = false;
        if (seriesDependent) {
            int numSeries = this.graph.DLObj.vaSerDep.size();
            for (int i = 0; i < numSeries; ++i) {
                SerDepDataClass series = (SerDepDataClass)this.graph.DLObj.vaSerDep.getAt(i);
                this.perspective.setDisplay(this.perspective.getDataText(i), series.nDummy3 > 0);
                if (i != 0 || series.nDummy3 <= 0) continue;
                showLabels = true;
            }
        } else {
            boolean showText = this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 2);
            boolean showValue = this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 1);
            boolean showZ = this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 16);
            showLabels = this.getCurrentGraphType().isBubble() ? showValue || showZ : (this.getCurrentGraphType().isGanttType() ? showText : showText || showValue);
        }
        this.perspective.setDataTextTemplate(textPattern);
        this.perspective.setDisplay(Identity.DataText, showLabels);
        this.perspective.setDataTextPosition(this.convertDataTextPosition(this.graph.LObj.Y1Axis.nPlaceQDRLabel));
        this.perspective.setDataTextPositionSecondary(this.convertDataTextPosition(this.graph.LObj.X1Axis.nPlaceQDRLabel));
        this.perspective.setStackedDataValueSum(!this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 4));
        this.perspective.setDisplay(Identity.DataTextStackedTotalOnTop, this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 8));
        this.perspective.setShowTotalsDisplay(this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 8));
        if (this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 32)) {
            this.perspective.setPercentValueFormat(1);
        } else {
            this.perspective.setPercentValueFormat(0);
        }
        this.setTextAttributes(this.graph.LObj.Label1, Identity.DataText);
        this.setTitleBoxAttributes(this.graph.LObj.Label1, Identity.DataTextBox);
    }

    private String getDataTextTemplate(int showQDRLabels) {
        if (this.getCurrentGraphType().isGanttType()) {
            if (this.bitwiseAND(showQDRLabels, 1)) {
                return "[TIME]";
            }
            return "";
        }
        boolean dataOnly = this.perspective.getUsePGSDKTimeScaleAxis() || this.perspective.getUseNumericScaleAxis();
        String textPattern = "";
        if (this.bitwiseAND(showQDRLabels, 2)) {
            textPattern = dataOnly ? "[DATA]" : "[SERIES]";
        }
        if (this.bitwiseAND(showQDRLabels, 1)) {
            textPattern = textPattern.length() == 0 ? "[DATA]" : textPattern + " [DATA]";
        }
        return textPattern;
    }

    private void setTextAttributes(FontInstRec dataText, IdentObj identObj) {
        int convertedRotation;
        double quantizeFactor = 4.0;
        this.perspective.setTextJustHoriz(identObj, dataText.justH);
        this.perspective.setTextJustVert(identObj, dataText.justV);
        if (dataText.nSize > 0) {
            double fontSizeVC = (double)dataText.nSize * 0.9766221082829762;
            double fontSizePts = this.fontSizeVcToPoints(fontSizeVC);
            double fontSizePtsQuantized = MathUtilities.quantize(fontSizePts, 4.0);
            this.perspective.setFontSizeVC(identObj, (int)fontSizeVC);
            if (fontSizePtsQuantized > 0.0) {
                this.perspective.setFontSizeInPoints(identObj, (float)Math.min(128.0, fontSizePtsQuantized));
                this.perspective.setFontSizeAbsolute(identObj, true);
            } else {
                this.perspective.setFontSizeAbsolute(identObj, false);
                logger.warn((Object)"Using VC font sizes... did you set chart physical size correctly?");
            }
        } else {
            logger.warn((Object)"Chart Font Size <= 0, using default");
        }
        this.perspective.setFontStyle(identObj, this.WriteJAVA_TransformFontStyle(dataText.textFace));
        this.perspective.setTextStrikethrough(identObj, this.convertTextStrikeThrough(dataText.textFace));
        this.setFillColor(identObj, dataText.color);
        FontNameInfo fontInfo = this.graph.FontMaster.getFontInfo(dataText.nFontIndex);
        if (fontInfo != null) {
            this.perspective.setFontName(identObj, this.getString(fontInfo.fontName));
        }
        if ((convertedRotation = this.convertTextRotation(dataText.nFlags)) == 3 || convertedRotation == 5) {
            this.perspective.setTextWrap(identObj, false);
        } else {
            this.perspective.setTextWrap(identObj, true);
        }
        this.perspective.setTextRotation(identObj, convertedRotation);
    }

    private double fontSizeVcToPoints(double fontSizeVC) {
        return fontSizeVC / 32000.0 * (double)this.perspective.getDocumentHeightInPoints();
    }

    private boolean convertTextStrikeThrough(int style) {
        int PGSDK_FONTSTYLE_STRIKEOUT = 8;
        return this.bitwiseAND(style, 8);
    }

    private String getString(char[] c) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < c.length & c[i] != '\u0000') {
            buffer.append(c[i++]);
        }
        return buffer.toString();
    }

    private int convertTextRotation(int i) {
        int javaCode = 0;
        int FONT_bRotate90 = 8;
        int FONT_bRotate180 = 16;
        int FONT_bRotate270 = 32;
        int FONT_bRotate45 = 64;
        int FONT_bRotate315 = 128;
        if (this.bitwiseAND(i, 8)) {
            javaCode = 1;
        }
        if (this.bitwiseAND(i, 32)) {
            javaCode = 2;
        }
        if (this.bitwiseAND(i, 16)) {
            javaCode = 4;
        }
        if (this.bitwiseAND(i, 64)) {
            javaCode = 3;
        }
        if (this.bitwiseAND(i, 128)) {
            javaCode = 5;
        }
        return javaCode;
    }

    private int convertDataTextPosition(int pgsdkTextPosition) {
        int nJAVADataTextPosition = 4;
        switch (pgsdkTextPosition) {
            default: {
                nJAVADataTextPosition = 4;
                break;
            }
            case 2: {
                nJAVADataTextPosition = 5;
                break;
            }
            case 1: {
                nJAVADataTextPosition = 8;
                break;
            }
            case 3: {
                nJAVADataTextPosition = 3;
                break;
            }
            case 4: {
                nJAVADataTextPosition = 1;
            }
        }
        return nJAVADataTextPosition;
    }

    private void convertSeriesGroupMisc() throws ChartNotSupportedException {
        int colorModel;
        if (this.graph.LObj.vaRiserBorders.size() > 0) {
            this.perspective.setSeriesLineWidthDefault(this.convertSeriesLineWidthDefault(((LineInstRec)this.graph.LObj.vaRiserBorders.get((int)0)).nThick));
        }
        if ((colorModel = this.graph.LObj.ColorModel.nColorModel) > 2) {
            if (colorModel == 4) {
                colorModel = 3;
                Color startColor = this.WriteJAVA_ScaleColor(this.graph.LObj.ColorModel.washBeginColor);
                Color endColor = this.WriteJAVA_ScaleColor(this.graph.LObj.ColorModel.washEndColor);
                this.perspective.setGradientPinLeftColor(Identity.ColorByHeight, startColor, 0);
                this.perspective.setGradientPinRightColor(Identity.ColorByHeight, startColor, 0);
                this.perspective.setGradientPinPosition(Identity.ColorByHeight, 0.0, 0);
                this.perspective.setGradientPinLeftColor(Identity.ColorByHeight, endColor, 1);
                this.perspective.setGradientPinRightColor(Identity.ColorByHeight, endColor, 1);
                this.perspective.setGradientPinPosition(Identity.ColorByHeight, 1.0, 1);
            } else {
                colorModel = 1;
            }
        }
        if (this.graph.bAutoColorByRow && this.graph.nSubRevision >= 100 && this.graph.nRevision >= 2) {
            this.perspective.setColorMode(0);
        } else {
            this.perspective.setColorMode(colorModel);
        }
        this.perspective.setSeriesAreRows(!this.graph.DLObj.bAxisSwap);
        this.perspective.setReverseSeries(this.graph.DLObj.bRowReverse);
        int nNumItems = this.graph.DLObj.vaSerDep.size();
        for (int nIndex = 0; nIndex < nNumItems; ++nIndex) {
            SerDepDataClass sd = (SerDepDataClass)this.graph.DLObj.vaSerDep.getAt(nIndex);
            if (sd == null) continue;
            this.perspective.setAxisAssignment(nIndex, sd.bSplitY);
        }
        this.perspective.setSeriesLooping(this.graph.LObj.vaSerDepLook.size());
    }

    private int convertSeriesLineWidthDefault(int i) {
        return Math.max(Math.min(100, i / 75), 0);
    }

    private void convertRisers() {
        int i;
        int nColorMode;
        GraphPresetType gpType = new GraphPresetType();
        this.graph.getGraphPresetType(gpType);
        boolean is3DChart = gpType.majorType == 0;
        int j = this.graph.LObj.vaRiserShapes.size();
        for (int i2 = 0; i2 < j; ++i2) {
            int pgsdkShape = (Integer)this.graph.LObj.vaRiserShapes.get(i2);
            int pfjBorderStyle = this.convertBorderStyleFromMarkerShape(pgsdkShape);
            this.setBorderAttributes(this.perspective.getBarRiser(i2), pfjBorderStyle, 200);
            this.setBorderAttributes(this.perspective.getLegendMarker(i2), pfjBorderStyle, 200);
            this.setBorderAttributes(this.perspective.getLineMarker(i2), pfjBorderStyle, 200);
            if (i2 != 0) continue;
            this.setBorderAttributes(Identity.BarRiser, pfjBorderStyle, 200);
            this.setBorderAttributes(Identity.LegendMarker, pfjBorderStyle, 200);
            this.setBorderAttributes(Identity.LineMarker, pfjBorderStyle, 200);
        }
        boolean bExportRiserColors = true;
        if (is3DChart && (nColorMode = this.graph.LObj.ColorModel.nColorModel) == 0) {
            bExportRiserColors = false;
        }
        int nNumItems = this.graph.DLObj.vaSerDep.size();
        for (i = 0; i < nNumItems; ++i) {
            int riserType;
            SerDepDataClass sd = (SerDepDataClass)this.graph.DLObj.vaSerDep.getAt(i);
            if (sd == null || (riserType = this.convertRiserType(sd)) < 0) continue;
            this.perspective.setSeriesType(this.perspective.getSeries(i), riserType);
        }
        nNumItems = this.graph.LObj.vaRiserColors.size();
        for (int nIndex = 0; nIndex < nNumItems; ++nIndex) {
            AreaInstRec riserColor = this.graph.LObj.vaRiserColors.getAt(nIndex);
            if (riserColor.color.nSpectrumBin == 9999) {
                this.perspective.setTransparentFillColor(this.perspective.getSeries(nIndex), true);
                continue;
            }
            if (!bExportRiserColors) continue;
            Color color = this.WriteJAVA_ScaleColor(riserColor.color);
            this.perspective.setFillColor(this.perspective.getSeries(nIndex), color);
            this.perspective.setTransparentFillColor(this.perspective.getSeries(nIndex), false);
        }
        for (i = 0; i < this.graph.LObj.vaSerDepLook.size(); ++i) {
            SerDepLookClass s = this.graph.LObj.vaSerDepLook.getAt(i);
            LineInstRec seriesLine = this.getSeriesRiserLineBorder(i, s);
            if (seriesLine == null) continue;
            this.setLineAttributes(this.perspective.getSeries(i), seriesLine, false);
            this.setLineAttributes(this.perspective.getLegendMarker(i), s.ErrorBarInfo.ErrorBarLine, false);
            this.setLineAttributes(this.perspective.getLineMarker(i), s.ErrorBarInfo.ErrorBarLine, false);
        }
    }

    private LineInstRec getSeriesRiserLineBorder(int i, SerDepLookClass s) {
        if (this.getRiserType(i) == 2 || this.getCurrentGraphType().isRadarLine()) {
            return this.graph.LObj.vaRiserBorders.getAt(i + 1);
        }
        return s.ErrorBarInfo.ErrorBarLine;
    }

    private int getRiserType(int i) {
        SerDepDataClass sddc = (SerDepDataClass)this.graph.DLObj.vaSerDep.getAt(i);
        if (sddc == null) {
            return -1;
        }
        return this.convertRiserType(sddc);
    }

    private int convertRiserType(SerDepDataClass sddc) {
        if (this.getCurrentGraphType().is3DType()) {
            int graphType = this.perspective.getGraphType();
            switch (sddc.nRiserType) {
                default: {
                    return graphType == 0 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.Bar3D.ordinal();
                }
                case 1: {
                    return graphType == 9 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.ColumnArea.ordinal();
                }
                case 2: {
                    return graphType == 10 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.ColumnLine.ordinal();
                }
                case 4: {
                    return graphType == 4 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.Cube.ordinal();
                }
                case 5: {
                    return graphType == 131 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.CutCorner.ordinal();
                }
                case 6: {
                    return graphType == 11 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.Sphere.ordinal();
                }
                case 9: {
                    return graphType == 2 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.Octagon.ordinal();
                }
                case 10: {
                    return graphType == 1 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.Pyramid.ordinal();
                }
                case 11: {
                    return graphType == 6 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.RowArea.ordinal();
                }
                case 12: 
            }
            return graphType == 7 ? PerspectiveBase.RiserType3D.Default.ordinal() : PerspectiveBase.RiserType3D.RowLine.ordinal();
        }
        int pgsdkRiserType = sddc.nEmphasized;
        if (this.getCurrentGraphType().isLineType()) {
            switch (pgsdkRiserType) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
        }
        if (this.getCurrentGraphType().isAreaType()) {
            switch (pgsdkRiserType) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
        }
        if (this.getCurrentGraphType().isBarType()) {
            switch (pgsdkRiserType) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return -1;
    }

    private void convertBackground() {
        this.setAreaAttributes(Identity.ChartBackground, 1, 0);
    }

    private void convertPatternFill(IdentObj identObj, AreaInstRec areaInstRec) {
        if (areaInstRec.nPattern > 0) {
            Color backgroundColor = this.WriteJAVA_ScaleColor(areaInstRec.nBRed, areaInstRec.nBGreen, areaInstRec.nBBlue);
            Color foregroundColor = this.WriteJAVA_ScaleColor(areaInstRec.color);
            TexturePaint texturePaint = PatternTable.getTexturePattern(areaInstRec.nPattern, backgroundColor, foregroundColor);
            this.perspective.setNPatternFill(identObj, areaInstRec.nPattern);
            this.perspective.setPatternBackground(identObj, backgroundColor);
            this.perspective.setPaintObject(identObj, texturePaint);
        }
    }

    private void convertFrame() {
        IdentObj frame = this.perspective.getCurrentFrame();
        if (this.getCurrentGraphType().isRadarType()) {
            this.perspective.setTransparentBorderColor(frame, true);
        }
        this.perspective.setFrameDisplay(true);
        this.perspective.setRect(frame, this.convertFrameRectangle(this.graph.LObj.xyFrame));
        this.setAreaAttributes(frame, 3, 21);
        this.setAreaAttributes(Identity.FrameBottom, 3, 21);
        this.setAreaAttributes(Identity.FrameSide, 3, 21);
        this.setAreaAttributes(Identity.FrameSeparator, 3, 21);
        if (null != this.graph.LObj.AreaColors[3] && null != this.graph.LObj.AreaColors[3].color) {
            Color frameColor = this.WriteJAVA_ScaleColor(this.graph.LObj.AreaColors[3].color);
            if (!this.perspective.getTransparentFillColor(Identity.FrameBottom)) {
                this.perspective.setFillColor(Identity.FrameBottom, GraphicsUtil.darker(frameColor, Color.BLACK, 0.3));
            }
            if (!this.perspective.getTransparentFillColor(Identity.FrameSide)) {
                this.perspective.setFillColor(Identity.FrameSide, GraphicsUtil.darker(frameColor, Color.BLACK, 0.17));
            }
            if (!this.perspective.getTransparentFillColor(Identity.FrameSeparator)) {
                this.perspective.setFillColor(Identity.FrameSeparator, GraphicsUtil.darker(frameColor, Color.BLACK, 0.3));
            }
        }
        if (this.perspective.isPgsdkAutoArrange()) {
            if (this.graph.LObj.hasAutoPlacementMask) {
                if (this.bitwiseAND(this.graph.LObj.AutoPlacementMask, 1)) {
                    this.perspective.setPlaceResize(frame, PlaceMode.FULL_AUTO);
                } else {
                    this.perspective.setPlaceResize(frame, PlaceMode.MANUAL);
                }
            } else {
                this.perspective.setPlaceResize(frame, PlaceMode.SEMI_AUTO);
            }
        } else {
            this.perspective.setPlaceResize(frame, PlaceMode.SEMI_AUTO);
        }
    }

    private Rectangle convertFrameRectangle(BoxInstRec rect) {
        JGraphType gt = this.getCurrentGraphType();
        Rectangle rec = this.WriteJAVA_TransformRect(rect);
        if (gt.wantDepthEffect()) {
            int depthAngle = this.perspective.getDepthAngle();
            int depthRadius = this.perspective.getDepthRadius();
            double radius = depthRadius * 10;
            int dx = (int)(radius * Math.cos((double)depthAngle * (Math.PI / 180)));
            int dy = (int)(radius * Math.sin((double)depthAngle * (Math.PI / 180)));
            rec.x += dx;
            rec.y += dy;
        }
        return rec;
    }

    private long convertDate1900(double date1900) {
        int nCurrentMonthIndex = 0;
        int nSum = 0;
        int nT = (int)date1900;
        int nStart = 0;
        int NUMBER_OF_DAYS_IN_4_YEARS = 1461;
        int[] MonthLookup = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int n4YearCount = (int)(date1900 / (double)NUMBER_OF_DAYS_IN_4_YEARS);
        int nDayCount = n4YearCount * NUMBER_OF_DAYS_IN_4_YEARS;
        nT = (int)(date1900 - (double)nDayCount);
        int nYear = 4 * n4YearCount;
        if (nT == 0) {
            return this.perspective.getMillisFromDate(1900 + nYear - 1, 12, 31, 0, 0, 0);
        }
        if (nT > 366 && nT <= 731) {
            nStart = 12;
            ++nYear;
            nSum += 366;
            nDayCount += 366;
        } else if (nT > 731 && nT <= 1096) {
            nStart = 24;
            nYear += 2;
            nSum += 731;
            nDayCount += 731;
        } else if (nT > 1096 && nT <= NUMBER_OF_DAYS_IN_4_YEARS) {
            nStart = 36;
            nYear += 3;
            nSum += 1096;
            nDayCount += 1096;
        }
        nCurrentMonthIndex = nStart;
        while (nCurrentMonthIndex < 48 && nSum < nT) {
            if ((nSum += MonthLookup[nCurrentMonthIndex]) >= nT) continue;
            nDayCount += MonthLookup[nCurrentMonthIndex];
            ++nCurrentMonthIndex;
        }
        int nMonth = nCurrentMonthIndex % 12;
        int nDay = (int)(date1900 - (double)nDayCount);
        return this.perspective.getMillisFromDate(nYear += 1900, ++nMonth, nDay, 0, 0, 0);
    }

    private int convertGraphType() throws ChartNotSupportedException {
        int gType = this.graph.LObj.nGraphType;
        int newType = -1;
        if (gType >= 0 && gType <= 16) {
            newType = this.convertChartType3D();
        } else {
            switch (gType) {
                case 18: 
                case 25: {
                    newType = this.convertChartTypeBar();
                    break;
                }
                case 17: 
                case 24: {
                    newType = this.convertChartTypeArea();
                    break;
                }
                case 31: 
                case 35: {
                    newType = this.convertChartTypeLine();
                    break;
                }
                case 36: 
                case 38: {
                    newType = this.convertChartTypePie();
                    break;
                }
                case 60: {
                    newType = 106;
                    break;
                }
                case 23: {
                    newType = 99;
                    break;
                }
                case 59: {
                    newType = 110;
                    break;
                }
                case 34: {
                    newType = 85;
                    break;
                }
                case 30: {
                    newType = 86;
                    break;
                }
                default: {
                    newType = this.convertChartTypeSpecial();
                }
            }
        }
        return newType;
    }

    private void convertChartType() throws ChartNotSupportedException {
        int newType = this.convertGraphType();
        if (newType != -1) {
            this.perspective.setGraphType(newType);
        }
    }

    private int convertTimeUnit(int tu) {
        switch (tu) {
            default: {
                return 4;
            }
            case 1: {
                return 6;
            }
            case 2: 
        }
        return 8;
    }

    private int convertChartTypeLine() {
        int orientation = this.graph.LObj.getOrientation();
        GraphPresetType presetType = new GraphPresetType();
        this.graph.getGraphPresetType(presetType);
        int subType = presetType.minorType;
        int javaType = 0;
        block0 : switch (orientation) {
            default: {
                switch (subType) {
                    default: {
                        javaType = 41;
                        break block0;
                    }
                    case 1: {
                        javaType = 43;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        javaType = 45;
                        break block0;
                    }
                    case 4: {
                        javaType = 42;
                        break block0;
                    }
                    case 5: {
                        javaType = 44;
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        javaType = 46;
                        break block0;
                    }
                    case 12: 
                }
                javaType = 47;
                break;
            }
            case 0: {
                switch (subType) {
                    default: {
                        javaType = 48;
                        break block0;
                    }
                    case 1: {
                        javaType = 50;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        javaType = 52;
                        break block0;
                    }
                    case 4: {
                        javaType = 49;
                        break block0;
                    }
                    case 5: {
                        javaType = 51;
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        javaType = 53;
                        break block0;
                    }
                    case 12: 
                }
                javaType = 54;
            }
        }
        return javaType;
    }

    private int convertChartTypeBar() {
        int orientation = this.graph.LObj.getOrientation();
        GraphPresetType presetType = new GraphPresetType();
        this.graph.getGraphPresetType(presetType);
        int subType = presetType.minorType;
        int javaType = 0;
        block0 : switch (orientation) {
            default: {
                switch (subType) {
                    default: {
                        javaType = 18;
                        break block0;
                    }
                    case 5: {
                        javaType = 20;
                        break block0;
                    }
                    case 6: {
                        javaType = 22;
                        break block0;
                    }
                    case 7: {
                        javaType = 22;
                        break block0;
                    }
                    case 8: {
                        javaType = 17;
                        break block0;
                    }
                    case 9: {
                        javaType = 19;
                        break block0;
                    }
                    case 10: 
                    case 11: {
                        javaType = 21;
                        break block0;
                    }
                    case 12: 
                }
                javaType = 23;
                break;
            }
            case 0: {
                switch (subType) {
                    default: {
                        javaType = 25;
                        break block0;
                    }
                    case 5: {
                        javaType = 27;
                        break block0;
                    }
                    case 6: {
                        javaType = 29;
                        break block0;
                    }
                    case 7: {
                        javaType = 29;
                        break block0;
                    }
                    case 8: {
                        javaType = 24;
                        break block0;
                    }
                    case 9: {
                        javaType = 26;
                        break block0;
                    }
                    case 10: 
                    case 11: {
                        javaType = 28;
                        break block0;
                    }
                    case 12: 
                }
                javaType = 30;
            }
        }
        return javaType;
    }

    private int convertChartTypeArea() {
        GraphPresetType presetType = new GraphPresetType();
        this.graph.getGraphPresetType(presetType);
        int subType = presetType.minorType;
        int HorizOffset = 5;
        int orientation = this.graph.LObj.getOrientation();
        int javaType = 0;
        switch (subType) {
            default: {
                javaType = 31;
                break;
            }
            case 1: {
                javaType = 31;
                break;
            }
            case 2: 
            case 3: {
                javaType = 33;
                break;
            }
            case 4: {
                javaType = 32;
                break;
            }
            case 5: {
                javaType = 32;
                break;
            }
            case 6: 
            case 7: {
                javaType = 34;
                break;
            }
            case 12: {
                javaType = 35;
            }
        }
        if (orientation == 0) {
            javaType += 5;
        }
        return javaType;
    }

    private int convertChartType3D() {
        GraphPresetType presetType = new GraphPresetType();
        this.graph.getGraphPresetType(presetType);
        int subType = presetType.minorType;
        if (subType < 0 || subType > 16) {
            return 0;
        }
        switch (subType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 131;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 13;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 12;
            }
        }
        return 13;
    }

    private int convertChartTypePie() {
        int subType = this.graph.LObj.SubType;
        int mainType = this.graph.LObj.nGraphType;
        if (mainType == 38) {
            switch (subType) {
                default: {
                    return 55;
                }
                case 6: 
            }
            return 56;
        }
        switch (subType) {
            default: {
                return 57;
            }
            case 5: {
                return 59;
            }
            case 6: {
                return 58;
            }
            case 7: 
        }
        return 60;
    }

    private int convertChartTypeSpecial() throws ChartNotSupportedException {
        int dataINT16GraphType;
        GraphPresetType presetType = new GraphPresetType();
        this.graph.getGraphPresetType(presetType);
        switch (presetType.minorType) {
            case 0: {
                if (this.graph.LObj.getOrientation() == 0) {
                    dataINT16GraphType = 86;
                    break;
                }
                dataINT16GraphType = 85;
                break;
            }
            case 3: {
                dataINT16GraphType = 61;
                break;
            }
            case 4: {
                dataINT16GraphType = 62;
                break;
            }
            case 2: {
                dataINT16GraphType = 65;
                break;
            }
            case 17: {
                dataINT16GraphType = 89;
                break;
            }
            case 18: {
                dataINT16GraphType = 91;
                break;
            }
            case 13: {
                dataINT16GraphType = 127;
                break;
            }
            case 12: {
                dataINT16GraphType = 67;
                break;
            }
            case 20: {
                dataINT16GraphType = 68;
                break;
            }
            case 5: 
            case 6: {
                dataINT16GraphType = this.getStockChartType(presetType.minorType, this.graph.DLObj.nDataFormatID);
                break;
            }
            case 21: {
                dataINT16GraphType = 70;
                break;
            }
            case 22: {
                dataINT16GraphType = 73;
                break;
            }
            case 60: {
                dataINT16GraphType = 106;
                break;
            }
            default: {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Chart type not supported.");
                }
                throw new ChartNotSupportedException("Chart type not implemented yet.");
            }
        }
        return dataINT16GraphType;
    }

    private int getStockChartType(int minorType, int format) {
        int pfjType = -1;
        block0 : switch (minorType) {
            case 6: {
                switch (format) {
                    case 1: {
                        pfjType = 74;
                        break;
                    }
                    case 3: {
                        pfjType = 80;
                        break;
                    }
                    case 6: {
                        pfjType = 80;
                        break;
                    }
                    case 2: {
                        pfjType = 129;
                    }
                }
                break;
            }
            case 5: {
                switch (format) {
                    case 1: {
                        pfjType = 73;
                        break block0;
                    }
                    case 3: {
                        pfjType = 79;
                        break block0;
                    }
                    case 6: {
                        pfjType = 76;
                        break block0;
                    }
                    case 2: {
                        pfjType = 128;
                    }
                }
            }
        }
        return pfjType;
    }

    private void convertLegend() {
        IdentObj legendAreaID = Identity.LegendArea;
        boolean showLegend = this.graph.LObj.bLegendWanted;
        int pfjLegendPosition = this.convertPlaceLegend(this.graph.nDefaultLegendIndicator);
        this.perspective.setLegendDisplay(showLegend);
        int nLegendLayout = this.graph.LObj.nLegendLayout;
        switch (nLegendLayout) {
            default: {
                this.perspective.setLegendLabelType(0);
                break;
            }
            case 3: {
                this.perspective.setLegendLabelType(3);
                break;
            }
            case 4: {
                this.perspective.setLegendLabelType(2);
                break;
            }
            case 5: {
                this.perspective.setLegendLabelType(1);
            }
        }
        this.perspective.setLegendRect(this.WriteJAVA_TransformRect(this.graph.LObj.Legend));
        this.perspective.setLegendAutomatic(true);
        this.perspective.setLegendOrient(2);
        this.perspective.setPlace(true);
        this.perspective.setLegendPosition(pfjLegendPosition);
        this.perspective.setPlacePosition(legendAreaID, pfjLegendPosition);
        this.setAreaAttributes(legendAreaID, 2, 35);
        this.setTextAttributes(this.graph.LObj.Header4, Identity.LegendText);
        this.perspective.setLegendMarkerPosition(this.convertMarkerLayoutMode(this.graph.nMarkerLayoutMode));
        IdentObj idLegentText = new IdentObj(14);
        this.perspective.setTextJustHoriz(idLegentText, 0);
        this.perspective.setDisplay(Identity.LegendTitle, this.graph.LObj.bShowSeriesTitle != 0);
        int pfjStyle = 0;
        if (this.graph.LegendFancyBox != null) {
            pfjStyle = this.convertBorderStyle(this.graph.LegendFancyBox.nStyle);
        }
        this.setBorderAttributes(legendAreaID, pfjStyle, 200);
        if (pfjLegendPosition == -1) {
            this.perspective.setLegendMarkersPerRow(this.graph.LObj.nLegendElements);
        }
        if ((this.getCurrentGraphType().isPieType() || this.getCurrentGraphType().isFunnelType()) && this.perspective.getLegendLabelType() != 0) {
            this.perspective.setLegendMarkersPerRow(1);
        }
    }

    private int convertPlaceLegend(int i) {
        switch (i) {
            case 0: {
                return -1;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    private int convertMarkerLayoutMode(int i) {
        int retval;
        switch (i) {
            case 0: {
                retval = 0;
                break;
            }
            case 1: {
                retval = 1;
                break;
            }
            case 2: {
                retval = 4;
                break;
            }
            case 3: {
                retval = 2;
                break;
            }
            case 4: {
                retval = 3;
                break;
            }
            default: {
                retval = 0;
            }
        }
        return retval;
    }

    private void convertStock() {
        if (!this.getCurrentGraphType().isStockType()) {
            return;
        }
        boolean bShowOpen = this.graph.LObj.StockMktLook.bShowOpen;
        this.perspective.setStockOpenTicksDisplay(bShowOpen);
        boolean bShowClose = this.graph.LObj.StockMktLook.bShowClose;
        this.perspective.setStockCloseTicksDisplay(bShowClose);
        this.perspective.setInterpretAsHLOC(true);
        this.perspective.setStockRiserWidthVC(this.graph.LObj.StockMktLook.nHLWidth);
        this.perspective.setStockTickWidthVC(this.graph.LObj.StockMktLook.nOCWidth);
        this.perspective.setStockTickHeightVC(this.graph.LObj.StockMktLook.nOCHeight);
        this.perspective.setStockCloseSplitDisplay(false);
        switch (this.graph.LObj.StockMktLook.nDTXTItem) {
            case 0: {
                this.perspective.setDataTextTemplateHiLo("[HIGH]");
                break;
            }
            case 1: {
                this.perspective.setDataTextTemplateHiLo("[LOW]");
                break;
            }
            case 2: {
                if (this.graph.DLObj.nDataFormatID != 3) break;
                this.perspective.setDataTextTemplateHiLo("[OPEN]");
                break;
            }
            case 3: {
                if (!(this.graph.DLObj.nDataFormatID == 3 | this.graph.DLObj.nDataFormatID == 6)) break;
                this.perspective.setDataTextTemplateHiLo("[CLOSE]");
            }
        }
    }

    private void convertBubble() {
        if (!this.getCurrentGraphType().isBubble()) {
            return;
        }
        this.perspective.setMaxBubbleSize(this.convertMarkerSize(this.graph.LObj.BubbleLook.nMaxBubble));
        this.perspective.setMinBubbleSize(this.convertMarkerSize(this.graph.LObj.BubbleLook.nMinBubble));
        this.setTextAttributes(this.graph.LObj.Label2, Identity.X1Label);
        this.perspective.setDisplay(Identity.QuadrantLine, false);
        if (this.bitwiseAND(this.graph.LObj.nShowQDRLabels, 16)) {
            this.perspective.setDataTextTemplateBubble("([X], [Y], [SIZE])");
        } else {
            this.perspective.setDataTextTemplateBubble("([X], [Y])");
        }
    }

    private void convertGauge() {
        int i;
        int nBand;
        if (!this.getCurrentGraphType().isGaugeType()) {
            return;
        }
        IdentObj[] bands = new IdentObj[]{this.perspective.getGaugeBand1(), this.perspective.getGaugeBand2(), this.perspective.getGaugeBand3(), this.perspective.getGaugeBand4(), this.perspective.getGaugeBand5()};
        for (nBand = 0; nBand < bands.length; ++nBand) {
            this.perspective.setGaugeBandMin(bands[nBand], 0.0);
            this.perspective.setGaugeBandMax(bands[nBand], 0.0);
            this.perspective.setTransparentFillColor(bands[nBand], true);
            this.perspective.setTransparentBorderColor(bands[nBand], true);
        }
        nBand = 0;
        for (i = 0; i < this.graph.gauge.Range.length && nBand < bands.length; ++i) {
            if (!this.graph.gauge.Range[i].bShowRange) continue;
            this.perspective.setGaugeBandMin(bands[nBand], this.graph.gauge.Range[i].fRangeStart);
            this.perspective.setGaugeBandMax(bands[nBand], this.graph.gauge.Range[i].fRangeEnd);
            this.setFillColor(bands[nBand], this.graph.gauge.Range[i].RangeArea.color);
            this.setLineAttributes(bands[nBand], this.graph.gauge.GaugeBorder, false);
            this.convertSFX(bands[nBand], this.graph.gauge.Range[i].RangeArea);
            ++nBand;
        }
        int pfjStyle = 0;
        if (this.graph.gauge.GaugeContainerFancyBox != null) {
            pfjStyle = this.convertBorderStyle(this.graph.gauge.GaugeContainerFancyBox.nStyle);
        }
        this.setBorderAttributes(Identity.SubFrame, pfjStyle, 200);
        this.setAreaAttributes(Identity.SubFrame, 3, 21);
        this.perspective.setPiesPerRow(this.graph.LObj.PieLook.PiesPerRow);
        this.perspective.setGaugeBandThicknessVC(this.graph.gauge.nThickness);
        this.perspective.setGaugeMajorTickRelativeTickLength(1.0);
        this.perspective.setGaugeMinorTickRelativeTickLength(0.5);
        this.setFillColor(this.perspective.getGaugeBackground(), this.graph.gauge.GaugeFill.color);
        this.setLineAttributes(this.perspective.getGaugeBackground(), this.graph.gauge.GaugeBorder, false);
        this.convertSFX(this.perspective.getGaugeBackground(), this.graph.gauge.GaugeFill);
        this.perspective.setGaugeNeedleStyle(5);
        this.perspective.setDisplay(this.perspective.getGaugeStyledBackground(), false);
        this.perspective.setDisplay(this.perspective.getGaugeBackground(), false);
        this.perspective.setDisplay(this.perspective.getGaugeMajorTick(), this.perspective.getY1MajorGridDisplay());
        this.perspective.setDisplay(this.perspective.getGaugeMinorTick(), this.perspective.getY1MinorGridDisplay());
        this.perspective.setDisplay(this.perspective.getGaugeLabel(), this.perspective.getY1LabelDisplay());
        this.setLineAttributes(this.perspective.getGaugeMajorTick(), this.graph.LObj.LineColors[5], false);
        this.setLineAttributes(this.perspective.getGaugeMinorTick(), this.graph.LObj.LineColors[6], false);
        this.perspective.setGaugeStopAngle(this.graph.gauge.nStartAngle);
        this.perspective.setGaugeStartAngle(this.graph.gauge.nStopAngle);
        this.perspective.setGaugeDescending(this.graph.LObj.Y1Axis.bInvertNumScale);
        this.perspective.setGaugeTitlePosition(1);
        this.setTextAttributes(this.graph.LObj.Label3, this.perspective.getGaugeLabel());
        this.setTitleBoxAttributes(this.graph.LObj.Label3, this.perspective.getGaugeLabel());
        this.setTextAttributes(this.graph.LObj.Header1, this.perspective.getGaugeTitle());
        this.setTitleBoxAttributes(this.graph.LObj.Header1, this.perspective.getGaugeTitle());
        boolean major = (this.graph.LObj.Y1Axis.nShowStatus & 4) == 4 && this.graph.LObj.Y1Axis.MajorHashFrame.HashStyle != 0;
        this.perspective.setDisplay(this.perspective.getGaugeMajorTick(), major);
        boolean minor = (this.graph.LObj.Y1Axis.nShowStatus & 8) == 8 && this.graph.LObj.Y1Axis.MinorHashFrame.HashStyle != 0;
        this.perspective.setDisplay(this.perspective.getGaugeMinorTick(), minor);
        int numSeries = this.perspective.getSeriesLooping();
        for (i = 0; i < numSeries; ++i) {
            this.perspective.setTransparentFillColor(new IdentObj(100, -3, i), true);
            this.perspective.setTransparentBorderColor(new IdentObj(100, -3, i), true);
        }
        this.perspective.setDisplay(new IdentObj(119), false);
    }

    private void convertFunnel() {
        int nDataINT16;
        if (!this.getCurrentGraphType().isFunnelType()) {
            return;
        }
        SerDepDataClass seriesDependantData = (SerDepDataClass)this.graph.DLObj.vaSerDep.get(0);
        this.perspective.setFunnelVertExplosionFactor(seriesDependantData.PieSerDepData.nMove);
        this.perspective.setPieRotate(this.graph.LObj.PieLook.nPieRotate);
        if (!this.graph.LObj.PieLook.bPieTilt) {
            this.perspective.setPieTilt(0);
        } else {
            nDataINT16 = this.graph.LObj.PieLook.nPieTilt;
            this.perspective.setPieTilt(nDataINT16);
        }
        nDataINT16 = this.graph.LObj.PieLook.PieDepth / 30;
        this.perspective.setPieDepth(nDataINT16);
        short labelChoice = seriesDependantData == null ? (short)0 : seriesDependantData.PieSerDepData.nShowPieLabel;
        this.perspective.setDisplay(Identity.FunnelSliceLabel, this.bitwiseAND(labelChoice, 2));
        this.perspective.setDisplay(Identity.FunnelValueLabel, this.bitwiseAND(labelChoice, 1));
        this.perspective.setDisplay(Identity.FunnelFeeler, seriesDependantData.PieSerDepData.bShowFeeler);
        this.perspective.setDataTextPosition(this.convertDataTextPosition(this.graph.LObj.Y1Axis.nPlaceQDRLabel));
        if (this.bitwiseAND(labelChoice, 32)) {
            this.perspective.setPieValueFormat(0);
        } else {
            this.perspective.setPieValueFormat(1);
        }
        this.perspective.setDisplay(Identity.FunnelGroupLabel, this.graph.LObj.PieLook.bShowGroupLabels);
        this.setTextAttributes(this.graph.LObj.Label1, Identity.FunnelSliceLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Label1, Identity.FunnelSliceLabelBox);
        this.setTextAttributes(this.graph.LObj.Label2, Identity.FunnelValueLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Label2, Identity.FunnelValueLabelBox);
        this.setTextAttributes(this.graph.LObj.Header1, Identity.FunnelGroupLabel);
        this.setTitleBoxAttributes(this.graph.LObj.Header1, Identity.FunnelGroupLabelBox);
    }

    private void convertGantt() {
        this.perspective.setDisplay(Identity.ChildLinkLine, false);
    }

    private void convertO1Axis() {
        boolean showMinor;
        AxisLookClass o1Axis = this.graph.LObj.O1Axis;
        this.perspective.setExtendToFrameEdge(this.graph.LObj.O1Axis.nOrdSpace == 1);
        this.perspective.setExcludeMaxLabel(Identity.O1Label, this.convertExcludeLabel(o1Axis.nScaleEnd, true));
        this.perspective.setExcludeMinLabel(Identity.O1Label, this.convertExcludeLabel(o1Axis.nScaleEnd, false));
        if ((o1Axis.nShowStatus & 1) == 1) {
            this.perspective.setO1AxisLineDisplay(true);
        } else {
            this.perspective.setO1AxisLineDisplay(false);
        }
        if ((o1Axis.nShowStatus & 1) == 1) {
            this.perspective.setO1AxisLineDisplay(true);
        } else {
            this.perspective.setO1AxisLineDisplay(false);
        }
        this.setLineAttributes(Identity.O1AxisLine, 30);
        if ((o1Axis.nShowStatus & 2) == 2) {
            this.perspective.setO1LabelDisplay(true);
        } else {
            this.perspective.setO1LabelDisplay(false);
        }
        boolean showMajor = this.bitwiseAND(o1Axis.nShowStatus, 4) && (o1Axis.MajorHashFrame.HashStyle != 0 || this.getCurrentGraphType().isRadarType());
        boolean bl = showMinor = this.bitwiseAND(o1Axis.nShowStatus, 8) && o1Axis.MinorHashFrame.HashStyle != 0;
        if (this.perspective.pgsdkToPfjO1MajorMinorGridlinesSwapped()) {
            this.perspective.setO1MajorGridDisplay(showMinor);
            this.perspective.setO1MinorGridDisplay(showMajor);
        } else {
            this.perspective.setO1MajorGridDisplay(showMajor);
            this.perspective.setO1MinorGridDisplay(showMinor);
        }
        switch (o1Axis.Side) {
            case 0: 
            case 1: 
            case 2: {
                this.perspective.setO1AxisSide(o1Axis.Side);
            }
        }
        if (o1Axis.bStaggered) {
            this.perspective.setO1LabelStagger(true);
        } else {
            this.perspective.setO1LabelStagger(false);
        }
    }

    private void convertO2Axis() {
        if (this.perspective.getJGraphType().getAxisDescriptor().hasO2()) {
            this.perspective.setO2LabelDisplay(true);
        }
    }

    private void convertTextAutofit() {
        int bDataBoolean16 = this.graph.LObj.nAutoFitQDRLabels;
        bDataBoolean16 = this.graph.LObj.O1Axis.ctAxis.bAutoFit;
        if (bDataBoolean16 == 1) {
            this.perspective.setO1LabelAutofit(true);
        } else {
            this.perspective.setO1LabelAutofit(false);
        }
        if (this.perspective.getJGraphType().getAxisDescriptor().hasO2()) {
            bDataBoolean16 = this.graph.LObj.O2Axis.ctAxis.bAutoFit;
            if (bDataBoolean16 == 1) {
                this.perspective.setO2LabelAutofit(true);
            } else {
                this.perspective.setO2LabelAutofit(false);
            }
        }
        if ((bDataBoolean16 = this.graph.LObj.X1Axis.ctAxis.bAutoFit) == 1) {
            this.perspective.setX1LabelAutofit(true);
        } else {
            this.perspective.setX1LabelAutofit(false);
        }
        bDataBoolean16 = this.graph.LObj.Y1Axis.ctAxis.bAutoFit;
        if (bDataBoolean16 == 1) {
            this.perspective.setY1LabelAutofit(true);
        } else {
            this.perspective.setY1LabelAutofit(false);
        }
        if (this.perspective.getJGraphType().getAxisDescriptor().hasY2()) {
            bDataBoolean16 = this.graph.LObj.Y2Axis.ctAxis.bAutoFit;
            if (bDataBoolean16 == 1) {
                this.perspective.setY2LabelAutofit(true);
            } else {
                this.perspective.setY2LabelAutofit(false);
            }
        }
        this.perspective.setLegendTextAutofit(this.graph.LObj.ctLegendHead.bAutoFit == 1);
    }

    private float scaleLineWidthToPointSize(int i, boolean advancedPGSDKThicknessCalculation) {
        float pgsdkFactor = 3.125E-5f * ((float)this.perspective.getDocumentHeightInPoints() / 1.33333f) * Math.max(1.0f, (float)this.perspective.getDocumentWidthInTwips() / (float)this.perspective.getDocumentHeightInTwips());
        if (advancedPGSDKThicknessCalculation) {
            return Math.max(0.25f, pgsdkFactor * (float)i);
        }
        return Math.max((float)i / 150.0f, 0.25f);
    }

    private int WriteJAVA_TransformFontStyle(int style) {
        boolean PGSDK_FONTSTYLE_BOLD = true;
        int PGSDK_FONTSTYLE_ITALIC = 2;
        int PGSDK_FONTSTYLE_UNDERLINE = 4;
        int pfjStyle = 0;
        if (this.bitwiseAND(style, 1)) {
            pfjStyle |= 2;
        }
        if (this.bitwiseAND(style, 2)) {
            pfjStyle |= 1;
        }
        if (this.bitwiseAND(style, 4)) {
            pfjStyle |= 4;
        }
        return pfjStyle;
    }

    private Color WriteJAVA_ScaleColor(RGB16 c) {
        return this.WriteJAVA_ScaleColor(c.red, c.green, c.blue);
    }

    private Color WriteJAVA_ScaleColor(ColorInstRec pColor) {
        return this.WriteJAVA_ScaleColor(pColor.nRed, pColor.nGreen, pColor.nBlue);
    }

    private Color WriteJAVA_ScaleColor(int r, int g, int b) {
        return new Color(r >>= 8, g >>= 8, b >>= 8);
    }

    Rectangle WriteJAVA_TransformRect(BoxInstRec pRectOld) {
        Rectangle newRect = new Rectangle();
        if (pRectOld == null) {
            return newRect;
        }
        double xULC = (double)pRectOld.xULC * 0.9766221082829762;
        double yULC = (double)pRectOld.yULC * 0.9766221082829762;
        double xLRC = (double)pRectOld.xLRC * 0.9766221082829762;
        double yLRC = (double)pRectOld.yLRC * 0.9766221082829762;
        newRect.x = (int)xULC;
        newRect.y = (int)yLRC;
        newRect.width = (int)Math.abs(xULC - xLRC);
        newRect.height = (int)Math.abs(yULC - yLRC);
        return newRect;
    }

    private void PGSDKFormatToAdvFormatStruct(AdvFormatStruct a, int nPGSDKFormat) {
        int THOUSANDS_SYMBOL = 75;
        int MILLIONS_SYMBOL = 77;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols dfs = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            a.szCurrency = dfs.getCurrencySymbol().toCharArray();
            a.szDecimal[0] = dfs.getDecimalSeparator();
            a.szMonDecimalSep[0] = dfs.getMonetaryDecimalSeparator();
            a.szThousand[0] = dfs.getGroupingSeparator();
            a.szMonThousandSep[0] = dfs.getGroupingSeparator();
        } else {
            a.szCurrency[0] = 36;
            a.szDecimal[0] = 46;
            a.szMonDecimalSep[0] = 46;
            a.szThousand[0] = 44;
            a.szMonThousandSep[0] = 44;
        }
        a.szScientificSymbol[0] = 101;
        a.iLZero = 1;
        switch (nPGSDKFormat) {
            default: {
                a.formatType = 1;
                break;
            }
            case 1: 
            case 2: {
                a.formatType = 2;
                a.iDigits = 0;
                break;
            }
            case 3: {
                a.formatType = 2;
                a.iDigits = 1;
                break;
            }
            case 4: {
                a.formatType = 2;
                a.iDigits = 2;
                break;
            }
            case 5: {
                a.formatType = 2;
                a.iGrouping = 3;
                break;
            }
            case 6: {
                a.formatType = 2;
                a.iGrouping = 3;
                a.iDigits = 2;
                break;
            }
            case 7: {
                a.formatType = 6;
                break;
            }
            case 8: {
                a.formatType = 6;
                a.iDigits = 2;
                break;
            }
            case 9: {
                a.formatType = 6;
                a.iMonGrouping = 3;
                break;
            }
            case 10: {
                a.formatType = 6;
                a.iMonGrouping = 3;
                a.iDigits = 2;
                break;
            }
            case 11: 
            case 14: {
                a.formatType = 4;
                break;
            }
            case 12: 
            case 15: {
                a.formatType = 4;
                a.iDigits = 1;
                break;
            }
            case 13: 
            case 16: {
                a.formatType = 4;
                a.iDigits = 2;
                break;
            }
            case 17: {
                a.formatType = 3;
                a.szScientificSymbol[0] = 69;
                a.iDigits = 1;
                break;
            }
            case 18: {
                a.formatType = 3;
                a.szScientificSymbol[0] = 69;
                a.iDigits = 2;
                break;
            }
            case 19: {
                a.formatType = 3;
                a.szScientificSymbol[0] = 69;
                a.iDigits = 3;
                break;
            }
            case 20: {
                a.formatType = 3;
                a.iDigits = 1;
                break;
            }
            case 21: {
                a.formatType = 3;
                a.iDigits = 2;
                break;
            }
            case 22: {
                a.formatType = 3;
                a.iDigits = 3;
                break;
            }
            case 23: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.szPostfixText[0] = 75;
                break;
            }
            case 24: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iDigits = 2;
                a.szPostfixText[0] = 75;
                break;
            }
            case 25: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iGrouping = 3;
                a.szPostfixText[0] = 75;
                break;
            }
            case 26: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iGrouping = 3;
                a.iDigits = 2;
                a.szPostfixText[0] = 75;
                break;
            }
            case 27: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.szPrefixText[0] = 75;
                break;
            }
            case 28: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iDigits = 2;
                a.szPrefixText[0] = 75;
                break;
            }
            case 29: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iGrouping = 3;
                a.szPrefixText[0] = 75;
                break;
            }
            case 30: {
                a.formatType = 2;
                a.dScaleFactor = 1000.0;
                a.iGrouping = 3;
                a.iDigits = 2;
                a.szPrefixText[0] = 75;
                break;
            }
            case 31: {
                a.formatType = 6;
                a.dScaleFactor = 1000.0;
                a.szPostfixText[0] = 75;
                a.szPostfixText[1] = '\u0000';
                a.iCurrDigits = 0;
                a.iMonGrouping = 0;
                a.iPosCurr = 0;
                break;
            }
            case 32: {
                a.formatType = 6;
                a.dScaleFactor = 1000.0;
                a.szPostfixText[0] = 75;
                a.iCurrDigits = 2;
                a.iMonGrouping = 0;
                a.iPosCurr = 0;
                break;
            }
            case 33: {
                a.formatType = 6;
                a.dScaleFactor = 1000.0;
                a.iMonGrouping = 3;
                a.szPostfixText[0] = 75;
                a.iCurrDigits = 0;
                a.iPosCurr = 0;
                break;
            }
            case 34: {
                a.formatType = 6;
                a.dScaleFactor = 1000.0;
                a.iMonGrouping = 3;
                a.szPostfixText[0] = 75;
                a.iCurrDigits = 2;
                a.iPosCurr = 0;
                break;
            }
            case 35: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.szPostfixText[0] = 77;
                break;
            }
            case 36: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iDigits = 2;
                a.szPostfixText[0] = 77;
                break;
            }
            case 37: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iGrouping = 3;
                a.szPostfixText[0] = 77;
                break;
            }
            case 38: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iGrouping = 3;
                a.iDigits = 2;
                a.szPostfixText[0] = 77;
                break;
            }
            case 39: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.szPrefixText[0] = 77;
                break;
            }
            case 40: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iDigits = 2;
                a.szPrefixText[0] = 77;
                break;
            }
            case 41: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iGrouping = 3;
                a.szPrefixText[0] = 77;
                break;
            }
            case 42: {
                a.formatType = 2;
                a.dScaleFactor = 1000000.0;
                a.iGrouping = 3;
                a.iDigits = 2;
                a.szPrefixText[0] = 77;
                break;
            }
            case 43: {
                a.formatType = 6;
                a.dScaleFactor = 1000000.0;
                a.szPostfixText[0] = 77;
                break;
            }
            case 44: {
                a.formatType = 6;
                a.dScaleFactor = 1000000.0;
                a.iDigits = 2;
                a.szPostfixText[0] = 77;
                break;
            }
            case 45: {
                a.formatType = 6;
                a.dScaleFactor = 1000000.0;
                a.iMonGrouping = 3;
                a.szPostfixText[0] = 77;
                break;
            }
            case 46: {
                a.formatType = 6;
                a.dScaleFactor = 1000000.0;
                a.iMonGrouping = 3;
                a.iDigits = 2;
                a.szPostfixText[0] = 77;
                break;
            }
            case 47: {
                a.formatType = 8;
                a.szTimeFormat = "hh':'mm tt".toCharArray();
                break;
            }
            case 48: {
                a.formatType = 8;
                a.szTimeFormat = "hh':'mm':'ss tt".toCharArray();
                break;
            }
            case 49: {
                a.formatType = 8;
                a.szTimeFormat = "HH':'mm".toCharArray();
                break;
            }
            case 50: {
                a.formatType = 7;
                DateFormat d = DateFormat.getDateInstance(3);
                if (d instanceof SimpleDateFormat) {
                    a.szDateFormat = ((SimpleDateFormat)d).toLocalizedPattern().toCharArray();
                    break;
                }
                a.szDateFormat = new SimpleDateFormat().toLocalizedPattern().toCharArray();
                break;
            }
            case 51: {
                a.formatType = 7;
                DateFormat dec = DateFormat.getDateInstance(1);
                if (dec instanceof SimpleDateFormat) {
                    a.szDateFormat = ((SimpleDateFormat)dec).toLocalizedPattern().toCharArray();
                    break;
                }
                a.szDateFormat = new SimpleDateFormat().toLocalizedPattern().toCharArray();
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                a.formatType = 7;
                DateFormat df = DateFormat.getDateInstance(2);
                a.szDateFormat = df instanceof SimpleDateFormat ? ((SimpleDateFormat)df).toLocalizedPattern().toCharArray() : new SimpleDateFormat().toLocalizedPattern().toCharArray();
            }
        }
    }

    private JGraphType getCurrentGraphType() {
        return JGraphType.getJGraphType(this.perspective.getGraphType());
    }

    private void setFillColor(IdentObj objectID, ColorInstRec colorRec) {
        if (colorRec == null) {
            return;
        }
        boolean transparent = false;
        if (colorRec.nSpectrumBin == 9999) {
            transparent = true;
        }
        this.perspective.setTransparentFillColor(objectID, transparent);
        if (!transparent) {
            this.perspective.setFillColor(objectID, this.WriteJAVA_ScaleColor(colorRec));
        }
    }

    private void setLineAttributes(IdentObj objectID, LineInstRec lineInstRec, boolean wantFill) {
        if (lineInstRec == null) {
            return;
        }
        if (wantFill) {
            this.setFillColor(objectID, lineInstRec.color);
        }
        this.setLineColor(objectID, lineInstRec.color);
        this.setLineWidth(objectID, lineInstRec);
        this.setLineDash(objectID, lineInstRec);
    }

    private void setLineDash(IdentObj objectID, LineInstRec lineInstRec) {
        if (lineInstRec == null) {
            return;
        }
        int nStyle = lineInstRec.nStyle;
        if (nStyle < 1 || nStyle > 15) {
            this.perspective.setLineBasicStrokeType(objectID, 1);
            this.perspective.setPGSDKLineStyle(objectID, nStyle);
            return;
        }
        int segments = DASH_STYLE[nStyle][0];
        ArrayList<Double> v = new ArrayList<Double>(segments);
        for (int i = 1; i <= segments; ++i) {
            v.add(this.convertDashSpacing(objectID, DASH_STYLE[nStyle][i], lineInstRec.nThick));
        }
        this.perspective.setLineDash(objectID, v);
        this.perspective.setLineBasicStrokeType(objectID, 5);
        this.perspective.setPGSDKLineStyle(objectID, nStyle);
    }

    private double convertDashSpacing(IdentObj objectID, int i, int width) {
        double scalingFactor = Math.max((double)this.scaleLineWidthToPointSize(width, this.wantPGSDKAdvancedThicknessCalcualation(objectID)) * 0.666666, 0.666666);
        return (double)i * scalingFactor;
    }

    private void setLineAttributes(IdentObj objectID, int index) {
        if (this.graph.LObj.LineColors.length < index) {
            return;
        }
        this.setLineAttributes(objectID, this.graph.LObj.LineColors[index], true);
    }

    private void setLineWidth(IdentObj objectID, LineInstRec lineInstRec) {
        if (lineInstRec == null) {
            return;
        }
        float scaledThickness = this.scaleLineWidthToPointSize(lineInstRec.nThick, this.wantPGSDKAdvancedThicknessCalcualation(objectID));
        this.perspective.setLineWidth(objectID, scaledThickness);
    }

    private boolean wantPGSDKAdvancedThicknessCalcualation(IdentObj objectID) {
        return objectID.getObjectID() == -3;
    }

    private void setLineColor(IdentObj objectID, ColorInstRec colorRec) {
        if (colorRec == null) {
            return;
        }
        boolean transparent = false;
        if (colorRec.nSpectrumBin == 9999) {
            transparent = true;
        }
        this.perspective.setTransparentBorderColor(objectID, transparent);
        if (!transparent) {
            this.perspective.setBorderColor(objectID, this.WriteJAVA_ScaleColor(colorRec));
        }
    }

    private void setAreaAttributes(IdentObj objectID, int fillIndex, int borderIndex) {
        if (this.graph.LObj.AreaColors.length < fillIndex) {
            return;
        }
        if (this.graph.LObj.LineColors.length < borderIndex) {
            return;
        }
        if (null != this.graph.LObj.AreaColors[fillIndex] && null != this.graph.LObj.AreaColors[fillIndex].color) {
            this.setFillColor(objectID, this.graph.LObj.AreaColors[fillIndex].color);
        }
        if (null != this.graph.LObj.LineColors[borderIndex]) {
            this.setLineAttributes(objectID, this.graph.LObj.LineColors[borderIndex], false);
        }
    }

    private void convertHistogram() {
        if (!this.getCurrentGraphType().isHistogram()) {
            return;
        }
        this.setTextAttributes(this.graph.LObj.Label2, Identity.X1Label);
        AreaInstRec area = this.graph.LObj.vaRiserColors.getAt(0);
        this.convertSFX(Identity.HistogramRiser, area);
        if (area.color.nSpectrumBin == 9999) {
            this.perspective.setTransparentFillColor(Identity.HistogramRiser, true);
        } else {
            this.perspective.setFillColor(Identity.HistogramRiser, this.WriteJAVA_ScaleColor(area.color));
            this.perspective.setTransparentFillColor(Identity.HistogramRiser, false);
        }
        LineInstRec seriesLine = this.getSeriesRiserLineBorder(0, this.graph.LObj.vaSerDepLook.getAt(0));
        if (seriesLine != null) {
            this.setLineAttributes(Identity.HistogramRiser, seriesLine, false);
        }
    }

    public static class PerspectiveSummary {
        public int jChartType;
        public boolean isNumericAxis;
        public boolean isDateTimeAxis;
        public boolean seriesAreSwapped;
        public int numMissingTextures;
    }
}

