/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.gauges;

import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.GaugeAutoScaleBase;
import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.IGauge;
import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.TrendPointInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.common.math.FloatingPoint;
import com.businessobjects.visualization.pfjgraphics.rendering.common.math.ValueListFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.MinMaxStep;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.ScaleLinear;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.ScaleLog;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardDraw;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.MinMax;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjectID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class GaugeBase
implements IGauge {
    protected static final int kNB_QUALITY_BANDS = 5;
    protected static final double INITIAL_VALUE = 1.23456E-306;
    protected IStandardDraw m_StdDraw;
    protected IStandardLook m_StdLook;
    protected String m_szTitle = null;
    protected List<Double> m_ScaleMajorTicksList;
    protected List<Double> m_ScaleMinorTicksList;
    private Number m_Value = new Double(1.23456E-306);
    protected double[] m_ValueList;
    protected double m_dStep = 10.0;
    protected double m_dMinorStep = 5.0;
    protected boolean m_AutoScaleStep = true;
    protected IScale m_Scale;
    protected MinMax[] m_QualityMinMax;
    private double m_rawMin = 0.0;
    private double m_rawMax = 100.0;
    protected Rectangle m_rGauge;
    protected double m_dRatioX;
    protected double m_dRatioY;
    protected double m_dScaleMultiple = 1.0;
    protected List<TrendPointInfo> m_TrendPointInfoList;
    private boolean m_bNeedleVisible = true;
    protected Map<String, Mark> m_MarkMap = new HashMap<String, Mark>();
    private int m_nTitlePosition = 1;
    protected Perspective m_p;
    protected Dimension m_titleBoundingBoxDC = new Dimension(0, 0);

    protected GaugeBase(IStandardDraw stdDraw, IStandardLook stdLook, Object logger) throws IllegalArgumentException {
        if (stdDraw == null || stdLook == null) {
            throw new IllegalArgumentException("init: null parameter passed");
        }
        this.m_p = stdLook.getPerspective();
        this.m_StdDraw = stdDraw;
        this.m_StdLook = stdLook;
        this.m_rGauge = null;
        this.m_QualityMinMax = new MinMax[5];
        this.m_QualityMinMax[0] = new MinMax(0.0, 20.0);
        this.m_QualityMinMax[1] = new MinMax(20.0, 40.0);
        this.m_QualityMinMax[2] = new MinMax(40.0, 60.0);
        this.m_QualityMinMax[3] = new MinMax(60.0, 80.0);
        this.m_QualityMinMax[4] = new MinMax(80.0, 100.0);
        this.initLook();
        this.m_StdDraw.addDetectableObject(stdLook.getObjectID("GaugeNeedle"));
    }

    public void setTitleBoundingBoxDimensionDC(Dimension titleBoundingBoxDimensionDC) {
        this.m_titleBoundingBoxDC = titleBoundingBoxDimensionDC;
    }

    protected void calcScale() {
        boolean bLogScale = this.getAttrBoolean("GaugeArea", "Gauge.LogScale");
        boolean bAutoMinorStep = this.getAttrBoolean("GaugeArea", "Gauge.ScaleMinorAutoStep");
        GaugeAutoScaleBase autoScale = new GaugeAutoScaleBase(false, false, this.m_AutoScaleStep, this.m_dStep, bLogScale, 10.0, this.getStepDensity());
        MinMaxStep minMaxStep = autoScale.findNiceLimits(new MinMax(this.m_rawMin, this.m_rawMax));
        this.m_Scale = bLogScale ? new ScaleLog(minMaxStep.getMin(), minMaxStep.getMax()) : new ScaleLinear(minMaxStep.getMin(), minMaxStep.getMax());
        this.m_ScaleMajorTicksList = ValueListFactory.makeValueList(minMaxStep.getMin(), minMaxStep.getMax(), minMaxStep.getStep(), Double.MAX_VALUE, 1, true);
        double dMinorStep = bAutoMinorStep ? minMaxStep.getStep() / 2.0 : this.m_dMinorStep;
        this.m_ScaleMinorTicksList = ValueListFactory.makeValueList(minMaxStep.getMin(), minMaxStep.getMax(), minMaxStep.getStep(), dMinorStep, 1, false);
    }

    protected void drawBackground() {
        if (this.getAttrBoolean("GaugeBackground", "Visible")) {
            this.m_StdDraw.drawRectangle(this.m_StdLook.getObjectID("GaugeBackground"), this.m_StdDraw.getRectangle(), this.m_StdLook);
        }
    }

    public void drawInOffscreen() {
        this.calcScale();
        this.drawBackground();
        this.calcRatios();
    }

    protected void drawQualityBands() {
        String[] szObjectIDs = new String[]{"GaugeBand1", "GaugeBand2", "GaugeBand3", "GaugeBand4", "GaugeBand5"};
        for (int i = 0; i < 5; ++i) {
            boolean pgsdkCompatible;
            double dMax;
            ObjectID objectID = this.m_StdLook.getObjectID(szObjectIDs[i]);
            if (!this.getAttrBoolean(szObjectIDs[i], "Visible")) continue;
            double dMin = this.m_QualityMinMax[i].getMin();
            if (dMin > (dMax = this.m_QualityMinMax[i].getMax())) {
                double dTemp = dMin;
                dMin = dMax;
                dMax = dTemp;
            }
            if (pgsdkCompatible = true) {
                if (!(dMin >= this.m_Scale.getMinValue()) || !(dMin <= this.m_Scale.getMaxValue()) || !(dMax >= this.m_Scale.getMinValue()) || !(dMax <= this.m_Scale.getMaxValue())) continue;
                this.drawQualityBand(objectID, dMin, dMax);
                continue;
            }
            dMin = Math.max(this.m_Scale.getMinValue(), dMin);
            dMax = Math.max(this.m_Scale.getMinValue(), dMax);
            dMin = Math.min(this.m_Scale.getMaxValue(), dMin);
            dMax = Math.min(this.m_Scale.getMaxValue(), dMax);
            if (!(dMax > dMin)) continue;
            this.drawQualityBand(objectID, dMin, dMax);
        }
    }

    protected void drawBackgroundBand(Object objectID) {
    }

    protected abstract void drawQualityBand(Object var1, double var2, double var4);

    protected double getAttrDouble(String szObjectID, String szAttr) throws IllegalArgumentException {
        Double dValue = (Double)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID(szObjectID), this.m_StdLook.getAttr(szAttr));
        return dValue;
    }

    protected boolean getAttrBoolean(String szObjectID, String szAttr) throws IllegalArgumentException {
        Boolean bValue = (Boolean)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID(szObjectID), this.m_StdLook.getAttr(szAttr));
        return bValue;
    }

    protected Rectangle getAttrRectangle(String szObjectID, String szAttr) throws IllegalArgumentException {
        return (Rectangle)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID(szObjectID), this.m_StdLook.getAttr(szAttr));
    }

    public void setNumSeries(int numSeries) {
        this.m_ValueList = new double[numSeries];
    }

    public void setValue(double datavalue, int s) {
        this.m_ValueList[s] = datavalue;
    }

    public Number getValue(boolean bForceInScale) {
        if (bForceInScale && this.m_Value instanceof Double) {
            double dValue = this.m_Value.doubleValue();
            if (dValue < this.m_rawMin) {
                dValue = this.m_rawMin;
                return new Double(dValue);
            }
            if (dValue > this.m_rawMax) {
                dValue = this.m_rawMax;
                return new Double(dValue);
            }
        }
        return this.m_Value;
    }

    public void setTitlePosition(int nTitlePos) {
        this.m_nTitlePosition = nTitlePos;
    }

    public int getTitlePosition() {
        return this.m_nTitlePosition;
    }

    public void setScaleMin(double dMin) {
        this.m_rawMin = dMin;
        this.m_StdDraw.setOffScreenDirty(true);
    }

    public double getScaleMin() {
        return this.m_rawMin;
    }

    public void setScaleMax(double dMax) {
        assert (!Double.isNaN(dMax));
        this.m_rawMax = dMax;
        this.m_StdDraw.setOffScreenDirty(true);
    }

    public double getScaleMax() {
        return this.m_rawMax;
    }

    public void setScaleStep(double dScaleStep) {
        this.m_dStep = dScaleStep;
        this.m_StdDraw.setOffScreenDirty(true);
    }

    public double getScaleStep() {
        return this.m_dStep;
    }

    public void setScaleMinorStep(double dScaleStep) {
        this.m_dMinorStep = dScaleStep;
        this.m_StdDraw.setOffScreenDirty(true);
    }

    public double getScaleMinorStep() {
        return this.m_dMinorStep;
    }

    public void setAutoScaleStep(boolean b) {
        this.m_AutoScaleStep = b;
    }

    public void setQualityBandMinMax(int nBand, double dMin, double dMax) {
        if (nBand < 0 || nBand >= 5) {
            throw new IllegalArgumentException("invalid band index");
        }
        this.m_QualityMinMax[nBand] = new MinMax(dMin, dMax);
        this.m_StdDraw.setOffScreenDirty(true);
    }

    public void draw() {
        if (this.m_StdDraw.isOffScreenDirty()) {
            this.drawInOffscreen();
        }
        this.m_StdDraw.drawOffScreen();
        this.drawAfterOffscreen();
    }

    protected void initLook() {
        Object numberFormatAttr = this.m_StdLook.getAttr("NumberFormat");
        NumberFormat numberFormat = (NumberFormat)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID("GaugeValue"), numberFormatAttr);
        numberFormat.setMaximumFractionDigits(2);
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeValue"), numberFormatAttr, numberFormat);
    }

    protected Polygon transformPolygon(Polygon polyIn) {
        Polygon polyOut = new Polygon();
        for (int i = 0; i < polyIn.npoints; ++i) {
            polyOut.addPoint(this.transformX(polyIn.xpoints[i]), this.transformY(polyIn.ypoints[i]));
        }
        return polyOut;
    }

    protected Polygon transformPolygon(AffineTransform affineTransform, Polygon polyIn) {
        Polygon polyOut = new Polygon();
        double[] source = new double[2];
        double[] dest = new double[2];
        for (int i = 0; i < polyIn.npoints; ++i) {
            source[0] = polyIn.xpoints[i];
            source[1] = polyIn.ypoints[i];
            affineTransform.transform(source, 0, dest, 0, 1);
            polyOut.addPoint((int)dest[0], (int)dest[1]);
        }
        return polyOut;
    }

    protected int transformX(int x) {
        return (int)((double)this.m_rGauge.x + this.m_dRatioX * (double)x);
    }

    protected int transformY(int y) {
        return (int)((double)this.m_rGauge.y + this.m_dRatioY * (double)y);
    }

    protected int invTransformX(int x) {
        return (int)(((double)x - (double)this.m_rGauge.x) / this.m_dRatioX);
    }

    protected int invTransformY(int y) {
        return (int)(((double)y - (double)this.m_rGauge.y) / this.m_dRatioY);
    }

    protected void drawPolygon(String szObjectID, Polygon polygon, Color borderColor, Color fillColor) {
        if (this.getAttrBoolean(szObjectID, "Visible")) {
            ObjectID objectID = this.m_StdLook.getObjectID(szObjectID);
            Object saveFillColor = this.m_StdLook.getAttrValue(objectID, this.m_StdLook.getAttr("FillColor"));
            Object saveBorderColor = this.m_StdLook.getAttrValue(objectID, this.m_StdLook.getAttr("BorderColor"));
            Object saveTextColor = this.m_StdLook.getAttrValue(objectID, this.m_StdLook.getAttr("TextColor"));
            this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("FillColor"), fillColor);
            this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("BorderColor"), borderColor);
            polygon = this.transformPolygon(polygon);
            this.m_StdDraw.drawPolygon(objectID, polygon, this.m_StdLook);
            this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("FillColor"), saveFillColor);
            this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("BorderColor"), saveBorderColor);
            this.m_StdLook.setAttrValue(objectID, this.m_StdLook.getAttr("TextColor"), saveTextColor);
        }
    }

    public void setTitle(String szTitle) {
        this.m_szTitle = szTitle;
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    protected abstract Dimension getMetaSize();

    protected abstract void drawAfterOffscreen();

    protected Polygon getMarkPolygon(Mark mark) {
        return null;
    }

    protected void drawMarks() {
        if (this.getAttrBoolean("GaugeMarker", "Visible")) {
            ObjectID objectID = this.m_StdLook.getObjectID("GaugeMarker");
            int i = 0;
            for (String strName : this.m_MarkMap.keySet()) {
                Polygon poly;
                ObjectID objectNewMisc = objectID.getNewMisc(i);
                this.updateMarkObjectID(strName, objectNewMisc);
                this.m_StdDraw.addDetectableObject(objectNewMisc);
                Mark mark = this.m_MarkMap.get(strName);
                if (mark.value instanceof Double && !((Double)mark.value < this.getScaleMin()) && !((Double)mark.value > this.getScaleMax()) && (poly = this.getMarkPolygon(mark)) != null) {
                    this.m_StdLook.setAttrValue(objectNewMisc, this.m_StdLook.getAttr("BorderColor"), mark.bSmall ? mark.color : Color.black);
                    this.m_StdLook.setAttrValue(objectNewMisc, this.m_StdLook.getAttr("FillColor"), mark.color);
                    this.m_StdDraw.drawPolygon(objectNewMisc, poly, this.m_StdLook);
                }
                ++i;
            }
        }
    }

    protected void drawTrendPoints() {
        if (this.getAttrBoolean("GaugeTrendPoint", "Visible")) {
            ObjectID objectID = this.m_StdLook.getObjectID("GaugeTrendPoint");
            if (this.m_TrendPointInfoList != null) {
                int nSize = this.m_TrendPointInfoList.size();
                for (int i = 0; i < nSize - 1; ++i) {
                    ObjectID objectNewMisc = objectID.getNewMisc(i);
                    TrendPointInfo tpi = this.m_TrendPointInfoList.get(i);
                    Point ptTrend = this.getTrendPointLocation(i, tpi);
                    Polygon polyTrend = new Polygon();
                    polyTrend.addPoint(ptTrend.x - 1, ptTrend.y);
                    polyTrend.addPoint(ptTrend.x, ptTrend.y + 1);
                    polyTrend.addPoint(ptTrend.x + 1, ptTrend.y);
                    polyTrend.addPoint(ptTrend.x, ptTrend.y - 1);
                    this.m_StdDraw.drawPolygon(objectNewMisc, polyTrend, this.m_StdLook);
                }
            }
        }
    }

    protected String calcScaleFactorLabel() {
        if (this.m_dScaleMultiple < 1000.0 && this.m_dScaleMultiple > -1000.0) {
            return "";
        }
        if (this.m_dScaleMultiple < 1000000.0 && this.m_dScaleMultiple > -1000000.0) {
            return "in thousands";
        }
        if (this.m_dScaleMultiple < 1.0E9 && this.m_dScaleMultiple > -1.0E9) {
            return "in millions";
        }
        if (this.m_dScaleMultiple < 1.0E12 && this.m_dScaleMultiple > -1.0E12) {
            return "in billions";
        }
        if (this.m_dScaleMultiple < 1.0E15 && this.m_dScaleMultiple > -1.0E15) {
            return "in trillions";
        }
        return "too big...";
    }

    protected void calcScaleFactor() {
        this.m_dScaleMultiple = 1.0;
        for (double dMax = this.m_rawMax; dMax > 1000.0; dMax /= 1000.0) {
            this.m_dScaleMultiple *= 1000.0;
        }
    }

    protected TrendPointInfo getTrendPoint(double dValue) {
        if (this.m_TrendPointInfoList != null) {
            int nSize = this.m_TrendPointInfoList.size();
            for (int i = 0; i < nSize; ++i) {
                TrendPointInfo tpi = this.m_TrendPointInfoList.get(i);
                if (!FloatingPoint.approxEqual(tpi.getValue(), dValue)) continue;
                return tpi;
            }
        }
        return null;
    }

    protected Color getQualityColor(double dValue) {
        String[] szObjectIDs = new String[]{"GaugeBand1", "GaugeBand2", "GaugeBand3", "GaugeBand4", "GaugeBand5"};
        for (int nIndex = 0; nIndex < szObjectIDs.length; ++nIndex) {
            double dMin = this.m_QualityMinMax[nIndex].getMin();
            double dMax = this.m_QualityMinMax[nIndex].getMax();
            if (!(dValue >= dMin) || !(dValue <= dMax)) continue;
            ObjectID objID = this.m_StdLook.getObjectID(szObjectIDs[nIndex]);
            Color color = (Color)this.m_StdLook.getAttrValue(objID, this.m_StdLook.getAttr("FillColor"));
            return color;
        }
        return Color.black;
    }

    protected boolean isNeedleVisible() {
        return this.m_bNeedleVisible;
    }

    public void updateMarkObjectID(String strName, ObjectID objectID) {
        Mark mark = this.m_MarkMap.get(strName);
        if (mark != null) {
            mark.objectID = objectID;
        }
    }

    public void calc(Rectangle rSubFrameDC) {
        double endDeg = this.getAttrDouble("GaugeScaleArea", "Gauge.StartAngle");
        double startDeg = this.getAttrDouble("GaugeScaleArea", "Gauge.StopAngle");
        if (startDeg >= endDeg) {
            return;
        }
        String clsName = this.m_StdDraw.getClass().getName();
        if (clsName.equals("com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.StandardDrawPFJ")) {
            this.m_StdDraw.drawBegin(rSubFrameDC, this.m_StdLook);
            this.draw();
            this.m_StdDraw.drawEnd();
        }
    }

    protected abstract Point getTrendPointLocation(int var1, TrendPointInfo var2);

    protected abstract void calcRatios();

    protected abstract boolean getStepDensity();

    protected static class Mark {
        Color color;
        Number value;
        String strLabel;
        boolean bSmall;
        ObjectID objectID;

        protected Mark() {
        }
    }
}

