/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;

public class TIMEZONETAB {
    private static HashMap<Integer, TIMEZONETAB> instanceCache = null;
    private int instanceCount = 0;
    private int versionNumber = 0;
    private Hashtable zonetab = new Hashtable();
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int BYTE_SIZE = 10;

    private TIMEZONETAB(int _versionNumber) throws SQLException {
        this.versionNumber = _versionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static TIMEZONETAB getInstance(int versionNumber) throws SQLException {
        TIMEZONETAB tzTab;
        if (instanceCache == null) {
            Class<TIMEZONETAB> clazz = TIMEZONETAB.class;
            // MONITORENTER : oracle.sql.TIMEZONETAB.class
            if (instanceCache == null) {
                instanceCache = new HashMap(5);
            }
            // MONITOREXIT : clazz
        }
        if ((tzTab = instanceCache.get(versionNumber)) != null) return tzTab.returnInstance();
        Class<TIMEZONETAB> clazz = TIMEZONETAB.class;
        // MONITORENTER : oracle.sql.TIMEZONETAB.class
        tzTab = instanceCache.get(versionNumber);
        if (tzTab == null) {
            tzTab = new TIMEZONETAB(versionNumber);
        }
        // MONITOREXIT : clazz
        return tzTab.returnInstance();
    }

    private synchronized TIMEZONETAB returnInstance() {
        ++this.instanceCount;
        instanceCache.put(this.versionNumber, this);
        return this;
    }

    public synchronized void freeInstance() throws SQLException {
        --this.instanceCount;
        if (this.instanceCount < 1) {
            instanceCache.remove(this.versionNumber);
        }
    }

    public void addTrans(byte[] transarray, int regionID) {
        int[] result = new int[BYTE_SIZE];
        int num_trans = transarray[0] & 0xFF;
        OffsetDST[] trans = new OffsetDST[num_trans];
        int transIndex = 0;
        for (int i2 = 1; i2 < num_trans * BYTE_SIZE; i2 += BYTE_SIZE) {
            for (int j2 = 0; j2 < BYTE_SIZE; ++j2) {
                result[j2] = transarray[j2 + i2] & 0xFF;
            }
            int year = (result[0] - 100) * 100 + (result[1] - 100);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            cal.set(14, 0);
            long millis = cal.getTime().getTime();
            int offset = (result[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (result[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte dstflag = (byte)result[9];
            trans[transIndex++] = new OffsetDST(new Timestamp(millis), offset, dstflag);
        }
        this.zonetab.put(regionID & 0x1FF, trans);
    }

    public byte getLocalOffset(Calendar cal, int regionID, OffsetDST trans_data) throws SQLException {
        byte olap;
        block13: {
            byte isdst2;
            byte isdst1;
            boolean tempdate1 = false;
            boolean tempdate2 = false;
            olap = 0;
            Calendar tempCal1 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar tempCal2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar caltemp = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            caltemp.set(1, cal.get(1));
            caltemp.set(2, cal.get(2));
            caltemp.set(5, cal.get(5));
            caltemp.set(11, cal.get(11));
            caltemp.set(12, cal.get(12));
            caltemp.set(13, cal.get(13));
            caltemp.set(14, cal.get(14));
            Calendar auxCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            auxCal.set(1, caltemp.get(1));
            auxCal.set(2, caltemp.get(2));
            auxCal.set(5, 1);
            auxCal.set(11, 0);
            auxCal.set(12, 0);
            auxCal.set(13, 0);
            auxCal.set(14, 0);
            OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
            int i2 = this.findCloseMatch(localTrans, auxCal.getTimeInMillis());
            while (true) {
                tempCal1.setTime(localTrans[i2].getTimestamp());
                int offset1 = localTrans[i2].getOFFSET();
                tempCal1.add(10, offset1 / HOUR_MILLISECOND);
                tempCal1.add(12, offset1 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                isdst1 = localTrans[i2].getDSTFLAG();
                if (caltemp.equals(tempCal1)) {
                    trans_data.setOFFSET(localTrans[i2].getOFFSET());
                    trans_data.setDSTFLAG(localTrans[i2].getDSTFLAG());
                    olap = 0;
                    if (i2 > 0) {
                        isdst2 = localTrans[i2 - 1].getDSTFLAG();
                        if (isdst1 == 0 && isdst2 == 1) {
                            olap = 1;
                        }
                    }
                    break block13;
                }
                if (caltemp.before(tempCal1)) {
                    if (i2 == 0) {
                        trans_data.setOFFSET(0);
                        trans_data.setDSTFLAG((byte)0);
                        olap = 0;
                        if (isdst1 == 1) {
                            tempCal1.add(10, -1);
                            if (!caltemp.before(tempCal1)) {
                                throw new SQLException("Illegal local time.");
                            }
                        }
                        break block13;
                    }
                    if (--i2 < 0) continue;
                    isdst2 = localTrans[i2].getDSTFLAG();
                    if (isdst1 != 1 || isdst2 != 0) continue;
                    tempCal1.add(10, -1);
                    if (caltemp.before(tempCal1)) continue;
                    throw new SQLException("Illegal local time.");
                }
                if (i2 == localTrans.length - 1) break;
                tempCal2.setTime(localTrans[i2 + 1].getTimestamp());
                int offset2 = localTrans[i2 + 1].getOFFSET();
                tempCal2.add(10, offset2 / HOUR_MILLISECOND);
                tempCal2.add(12, offset2 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                if (caltemp.before(tempCal2)) break;
                ++i2;
            }
            trans_data.setOFFSET(localTrans[i2].getOFFSET());
            trans_data.setDSTFLAG(localTrans[i2].getDSTFLAG());
            olap = 0;
            if (isdst1 == 0) {
                if (i2 > 0 && (isdst2 = localTrans[i2 - 1].getDSTFLAG()) == 1) {
                    tempCal1.add(10, 1);
                    if (caltemp.before(tempCal1)) {
                        olap = 1;
                    }
                }
                if (i2 != localTrans.length - 1 && (isdst2 = localTrans[i2 + 1].getDSTFLAG()) == 1) {
                    tempCal2.add(10, -1);
                    if (!caltemp.before(tempCal2)) {
                        throw new SQLException("Illegal local time.");
                    }
                }
            }
        }
        return olap;
    }

    public int getOffset(Calendar cal, int regionID) throws SQLException {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        return this.getOffset(cal, localTrans);
    }

    public int getOffset(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getOFFSET();
    }

    public boolean isDST(Calendar cal, OffsetDST[] localTrans) throws SQLException {
        boolean dateindex = false;
        Timestamp date = new Timestamp(cal.getTime().getTime());
        int index = this.findCloseMatch(localTrans, date.getTime());
        return localTrans[index].getDSTFLAG() == 1;
    }

    public OffsetDST[] getOffsetDST(int regionID) {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID & 0x1FF);
        return localTrans;
    }

    final int findCloseMatch(OffsetDST[] localTrans, long keyDate) {
        int mid;
        int max = localTrans.length;
        int min = 0;
        int mid2 = mid = max / 2;
        if (keyDate < localTrans[min].getTime()) {
            int n2;
            for (n2 = 0; localTrans[n2].getDSTFLAG() == 1 && n2 < localTrans.length; ++n2) {
            }
            return n2 < localTrans.length ? n2 : 0;
        }
        while (mid > 0) {
            if (keyDate > localTrans[mid].getTime()) {
                min = mid;
            } else if (keyDate < localTrans[mid].getTime()) {
                max = mid;
            } else if (mid == min) break;
            mid = min + (max - min) / 2;
            if (mid2 == mid) break;
            mid2 = mid;
        }
        return mid;
    }

    public void displayTable(int regionID) {
        OffsetDST[] localTrans = (OffsetDST[])this.zonetab.get(regionID);
        for (int i2 = 0; i2 < localTrans.length; ++i2) {
            System.out.print(localTrans[i2].getTimestamp().toString());
            System.out.print("    " + localTrans[i2].getOFFSET());
            System.out.println("    " + localTrans[i2].getDSTFLAG());
        }
    }

    public boolean checkID(int regionID) {
        return this.zonetab.get(regionID & 0x1FF) == null;
    }

    public void updateTable(Connection conn, int regionID) throws SQLException, NullPointerException {
        byte[] transarray = TRANSDUMP.getTransitions(conn, regionID);
        if (transarray == null) {
            throw new NullPointerException();
        }
        this.addTrans(transarray, regionID);
    }
}

