/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded = false;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa11";
    private static final char atSignChar = '@';
    private static int rmidSeed = 0;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXADataSource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.isOracleDataSource = true;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection() throws SQLException {
        XAConnection xAConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties prop = new Properties(this.connectionProperties);
            if (this.user != null && this.password != null) {
                prop.setProperty("user", this.user);
                prop.setProperty("password", this.password);
            }
            XAConnection __result__ = this.getXAConnection(prop);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            xAConnection = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String userName, String passwd) throws SQLException {
        XAConnection xAConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties prop = new Properties(this.connectionProperties);
            if (userName == null || passwd == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            prop.setProperty("user", userName);
            prop.setProperty("password", passwd);
            XAConnection __result__ = this.getXAConnection(prop);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            xAConnection = __result__;
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_16 = null;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(Properties prop) throws SQLException {
        XAConnection xAConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(prop));
                    xAConnection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.connCachingEnabled) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 163);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 163);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            XAConnection __result__ = (XAConnection)this.getPooledConnection(prop);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            xAConnection = __result__;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return xAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(String userName, String passwd) throws SQLException {
        PooledConnection pooledConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties prop = new Properties();
            prop.setProperty("user", userName);
            prop.setProperty("password", passwd);
            PooledConnection __result__ = this.getPooledConnection(prop);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            pooledConnection = __result__;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PooledConnection getPooledConnection(Properties info) throws SQLException {
        try {
            String passwd;
            String userName;
            block95: {
                String url;
                block94: {
                    OracleXAHeteroConnection oracleXAHeteroConnection;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXADataSource.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(info));
                            Object var3_2 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    try {
                        int status;
                        Class<OracleXADataSource> __ex__2;
                        url = this.getURL();
                        userName = info.getProperty("user");
                        passwd = info.getProperty("password");
                        String rmName = null;
                        String xaclsstr = null;
                        String localXaOpenString = null;
                        int localRmid = 0;
                        if (!this.useNativeXA || !url.startsWith("jdbc:oracle:oci8") && !url.startsWith("jdbc:oracle:oci")) break block94;
                        long[] ociHandles = new long[]{0L, 0L};
                        String tnsentry = null;
                        String propNlsLangBackdoor = null;
                        OracleXADataSource oracleXADataSource = this;
                        // MONITORENTER : oracleXADataSource
                        tnsentry = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(url);
                        if (tnsentry != null && tnsentry.length() == 0 || tnsentry.startsWith("(DESCRIPTION")) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 207);
                                    Object var14_29 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var14_30 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 207);
                            __ex__2.fillInStackTrace();
                            throw __ex__2;
                        }
                        if (!libraryLoaded) {
                            __ex__2 = OracleXADataSource.class;
                            // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                            if (!libraryLoaded) {
                                try {
                                    System.loadLibrary(dllName);
                                    libraryLoaded = true;
                                }
                                catch (Error exc) {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "------ JNI JDBC XA lib not loaded properly. ------");
                                            Object var16_40 = null;
                                            OracleLog.recursiveExit();
                                        }
                                        catch (Throwable throwable) {
                                            Object var16_41 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                    }
                                    libraryLoaded = false;
                                    throw exc;
                                }
                            }
                            // MONITOREXIT : __ex__2
                        }
                        if (this.connectionProperties != null) {
                            propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                        }
                        // MONITOREXIT : oracleXADataSource
                        if (propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true")) {
                            short driverCharSetId = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                            this.driverCharSetIdString = Integer.toString(driverCharSetId);
                        } else if (!tnsentry.equals(this.oldTnsEntry)) {
                            short driverCharSetId = T2CConnection.getClientCharSetId();
                            this.driverCharSetIdString = Integer.toString(driverCharSetId);
                            this.oldTnsEntry = tnsentry;
                        }
                        OracleXADataSource driverCharSetId = this;
                        // MONITORENTER : driverCharSetId
                        rmName = this.databaseName + dbSuffix + rmidSeed;
                        this.rmid = localRmid = rmidSeed;
                        __ex__2 = OracleXADataSource.class;
                        // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                        rmidSeed = (rmidSeed + 1) % 65536;
                        // MONITOREXIT : __ex__2
                        int trcLevel = 0;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                trcLevel = 7;
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "getXAConnection(user, pwd): trcLevel = " + trcLevel);
                                Object var21_44 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var21_45 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                        this.xaOpenString = localXaOpenString = this.generateXAOpenString(rmName, tnsentry, userName, passwd, 60, 2000, true, true, ".", trcLevel, false, l_xaLoose != null && l_xaLoose.equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                        xaclsstr = this.generateXACloseString(rmName, false);
                        // MONITOREXIT : driverCharSetId
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "getPooledConnection(user, pwd): before t2cDoXaOpen()");
                                Object var24_47 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var24_48 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        if ((status = this.t2cDoXaOpen(localXaOpenString, localRmid, 0, 0)) != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + -1 * status);
                                    Object var26_50 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var26_51 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * status);
                            __ex__3.fillInStackTrace();
                            throw __ex__3;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "getPooledConnection(user, pwd): before t2cConvertOciHandles()");
                                Object var28_53 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var28_54 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        if ((status = this.t2cConvertOciHandles(rmName, ociHandles)) != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXADataSource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + -1 * status);
                                    Object var30_56 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var30_57 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__4 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * status);
                            __ex__4.fillInStackTrace();
                            throw __ex__4;
                        }
                        info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                        info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                        info.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                        if (this.loginTimeout != 0) {
                            info.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "getPooledConnection(user, pwd): before getConnection(url, info)");
                                Object var32_59 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var32_60 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Connection conn = this.driver.connect(this.getURL(), info);
                        ((OracleConnection)conn).setStatementCacheSize(this.maxStatements);
                        ((OracleConnection)conn).setExplicitCachingEnabled(this.explicitCachingEnabled);
                        ((OracleConnection)conn).setImplicitCachingEnabled(this.implicitCachingEnabled);
                        if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                            ((OracleConnection)conn).setImplicitCachingEnabled(true);
                            ((OracleConnection)conn).setExplicitCachingEnabled(true);
                        }
                        OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                        if (userName != null && passwd != null) {
                            xaconn.setUserName(userName, passwd);
                        }
                        xaconn.setRmid(localRmid);
                        xaconn.setXaCloseString(xaclsstr);
                        xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + xaconn);
                                Object var34_62 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var34_63 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        oracleXAHeteroConnection = xaconn;
                    }
                    catch (XAException xae) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "getPooledConnection(user, pwd): XAException at end " + xae);
                                Object var45_94 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var45_95 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                                Object var47_97 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var47_98 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        PooledConnection pooledConnection = null;
                        Object var49_68 = null;
                        if (!TRACE) return pooledConnection;
                        if (!OracleLog.recursiveEnter()) return pooledConnection;
                        try {}
                        catch (Throwable throwable) {
                            Object var51_77 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var51_76 = null;
                        OracleLog.recursiveExit();
                        return pooledConnection;
                    }
                    Object var49_65 = null;
                    if (!TRACE) return oracleXAHeteroConnection;
                    if (!OracleLog.recursiveEnter()) return oracleXAHeteroConnection;
                    try {
                        OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var51_70 = null;
                        OracleLog.recursiveExit();
                        return oracleXAHeteroConnection;
                    }
                    catch (Throwable throwable) {
                        Object var51_71 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (!this.thinUseNativeXA || !url.startsWith("jdbc:oracle:thin")) break block95;
                Properties prop = new Properties();
                OracleXADataSource tnsentry = this;
                // MONITORENTER : tnsentry
                Class<OracleXADataSource> propNlsLangBackdoor = OracleXADataSource.class;
                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                // MONITOREXIT : propNlsLangBackdoor
                if (this.connectionProperties == null) {
                    this.connectionProperties = new Properties();
                }
                this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                if (userName != null) {
                    prop.setProperty("user", userName);
                }
                if (passwd != null) {
                    prop.setProperty("password", passwd);
                }
                prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                if (this.loginTimeout != 0) {
                    prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                // MONITOREXIT : tnsentry
                T4CXAConnection conn = new T4CXAConnection(super.getPhysicalConnection(prop));
                if (userName != null && passwd != null) {
                    conn.setUserName(userName, passwd);
                }
                String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                boolean bl = conn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + conn);
                        Object var38_85 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var38_86 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                T4CXAConnection t4CXAConnection = conn;
                Object var49_66 = null;
                if (!TRACE) return t4CXAConnection;
                if (!OracleLog.recursiveEnter()) return t4CXAConnection;
                try {}
                catch (Throwable throwable) {
                    Object var51_73 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var51_72 = null;
                OracleLog.recursiveExit();
                return t4CXAConnection;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleXADataSource.getPooledConnection(user, pwd) return: non-oci");
                    Object var40_88 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var40_89 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Properties prop = new Properties();
            OracleXADataSource conn = this;
            // MONITORENTER : conn
            if (userName != null) {
                prop.setProperty("user", userName);
            }
            if (passwd != null) {
                prop.setProperty("password", passwd);
            }
            prop.setProperty("stmt_cache_size", "" + this.maxStatements);
            prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
            prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
            if (this.loginTimeout != 0) {
                prop.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            // MONITOREXIT : conn
            OracleXAConnection l_xaconn = new OracleXAConnection(super.getPhysicalConnection(prop));
            if (userName != null && passwd != null) {
                l_xaconn.setUserName(userName, passwd);
            }
            String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            boolean bl = l_xaconn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l_xaconn);
                    Object var43_91 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var43_92 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleXAConnection oracleXAConnection = l_xaconn;
            Object var49_67 = null;
            if (!TRACE) return oracleXAConnection;
            if (!OracleLog.recursiveEnter()) return oracleXAConnection;
            try {}
            catch (Throwable throwable) {
                Object var51_75 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var51_74 = null;
            OracleLog.recursiveExit();
            return oracleXAConnection;
        }
        catch (Throwable throwable) {
            Object var49_69 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var51_79 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXADataSource.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var51_78 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    /*
     * Exception decompiling
     */
    synchronized void setRmid(int rmid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getRmid() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(this.rmid));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rmid);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.rmid;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setXaOpenString(String xaOpenString) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(xaOpenString));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.xaOpenString = xaOpenString;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    synchronized String getXaOpenString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaOpenString);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = this.xaOpenString;
            Object var6_8 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXAOpenString(String rmName, String connectString, String userName, String passwd, int lockTimeout, int sessionTimeout, boolean threadFlag, boolean objectFlag, String logDir, int traceLevel, boolean cacheFlag, boolean isLoose, String dbCsId, String dbNCharCsId) {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rmName) + ", " + OracleLog.argument(connectString) + ", " + OracleLog.argument(userName) + ", " + OracleLog.argument(passwd) + ", " + OracleLog.argument(lockTimeout) + ", " + OracleLog.argument(sessionTimeout) + ", " + OracleLog.argument(threadFlag) + ", " + OracleLog.argument(objectFlag) + ", " + OracleLog.argument(logDir) + ", " + OracleLog.argument(traceLevel) + ", " + OracleLog.argument(cacheFlag) + ", " + OracleLog.argument(isLoose) + ", " + OracleLog.argument(dbCsId) + ", " + OracleLog.argument(dbNCharCsId));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String __result__ = "ORACLE_XA+DB=" + rmName + "+ACC=P/" + userName + "/" + passwd + "+SESTM=" + sessionTimeout + "+SESWT=" + lockTimeout + "+LOGDIR=" + logDir + "+SQLNET=" + connectString + (threadFlag ? "+THREADS=true" : "") + (objectFlag ? "+OBJECTS=true" : "") + "+DBGFL=0x" + traceLevel + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f") + (isLoose ? "+Loose_Coupling=t" : "") + "+CharSet=" + dbCsId + "+NCharSet=" + dbNCharCsId;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var18_19 = null;
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var20_22 = null;
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var22_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_24 = null;
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateXACloseString(String rmName, boolean cacheFlag) {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rmName) + ", " + OracleLog.argument(cacheFlag));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String __result__ = "ORACLE_XA+DB=" + rmName + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var8_10 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTNSEntryFromUrl(String url) {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(url));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int at_sign = url.indexOf(64);
            String __result__ = url.substring(at_sign + 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var7_10 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_14 = null;
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleXADataSource.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

