/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleSqlReadOnly;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;

public class OracleSql {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST = new String[0];
    DBConversion conversion;
    String originalSql;
    String parameterSql;
    String utickSql;
    String processedSql;
    String rowidSql;
    String actualSql;
    byte[] sqlBytes;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
    byte sqlKindByte = (byte)-1;
    int parameterCount = -1;
    int returningIntoParameterCount = -1;
    boolean currentConvertNcharLiterals = true;
    boolean currentProcessEscapes = true;
    boolean includeRowid = false;
    String[] parameterList = EMPTY_LIST;
    char[] currentParameter = null;
    int bindParameterCount = -1;
    String[] bindParameterList = null;
    int cachedBindParameterCount = -1;
    String[] cachedBindParameterList = null;
    String cachedParameterSql;
    String cachedUtickSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    int selectEndIndex = -1;
    int orderByStartIndex = -1;
    int orderByEndIndex = -1;
    int whereStartIndex = -1;
    int whereEndIndex = -1;
    int forUpdateStartIndex = -1;
    int forUpdateEndIndex = -1;
    int[] ncharLiteralLocation = new int[513];
    int lastNcharLiteralLocation = -1;
    static final String paramPrefix = "rowid";
    int paramSuffix = 0;
    StringBuffer stringBufferForScrollableStatement = null;
    private static final int cMax = 127;
    private static final int[][] TRANSITION = OracleSqlReadOnly.TRANSITION;
    private static final int[][] ACTION = OracleSqlReadOnly.ACTION;
    private static final int NO_ACTION = 0;
    private static final int DELETE_ACTION = 1;
    private static final int INSERT_ACTION = 2;
    private static final int MERGE_ACTION = 3;
    private static final int UPDATE_ACTION = 4;
    private static final int PLSQL_ACTION = 5;
    private static final int CALL_ACTION = 6;
    private static final int SELECT_ACTION = 7;
    private static final int ORDER_ACTION = 10;
    private static final int ORDER_BY_ACTION = 11;
    private static final int WHERE_ACTION = 9;
    private static final int FOR_ACTION = 12;
    private static final int FOR_UPDATE_ACTION = 13;
    private static final int OTHER_ACTION = 8;
    private static final int QUESTION_ACTION = 14;
    private static final int PARAMETER_ACTION = 15;
    private static final int END_PARAMETER_ACTION = 16;
    private static final int START_NCHAR_LITERAL_ACTION = 17;
    private static final int END_NCHAR_LITERAL_ACTION = 18;
    private static final int SAVE_DELIMITER_ACTION = 19;
    private static final int LOOK_FOR_DELIMITER_ACTION = 20;
    private static final int ALTER_SESSION_ACTION = 21;
    private static final int RETURNING_ACTION = 22;
    private static final int INTO_ACTION = 23;
    private static final int INITIAL_STATE = 0;
    private static final int RESTART_STATE = 66;
    private static final OracleSqlReadOnly.ODBCAction[][] ODBC_ACTION = OracleSqlReadOnly.ODBC_ACTION;
    private static final boolean DEBUG_CBI = false;
    int current_argument;
    int i;
    int length;
    char currentChar;
    boolean first;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleSql(DBConversion conv) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.conversion = conv;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String newSql) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(newSql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (newSql == null || newSql.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 104);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 104);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.originalSql = newSql;
            this.utickSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
            this.sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
            this.parameterCount = -1;
            this.parameterList = EMPTY_LIST;
            this.includeRowid = false;
            this.parameterSql = this.originalSql;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.cachedBindParameterCount = -1;
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            this.selectEndIndex = -1;
            this.orderByStartIndex = -1;
            this.orderByEndIndex = -1;
            this.whereStartIndex = -1;
            this.whereEndIndex = -1;
            this.forUpdateStartIndex = -1;
            this.forUpdateEndIndex = -1;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOriginalSql() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.originalSql);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.originalSql;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setNamedParameters(int paramCount, String[] paramList) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(paramCount) + ", " + OracleLog.argument(paramList));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean needToParse = false;
            if (paramCount == 0) {
                this.bindParameterCount = -1;
                needToParse = this.bindParameterCount != this.cachedBindParameterCount;
            } else {
                this.bindParameterCount = paramCount;
                this.bindParameterList = paramList;
                boolean bl = needToParse = this.bindParameterCount != this.cachedBindParameterCount;
                if (!needToParse) {
                    for (int i2 = 0; i2 < paramCount; ++i2) {
                        if (this.bindParameterList[i2] == this.cachedBindParameterList[i2]) continue;
                        needToParse = true;
                        break;
                    }
                }
                if (needToParse) {
                    if (this.bindParameterCount != this.getParameterCount()) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 197);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 197);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    char[] sqlArray = this.originalSql.toCharArray();
                    StringBuffer strBuf = new StringBuffer();
                    int j2 = 0;
                    for (int i3 = 0; i3 < sqlArray.length; ++i3) {
                        if (sqlArray[i3] != '?') {
                            strBuf.append(sqlArray[i3]);
                            continue;
                        }
                        strBuf.append(this.bindParameterList[j2++]);
                        strBuf.append("=>" + this.nextArgument());
                    }
                    this.parameterSql = strBuf.toString();
                    this.actualSql = null;
                    this.utickSql = null;
                    this.processedSql = null;
                    this.rowidSql = null;
                    this.sqlBytes = null;
                } else {
                    this.parameterSql = this.cachedParameterSql;
                    this.actualSql = this.cachedActualSql;
                    this.utickSql = this.cachedUtickSql;
                    this.processedSql = this.cachedProcessedSql;
                    this.rowidSql = this.cachedRowidSql;
                    this.sqlBytes = this.cachedSqlBytes;
                }
            }
            this.cachedBindParameterList = null;
            this.cachedParameterSql = null;
            this.cachedActualSql = null;
            this.cachedUtickSql = null;
            this.cachedProcessedSql = null;
            this.cachedRowidSql = null;
            this.cachedSqlBytes = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + needToParse);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = needToParse;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetNamedParameters() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.cachedBindParameterCount = this.bindParameterCount;
            if (this.bindParameterCount != -1) {
                if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                    this.cachedBindParameterList = new String[this.bindParameterCount];
                }
                System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
                this.cachedParameterSql = this.parameterSql;
                this.cachedActualSql = this.actualSql;
                this.cachedUtickSql = this.utickSql;
                this.cachedProcessedSql = this.processedSql;
                this.cachedRowidSql = this.rowidSql;
                this.cachedSqlBytes = this.sqlBytes;
                this.bindParameterCount = -1;
                this.bindParameterList = null;
                this.parameterSql = this.originalSql;
                this.actualSql = null;
                this.utickSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSql(boolean desiredProcessEscapes, boolean desiredConvertNcharLiterals) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(desiredProcessEscapes) + ", " + OracleLog.argument(desiredConvertNcharLiterals));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (desiredProcessEscapes != this.currentProcessEscapes || desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                if (desiredConvertNcharLiterals != this.currentConvertNcharLiterals) {
                    this.utickSql = null;
                }
                this.processedSql = null;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
            this.currentConvertNcharLiterals = desiredConvertNcharLiterals;
            this.currentProcessEscapes = desiredProcessEscapes;
            if (this.actualSql == null) {
                if (this.utickSql == null) {
                    String string = this.utickSql = this.currentConvertNcharLiterals ? this.convertNcharLiterals(this.parameterSql) : this.parameterSql;
                }
                if (this.processedSql == null) {
                    String string = this.processedSql = this.currentProcessEscapes ? this.parse(this.utickSql) : this.utickSql;
                }
                if (this.rowidSql == null) {
                    this.rowidSql = this.includeRowid ? this.addRowid(this.processedSql) : this.processedSql;
                }
                this.actualSql = this.rowidSql;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.actualSql);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.actualSql;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRevisedSql() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String result = null;
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            result = this.removeForUpdate(this.parameterSql);
            String __result__ = this.addRowid(result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeForUpdate(String revisedSql) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(revisedSql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                revisedSql = revisedSql.substring(0, this.orderByStartIndex);
            } else if (this.forUpdateStartIndex != -1) {
                revisedSql = revisedSql.substring(0, this.forUpdateStartIndex);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + revisedSql);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = revisedSql;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendForUpdate(StringBuffer stringBuffer) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stringBuffer));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.orderByStartIndex != -1 && (this.forUpdateStartIndex == -1 || this.forUpdateStartIndex > this.orderByStartIndex)) {
                stringBuffer.append(this.originalSql.substring(this.orderByStartIndex));
            } else if (this.forUpdateStartIndex != -1) {
                stringBuffer.append(this.originalSql.substring(this.forUpdateStartIndex));
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInsertSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(updatableResultSet));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String originalSql = this.getOriginalSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(originalSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("insert into (");
            this.stringBufferForScrollableStatement.append(this.removeForUpdate(originalSql));
            this.stringBufferForScrollableStatement.append(") values ( ");
            for (int i2 = 1; i2 < updatableResultSet.getColumnCount(); ++i2) {
                if (i2 != 1) {
                    this.stringBufferForScrollableStatement.append(", ");
                }
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append("?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(":" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(")");
            this.paramSuffix = 0;
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRefetchSqlForScrollableResultSet(ScrollableResultSet scrollableResultSet, int realRefreshSize) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(scrollableResultSet) + ", " + OracleLog.argument(realRefreshSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append(revisedSql);
            if (this.whereStartIndex == -1) {
                this.stringBufferForScrollableStatement.append(needEscapeProcessing ? " WHERE ( ROWID = ?" : " WHERE ( ROWID = :" + this.generateParameterName());
            } else {
                this.stringBufferForScrollableStatement.append(needEscapeProcessing ? " AND ( ROWID = ?" : " AND ( ROWID = :" + this.generateParameterName());
            }
            for (int i2 = 0; i2 < realRefreshSize - 1; ++i2) {
                if (needEscapeProcessing) {
                    this.stringBufferForScrollableStatement.append(" OR ROWID = ?");
                    continue;
                }
                this.stringBufferForScrollableStatement.append(" OR ROWID = :" + this.generateParameterName());
            }
            this.stringBufferForScrollableStatement.append(" ) ");
            this.appendForUpdate(this.stringBufferForScrollableStatement);
            this.paramSuffix = 0;
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getUpdateSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet, int numberOfColumnsChanged, Object[] rowBuffer, int[] indexColsChanged) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(updatableResultSet) + ", " + OracleLog.argument(numberOfColumnsChanged) + ", " + OracleLog.argument(rowBuffer) + ", " + OracleLog.argument(indexColsChanged));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("update (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") set ");
            if (rowBuffer != null) {
                for (int i2 = 0; i2 < numberOfColumnsChanged; ++i2) {
                    if (i2 > 0) {
                        this.stringBufferForScrollableStatement.append(", ");
                    }
                    this.stringBufferForScrollableStatement.append(updatableResultSet.getInternalMetadata().getColumnName(indexColsChanged[i2] + 1));
                    if (needEscapeProcessing) {
                        this.stringBufferForScrollableStatement.append(" = ?");
                        continue;
                    }
                    this.stringBufferForScrollableStatement.append(" = :" + this.generateParameterName());
                }
            }
            this.stringBufferForScrollableStatement.append(" WHERE ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeleteSqlForUpdatableResultSet(UpdatableResultSet updatableResultSet) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(updatableResultSet));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String revisedSql = this.getRevisedSql();
            boolean needEscapeProcessing = this.generatedSqlNeedEscapeProcessing();
            if (this.stringBufferForScrollableStatement == null) {
                this.stringBufferForScrollableStatement = new StringBuffer(revisedSql.length() + 100);
            } else {
                this.stringBufferForScrollableStatement.delete(0, this.stringBufferForScrollableStatement.length());
            }
            this.stringBufferForScrollableStatement.append("delete from (");
            this.stringBufferForScrollableStatement.append(revisedSql);
            this.stringBufferForScrollableStatement.append(") where ");
            if (needEscapeProcessing) {
                this.stringBufferForScrollableStatement.append(" ROWID = ?");
            } else {
                this.stringBufferForScrollableStatement.append(" ROWID = :" + this.generateParameterName());
            }
            this.paramSuffix = 0;
            String __result__ = this.stringBufferForScrollableStatement.substring(0, this.stringBufferForScrollableStatement.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    final boolean generatedSqlNeedEscapeProcessing() {
        return this.parameterCount > 0 && this.parameterList == EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getSqlBytes(boolean desiredProcessEscapes, boolean desiredConvertNcharLiterals) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(desiredProcessEscapes) + ", " + OracleLog.argument(desiredConvertNcharLiterals));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.sqlBytes == null || desiredProcessEscapes != this.currentProcessEscapes) {
                this.sqlBytes = this.conversion.StringToCharBytes(this.getSql(desiredProcessEscapes, desiredConvertNcharLiterals));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sqlBytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.sqlBytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement.SqlKind getSqlKind() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.parameterSql == null) {
                OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.UNINITIALIZED;
                return sqlKind;
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            OracleStatement.SqlKind __result__ = this.sqlKind;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)__result__));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement.SqlKind sqlKind = __result__;
            return sqlKind;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getParameterCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.parameterCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.parameterCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getParameterList() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.parameterCount == -1) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.parameterList);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String[] stringArray = this.parameterList;
            return stringArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncludeRowid(boolean enable) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(enable));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (enable != this.includeRowid) {
                this.includeRowid = enable;
                this.rowidSql = null;
                this.actualSql = null;
                this.sqlBytes = null;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            String __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__ = this.parameterSql == null ? "null" : this.parameterSql;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = __result__;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hexUnicode(int c2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String hex = Integer.toHexString(c2);
            switch (hex.length()) {
                case 0: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "\\0000");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = "\\0000";
                    return string;
                }
                case 1: {
                    String __result__ = "\\000" + hex;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case 2: {
                    String __result__ = "\\00" + hex;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case 3: {
                    String __result__ = "\\0" + hex;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
                case 4: {
                    String __result__ = "\\" + hex;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    String string = __result__;
                    return string;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89 + "Unexpected case in OracleSql.hexUnicode: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Unexpected case in OracleSql.hexUnicode: " + c2);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String convertNcharLiterals(String sql) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.lastNcharLiteralLocation <= 2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sql);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                String string = sql;
                return string;
            }
            String buf = "";
            int i2 = 0;
            block20: while (true) {
                int end = this.ncharLiteralLocation[i2++];
                int start = this.ncharLiteralLocation[i2++];
                buf = buf + sql.substring(end, start);
                if (i2 >= this.lastNcharLiteralLocation) break;
                end = this.ncharLiteralLocation[i2];
                buf = buf + "u'";
                int j2 = start + 2;
                while (true) {
                    if (j2 >= end) continue block20;
                    char c2 = sql.charAt(j2);
                    buf = c2 == '\\' ? buf + "\\\\" : (c2 < '\u0080' ? buf + c2 : buf + this.hexUnicode(c2));
                    ++j2;
                }
                break;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + buf);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = buf;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void computeBasicInfo(String sql) throws SQLException {
        try {
            if (OracleSql.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sql));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.parameterCount = 0;
            seenReturning = false;
            inReturningInto = false;
            this.returningIntoParameterCount = 0;
            this.lastNcharLiteralLocation = 0;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = 0;
            delimiter = 0;
            currentParameterLength = 0;
            s = 0;
            len = sql.length();
            temp_orderByStartIndex = -1;
            temp_forUpdateStartIndex = -1;
            stop = len + 1;
            for (i = 0; i < stop; ++i) {
                unicodeChar = i < len ? (int)sql.charAt(i) : 32;
                this.currentChar = (char)unicodeChar;
                if (unicodeChar > 127) {
                    this.currentChar = Character.isLetterOrDigit((char)unicodeChar) != false ? (char)88 : (char)32;
                }
                switch (OracleSql.ACTION[s][this.currentChar]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.sqlKind = OracleStatement.SqlKind.DELETE;
                        break;
                    }
                    case 2: {
                        this.sqlKind = OracleStatement.SqlKind.INSERT;
                        break;
                    }
                    case 3: {
                        this.sqlKind = OracleStatement.SqlKind.MERGE;
                        break;
                    }
                    case 4: {
                        this.sqlKind = OracleStatement.SqlKind.UPDATE;
                        break;
                    }
                    case 5: {
                        this.sqlKind = OracleStatement.SqlKind.PLSQL_BLOCK;
                        break;
                    }
                    case 6: {
                        this.sqlKind = OracleStatement.SqlKind.CALL_BLOCK;
                        break;
                    }
                    case 7: {
                        this.sqlKind = OracleStatement.SqlKind.SELECT;
                        this.selectEndIndex = i;
                        break;
                    }
                    case 8: {
                        this.sqlKind = OracleStatement.SqlKind.OTHER;
                        break;
                    }
                    case 9: {
                        this.whereStartIndex = i - 5;
                        this.whereEndIndex = i;
                        break;
                    }
                    case 10: {
                        temp_orderByStartIndex = i - 5;
                        break;
                    }
                    case 11: {
                        this.orderByStartIndex = temp_orderByStartIndex;
                        this.orderByEndIndex = i;
                        break;
                    }
                    case 12: {
                        temp_forUpdateStartIndex = i - 3;
                        break;
                    }
                    case 13: {
                        this.forUpdateStartIndex = temp_forUpdateStartIndex;
                        this.forUpdateEndIndex = i;
                        if (this.sqlKind != OracleStatement.SqlKind.SELECT) break;
                        this.sqlKind = OracleStatement.SqlKind.SELECT_FOR_UPDATE;
                        break;
                    }
                    case 21: {
                        this.sqlKind = OracleStatement.SqlKind.ALTER_SESSION;
                        break;
                    }
                    case 14: {
                        ++this.parameterCount;
                        if (!inReturningInto) break;
                        ++this.returningIntoParameterCount;
                        break;
                    }
                    case 15: {
                        if (this.currentParameter == null) {
                            this.currentParameter = new char[32];
                        }
                        if (currentParameterLength < this.currentParameter.length) ** GOTO lbl99
                        if (OracleSql.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 134 + new String(this.currentParameter));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 134, new String(this.currentParameter));
                        __ex__.fillInStackTrace();
                        throw __ex__;
lbl99:
                        // 1 sources

                        this.currentParameter[currentParameterLength++] = unicodeChar;
                        break;
                    }
                    case 16: {
                        if (currentParameterLength <= 0) break;
                        if (this.parameterList == OracleSql.EMPTY_LIST) {
                            this.parameterList = new String[Math.max(8, this.parameterCount * 4)];
                        } else if (this.parameterList.length <= this.parameterCount) {
                            newList = new String[this.parameterList.length * 4];
                            System.arraycopy(this.parameterList, 0, newList, 0, this.parameterList.length);
                            this.parameterList = newList;
                        }
                        this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, currentParameterLength).intern();
                        currentParameterLength = 0;
                        ++this.parameterCount;
                        if (!inReturningInto) break;
                        ++this.returningIntoParameterCount;
                        break;
                    }
                    case 17: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i - 1;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                        break;
                    }
                    case 18: {
                        this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = i;
                        if (this.lastNcharLiteralLocation < this.ncharLiteralLocation.length) break;
                        this.growNcharLiteralLocation(this.ncharLiteralLocation.length << 2);
                        break;
                    }
                    case 19: {
                        if (unicodeChar == 91) {
                            delimiter = 93;
                            break;
                        }
                        if (unicodeChar == 123) {
                            delimiter = 125;
                            break;
                        }
                        if (unicodeChar == 60) {
                            delimiter = 62;
                            break;
                        }
                        if (unicodeChar == 40) {
                            delimiter = 41;
                            break;
                        }
                        delimiter = unicodeChar;
                        break;
                    }
                    case 20: {
                        if (unicodeChar != delimiter) break;
                        ++s;
                        break;
                    }
                    case 22: {
                        seenReturning = true;
                        break;
                    }
                    case 23: {
                        if (!seenReturning) break;
                        inReturningInto = true;
                    }
                }
                s = OracleSql.TRANSITION[s][this.currentChar];
            }
            if (this.lastNcharLiteralLocation + 2 >= this.ncharLiteralLocation.length) {
                this.growNcharLiteralLocation(this.lastNcharLiteralLocation + 2);
            }
            this.ncharLiteralLocation[this.lastNcharLiteralLocation++] = len;
            this.ncharLiteralLocation[this.lastNcharLiteralLocation] = len;
        }
        finally {
            if (OracleSql.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void growNcharLiteralLocation(int size) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(size));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int[] temp = new int[size];
            System.arraycopy(this.ncharLiteralLocation, 0, temp, 0, this.ncharLiteralLocation.length);
            this.ncharLiteralLocation = null;
            this.ncharLiteralLocation = temp;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addRowid(String sql) throws SQLException {
        if (this.selectEndIndex == -1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 88);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 88);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        String result = "select rowid as \"__Oracle_JDBC_interal_ROWID__\"," + sql.substring(this.selectEndIndex);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String parse(String os) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(os));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.first = true;
            this.current_argument = 1;
            this.i = 0;
            this.odbc_sql = os;
            this.length = this.odbc_sql.length();
            if (this.oracle_sql == null) {
                this.oracle_sql = new StringBuffer(this.length);
                this.token_buffer = new StringBuffer(32);
            } else {
                this.oracle_sql.ensureCapacity(this.length);
            }
            this.oracle_sql.delete(0, this.oracle_sql.length());
            this.skipSpace();
            this.handleODBC(ParseMode.NORMAL);
            if (this.i < this.length) {
                Integer index = this.i;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 33 + index);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, index);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            String __result__ = this.oracle_sql.substring(0, this.oracle_sql.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleODBC(ParseMode mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument((Object)mode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int s2 = mode == ParseMode.NORMAL ? 0 : 66;
            char delimiter = '\u0000';
            int parenDepth = 0;
            while (this.i < this.length) {
                char unicodeChar = this.i < this.length ? (char)this.odbc_sql.charAt(this.i) : (char)' ';
                this.currentChar = unicodeChar;
                if (unicodeChar > '\u007f') {
                    this.currentChar = Character.isLetterOrDigit(unicodeChar) ? (char)88 : (char)32;
                }
                switch (ODBC_ACTION[s2][this.currentChar]) {
                    case NONE: {
                        break;
                    }
                    case COPY: {
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case QUESTION: {
                        this.oracle_sql.append(this.nextArgument());
                        this.oracle_sql.append(' ');
                        break;
                    }
                    case SAVE_DELIMITER: {
                        delimiter = unicodeChar == '[' ? (char)']' : (unicodeChar == '{' ? (char)'}' : (unicodeChar == '<' ? (char)'>' : (unicodeChar == '(' ? (char)')' : unicodeChar)));
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case LOOK_FOR_DELIMITER: {
                        if (unicodeChar == delimiter) {
                            ++s2;
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case FUNCTION: {
                        this.handleFunction();
                        break;
                    }
                    case CALL: {
                        this.handleCall();
                        break;
                    }
                    case TIME: {
                        this.handleTime();
                        break;
                    }
                    case TIMESTAMP: {
                        this.handleTimestamp();
                        break;
                    }
                    case DATE: {
                        this.handleDate();
                        break;
                    }
                    case ESCAPE: {
                        this.handleEscape();
                        break;
                    }
                    case SCALAR_FUNCTION: {
                        this.handleScalarFunction();
                        break;
                    }
                    case OUTER_JOIN: {
                        this.handleOuterJoin();
                        break;
                    }
                    case UNKNOWN_ESCAPE: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + this.i);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, (Object)this.i);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    case END_ODBC_ESCAPE: {
                        if (mode == ParseMode.SCALAR) {
                            s2 = TRANSITION[s2][this.currentChar];
                            if (!TRACE || !OracleLog.recursiveEnter()) return;
                            try {
                                OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                return;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                    }
                    case COMMA: {
                        if (mode == ParseMode.LOCATE_1 && parenDepth > 1) {
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_1) {
                            s2 = TRANSITION[s2][this.currentChar];
                            if (!TRACE || !OracleLog.recursiveEnter()) return;
                            try {
                                OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                return;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (mode == ParseMode.LOCATE_2) break;
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case OPEN_PAREN: {
                        if (mode == ParseMode.LOCATE_1) {
                            if (parenDepth > 0) {
                                this.oracle_sql.append(unicodeChar);
                            }
                            ++parenDepth;
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2) {
                            ++parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case CLOSE_PAREN: {
                        if (mode == ParseMode.LOCATE_1) {
                            --parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2 && parenDepth > 1) {
                            --parenDepth;
                            this.oracle_sql.append(unicodeChar);
                            break;
                        }
                        if (mode == ParseMode.LOCATE_2) {
                            ++this.i;
                            s2 = TRANSITION[s2][this.currentChar];
                            if (!TRACE || !OracleLog.recursiveEnter()) return;
                            try {
                                OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                return;
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        this.oracle_sql.append(unicodeChar);
                        break;
                    }
                    case BEGIN: {
                        this.first = false;
                        this.oracle_sql.append(unicodeChar);
                    }
                }
                s2 = TRANSITION[s2][this.currentChar];
                ++this.i;
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFunction() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean need_block = this.first;
            this.first = false;
            if (need_block) {
                this.oracle_sql.append("BEGIN ");
            }
            this.appendChar(this.oracle_sql, '?');
            this.skipSpace();
            if (this.currentChar != '=') {
                String s2 = this.i + ". Expecting \"=\" got \"" + this.currentChar + "\"";
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 33 + s2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, s2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            ++this.i;
            this.skipSpace();
            if (!this.odbc_sql.startsWith("call", this.i)) {
                String s3 = this.i + ". Expecting \"call\"";
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 33 + s3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33, s3);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.i += 4;
            this.oracle_sql.append(" := ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCall() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean need_block = this.first;
            this.first = false;
            if (need_block) {
                this.oracle_sql.append("BEGIN ");
            }
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.skipSpace();
            if (need_block) {
                this.oracle_sql.append("; END;");
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimestamp() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTime() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(", 'HH24:MI:SS')");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDate() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(", 'YYYY-MM-DD')");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEscape() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append("ESCAPE ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleScalarFunction() throws SQLException {
        block162: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.token_buffer.delete(0, this.token_buffer.length());
                ++this.i;
                this.skipSpace();
                while (this.i < this.length && (Character.isJavaLetterOrDigit(this.currentChar = this.odbc_sql.charAt(this.i)) || this.currentChar == '?')) {
                    this.token_buffer.append(this.currentChar);
                    ++this.i;
                }
                String functionName = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
                if (functionName == "ABS") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "ACOS") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "ASIN") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "ATAN") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "ATAN2") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "CEILING") {
                    this.usingFunctionName("CEIL");
                    break block162;
                }
                if (functionName == "COS") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "COT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "DEGREES") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "EXP") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "FLOOR") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "LOG") {
                    this.usingFunctionName("LN");
                    break block162;
                }
                if (functionName == "LOG10") {
                    this.replacingFunctionPrefix("LOG ( 10, ");
                    break block162;
                }
                if (functionName == "MOD") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "PI") {
                    this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
                    break block162;
                }
                if (functionName == "POWER") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "RADIANS") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "RAND") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "ROUND") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "SIGN") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "SIN") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "SQRT") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "TAN") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "TRUNCATE") {
                    this.usingFunctionName("TRUNC");
                    break block162;
                }
                if (functionName == "ASCII") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "CHAR") {
                    this.usingFunctionName("CHR");
                    break block162;
                }
                if (functionName == "CONCAT") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "DIFFERENCE") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "INSERT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "LCASE") {
                    this.usingFunctionName("LOWER");
                    break block162;
                }
                if (functionName == "LEFT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "LENGTH") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "LOCATE") {
                    StringBuffer savedOracleSql = this.oracle_sql;
                    this.oracle_sql = new StringBuffer();
                    this.handleODBC(ParseMode.LOCATE_1);
                    StringBuffer arg1 = this.oracle_sql;
                    this.oracle_sql = savedOracleSql;
                    this.oracle_sql.append("INSTR(");
                    this.handleODBC(ParseMode.LOCATE_2);
                    this.oracle_sql.append(',');
                    this.oracle_sql.append(arg1);
                    this.oracle_sql.append(')');
                    this.handleODBC(ParseMode.SCALAR);
                    break block162;
                }
                if (functionName == "LTRIM") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "REPEAT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "REPLACE") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "RIGHT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "RTRIM") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "SOUNDEX") {
                    this.usingFunctionName(functionName);
                    break block162;
                }
                if (functionName == "SPACE") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "SUBSTRING") {
                    this.usingFunctionName("SUBSTR");
                    break block162;
                }
                if (functionName == "UCASE") {
                    this.usingFunctionName("UPPER");
                    break block162;
                }
                if (functionName == "CURDATE") {
                    this.replacingFunctionPrefix("(CURRENT_DATE");
                    break block162;
                }
                if (functionName == "CURTIME") {
                    this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
                    break block162;
                }
                if (functionName == "DAYNAME") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "DAYOFMONTH") {
                    this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
                    break block162;
                }
                if (functionName == "DAYOFWEEK") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "DAYOFYEAR") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "HOUR") {
                    this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
                    break block162;
                }
                if (functionName == "MINUTE") {
                    this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
                    break block162;
                }
                if (functionName == "MONTH") {
                    this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
                    break block162;
                }
                if (functionName == "MONTHNAME") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "NOW") {
                    this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
                    break block162;
                }
                if (functionName == "QUARTER") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "SECOND") {
                    this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
                    break block162;
                }
                if (functionName == "TIMESTAMPADD") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "TIMESTAMPDIFF") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "WEEK") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "YEAR") {
                    this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
                    break block162;
                }
                if (functionName == "DATABASE") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (functionName == "IFNULL") {
                    this.usingFunctionName("NVL");
                    break block162;
                }
                if (functionName == "USER") {
                    this.replacingFunctionPrefix("(USER");
                    break block162;
                }
                if (functionName == "CONVERT") {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 34 + functionName);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 34, functionName);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void usingFunctionName(String newName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(newName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append(newName);
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replacingFunctionPrefix(String newPrefix) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(newPrefix));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.skipSpace();
            if (this.i < this.length && (this.currentChar = this.odbc_sql.charAt(this.i)) == '(') {
                ++this.i;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 33);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 33);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.oracle_sql.append(newPrefix);
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOuterJoin() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.oracle_sql.append(" ( ");
            this.skipSpace();
            this.handleODBC(ParseMode.SCALAR);
            this.oracle_sql.append(" ) ");
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nextArgument() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String result = ":" + this.current_argument;
            ++this.current_argument;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendChar(StringBuffer oracle_sql, char c2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracle_sql) + ", " + OracleLog.argument(c2));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (c2 == '?') {
                oracle_sql.append(this.nextArgument());
            } else {
                oracle_sql.append(c2);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void skipSpace() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            while (this.i < this.length && (this.currentChar = this.odbc_sql.charAt(this.i)) == ' ') {
                ++this.i;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    String generateParameterName() {
        String newParameter;
        if (this.parameterCount == 0 || this.parameterList == null) {
            return paramPrefix + this.paramSuffix++;
        }
        block0: while (true) {
            newParameter = paramPrefix + this.paramSuffix++;
            for (int i2 = 0; i2 < this.parameterList.length; ++i2) {
                if (newParameter.equals(this.parameterList[i2])) continue block0;
            }
            break;
        }
        return newParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isValidPlsqlWarning(String setting) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(setting));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean __result__ = setting.matches("('\\s*([a-zA-Z0-9:,\\(\\)\\s])*')\\s*(,\\s*'([a-zA-Z0-9:,\\(\\)\\s])*')*");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidObjectName(String name) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(name));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (name.matches("([a-zA-Z]{1}\\w*(\\$|\\#)*\\w*)|(\".*)")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, "         Return: true");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            char[] c2 = name.toCharArray();
            int length = c2.length;
            if (!Character.isLetter(c2[0])) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            for (int i2 = 1; i2 < length; ++i2) {
                if (Character.isLetterOrDigit(c2[i2]) || c2[i2] == '$' || c2[i2] == '#' || c2[i2] == '_') continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(OracleLog.TRACE_30, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Return: true");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public static void main(String[] args) {
        String[] cases;
        if (args.length < 2) {
            System.err.println("ERROR: incorrect usage. OracleSql (-transition <file> | <process_escapes> <convert_nchars> { <sql> } )");
            return;
        }
        if (args[0].equals("-dump")) {
            OracleSql.dumpTransitionMatrix(args[1]);
            return;
        }
        boolean escapes = args[0].equals("true");
        boolean nchar = args[1].equals("true");
        if (args.length > 2) {
            cases = new String[args.length - 2];
            System.arraycopy(args, 2, cases, 0, cases.length);
        } else {
            cases = new String[]{"select ? from dual", "insert into dual values (?)", "delete from dual", "update dual set dummy = ?", "merge tab into dual", " select ? from dual where ? = ?", "select ?from dual where?=?for update", "select '?', n'?', q'???', q'{?}', q'{cat's}' from dual", "select'?',n'?',q'???',q'{?}',q'{cat's}'from dual", "select--line\n? from dual", "select --line\n? from dual", "--line\nselect ? from dual", " --line\nselect ? from dual", "--line\n select ? from dual", "begin proc4in4out (:x1, :x2, :x3, :x4); end;", "{CALL tkpjpn01(:pin, :pinout, :pout)}", "select :NumberBindVar as the_number from dual", "select {fn locate(bob(carol(),ted(alice,sue)), 'xfy')} from dual", "CREATE USER vijay6 IDENTIFIED BY \"vjay?\"", "ALTER SESSION SET TIME", "SELECT ename FROM emp WHERE hiredate BETWEEN {ts'1980-12-17'} AND {ts '1981-09-28'} "};
        }
        for (String testCase : cases) {
            try {
                int i2;
                System.out.println("\n\n-----------------------");
                System.out.println(testCase);
                System.out.println();
                OracleSql o2 = new OracleSql(null);
                o2.initialize(testCase);
                String sql = o2.getSql(escapes, nchar);
                System.out.println((Object)((Object)o2.sqlKind) + ", " + o2.parameterCount);
                String[] p2 = o2.getParameterList();
                if (p2 == EMPTY_LIST) {
                    System.out.println("parameterList is empty");
                } else {
                    for (i2 = 0; i2 < p2.length; ++i2) {
                        System.out.println("parameterList[" + i2 + "] = " + p2[i2]);
                    }
                }
                if (o2.getSqlKind().isDML()) {
                    int c2 = o2.getReturnParameterCount();
                    if (c2 == -1) {
                        System.out.println("no return parameters");
                    } else {
                        System.out.println(c2 + " return parameters");
                    }
                }
                if (o2.lastNcharLiteralLocation == 2) {
                    System.out.println("No NCHAR literals");
                } else {
                    System.out.println("NCHAR Literals");
                    i2 = 1;
                    while (i2 < o2.lastNcharLiteralLocation - 1) {
                        System.out.println(sql.substring(o2.ncharLiteralLocation[i2++], o2.ncharLiteralLocation[i2++]));
                    }
                }
                System.out.println("Keywords");
                if (o2.selectEndIndex == -1) {
                    System.out.println("no select");
                } else {
                    System.out.println("'" + sql.substring(o2.selectEndIndex - 6, o2.selectEndIndex) + "'");
                }
                if (o2.orderByStartIndex == -1) {
                    System.out.println("no order by");
                } else {
                    System.out.println("'" + sql.substring(o2.orderByStartIndex, o2.orderByEndIndex) + "'");
                }
                if (o2.whereStartIndex == -1) {
                    System.out.println("no where");
                } else {
                    System.out.println("'" + sql.substring(o2.whereStartIndex, o2.whereEndIndex) + "'");
                }
                if (o2.forUpdateStartIndex == -1) {
                    System.out.println("no for update");
                } else {
                    System.out.println("'" + sql.substring(o2.forUpdateStartIndex, o2.forUpdateEndIndex) + "'");
                }
                System.out.println("isPlsqlOrCall(): " + o2.getSqlKind().isPlsqlOrCall());
                System.out.println("isDML(): " + o2.getSqlKind().isDML());
                System.out.println("isSELECT(): " + o2.getSqlKind().isSELECT());
                System.out.println("isOTHER(): " + o2.getSqlKind().isOTHER());
                System.out.println("\"" + sql + "\"");
                System.out.println("\"" + o2.getRevisedSql() + "\"");
            }
            catch (Exception e2) {
                System.out.println(e2);
            }
        }
    }

    private static final void dumpTransitionMatrix(String fileName) {
        try {
            PrintWriter f2 = new PrintWriter(fileName);
            f2.print(",");
            for (int c2 = 0; c2 < 128; ++c2) {
                f2.print("'" + (c2 < 32 ? "0x" + Integer.toHexString(c2) : Character.toString((char)c2)) + (c2 < 127 ? "'," : "'"));
            }
            f2.println();
            int[][] m2 = OracleSqlReadOnly.TRANSITION;
            String[] n2 = OracleSqlReadOnly.PARSER_STATE_NAME;
            for (int s2 = 0; s2 < TRANSITION.length; ++s2) {
                f2.print(n2[s2] + ",");
                for (int c3 = 0; c3 < m2[s2].length; ++c3) {
                    f2.print(n2[m2[s2][c3]] + (c3 < 127 ? "," : ""));
                }
                f2.println();
            }
            f2.close();
        }
        catch (Throwable e2) {
            System.err.println(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReturnParameterCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.computeBasicInfo(this.parameterSql);
            }
            if (!this.sqlKind.isDML()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = -1;
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.returningIntoParameterCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.returningIntoParameterCount;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSubstrPos(String sSQL, String token) throws SQLException {
        try {
            int posEnd;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sSQL) + ", " + OracleLog.argument(token));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int retVal = -1;
            int posStart = sSQL.indexOf(token);
            if (posStart >= 1 && Character.isWhitespace(sSQL.charAt(posStart - 1)) && (posEnd = posStart + token.length()) < sSQL.length() && Character.isWhitespace(sSQL.charAt(posEnd))) {
                retVal = posStart;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retVal);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = retVal;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSql.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleSql"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseMode {
        NORMAL,
        SCALAR,
        LOCATE_1,
        LOCATE_2;

    }
}

