/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class Accessor {
    static final int FIXED_CHAR = 999;
    static final int CHAR = 96;
    static final int VARCHAR = 1;
    static final int VCS = 9;
    static final int LONG = 8;
    static final int NUMBER = 2;
    static final int VARNUM = 6;
    static final int BINARY_FLOAT = 100;
    static final int BINARY_DOUBLE = 101;
    static final int RAW = 23;
    static final int VBI = 15;
    static final int LONG_RAW = 24;
    static final int ROWID = 104;
    static final int RESULT_SET = 102;
    static final int RSET = 116;
    static final int DATE = 12;
    static final int BLOB = 113;
    static final int CLOB = 112;
    static final int BFILE = 114;
    static final int NAMED_TYPE = 109;
    static final int REF_TYPE = 111;
    static final int TIMESTAMP = 180;
    static final int TIMESTAMPTZ = 181;
    static final int TIMESTAMPLTZ = 231;
    static final int INTERVALYM = 182;
    static final int INTERVALDS = 183;
    static final int UROWID = 208;
    static final int PLSQL_INDEX_TABLE = 998;
    static final int T2S_OVERLONG_RAW = 997;
    static final int SET_CHAR_BYTES = 996;
    static final int NULL_TYPE = 995;
    static final int DML_RETURN_PARAM = 994;
    static final int ONLY_FORM_USABLE = 0;
    static final int NOT_USABLE = 1;
    static final int NO_NEED_TO_PREPARE = 2;
    static final int NEED_TO_PREPARE = 3;
    OracleStatement statement;
    boolean outBind;
    int internalType;
    int internalTypeMaxLength;
    boolean isStream = false;
    boolean isColumnNumberAware = false;
    short formOfUse = (short)2;
    OracleType internalOtype;
    int externalType;
    String internalTypeName;
    String columnName;
    int describeType;
    int describeMaxLength;
    boolean nullable;
    int precision;
    int scale;
    int flags;
    int contflag;
    int total_elems;
    OracleType describeOtype;
    String describeTypeName;
    int definedColumnType = 0;
    int definedColumnSize = 0;
    int oacmxl = 0;
    short udskpos = (short)-1;
    int lobPrefetchSizeForThisColumn = -1;
    long[] prefetchedLobSize = null;
    int[] prefetchedLobChunkSize = null;
    byte[] prefetchedClobFormOfUse = null;
    byte[][] prefetchedLobData = null;
    char[][] prefetchedLobCharData = null;
    int[] prefetchedLobDataL = null;
    OracleResultSetMetaData.SecurityAttribute securityAttribute;
    byte[] rowSpaceByte = null;
    char[] rowSpaceChar = null;
    short[] rowSpaceIndicator = null;
    static final byte DATA_UNAUTHORIZED = 1;
    byte[] rowSpaceMetaData = null;
    int columnIndex = 0;
    int lengthIndex = 0;
    int indicatorIndex = 0;
    int metaDataIndex = 0;
    int columnIndexLastRow = 0;
    int lengthIndexLastRow = 0;
    int indicatorIndexLastRow = 0;
    int metaDataIndexLastRow = 0;
    int byteLength = 0;
    int charLength = 0;
    int defineType;
    boolean isDMLReturnedParam = false;
    int lastRowProcessed = 0;
    boolean isUseLess = false;
    int physicalColumnIndex = -2;
    boolean isNullByDescribe = false;
    static final byte[] NULL_DATA_BYTES = new byte[]{2, 3, 5, 7, 11, 13, 17, 19};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    Accessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOffsets(int nrows) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nrows));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.columnIndex = this.statement.defineByteSubRange;
            this.statement.defineByteSubRange = this.columnIndex + nrows * this.byteLength;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(OracleStatement stmt, int internal_type, int database_type, short form, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(database_type) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(forBind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.statement = stmt;
            this.outBind = forBind;
            this.internalType = internal_type;
            this.defineType = database_type;
            this.formOfUse = form;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    abstract void initForDataAccess(int var1, int var2, String var3) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDescribe(int type, int maxLength, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(maxLength) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.describeType = type;
            this.describeMaxLength = maxLength;
            this.nullable = nullable;
            this.precision = precision;
            this.scale = scale;
            this.flags = flags;
            this.contflag = contflag;
            this.total_elems = total_elems;
            this.formOfUse = form;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDescribe(int type, int maxLength, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(maxLength) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.describeTypeName = typeName;
            this.describeOtype = null;
            this.initForDescribe(type, maxLength, nullable, flags, precision, scale, contflag, total_elems, form);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleInputStream initForNewRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.unimpl("initForNewRow");
            OracleInputStream oracleInputStream = null;
            return oracleInputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int useForDataAccessIfPossible(int internal_type, int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(internal_type) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int result = 3;
            int oldByteLength = 0;
            int oldCharLength = 0;
            if (this.internalType != 0) {
                if (this.internalType != internal_type) {
                    result = 0;
                } else if (this.rowSpaceIndicator != null) {
                    oldByteLength = this.byteLength;
                    oldCharLength = this.charLength;
                }
            }
            if (result == 3) {
                this.initForDataAccess(external_type, max_len, typeName);
                if (!this.outBind && oldByteLength >= this.byteLength && oldCharLength >= this.charLength) {
                    result = 2;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = result;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useForDescribeIfPossible(int type, int maxLength, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short formOfUse, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(maxLength) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(formOfUse) + ", " + OracleLog.argument(typeName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.externalType == 0 && type != this.describeType) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            this.initForDescribe(type, maxLength, nullable, flags, precision, scale, contflag, total_elems, formOfUse, typeName);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFormOfUse(short form) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(form));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.formOfUse = form;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateColumnNumber(int colNumber) {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(colNumber));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", internalTypeMaxLength=" + this.internalTypeMaxLength + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowSpaceByte=" + this.rowSpaceByte + ", rowSpaceChar=" + this.rowSpaceChar + ", rowSpaceIndicator=" + this.rowSpaceIndicator + ", columnIndex=" + this.columnIndex + ", lengthIndex=" + this.lengthIndex + ", indicatorIndex=" + this.indicatorIndex + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unimpl(String methodName) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + methodName + " not implemented for " + this.getClass());
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, methodName + " not implemented for " + this.getClass());
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getBoolean(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            this.unimpl("getBoolean");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getByte(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte by = 0;
                return by;
            }
            this.unimpl("getByte");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = 0;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceMetaData == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte metaDataByte1 = this.rowSpaceMetaData[this.metaDataIndex + 1 * currentRow];
            if ((metaDataByte1 & 1) != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleResultSet.AuthorizationIndicator.UNAUTHORIZED));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
                return authorizationIndicator;
            }
            if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleResultSet.AuthorizationIndicator.NONE));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.NONE;
                return authorizationIndicator;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleResultSet.AuthorizationIndicator.UNKNOWN));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = OracleResultSet.AuthorizationIndicator.UNKNOWN;
            return authorizationIndicator;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short getShort(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                short s2 = 0;
                return s2;
            }
            this.unimpl("getShort");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s3 = 0;
            return s3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInt(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 0;
                return n2;
            }
            this.unimpl("getInt");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 0;
            return n3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLong(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                long l2 = 0L;
                return l2;
            }
            this.unimpl("getLong");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = 0L;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getFloat(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                float f2 = 0.0f;
                return f2;
            }
            this.unimpl("getFloat");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = 0.0f;
            return f3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getDouble(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                double d2 = 0.0;
                return d2;
            }
            this.unimpl("getDouble");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = 0.0;
            return d3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getBigDecimal(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            this.unimpl("getBigDecimal");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getBigDecimal(int currentRow, int scale) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(scale));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            this.unimpl("getBigDecimal");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date getDate(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Date date = null;
                return date;
            }
            this.unimpl("getDate");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = null;
            return date;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date getDate(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Date date = null;
                return date;
            }
            this.unimpl("getDate");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date = null;
            return date;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time = null;
                return time;
            }
            this.unimpl("getTime");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = null;
            return time;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Time time = null;
                return time;
            }
            this.unimpl("getTime");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time = null;
            return time;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp getTimestamp(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp = null;
                return timestamp;
            }
            this.unimpl("getTimestamp");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(cal));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Timestamp timestamp = null;
                return timestamp;
            }
            this.unimpl("getTimestamp");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] privateGetBytes(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] __result__ = this.getBytes(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                result = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, result, 0, len);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getAsciiStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            this.unimpl("getAsciiStream");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            this.unimpl("getUnicodeStream");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getBinaryStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                InputStream inputStream = null;
                return inputStream;
            }
            this.unimpl("getBinaryStream");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var2_4 = null;
                return var2_4;
            }
            this.unimpl("getObject");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var2_5 = null;
            return var2_5;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getCursor(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = null;
                return datum;
            }
            this.unimpl("getOracleObject");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = null;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ROWID getROWID(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ROWID __ex__ = null;
                return __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NUMBER getNUMBER(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                NUMBER nUMBER = null;
                return nUMBER;
            }
            this.unimpl("getNUMBER");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER nUMBER = null;
            return nUMBER;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DATE getDATE(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                DATE dATE = null;
                return dATE;
            }
            this.unimpl("getDATE");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE dATE = null;
            return dATE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ARRAY getARRAY(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY aRRAY = null;
                return aRRAY;
            }
            this.unimpl("getARRAY");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY = null;
            return aRRAY;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    STRUCT getSTRUCT(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                STRUCT sTRUCT = null;
                return sTRUCT;
            }
            this.unimpl("getSTRUCT");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT = null;
            return sTRUCT;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OPAQUE getOPAQUE(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OPAQUE oPAQUE = null;
                return oPAQUE;
            }
            this.unimpl("getOPAQUE");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE oPAQUE = null;
            return oPAQUE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    REF getREF(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF rEF = null;
                return rEF;
            }
            this.unimpl("getREF");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF = null;
            return rEF;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CHAR getCHAR(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CHAR cHAR = null;
                return cHAR;
            }
            this.unimpl("getCHAR");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR = null;
            return cHAR;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RAW getRAW(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                RAW rAW = null;
                return rAW;
            }
            this.unimpl("getRAW");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW = null;
            return rAW;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BLOB getBLOB(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB bLOB = null;
                return bLOB;
            }
            this.unimpl("getBLOB");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB = null;
            return bLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CLOB getCLOB(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB cLOB = null;
                return cLOB;
            }
            this.unimpl("getCLOB");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB = null;
            return cLOB;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BFILE getBFILE(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE bFILE = null;
                return bFILE;
            }
            this.unimpl("getBFILE");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BFILE bFILE = null;
            return bFILE;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CustomDatum getCustomDatum(int currentRow, CustomDatumFactory factory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum d2 = this.getOracleObject(currentRow);
            CustomDatum __result__ = factory.create(d2, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CustomDatum customDatum = __result__;
            return customDatum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ORAData getORAData(int currentRow, ORADataFactory factory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum d2 = this.getOracleObject(currentRow);
            ORAData __result__ = factory.create(d2, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ORAData oRAData = __result__;
            return oRAData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow, OracleDataFactory factory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(factory));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum d2 = this.getOracleObject(currentRow);
            Object jdbcObject = d2.toJdbc();
            OracleData __result__ = factory.create(jdbcObject, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleData oracleData = __result__;
            return oracleData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object var3_5 = null;
                return var3_5;
            }
            this.unimpl("getObject");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object var3_6 = null;
            return var3_6;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Reader getCharacterStream(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Reader reader = null;
                return reader;
            }
            this.unimpl("getCharacterStream");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = null;
            return reader;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INTERVALYM getINTERVALYM(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                INTERVALYM iNTERVALYM = null;
                return iNTERVALYM;
            }
            this.unimpl("getINTERVALYM");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALYM iNTERVALYM = null;
            return iNTERVALYM;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INTERVALDS getINTERVALDS(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                INTERVALDS iNTERVALDS = null;
                return iNTERVALDS;
            }
            this.unimpl("getINTERVALDS");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALDS iNTERVALDS = null;
            return iNTERVALDS;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMP tIMESTAMP = null;
                return tIMESTAMP;
            }
            this.unimpl("getTIMESTAMP");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP tIMESTAMP = null;
            return tIMESTAMP;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMPTZ tIMESTAMPTZ = null;
                return tIMESTAMPTZ;
            }
            this.unimpl("getTIMESTAMPTZ");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ tIMESTAMPTZ = null;
            return tIMESTAMPTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                TIMESTAMPLTZ tIMESTAMPLTZ = null;
                return tIMESTAMPLTZ;
            }
            this.unimpl("getTIMESTAMPLTZ");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = null;
            return tIMESTAMPLTZ;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL getURL(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                URL uRL = null;
                return uRL;
            }
            this.unimpl("getURL");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum[] datumArray = null;
                return datumArray;
            }
            this.unimpl("getOraclePlsqlIndexTable");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = null;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNull(int currentRow) throws SQLException {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean bl = __result__ = this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNull(int currentRow, boolean value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.rowSpaceIndicator[this.indicatorIndex + currentRow] = (short)(value ? -1 : 0);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchNextColumns() throws SQLException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateSizeTmpByteArray() {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unmarshalOneRow() throws SQLException, IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 148);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyRow() throws SQLException, IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 148);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readStream(byte[] buffer, int length) throws SQLException, IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(length));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 148);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initMetadata() throws SQLException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplaySize(int max_len) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(max_len));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.describeMaxLength = max_len;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDataFromOldDefineBuffers(byte[] tmpDefineByte, char[] tmpDefineChar, short[] tmpDefineIndicator, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(tmpDefineByte) + ", " + OracleLog.argument(tmpDefineChar) + ", " + OracleLog.argument(tmpDefineIndicator) + ", " + OracleLog.argument(oldPrefetchSize) + ", " + OracleLog.argument(newPrefetchSize));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection __result__ = this.statement.getConnectionDuringExceptionHandling();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = __result__;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] == -1) {
                _checkSum = CRC64.updateChecksum(_checkSum, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
            } else {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                _checkSum = CRC64.updateChecksum(_checkSum, this.rowSpaceByte, off, (int)len);
            }
            long __result__ = _checkSum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = __result__;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Accessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.Accessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

