/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource;
    private String xaDataSourceName;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory() throws ResourceException {
        block13: {
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory(XADataSource xads) throws ResourceException {
        this.xaDataSource = null;
        this.xaDataSourceName = null;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xads));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xaDataSource = xads;
            this.xaDataSourceName = "XADataSource";
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXADataSourceName(String xadsName) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xadsName));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xaDataSourceName = xadsName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXADataSourceName() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaDataSourceName);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = this.xaDataSourceName;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        DataSource dataSource;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cxManager));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            DataSource __result__ = (DataSource)((Object)this.xaDataSource);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            dataSource = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory() throws ResourceException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object __result__ = this.createConnectionFactory(null);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        XAConnection xaconn = null;
        PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
        xaconn = pcred == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(pcred.getUserName(), new String(pcred.getPassword()));
        OracleManagedConnection omc = new OracleManagedConnection(xaconn);
        omc.setPasswordCredential(pcred);
        omc.setLogWriter(this.getLogWriter());
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + omc);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        OracleManagedConnection oracleManagedConnection = omc;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return oracleManagedConnection;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        block27: {
            try {
                if (OracleManagedConnectionFactory.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionSet) + ", " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                pcred = this.getPasswordCredential(subject, cxRequestInfo);
                for (E obj : connectionSet) {
                    if (!(obj instanceof OracleManagedConnection) || !(omc = (OracleManagedConnection)obj).getPasswordCredential().equals((Object)pcred)) continue;
                    if (OracleManagedConnectionFactory.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + omc);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var8_10 = omc;
                    if (OracleManagedConnectionFactory.TRACE == false) return var8_10;
                    break block27;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var12_14) {
                if (OracleManagedConnectionFactory.TRACE == false) throw var12_14;
                if (OracleLog.recursiveEnter() == false) throw var12_14;
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw var12_14;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
        if (OracleLog.recursiveEnter() == false) return var8_10;
        try {
            OracleManagedConnectionFactory.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return var8_10;
        }
        finally {
            OracleLog.recursiveExit();
        }
lbl-1000:
        // 1 sources

        {
            if (OracleManagedConnectionFactory.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var6_7 = null;
            if (OracleManagedConnectionFactory.TRACE == false) return var6_7;
        }
        if (OracleLog.recursiveEnter() == false) return var6_7;
        try {
            OracleManagedConnectionFactory.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            return var6_7;
        }
        finally {
            OracleLog.recursiveExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogWriter(PrintWriter out) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(out));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                this.xaDataSource.setLogWriter(out);
            }
            catch (SQLException exc) {
                EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                throw rexc;
            }
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PrintWriter getLogWriter() throws ResourceException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        PrintWriter __result__ = this.xaDataSource.getLogWriter();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        PrintWriter printWriter = __result__;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return printWriter;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleManagedConnectionFactory.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupXADataSource() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                XADataSource xads;
                InitialContext ic = null;
                try {
                    Properties props = System.getProperties();
                    ic = new InitialContext(props);
                }
                catch (java.lang.SecurityException exc) {
                    // empty catch block
                }
                if (ic == null) {
                    ic = new InitialContext();
                }
                if ((xads = (XADataSource)ic.lookup(this.xaDataSourceName)) == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleManagedConnectionFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing ResourceAdapterInternalException: " + "Invalid XADataSource object");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new ResourceAdapterInternalException("Invalid XADataSource object");
                }
                this.xaDataSource = xads;
            }
            catch (NamingException exc) {
                ResourceException rexc = new ResourceException("NamingException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                throw rexc;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (subject != null) {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential pcred : creds) {
                    if (!pcred.getManagedConnectionFactory().equals(this)) continue;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pcred);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    PasswordCredential passwordCredential = pcred;
                    return passwordCredential;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SecurityException: " + "Can not find user/password information" + RAERR_MCF_GET_PCRED);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
            }
            if (cxRequestInfo == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                PasswordCredential creds = null;
                return creds;
            }
            OracleConnectionRequestInfo info = (OracleConnectionRequestInfo)cxRequestInfo;
            PasswordCredential pcred = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
            pcred.setManagedConnectionFactory((ManagedConnectionFactory)this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + pcred);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PasswordCredential passwordCredential = pcred;
            return passwordCredential;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

