/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.RegionDefType;
import com.businessobjects.visualization.graphic.RegionTree;
import com.businessobjects.visualization.graphic.SettingsTree;

public class GraphicLayerBaseTree
extends SettingsTree {
    private Graphic graphic_;

    GraphicLayerBaseTree(Graphic graphic, GraphicLayerBaseTree parent, PropertyDefVisibilityType visibility) {
        super((GraphicDefNode)graphic.getDef(), parent, null, visibility);
        this.graphic_ = graphic;
        this.updateChilds();
    }

    private void addChild(Graphic glb, IRegion region, PropertyDefVisibilityType visibility) {
        if (region.getRegionDef().containsChildWithVisibility(visibility)) {
            RegionTree childTree = new RegionTree((Region)region, this, visibility);
            this.getChildVector().add(childTree);
        }
    }

    public void update() {
        this.cleanChilds();
        this.updateChilds();
    }

    private void updateChilds() {
        RegionDef[] regChilds = null;
        if (this.getDefinition().getNodeType() != IGraphicDefNode.GraphicDefNodeType.GRAPHIC) {
            return;
        }
        regChilds = this.graphic_.getPublicGraphicDef().getRegions();
        for (int k = 0; k < regChilds.length; ++k) {
            RegionDef regDef = regChilds[k];
            if (regDef.getType() != RegionDefType.STATIC) continue;
            IRegion reg = this.graphic_.getStaticRegion(regDef);
            this.addChild(this.graphic_, reg, this.getVisibility());
        }
    }
}

