/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.GraphicInstanceMediator;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.common.internal.VisuVersionManager;
import com.businessobjects.visualization.graphic.GraphicDef;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.GraphicLayerBase;
import com.businessobjects.visualization.graphic.GraphicLayerBaseTree;
import com.businessobjects.visualization.graphic.IGraphic;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IProperty;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.ISettingsListener;
import com.businessobjects.visualization.graphic.Palette;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.PublicGraphicDef;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.SettingsManager;
import com.businessobjects.visualization.graphic.SettingsTree;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectManager;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuSerializationMode;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.graphic.VisuTemplate;
import com.businessobjects.visualization.graphic.VisuTemplateType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGlobalValue;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLRegion;
import com.businessobjects.visualization.rendering.RenderFormat;
import com.businessobjects.visualization.rendering.formats.OutputType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class Graphic
extends GraphicLayerBase
implements IGraphic,
IXMLDelegator {
    private Region regionRoot_;
    private String id_;
    private GraphicDescription graphicDesc_;
    private VisuObjectManager voManager_ = new VisuObjectManager();
    private GraphicInstanceMediator mediator_;
    private boolean enableNotfication_;
    private VisuVersionManager visuVersionManager_;
    private SettingsManager settingsManager_ = new SettingsManager();

    public Graphic(PublicGraphicDef pg, GraphicInstanceMediator mediator) {
        this.id_ = pg.getGraphicDef().getId();
        this.visuVersionManager_ = pg.getGraphicDef().getProviderDescription().getVisuVersionManager();
        this.graphicDesc_ = pg.getGraphicDef().getProviderDescription().getGraphicDescription(pg.getId());
        this.initDefaultValues(pg.getGraphicDef().getProviderDescription().getDefaultValues());
        this.mediator_ = mediator;
        RegionDef rootDef = this.graphicDesc_.getPublicGraphic().getRegions()[0];
        this.regionRoot_ = new Region(this, rootDef, this.getGraphic());
        this.voManager_.setPalette(Palette.DEFAULT_PALETTE);
        this.enableNotfication_ = true;
    }

    public Graphic(XMLGraphic xg, PublicGraphicDef pg, GraphicInstanceMediator mediator, VisuVersion serializedVersion) {
        this.id_ = pg.getGraphicDef().getId();
        this.visuVersionManager_ = pg.getGraphicDef().getProviderDescription().getVisuVersionManager();
        this.graphicDesc_ = pg.getGraphicDef().getProviderDescription().getGraphicDescription(pg.getId());
        this.mediator_ = mediator;
        this.initDefaultValues(pg.getGraphicDef().getProviderDescription().getDefaultValues());
        this.voManager_.init(xg.m_GlobalValue);
        RegionDef rootDef = this.graphicDesc_.getPublicGraphic().getRegions()[0];
        this.regionRoot_ = new Region(this, rootDef, this.getGraphic());
        this.init(xg, VisuSerializationMode.SERIALIZATION, serializedVersion);
    }

    public void restoreDefaultSettings() {
        this.enableNotfication_ = false;
        this.restoreDefaultSettingsRegions();
        this.enableNotfication_ = true;
    }

    public RegionDef[] getRegionDefs() {
        return this.graphicDesc_.getPublicGraphic().getRegions();
    }

    public GraphicDef getGraphicDef() {
        return this.graphicDesc_.getGraphicDef();
    }

    public PublicGraphicDef getPublicGraphicDef() {
        return this.graphicDesc_.getPublicGraphic();
    }

    public GraphicDescription getGraphicDescription() {
        return this.graphicDesc_;
    }

    public String getGraphicDefId() {
        return this.graphicDesc_.getGraphicDef().getId();
    }

    public String getName() {
        return this.graphicDesc_.getName();
    }

    public IGraphicNode[] getChildren() {
        ArrayList regionList = this.getRegionList();
        IGraphicNode[] list = new IGraphicNode[regionList.size()];
        list = regionList.toArray(list);
        return list;
    }

    public IGraphicNode getParent() {
        return null;
    }

    public Object getXMLDelegate() {
        return this.getXMLDelegate(VisuSerializationMode.SERIALIZATION);
    }

    Object getXMLDelegate(VisuSerializationMode mode) {
        XMLGraphic xg = new XMLGraphic();
        xg.m_a_Id = this.graphicDesc_.getId();
        xg.m_GlobalValue = (XMLGlobalValue)this.voManager_.getXMLDelegate();
        xg.m_list_Region.add(this.regionRoot_.getXMLDelegate(mode));
        return xg;
    }

    public void saveAsTemplate(Writer writer) {
        try {
            VisuTemplate vt = this.saveAsTemplate("", "");
            XmlWriter xw = new XmlWriter(writer, Charset.forName("UTF-8"));
            vt.marshall(xw);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    public void initFromTemplate(Reader reader) {
        try {
            XmlReader xr = new XmlReader(reader);
            VisuTemplate vt = new VisuTemplate();
            vt.unmarshall(xr);
            this.initFromTemplate(vt);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    void init(XMLGraphic xg, VisuSerializationMode mode, VisuVersion serializedVersion) {
        this.voManager_.init(xg.m_GlobalValue);
        Iterator iter = xg.m_list_Region.iterator();
        while (iter.hasNext()) {
            XMLRegion xr = (XMLRegion)iter.next();
            String currentId = this.getVisuVersionManager().getCurrentRegionId(serializedVersion.getXmlVersion(), this.getDef().getUid(), xr.m_a_Id);
            if (xr.m_a_Type == 0) {
                Region reg = (Region)this.getStaticRegion(currentId);
                if (reg != null) {
                    reg.init(xr, mode, serializedVersion);
                    continue;
                }
                if (mode != VisuSerializationMode.FULLCHECK) continue;
                throw new VisualizationRuntimeException("VIZ_00091_ERR_INVALID_STATIC_REGIO", new Object[]{currentId});
            }
            if (mode == VisuSerializationMode.TEMPLATE) continue;
            RegionDef rd = this.graphicDesc_.getPublicGraphic().getRegion(currentId);
            if (rd != null) {
                Region reg = this.getParentRegion(rd).addRegion(rd, xr.m_a_Index);
                reg.init(xr, mode, serializedVersion);
                continue;
            }
            if (mode != VisuSerializationMode.FULLCHECK) continue;
            throw new VisualizationRuntimeException("VIZ_00090_ERR_INVALID_DYNAMIC_REGI", new Object[]{currentId});
        }
    }

    public IGraphicDefNode getDef() {
        return this.getPublicGraphicDef();
    }

    public RenderFormat[] getAvailableFormat() {
        int iTypes = this.graphicDesc_.getAvailableOutputTypes();
        return OutputType.toRenderFormats(iTypes);
    }

    public String getUid() {
        return this.getId();
    }

    public void setDefaultValue(VisuObject vo) {
        this.voManager_.setDefaultValue(vo);
    }

    public VisuObject getDefaultValue(VisuObjectType vot) {
        return this.voManager_.getDefaultValue(vot);
    }

    public void initDefaultValues(VisuObject[] vos) {
        for (int i = 0; i < vos.length; ++i) {
            this.voManager_.setDefaultValue(vos[i]);
        }
    }

    public VisuObjectManager getObjectManager() {
        return this.voManager_;
    }

    public void notifyPropertyChange(Region region, PropertyDef pdef, VisuObject vo) {
        if (this.enableNotfication_) {
            boolean bNotify = this.graphicDesc_.getPublicGraphic().containPropertyRef("root", pdef.getId());
            if (bNotify) {
                this.mediator_.notifyPropertyUpdated(this, pdef, vo);
            }
            this.settingsManager_.updateSettings(this, region, pdef, vo);
        }
    }

    Graphic getGraphic() {
        return this;
    }

    public VisuTemplate saveAsTemplate(String id, String name) {
        XMLGraphic xg = (XMLGraphic)this.getXMLDelegate(VisuSerializationMode.TEMPLATE);
        VisuTemplate vt = new VisuTemplate(id, name, this.visuVersionManager_.getCurrentVersion(), VisuTemplateType.GRAPHIC, xg);
        return vt;
    }

    public void initFromTemplate(VisuTemplate visuTemplate) {
        boolean old = this.enableNotfication_;
        this.enableNotfication_ = false;
        if (visuTemplate == null) {
            throw new VisualizationRuntimeException("VIZ_00034_ERR_TEMPLATE_IS_NULL");
        }
        if (visuTemplate.getType() != VisuTemplateType.GRAPHIC) {
            throw new VisualizationRuntimeException("VIZ_00092_ERR_INVALID_TEMPLATE_TYP", new Object[]{visuTemplate.getType()});
        }
        this.init(visuTemplate.getXmlGraphic(), VisuSerializationMode.TEMPLATE, visuTemplate.getVersion());
        this.enableNotfication_ = old;
    }

    public VisuVersionManager getVisuVersionManager() {
        return this.visuVersionManager_;
    }

    public void addListener(GraphicDefNode node, ISettingsListener listener) {
        if (node == null) {
            throw new VisualizationRuntimeException("VIZ_00035_ERR_PROPERTYDEF__IS_NULL");
        }
        if (listener == null) {
            throw new VisualizationRuntimeException("VIZ_00036_ERR_ISETTINGSLISTENER__I");
        }
        this.settingsManager_.addListener(node, listener);
    }

    public void removeListener(GraphicDefNode node, ISettingsListener listener) {
        this.settingsManager_.removeListener(node, listener);
    }

    public void removeAllListener() {
        this.settingsManager_.cleanAllListener();
    }

    public String toString2() {
        return this.getName();
    }

    public final String getId() {
        return this.id_;
    }

    public final IRegion[] getStaticRegions() {
        ArrayList<Region> result = new ArrayList<Region>();
        result.add(this.regionRoot_);
        ArrayList list = this.regionRoot_.getAllChildren(IGraphicDefNode.GraphicDefNodeType.REGION, false);
        for (int i = 0; i < list.size(); ++i) {
            result.add((Region)list.get(i));
        }
        IRegion[] resultRes = new Region[result.size()];
        resultRes = result.toArray(resultRes);
        return resultRes;
    }

    public final VisuBool getRegionValue(RegionDef reg) {
        return this.getRegionValue(reg.getId());
    }

    public final void setRegionValue(String key, VisuBool value) {
        Region region = (Region)this.getRegion(key);
        if (region != null) {
            region.setValue(value);
        }
    }

    public final void setRegionValue(RegionDef reg, VisuBool value) {
        this.setRegionValue(reg.getId(), value);
    }

    public final VisuObject getPropertyValue(String regId, String propId) {
        VisuObject result = null;
        Region region = (Region)this.getRegion(regId);
        if (region != null) {
            result = region.getPropertyValue(propId);
        }
        return result;
    }

    public final void setPropertyValue(String regId, String propId, VisuObject value) {
        IProperty property = this.getProperty(regId, propId);
        property.setPropertyValue(value);
    }

    public void setPropertyValue(String regId, String propId, String value) {
        this.setPropertyValue(regId, propId, new VisuString(value));
    }

    public IRegion getStaticRegion(RegionDef rd) {
        String key = rd.getId();
        return this.getInternalRegion(key);
    }

    public IRegion getRegion(String regionId) {
        Region result = this.getInternalRegion(regionId);
        if (result == null) {
            throw new VisualizationRuntimeException("VIZ_00153_ERR_REGION_NOT_EXIST", new Object[]{regionId});
        }
        return result;
    }

    public final IRegion getStaticRegion(String id) {
        return this.getInternalRegion(id);
    }

    public final IRegion[] getRegions() {
        return new IRegion[]{this.regionRoot_};
    }

    public final VisuBool getRegionValue(String key) {
        VisuBool result = null;
        Region region = (Region)this.getRegion(key);
        if (region != null) {
            result = region.getValue();
        }
        return result;
    }

    public boolean hasRegion(String regionId) {
        Region result = this.getInternalRegion(regionId);
        return result != null;
    }

    public boolean hasProperty(String regionId, String propId) {
        if (this.hasRegion(regionId)) {
            return this.getRegion(regionId).hasProperty(propId);
        }
        return false;
    }

    public final IProperty getProperty(String regId, String propId) {
        IProperty result = null;
        Region region = (Region)this.getRegion(regId);
        if (region != null && (result = region.getProperty(propId)) == null) {
            throw new VisualizationRuntimeException("VIZ_00152_ERR_PROPERTY_NOT_EXIST", new Object[]{propId});
        }
        return result;
    }

    public final IRegion[] getDynamicRegions(RegionDef rd) {
        return null;
    }

    public final IRegion getRegion(String regionDefId, int index) {
        return null;
    }

    public final void markDynamicRegionForDelete() {
    }

    public void cleanDynamicRegion() {
    }

    public SettingsTree getTree(PropertyDefVisibilityType visibility) {
        GraphicLayerBaseTree tree = new GraphicLayerBaseTree(this, null, visibility);
        return tree;
    }

    public String toString() {
        return "id : " + this.getId() + " name :" + this.getName();
    }

    final ArrayList getRegionList() {
        ArrayList<Region> result = new ArrayList<Region>();
        result.add(this.regionRoot_);
        ArrayList list = this.regionRoot_.getAllChildren(IGraphicDefNode.GraphicDefNodeType.REGION);
        for (int i = 0; i < list.size(); ++i) {
            result.add((Region)list.get(i));
        }
        return result;
    }

    private Region getInternalRegion(String regionId) {
        if (regionId == null) {
            throw new IllegalArgumentException(regionId);
        }
        Region result = null;
        if (this.regionRoot_.getId().equals(regionId)) {
            return this.regionRoot_;
        }
        if (regionId.startsWith(this.regionRoot_.getId())) {
            return (Region)this.regionRoot_.getInternalRegion(regionId);
        }
        return result;
    }

    final Region getParentRegion(RegionDef rd) {
        Region parentRegion = null;
        IGraphicDefNode node = rd.getParent();
        if (node.getNodeType() != IGraphicDefNode.GraphicDefNodeType.REGION) {
            throw new VisualizationInternalException("Parent node to id = " + rd + " is not a region");
        }
        RegionDef parentRegionDef = (RegionDef)node;
        parentRegion = (Region)this.getRegion(parentRegionDef.getId());
        return parentRegion;
    }

    protected void restoreDefaultSettingsRegions() {
        IRegion[] regions = this.getRegions();
        for (int k = 0; k < regions.length; ++k) {
            ((Region)regions[k]).restoreDefaultSettings();
        }
    }
}

