/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DictionaryAdapter;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DictionaryDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDataContainer;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDictionaryDescriptor;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLMeasureValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class DataDescriptor
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$definition$DataDescriptor == null ? (class$com$businessobjects$visualization$dataexchange$definition$DataDescriptor = DataDescriptor.class$("com.businessobjects.visualization.dataexchange.definition.DataDescriptor")) : class$com$businessobjects$visualization$dataexchange$definition$DataDescriptor));
    private HashSet dataContainerList_ = new HashSet();
    private DatasetDescriptor dataset_;
    private ArrayList dictionaryList_ = new ArrayList();
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$definition$DataDescriptor;

    public DataDescriptor() {
    }

    public DataDescriptor(XMLDataDescriptor xmlData, SerializationHelper sh) {
        this();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deserializing DataDescriptor (current version:" + sh.getCurrentVersion() + ") from stream (serialized version:" + sh.getSerializedVersion() + ")"));
        }
        Iterator iter = null;
        iter = xmlData.m_list_dataContainer.iterator();
        while (iter.hasNext()) {
            XMLDataContainer xmlDc = (XMLDataContainer)iter.next();
            if (xmlDc instanceof XMLDimensionLabels) {
                this.dataContainerList_.add(new DimensionLabels((XMLDimensionLabels)xmlDc, sh));
                continue;
            }
            if (!(xmlDc instanceof XMLMeasureValues)) continue;
            this.dataContainerList_.add(new MeasureValues((XMLMeasureValues)xmlDc, sh));
        }
        iter = xmlData.m_list_dictionaryDescriptor.iterator();
        while (iter.hasNext()) {
            DictionaryDescriptor dict = new DictionaryDescriptor((XMLDictionaryDescriptor)iter.next(), sh);
            this.dictionaryList_.add(dict);
        }
        this.dataset_ = new DatasetDescriptor(xmlData.m_datasetDescriptor, sh);
    }

    public Object getXMLDelegate() {
        XMLDataDescriptor xmlData = new XMLDataDescriptor();
        Iterator iter = null;
        iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            xmlData.m_list_dataContainer.add((XMLDataContainer)((DataContainer)iter.next()).getXMLDelegate());
        }
        iter = this.dictionaryList_.iterator();
        while (iter.hasNext()) {
            xmlData.m_list_dictionaryDescriptor.add((XMLDictionaryDescriptor)((DictionaryDescriptor)iter.next()).getXMLDelegate());
        }
        xmlData.m_datasetDescriptor = (XMLDatasetDescriptor)this.dataset_.getXMLDelegate();
        return xmlData;
    }

    public void addDataContainer(DataContainer dc) {
        this.dataContainerList_.add(dc);
    }

    public void removeDataContainer(DataContainer dc) {
        this.dataContainerList_.remove(dc);
    }

    void notifyRemoveDataContainer(DataContainer dc) {
        this.dataContainerList_.remove(dc);
    }

    public void addDatasetDescriptor(DatasetDescriptor dataset) {
        this.setDatasetDescriptor(dataset);
    }

    public void setDatasetDescriptor(DatasetDescriptor dataset) {
        this.dataset_ = dataset;
        if (dataset != null) {
            this.dataContainerList_.addAll(dataset.getAllDataContainers());
            dataset.setDataDescriptor(this);
        }
    }

    public void removeDatasetDescriptor(DatasetDescriptor dataset) {
        this.dataset_ = null;
    }

    public void clear() {
        this.dataset_.clear();
        this.dictionaryList_.clear();
        this.dataContainerList_.clear();
        this.dataset_ = null;
    }

    public void addDictionary(DictionaryDescriptor dict) {
        this.dictionaryList_.add(dict);
    }

    public void removeDictionary(DictionaryDescriptor dict) {
        this.dictionaryList_.remove(dict);
    }

    public DataContainer getDataContainerByUid(String uid) {
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainer dc = (DataContainer)iter.next();
            if (!dc.getUid().equals(uid)) continue;
            return dc;
        }
        return null;
    }

    public DataContainer getDataContainerById(String id) {
        Iterator iter = this.dataContainerList_.iterator();
        while (iter.hasNext()) {
            DataContainer dc = (DataContainer)iter.next();
            if (!dc.getId().equals(id)) continue;
            return dc;
        }
        return null;
    }

    public DataContainer[] getDataContainerList() {
        return this.dataContainerList_.toArray(new DataContainer[0]);
    }

    public DatasetDescriptor[] getDatasetDescriptorList() {
        if (this.dataset_ == null) {
            return new DatasetDescriptor[0];
        }
        DatasetDescriptor[] datasetList = new DatasetDescriptor[]{this.getDatasetDescriptor()};
        return datasetList;
    }

    public DatasetDescriptor getDatasetDescriptor() {
        return this.dataset_;
    }

    public DictionaryDescriptor[] getDictionaryList() {
        return this.dictionaryList_.toArray(new DictionaryDescriptor[0]);
    }

    public static DataDescriptor newInstance(DataDescriptor dd) {
        DataDescriptor newDd = new DataDescriptor();
        newDd.setDatasetDescriptor(DatasetDescriptor.newInstance(dd.getDatasetDescriptor()));
        DictionaryDescriptor[] dictList = dd.getDictionaryList();
        for (int i = 0; i < dictList.length; ++i) {
            newDd.addDictionary(DictionaryDescriptor.newInstance(dictList[i]));
        }
        return newDd;
    }

    public boolean subsetOf(DataDescriptor containerDescriptor) {
        if (this.dataset_ != null) {
            return this.dataset_.subsetOf(containerDescriptor.dataset_);
        }
        return false;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof DataDescriptor)) {
            return false;
        }
        DataDescriptor that = (DataDescriptor)oThat;
        return (this.dictionaryList_ == null ? that.dictionaryList_ == null : this.dictionaryList_.equals(that.dictionaryList_)) && (this.dataset_ == null ? that.dataset_ == null : this.dataset_.equals(that.dataset_));
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.dataset_);
        result = HashCodeHelper.hash(result, this.getDictionaryList());
        return result;
    }

    public DataAdapter getDataAdapter() {
        DataAdapter da = new DataAdapter();
        Stack<DictionaryAdapter> tempStack = new Stack<DictionaryAdapter>();
        Iterator iter = this.dictionaryList_.iterator();
        while (iter.hasNext()) {
            tempStack.push(((DictionaryDescriptor)iter.next()).getAdapter());
        }
        da.setDictionaries(tempStack.toArray(new DictionaryAdapter[0]));
        tempStack.clear();
        da.setDataset(this.dataset_.getDatasetAdapter());
        return da;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataDescriptor[");
        buffer.append("dataset_ = ").append(this.dataset_);
        buffer.append(", dataContainerList_ = ").append(this.dataContainerList_);
        buffer.append(", dictionaryList_ = ").append(this.dictionaryList_);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

