/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsBaseIterator;
import com.businessobjects.visualization.dataexchange.data.impl.SimpleMemberImpl;
import java.util.Properties;

public class DimensionLabelsSimpleIterator
extends DimensionLabelsBaseIterator {
    private boolean hasDimFilter_;
    private Object[] oArray_;
    private Properties[] properties_;
    private Data data_;
    private DataType defaultDataType_;

    public DimensionLabelsSimpleIterator(Data data, DataType membersDefaultDataType, int iAxisIndex, int iDimIndex) {
        this(data, membersDefaultDataType, iAxisIndex, iDimIndex, false);
    }

    public DimensionLabelsSimpleIterator(Data data, DataType membersDefaultDataType, int iAxisIndex, int iDimIndex, boolean hasDimFilter) {
        this(data, -1, -1, membersDefaultDataType, iAxisIndex, iDimIndex, hasDimFilter);
    }

    public DimensionLabelsSimpleIterator(Data data, int startIndex, int range, DataType membersDefaultDataType, int iAxisIndex, int iDimIndex) {
        this(data, startIndex, range, membersDefaultDataType, iAxisIndex, iDimIndex, false);
    }

    public DimensionLabelsSimpleIterator(Data data, int startIndex, int range, DataType membersDefaultDataType, int iAxisIndex, int iDimIndex, boolean hasDimFilter) {
        if (data == null) {
            throw new VisualizationRuntimeException("VIZ_00017_ERR_CANNOT_INSTANTIATE_I");
        }
        this.axisIndex_ = iAxisIndex;
        this.dimensionIndex_ = iDimIndex;
        this.defaultDataType_ = membersDefaultDataType;
        this.data_ = data;
        this.oArray_ = (Object[])data.getValues();
        this.properties_ = (Properties[])data.getProperties();
        this.hasDimFilter_ = hasDimFilter;
        this.setLimits(startIndex, range, this.oArray_.length - 1);
        this.reset();
        this.lastIndex_ = this.upperIndexLimit_;
    }

    public IMember next() {
        if (!this.hasNext()) {
            throw new VisualizationRuntimeException("VIZ_00018_ERR_CANNOT_MOVE_NEXT_LAB");
        }
        SimpleMemberImpl aMember = new SimpleMemberImpl(this.oArray_[this.currentIndex_], this.defaultDataType_, this.properties_ != null ? this.properties_[this.currentIndex_] : null, this);
        aMember.setStartIndex(this.currentIndex_);
        ++this.currentIndex_;
        if (this.childIterator_ != null || this.hasDimFilter_) {
            while (this.hasNext() && this.oArray_[this.currentIndex_].equals(aMember.getValue())) {
                ++this.currentIndex_;
            }
        }
        if (this.hasNext()) {
            aMember.setIndexRange(this.currentIndex_ - aMember.getStartIndex());
        } else {
            aMember.setIndexRange(this.upperIndexLimit_ + 1 - aMember.getStartIndex());
        }
        this.currentMember_ = aMember;
        return aMember;
    }

    public IDimensionLabelsIterator createFramedIterator(int iStartIndex, int iRange) {
        DimensionLabelsSimpleIterator newIter = new DimensionLabelsSimpleIterator(this.data_, iStartIndex, iRange, this.defaultDataType_, this.axisIndex_, this.dimensionIndex_, this.hasDimFilter_);
        if (this.childIterator_ != null) {
            newIter.setChildDimensionLabels(this.childIterator_);
        }
        newIter.setParentDimensionLabelsIterator(this.parentIterator_);
        return newIter;
    }

    public void setChildDimensionLabels(DimensionLabelsBaseIterator iterator) {
        this.childIterator_ = iterator;
        if (iterator != null) {
            Object lastValue = this.oArray_[this.lastIndex_];
            while (this.lastIndex_ - this.lowerIndexLimit_ > 1 && lastValue.equals(this.oArray_[this.lastIndex_ - 1])) {
                --this.lastIndex_;
            }
        }
    }
}

