/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.DataRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.RawData;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExtendedDataInputStream
extends DataInputStream
implements ExtendedDataInput {
    public ExtendedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public char readChar(boolean bl) throws IOException {
        return DataRandomAccessStorage.readChar(this, bl);
    }

    public int readInt(boolean bl) throws IOException {
        return DataRandomAccessStorage.readInt(this, bl);
    }

    public long readLong(boolean bl) throws IOException {
        return DataRandomAccessStorage.readLong(this, bl);
    }

    public String readLongUTF() throws IOException {
        int n = this.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        char[] cArray = new char[n];
        int n2 = UTF8Codec.decode(byArray, 0, n, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public short readShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readShort(this, bl);
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n * 2];
        this.readFully(byArray, 0, n * 2);
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = RawData.charFromData(byArray, i * 2);
        }
        return String.valueOf(cArray);
    }

    public int readUnsignedShort(boolean bl) throws IOException {
        return DataRandomAccessStorage.readUnsignedShort(this, bl);
    }
}

