/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

import com.crystaldecisions.reports.common.filemanagement.InMemoryRandomAccessStorage;
import com.crystaldecisions.reports.common.filemanagement.InsufficientCapacityException;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ByteArrayRandomAccessStorage
implements InMemoryRandomAccessStorage {
    private byte[] o;
    private int q;
    private int p;
    private final int n;

    private void for() throws IOException {
        if (this.o == null) {
            throw new IOException("Storage is closed");
        }
    }

    public ByteArrayRandomAccessStorage(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("initialSize < 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("limit < initialSize");
        }
        this.o = new byte[n];
        this.n = n2;
    }

    public void flush() throws IOException {
    }

    public long getFilePointer() throws IOException {
        return this.q;
    }

    public long length() throws IOException {
        return this.p;
    }

    public int read() throws IOException {
        this.for();
        int n = this.q++;
        return n < this.p ? this.o[n] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.for();
        int n3 = this.q;
        int n4 = this.p - n3;
        if (n4 <= 0) {
            return -1;
        }
        int n5 = n4 < n2 ? n4 : n2;
        System.arraycopy(this.o, n3, byArray, n, n5);
        this.q = n3 + n5;
        return n5;
    }

    public void seek(long l) throws IOException {
        this.for();
        if (l > (long)this.n) {
            this.q = this.n;
        } else if (l >= 0L) {
            this.q = (int)l;
        } else {
            throw new IllegalArgumentException("Cannot seek to negative offset.");
        }
    }

    private byte[] a(int n) throws IOException {
        if (n < 0) {
            throw new InsufficientCapacityException("Cannot grow ByteArrayRandomAccessStorage beyond the specified limit.");
        }
        if (this.o.length < n) {
            if (n > this.n) {
                throw new InsufficientCapacityException("Cannot grow ByteArrayRandomAccessStorage beyond the specified limit.");
            }
            int n2 = this.o.length * 2;
            if (n2 < n) {
                n2 = n;
            }
            if (n2 > this.n) {
                n2 = this.n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.o, 0, byArray, 0, this.p);
            this.o = byArray;
        }
        return this.o;
    }

    public void setLength(long l, boolean bl) throws IOException {
        this.for();
        this.setLength(l);
        if (bl) {
            this.trim();
        }
    }

    public void setLength(long l) throws IOException {
        this.for();
        if (l > (long)this.n) {
            throw new InsufficientCapacityException("Cannot grow beyond specified limit.");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("New length cannot be negative.");
        }
        this.a((int)l);
        this.p = (int)l;
    }

    public Object sync() {
        return this.o;
    }

    public void write(int n) throws IOException {
        this.for();
        int n2 = this.q;
        byte[] byArray = this.o;
        if (n2 >= byArray.length) {
            byArray = this.a(n2 + 1);
        }
        byArray[n2++] = (byte)n;
        this.q = n2;
        if (this.p < n2) {
            this.p = n2;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.for();
        int n3 = this.q;
        byte[] byArray2 = this.o;
        if (n3 > byArray2.length - n2) {
            byArray2 = this.a(n3 + n2);
        }
        System.arraycopy(byArray, n, byArray2, n3, n2);
        this.q = n3 += n2;
        if (this.p < n3) {
            this.p = n3;
        }
    }

    public void close() throws IOException {
        this.o = null;
        this.q = -1;
        this.p = -1;
    }

    public void trim() throws IOException {
        this.for();
        if (this.o.length > this.p) {
            byte[] byArray = new byte[this.p];
            System.arraycopy(this.o, 0, byArray, 0, this.p);
            this.o = byArray;
        }
    }

    public byte[] getByteArray() {
        return this.o;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.for();
        outputStream.write(this.o, 0, this.p);
    }

    public boolean fits(int n) {
        return this.p <= this.n - n;
    }

    public long limit() {
        return this.n;
    }

    public String toString() {
        return "BARAS[p=" + this.q + ",s=" + this.p + ",l=" + this.n + ']';
    }
}

