/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.sql.ARRAY;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements OracleStruct {
    StructDescriptor descriptor;
    Datum[] datumArray;
    Object[] objectArray;
    boolean enableLocalCache = false;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = objectArray != null ? this.descriptor.toArray(objectArray) : new Datum[this.descriptor.getLength()];
    }

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Map map) throws SQLException {
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        structDescriptor.setConnection(connection);
        if (!this.descriptor.isInstantiable()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.setPhysicalConnectionOf(connection);
        this.datumArray = this.descriptor.toOracleArray(map);
    }

    public STRUCT(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        STRUCT.assertNotNull(structDescriptor);
        this.descriptor = structDescriptor;
        STRUCT.assertNotNull(connection);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        structDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSQLTypeName() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            Object[] objectArray = this.getAttributes(this.getMap());
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes(Map map) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toArray(this, map, this.enableLocalCache);
        }
    }

    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructDescriptor getDescriptor() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor;
        }
    }

    public void setDescriptor(StructDescriptor structDescriptor) {
        this.descriptor = structDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] getOracleAttributes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toOracleArray(this, this.enableLocalCache);
        }
    }

    public Map getMap() {
        Map map = null;
        try {
            map = this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.descriptor.toBytes(this, this.enableLocalCache);
        }
    }

    public void setDatumArray(Datum[] datumArray) {
        try {
            this.datumArray = datumArray == null ? new Datum[this.descriptor.getLength()] : datumArray;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjArray(Object[] objectArray) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.objectArray = objectArray == null ? new Object[]{} : objectArray;
        }
    }

    public static STRUCT toSTRUCT(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        STRUCT sTRUCT = null;
        if (object != null) {
            if (object instanceof STRUCT) {
                sTRUCT = (STRUCT)object;
            } else if (object instanceof ORAData) {
                sTRUCT = (STRUCT)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof OracleData) {
                Object object2 = ((OracleData)object).toJDBCObject(oracleConnection);
                sTRUCT = (STRUCT)object2;
            } else if (object instanceof CustomDatum) {
                sTRUCT = (STRUCT)((OracleConnection)oracleConnection).toDatum((CustomDatum)object);
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)oracleConnection);
                SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
                sQLData.writeSQL(sQLOutput);
                sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
            } else {
                SQLException sQLException = DatabaseError.createSqlException(null, 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return sTRUCT;
    }

    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        return this.toJdbc(map);
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, this.getMap());
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object;
        block8: {
            object = null;
            try {
                if (clazz == null || clazz == STRUCT.class || clazz == Struct.class) {
                    object = this;
                    break block8;
                }
                Object t = clazz.newInstance();
                if (t instanceof SQLData) {
                    ((SQLData)t).readSQL(this.descriptor.toJdbc2SQLInput(this, map), this.descriptor.getName());
                    object = t;
                    break block8;
                }
                if (t instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t;
                    object = oRADataFactory.create(this, 2002);
                    break block8;
                }
                if (t instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)t;
                    object = oracleDataFactory.create(this, 2002);
                    break block8;
                }
                if (t instanceof CustomDatumFactory) {
                    CustomDatumFactory customDatumFactory = (CustomDatumFactory)t;
                    object = customDatumFactory.create(this, 2002);
                    break block8;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (InstantiationException instantiationException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (IllegalAccessException illegalAccessException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return object;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBuffering(boolean bl) throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            this.enableLocalCache = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoBuffering() throws SQLException {
        OracleConnection oracleConnection = this.getInternalConnection();
        synchronized (oracleConnection) {
            return this.enableLocalCache;
        }
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.imageLength = l2;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public long getImageLength() {
        return this.imageLength;
    }

    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (CustomDatumFactory)v;
    }

    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (ORADataFactory)v;
    }

    public OracleDataFactory getOracleDataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (OracleDataFactory)v;
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n2 = structDescriptor.getLength();
            stringWriter.write(" length = " + n2);
            Object[] objectArray = this.getAttributes();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringWriter.write(" attribute[" + i2 + "] = " + objectArray[i2]);
            }
            string = stringWriter.toString();
        }
        catch (SQLException sQLException) {
            string = "StructDescriptor missing or bad";
        }
        return string;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return this.getDescriptor().isInHierarchyOf(string);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public String dump() throws SQLException {
        return STRUCT.dump(this);
    }

    public static String dump(Object object) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        STRUCT.dump(object, printWriter);
        return stringWriter.getBuffer().substring(0);
    }

    public static void dump(Object object, PrintStream printStream) throws SQLException {
        STRUCT.dump(object, new PrintWriter(printStream, true));
    }

    public static void dump(Object object, PrintWriter printWriter) throws SQLException {
        STRUCT.dump(object, printWriter, 0);
    }

    static void dump(Object object, PrintWriter printWriter, int n2) throws SQLException {
        if (object instanceof STRUCT) {
            STRUCT.dump((STRUCT)object, printWriter, n2);
            return;
        }
        if (object instanceof ARRAY) {
            ARRAY.dump((ARRAY)object, printWriter, n2);
            return;
        }
        if (object == null) {
            printWriter.println("null");
        } else {
            printWriter.println(object.toString());
        }
    }

    static void dump(STRUCT sTRUCT, PrintWriter printWriter, int n2) throws SQLException {
        int n3;
        StructDescriptor structDescriptor = sTRUCT.getDescriptor();
        ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        printWriter.println("name = " + structDescriptor.getName());
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print(' ');
        }
        int n4 = structDescriptor.getLength();
        printWriter.println("length = " + n4);
        Object[] objectArray = sTRUCT.getAttributes();
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print(' ');
            }
            printWriter.print(resultSetMetaData.getColumnName(n3 + 1) + " = ");
            STRUCT.dump(objectArray[n3], printWriter, n2 + 1);
        }
    }
}

